/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2020-04-08 11:05:45 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_oneactionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=230 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneactionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=845 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneactionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneactionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=671 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onecleantalk_sessions` (
  `id` varchar(64) NOT NULL,
  `name` varchar(40) NOT NULL,
  `value` text,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`name`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_onecleantalk_sfw` (
  `network` int(11) unsigned NOT NULL,
  `mask` int(11) unsigned NOT NULL,
  KEY `network` (`network`,`mask`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_onecleantalk_sfw_logs` (
  `ip` varchar(15) NOT NULL,
  `all_entries` int(11) NOT NULL,
  `blocked_entries` int(11) NOT NULL,
  `entries_timestamp` int(11) NOT NULL,
  PRIMARY KEY (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_onecommentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onecomments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneduplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_onelinks` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`),
  KEY `link_owner` (`link_owner`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneoptions` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onepostmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6915 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneposts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=744 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneterm_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneterm_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onetermmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneterms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onetm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onetm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `class_identifier` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `attempts` int(11) DEFAULT '0',
  `description` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_locked_at` bigint(20) DEFAULT '0',
  `status` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneusermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneusers` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `fk_wp_onewc_download_log_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `wp_onewoocommerce_downloadable_product_permissions` (`permission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wp_oneactionscheduler_actions */
INSERT INTO `wp_oneactionscheduler_actions` VALUES("6", "action_scheduler/migration_hook", "complete", "2020-04-04 00:49:12", "2020-04-04 02:49:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585961352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585961352;}", "1", "1", "2020-04-04 00:49:14", "2020-04-04 02:49:14", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("7", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-05 00:00:00", "2020-04-05 02:00:00", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586044800;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586044800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-05 12:34:05", "2020-04-05 14:34:05", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("8", "wc-admin_import_orders", "complete", "2020-04-04 01:09:07", "2020-04-04 03:09:07", "[536]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962547;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962547;}", "3", "1", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("9", "wc-admin_import_orders", "complete", "2020-04-04 01:09:07", "2020-04-04 03:09:07", "[559]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962547;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962547;}", "3", "1", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("10", "wc-admin_import_orders", "complete", "2020-04-04 01:09:07", "2020-04-04 03:09:07", "[570]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962547;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962547;}", "3", "1", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("11", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[575]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("12", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[578]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("13", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[599]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("14", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[446]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("15", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[448]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("16", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[450]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("17", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[451]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("18", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[542]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("19", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[543]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("20", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[554]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("21", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[560]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("22", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[601]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("23", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[610]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("24", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("25", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[615]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("26", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[624]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("27", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[625]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("28", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[629]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("29", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[632]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("30", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[633]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("31", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[634]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("32", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[636]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("33", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("34", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[563]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("35", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[565]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("36", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[568]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("37", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[569]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("38", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[571]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("39", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[572]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("40", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[574]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("41", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[577]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("42", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[585]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("43", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[593]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("44", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[594]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("45", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[598]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("46", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[600]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("47", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[602]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("48", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[603]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("49", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[605]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("50", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[606]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("51", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[617]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("52", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[618]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("53", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[627]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("54", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[630]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("55", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[631]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("56", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("57", "wc-admin_import_customers", "complete", "2020-04-04 01:29:36", "2020-04-04 03:29:36", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963776;}", "3", "1", "2020-04-04 01:30:11", "2020-04-04 03:30:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("58", "wc-admin_import_orders", "complete", "2020-04-04 01:29:36", "2020-04-04 03:29:36", "[654]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963776;}", "3", "1", "2020-04-04 01:30:11", "2020-04-04 03:30:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("59", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("60", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[636]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("61", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("62", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[634]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("63", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[633]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("64", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[632]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("65", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[631]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("66", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[630]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("67", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[629]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("68", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[627]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("69", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[625]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("70", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[624]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("71", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[618]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("72", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[617]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("73", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[615]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("74", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("75", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[610]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("76", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[606]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("77", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[605]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("78", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("79", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[636]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("80", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("81", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[634]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("82", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[633]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("83", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[632]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("84", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[631]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("85", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[630]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("86", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[629]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("87", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[627]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("88", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[625]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("89", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[624]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("90", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[618]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("91", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[617]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("92", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[615]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("93", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("94", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[610]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("95", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[606]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("96", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[605]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("97", "wc-admin_import_customers", "complete", "2020-04-04 14:06:58", "2020-04-04 16:06:58", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586009218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586009218;}", "3", "1", "2020-04-04 14:07:38", "2020-04-04 16:07:38", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("98", "wc-admin_import_orders", "complete", "2020-04-04 14:06:58", "2020-04-04 16:06:58", "[666]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586009218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586009218;}", "3", "1", "2020-04-04 14:07:38", "2020-04-04 16:07:38", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("99", "wc-admin_import_customers", "complete", "2020-04-04 16:14:20", "2020-04-04 18:14:20", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586016860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586016860;}", "3", "1", "2020-04-04 16:21:06", "2020-04-04 18:21:06", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("100", "wc-admin_import_orders", "complete", "2020-04-04 16:14:20", "2020-04-04 18:14:20", "[668]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586016860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586016860;}", "3", "1", "2020-04-04 16:21:06", "2020-04-04 18:21:06", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("101", "wc-admin_import_customers", "complete", "2020-04-04 17:44:10", "2020-04-04 19:44:10", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586022250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586022250;}", "3", "1", "2020-04-04 17:45:50", "2020-04-04 19:45:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("102", "wc-admin_import_orders", "complete", "2020-04-04 17:44:10", "2020-04-04 19:44:10", "[669]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586022250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586022250;}", "3", "1", "2020-04-04 17:45:50", "2020-04-04 19:45:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("103", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-06 12:34:05", "2020-04-06 14:34:05", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586176445;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586176445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-06 12:54:31", "2020-04-06 14:54:31", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("104", "wc-admin_import_customers", "complete", "2020-04-05 18:17:31", "2020-04-05 20:17:31", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586110651;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586110651;}", "3", "1", "2020-04-05 18:18:15", "2020-04-05 20:18:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("105", "wc-admin_import_orders", "complete", "2020-04-05 18:17:31", "2020-04-05 20:17:31", "[687]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586110651;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586110651;}", "3", "1", "2020-04-05 18:18:15", "2020-04-05 20:18:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("106", "wc-admin_import_customers", "complete", "2020-04-05 20:46:00", "2020-04-05 22:46:00", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586119560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586119560;}", "3", "1", "2020-04-05 20:46:42", "2020-04-05 22:46:42", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("107", "wc-admin_import_orders", "complete", "2020-04-05 20:46:00", "2020-04-05 22:46:00", "[691]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586119560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586119560;}", "3", "1", "2020-04-05 20:46:42", "2020-04-05 22:46:42", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("108", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[691]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:55", "2020-04-05 23:15:55", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("109", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[687]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:55", "2020-04-05 23:15:55", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("110", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[669]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("111", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[668]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("112", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[666]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("113", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[654]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("114", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("115", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[636]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("116", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("117", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[634]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("118", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[633]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("119", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[632]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("120", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[631]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("121", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[630]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("122", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[629]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("123", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[627]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("124", "wc-admin_import_orders", "complete", "2020-04-05 21:15:30", "2020-04-05 23:15:30", "[625]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121330;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("125", "wc-admin_import_orders", "complete", "2020-04-05 21:15:30", "2020-04-05 23:15:30", "[624]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121330;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("126", "wc-admin_import_orders", "complete", "2020-04-05 21:15:30", "2020-04-05 23:15:30", "[618]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121330;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("127", "wc-admin_import_orders", "complete", "2020-04-05 21:15:30", "2020-04-05 23:15:30", "[617]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121330;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("128", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[615]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("129", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("130", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[610]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("131", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[606]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("132", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[605]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("133", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[603]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("134", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[602]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("135", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[601]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("136", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[600]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("137", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[599]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("138", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[598]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("139", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[594]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("140", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[593]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("141", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[585]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("142", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[578]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("143", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[577]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("144", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[575]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("145", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[574]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("146", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[572]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("147", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[571]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("148", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[570]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("149", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[569]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("150", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[568]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("151", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[565]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("152", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[563]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("153", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[560]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("154", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[559]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("155", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[554]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("156", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[543]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("157", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[542]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("158", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[536]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("159", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[451]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("160", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[448]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("161", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[450]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("162", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[446]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("163", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-07 12:54:31", "2020-04-07 14:54:31", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586264071;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586264071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-07 14:29:20", "2020-04-07 16:29:20", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("164", "wc-admin_import_customers", "complete", "2020-04-06 17:02:38", "2020-04-06 19:02:38", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586192558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586192558;}", "3", "1", "2020-04-06 17:03:47", "2020-04-06 19:03:47", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("165", "wc-admin_import_orders", "complete", "2020-04-06 17:02:38", "2020-04-06 19:02:38", "[717]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586192558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586192558;}", "3", "1", "2020-04-06 17:03:47", "2020-04-06 19:03:47", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("166", "wc-admin_import_customers", "complete", "2020-04-06 17:06:10", "2020-04-06 19:06:10", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586192770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586192770;}", "3", "1", "2020-04-06 17:06:16", "2020-04-06 19:06:16", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("167", "wc-admin_import_orders", "complete", "2020-04-06 17:06:10", "2020-04-06 19:06:10", "[718]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586192770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586192770;}", "3", "1", "2020-04-06 17:06:16", "2020-04-06 19:06:16", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("168", "wc-admin_import_customers", "complete", "2020-04-06 17:22:17", "2020-04-06 19:22:17", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586193737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586193737;}", "3", "1", "2020-04-06 17:23:33", "2020-04-06 19:23:33", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("169", "wc-admin_import_orders", "complete", "2020-04-06 17:22:18", "2020-04-06 19:22:18", "[719]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586193738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586193738;}", "3", "1", "2020-04-06 17:23:33", "2020-04-06 19:23:33", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("170", "wc-admin_import_customers", "complete", "2020-04-06 17:42:09", "2020-04-06 19:42:09", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586194929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586194929;}", "3", "1", "2020-04-06 17:42:09", "2020-04-06 19:42:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("171", "wc-admin_import_orders", "complete", "2020-04-06 17:42:09", "2020-04-06 19:42:09", "[720]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586194929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586194929;}", "3", "1", "2020-04-06 17:42:09", "2020-04-06 19:42:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("172", "wc-admin_import_customers", "complete", "2020-04-06 17:48:11", "2020-04-06 19:48:11", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195291;}", "3", "1", "2020-04-06 17:48:22", "2020-04-06 19:48:22", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("173", "wc-admin_import_orders", "complete", "2020-04-06 17:48:11", "2020-04-06 19:48:11", "[721]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195291;}", "3", "1", "2020-04-06 17:48:22", "2020-04-06 19:48:22", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("174", "wc-admin_import_customers", "complete", "2020-04-06 17:50:04", "2020-04-06 19:50:04", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195404;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195404;}", "3", "1", "2020-04-06 17:50:23", "2020-04-06 19:50:23", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("175", "wc-admin_import_orders", "complete", "2020-04-06 17:50:05", "2020-04-06 19:50:05", "[722]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195405;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195405;}", "3", "1", "2020-04-06 17:50:23", "2020-04-06 19:50:23", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("176", "wc-admin_import_customers", "complete", "2020-04-06 17:55:21", "2020-04-06 19:55:21", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195721;}", "3", "1", "2020-04-06 17:56:41", "2020-04-06 19:56:41", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("177", "wc-admin_import_orders", "complete", "2020-04-06 17:55:22", "2020-04-06 19:55:22", "[723]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195722;}", "3", "1", "2020-04-06 17:56:41", "2020-04-06 19:56:41", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("178", "wc-admin_import_customers", "complete", "2020-04-06 18:00:04", "2020-04-06 20:00:04", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196004;}", "3", "1", "2020-04-06 18:00:47", "2020-04-06 20:00:47", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("179", "wc-admin_import_orders", "complete", "2020-04-06 18:00:04", "2020-04-06 20:00:04", "[724]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196004;}", "3", "1", "2020-04-06 18:00:47", "2020-04-06 20:00:47", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("180", "wc-admin_import_customers", "complete", "2020-04-06 18:02:29", "2020-04-06 20:02:29", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196149;}", "3", "1", "2020-04-06 18:03:09", "2020-04-06 20:03:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("181", "wc-admin_import_orders", "complete", "2020-04-06 18:02:29", "2020-04-06 20:02:29", "[725]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196149;}", "3", "1", "2020-04-06 18:03:09", "2020-04-06 20:03:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("182", "wc-admin_import_customers", "complete", "2020-04-06 18:05:01", "2020-04-06 20:05:01", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196301;}", "3", "1", "2020-04-06 18:05:30", "2020-04-06 20:05:30", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("183", "wc-admin_import_orders", "complete", "2020-04-06 18:05:01", "2020-04-06 20:05:01", "[726]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196301;}", "3", "1", "2020-04-06 18:05:30", "2020-04-06 20:05:30", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("184", "wc-admin_import_customers", "complete", "2020-04-06 18:08:26", "2020-04-06 20:08:26", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196506;}", "3", "1", "2020-04-06 18:10:15", "2020-04-06 20:10:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("185", "wc-admin_import_orders", "complete", "2020-04-06 18:08:26", "2020-04-06 20:08:26", "[727]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196506;}", "3", "1", "2020-04-06 18:10:15", "2020-04-06 20:10:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("186", "wc-admin_import_orders", "complete", "2020-04-06 19:32:12", "2020-04-06 21:32:12", "[735]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586201532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586201532;}", "3", "1", "2020-04-06 19:32:34", "2020-04-06 21:32:34", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("187", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:05", "2020-04-07 13:08:05", "[717]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257685;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("188", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:05", "2020-04-07 13:08:05", "[718]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257685;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("189", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:05", "2020-04-07 13:08:05", "[719]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257685;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("190", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:05", "2020-04-07 13:08:05", "[720]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257685;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("191", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[721]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("192", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[722]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("193", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[723]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("194", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[724]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("195", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[725]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("196", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[726]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("197", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[727]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("198", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[735]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("199", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[735]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("200", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[727]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("201", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[726]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("202", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[725]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("203", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[724]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("204", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[723]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("205", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[722]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("206", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[721]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("207", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[720]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("208", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[719]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("209", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[718]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("210", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[717]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("211", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[717]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("212", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[718]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("213", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[719]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("214", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[720]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("215", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[721]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("216", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[722]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("217", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[723]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("218", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[724]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("219", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[725]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("220", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[726]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("221", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[727]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("222", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[735]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("223", "action_scheduler/migration_hook", "complete", "2020-04-07 11:28:25", "2020-04-07 13:28:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586258905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586258905;}", "1", "1", "2020-04-07 11:28:33", "2020-04-07 13:28:33", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("224", "action_scheduler/migration_hook", "complete", "2020-04-07 11:28:40", "2020-04-07 13:28:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586258920;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586258920;}", "1", "1", "2020-04-07 11:29:11", "2020-04-07 13:29:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("225", "action_scheduler/migration_hook", "complete", "2020-04-07 11:52:16", "2020-04-07 13:52:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586260336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586260336;}", "1", "1", "2020-04-07 11:53:03", "2020-04-07 13:53:03", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("226", "action_scheduler/migration_hook", "complete", "2020-04-07 12:00:28", "2020-04-07 14:00:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586260828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586260828;}", "1", "1", "2020-04-07 12:01:20", "2020-04-07 14:01:20", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("227", "action_scheduler/migration_hook", "complete", "2020-04-07 12:01:34", "2020-04-07 14:01:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586260894;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586260894;}", "1", "1", "2020-04-07 12:02:13", "2020-04-07 14:02:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("228", "action_scheduler/migration_hook", "complete", "2020-04-07 12:02:14", "2020-04-07 14:02:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586260934;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586260934;}", "1", "1", "2020-04-07 12:02:31", "2020-04-07 14:02:31", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("229", "wpforms_process_entry_emails_meta_cleanup", "pending", "2020-04-08 14:29:20", "2020-04-08 16:29:20", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586356160;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586356160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_oneactionscheduler_groups */
INSERT INTO `wp_oneactionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_oneactionscheduler_groups` VALUES("2", "wpforms");
INSERT INTO `wp_oneactionscheduler_groups` VALUES("3", "wc-admin-data");

/* INSERT TABLE DATA: wp_oneactionscheduler_logs */
INSERT INTO `wp_oneactionscheduler_logs` VALUES("1", "6", "action created", "2020-04-04 00:49:12", "2020-04-04 02:49:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("2", "6", "action started via Async Request", "2020-04-04 00:49:14", "2020-04-04 02:49:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("3", "6", "action complete via Async Request", "2020-04-04 00:49:14", "2020-04-04 02:49:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("4", "7", "action created", "2020-04-04 00:51:16", "2020-04-04 02:51:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("5", "8", "action créée", "2020-04-04 01:09:02", "2020-04-04 03:09:02");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("6", "9", "action créée", "2020-04-04 01:09:02", "2020-04-04 03:09:02");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("7", "10", "action créée", "2020-04-04 01:09:02", "2020-04-04 03:09:02");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("8", "11", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("9", "12", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("10", "13", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("11", "14", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("12", "15", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("13", "16", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("14", "17", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("15", "18", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("16", "19", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("17", "20", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("18", "21", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("19", "22", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("20", "23", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("21", "24", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("22", "25", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("23", "26", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("24", "27", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("25", "28", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("26", "29", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("27", "30", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("28", "31", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("29", "32", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("30", "33", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("31", "34", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("32", "35", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("33", "36", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("34", "37", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("35", "38", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("36", "39", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("37", "40", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("38", "41", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("39", "42", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("40", "43", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("41", "44", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("42", "45", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("43", "46", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("44", "47", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("45", "48", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("46", "49", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("47", "50", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("48", "51", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("49", "52", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("50", "53", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("51", "54", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("52", "55", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("53", "56", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("54", "8", "action lancée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("55", "8", "action terminée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("56", "9", "action lancée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("57", "9", "action terminée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("58", "10", "action lancée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("59", "10", "action terminée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("60", "11", "action lancée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("61", "11", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("62", "12", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("63", "12", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("64", "13", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("65", "13", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("66", "14", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("67", "14", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("68", "15", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("69", "15", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("70", "16", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("71", "16", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("72", "17", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("73", "17", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("74", "18", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("75", "18", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("76", "19", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("77", "19", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("78", "20", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("79", "20", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("80", "21", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("81", "21", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("82", "22", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("83", "22", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("84", "23", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("85", "23", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("86", "24", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("87", "24", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("88", "25", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("89", "25", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("90", "26", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("91", "26", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("92", "27", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("93", "27", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("94", "28", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("95", "28", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("96", "29", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("97", "29", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("98", "30", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("99", "30", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("100", "31", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("101", "31", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("102", "32", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("103", "32", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("104", "33", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("105", "33", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("106", "34", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("107", "34", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("108", "35", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("109", "35", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("110", "36", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("111", "36", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("112", "37", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("113", "37", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("114", "38", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("115", "38", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("116", "39", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("117", "39", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("118", "40", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("119", "40", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("120", "41", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("121", "41", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("122", "42", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("123", "42", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("124", "43", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("125", "43", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("126", "44", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("127", "44", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("128", "45", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("129", "45", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("130", "46", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("131", "46", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("132", "47", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("133", "47", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("134", "48", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("135", "48", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("136", "49", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("137", "49", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("138", "50", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("139", "50", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("140", "51", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("141", "51", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("142", "52", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("143", "52", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("144", "53", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("145", "53", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("146", "54", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("147", "54", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("148", "55", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("149", "55", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("150", "56", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("151", "56", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("152", "57", "action créée", "2020-04-04 01:29:31", "2020-04-04 03:29:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("153", "58", "action créée", "2020-04-04 01:29:31", "2020-04-04 03:29:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("154", "57", "action lancée via WP Cron", "2020-04-04 01:30:11", "2020-04-04 03:30:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("155", "57", "action terminée via WP Cron", "2020-04-04 01:30:11", "2020-04-04 03:30:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("156", "58", "action lancée via WP Cron", "2020-04-04 01:30:11", "2020-04-04 03:30:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("157", "58", "action terminée via WP Cron", "2020-04-04 01:30:11", "2020-04-04 03:30:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("158", "59", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("159", "60", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("160", "61", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("161", "62", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("162", "63", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("163", "64", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("164", "65", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("165", "66", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("166", "67", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("167", "68", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("168", "69", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("169", "70", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("170", "71", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("171", "72", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("172", "73", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("173", "74", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("174", "75", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("175", "76", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("176", "77", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("177", "59", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("178", "59", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("179", "60", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("180", "60", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("181", "61", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("182", "61", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("183", "62", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("184", "62", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("185", "63", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("186", "63", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("187", "64", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("188", "64", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("189", "65", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("190", "65", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("191", "66", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("192", "66", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("193", "67", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("194", "67", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("195", "68", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("196", "68", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("197", "69", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("198", "69", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("199", "70", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("200", "70", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("201", "71", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("202", "71", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("203", "72", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("204", "72", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("205", "73", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("206", "73", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("207", "74", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("208", "74", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("209", "75", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("210", "75", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("211", "76", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("212", "76", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("213", "77", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("214", "77", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("215", "78", "action créée", "2020-04-04 01:33:13", "2020-04-04 03:33:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("216", "79", "action créée", "2020-04-04 01:33:13", "2020-04-04 03:33:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("217", "80", "action créée", "2020-04-04 01:33:13", "2020-04-04 03:33:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("218", "81", "action créée", "2020-04-04 01:33:13", "2020-04-04 03:33:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("219", "82", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("220", "83", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("221", "84", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("222", "85", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("223", "86", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("224", "87", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("225", "88", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("226", "89", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("227", "90", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("228", "91", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("229", "92", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("230", "93", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("231", "94", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("232", "95", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("233", "96", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("234", "78", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("235", "78", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("236", "79", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("237", "79", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("238", "80", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("239", "80", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("240", "81", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("241", "81", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("242", "82", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("243", "82", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("244", "83", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("245", "83", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("246", "84", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("247", "84", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("248", "85", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("249", "85", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("250", "86", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("251", "86", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("252", "87", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("253", "87", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("254", "88", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("255", "88", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("256", "89", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("257", "89", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("258", "90", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("259", "90", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("260", "91", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("261", "91", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("262", "92", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("263", "92", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("264", "93", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("265", "93", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("266", "94", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("267", "94", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("268", "95", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("269", "95", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("270", "96", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("271", "96", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("272", "97", "action créée", "2020-04-04 14:06:53", "2020-04-04 16:06:53");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("273", "98", "action créée", "2020-04-04 14:06:53", "2020-04-04 16:06:53");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("274", "97", "action lancée via WP Cron", "2020-04-04 14:07:38", "2020-04-04 16:07:38");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("275", "97", "action terminée via WP Cron", "2020-04-04 14:07:38", "2020-04-04 16:07:38");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("276", "98", "action lancée via WP Cron", "2020-04-04 14:07:38", "2020-04-04 16:07:38");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("277", "98", "action terminée via WP Cron", "2020-04-04 14:07:38", "2020-04-04 16:07:38");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("278", "99", "action créée", "2020-04-04 16:14:15", "2020-04-04 18:14:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("279", "100", "action créée", "2020-04-04 16:14:15", "2020-04-04 18:14:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("280", "99", "action lancée via WP Cron", "2020-04-04 16:21:06", "2020-04-04 18:21:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("281", "99", "action terminée via WP Cron", "2020-04-04 16:21:06", "2020-04-04 18:21:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("282", "100", "action lancée via WP Cron", "2020-04-04 16:21:06", "2020-04-04 18:21:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("283", "100", "action terminée via WP Cron", "2020-04-04 16:21:06", "2020-04-04 18:21:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("284", "101", "action créée", "2020-04-04 17:44:05", "2020-04-04 19:44:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("285", "102", "action créée", "2020-04-04 17:44:05", "2020-04-04 19:44:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("286", "101", "action lancée via Async Request", "2020-04-04 17:45:50", "2020-04-04 19:45:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("287", "101", "action terminée via Async Request", "2020-04-04 17:45:50", "2020-04-04 19:45:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("288", "102", "action lancée via Async Request", "2020-04-04 17:45:50", "2020-04-04 19:45:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("289", "102", "action terminée via Async Request", "2020-04-04 17:45:50", "2020-04-04 19:45:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("290", "7", "action lancée via WP Cron", "2020-04-05 12:34:05", "2020-04-05 14:34:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("291", "7", "action terminée via WP Cron", "2020-04-05 12:34:05", "2020-04-05 14:34:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("292", "103", "action créée", "2020-04-05 12:34:05", "2020-04-05 14:34:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("293", "104", "action créée", "2020-04-05 18:17:26", "2020-04-05 20:17:26");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("294", "105", "action créée", "2020-04-05 18:17:26", "2020-04-05 20:17:26");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("295", "104", "action lancée via WP Cron", "2020-04-05 18:18:15", "2020-04-05 20:18:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("296", "104", "action terminée via WP Cron", "2020-04-05 18:18:15", "2020-04-05 20:18:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("297", "105", "action lancée via WP Cron", "2020-04-05 18:18:15", "2020-04-05 20:18:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("298", "105", "action terminée via WP Cron", "2020-04-05 18:18:15", "2020-04-05 20:18:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("299", "106", "action créée", "2020-04-05 20:45:55", "2020-04-05 22:45:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("300", "107", "action créée", "2020-04-05 20:45:55", "2020-04-05 22:45:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("301", "106", "action lancée via Async Request", "2020-04-05 20:46:42", "2020-04-05 22:46:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("302", "106", "action terminée via Async Request", "2020-04-05 20:46:42", "2020-04-05 22:46:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("303", "107", "action lancée via Async Request", "2020-04-05 20:46:42", "2020-04-05 22:46:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("304", "107", "action terminée via Async Request", "2020-04-05 20:46:42", "2020-04-05 22:46:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("305", "108", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("306", "109", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("307", "110", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("308", "111", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("309", "112", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("310", "113", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("311", "114", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("312", "115", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("313", "116", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("314", "117", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("315", "118", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("316", "119", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("317", "120", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("318", "121", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("319", "122", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("320", "123", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("321", "124", "action créée", "2020-04-05 21:15:25", "2020-04-05 23:15:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("322", "125", "action créée", "2020-04-05 21:15:25", "2020-04-05 23:15:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("323", "126", "action créée", "2020-04-05 21:15:25", "2020-04-05 23:15:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("324", "127", "action créée", "2020-04-05 21:15:25", "2020-04-05 23:15:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("325", "128", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("326", "129", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("327", "130", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("328", "131", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("329", "132", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("330", "133", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("331", "134", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("332", "135", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("333", "136", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("334", "137", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("335", "138", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("336", "139", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("337", "140", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("338", "141", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("339", "142", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("340", "143", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("341", "144", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("342", "145", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("343", "146", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("344", "147", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("345", "148", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("346", "149", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("347", "150", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("348", "151", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("349", "152", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("350", "153", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("351", "154", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("352", "155", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("353", "156", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("354", "157", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("355", "158", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("356", "159", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("357", "160", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("358", "161", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("359", "162", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("360", "108", "action lancée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("361", "108", "action terminée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("362", "109", "action lancée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("363", "109", "action terminée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("364", "110", "action lancée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("365", "110", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("366", "111", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("367", "111", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("368", "112", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("369", "112", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("370", "113", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("371", "113", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("372", "114", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("373", "114", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("374", "115", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("375", "115", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("376", "116", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("377", "116", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("378", "117", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("379", "117", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("380", "118", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("381", "118", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("382", "119", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("383", "119", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("384", "120", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("385", "120", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("386", "121", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("387", "121", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("388", "122", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("389", "122", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("390", "123", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("391", "123", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("392", "124", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("393", "124", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("394", "125", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("395", "125", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("396", "126", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("397", "126", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("398", "127", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("399", "127", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("400", "128", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("401", "128", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("402", "129", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("403", "129", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("404", "130", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("405", "130", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("406", "131", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("407", "131", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("408", "132", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("409", "132", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("410", "133", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("411", "133", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("412", "134", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("413", "134", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("414", "135", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("415", "135", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("416", "136", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("417", "136", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("418", "137", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("419", "137", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("420", "138", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("421", "138", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("422", "139", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("423", "139", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("424", "140", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("425", "140", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("426", "141", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("427", "141", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("428", "142", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("429", "142", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("430", "143", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("431", "143", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("432", "144", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("433", "144", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("434", "145", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("435", "145", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("436", "146", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("437", "146", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("438", "147", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("439", "147", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("440", "148", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("441", "148", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("442", "149", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("443", "149", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("444", "150", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("445", "150", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("446", "151", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("447", "151", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("448", "152", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("449", "152", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("450", "153", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("451", "153", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("452", "154", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("453", "154", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("454", "155", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("455", "155", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("456", "156", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("457", "156", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("458", "157", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("459", "157", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("460", "158", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("461", "158", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("462", "159", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("463", "159", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("464", "160", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("465", "160", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("466", "161", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("467", "161", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("468", "162", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("469", "162", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("470", "103", "action lancée via WP Cron", "2020-04-06 12:54:31", "2020-04-06 14:54:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("471", "103", "action terminée via WP Cron", "2020-04-06 12:54:31", "2020-04-06 14:54:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("472", "163", "action créée", "2020-04-06 12:54:31", "2020-04-06 14:54:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("473", "164", "action créée", "2020-04-06 17:02:33", "2020-04-06 19:02:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("474", "165", "action créée", "2020-04-06 17:02:33", "2020-04-06 19:02:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("475", "164", "action lancée via WP Cron", "2020-04-06 17:03:47", "2020-04-06 19:03:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("476", "164", "action terminée via WP Cron", "2020-04-06 17:03:47", "2020-04-06 19:03:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("477", "165", "action lancée via WP Cron", "2020-04-06 17:03:47", "2020-04-06 19:03:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("478", "165", "action terminée via WP Cron", "2020-04-06 17:03:47", "2020-04-06 19:03:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("479", "166", "action créée", "2020-04-06 17:06:05", "2020-04-06 19:06:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("480", "167", "action créée", "2020-04-06 17:06:05", "2020-04-06 19:06:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("481", "166", "action lancée via Async Request", "2020-04-06 17:06:16", "2020-04-06 19:06:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("482", "166", "action terminée via Async Request", "2020-04-06 17:06:16", "2020-04-06 19:06:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("483", "167", "action lancée via Async Request", "2020-04-06 17:06:16", "2020-04-06 19:06:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("484", "167", "action terminée via Async Request", "2020-04-06 17:06:16", "2020-04-06 19:06:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("485", "168", "action créée", "2020-04-06 17:22:12", "2020-04-06 19:22:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("486", "169", "action créée", "2020-04-06 17:22:13", "2020-04-06 19:22:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("487", "168", "action lancée via WP Cron", "2020-04-06 17:23:33", "2020-04-06 19:23:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("488", "168", "action terminée via WP Cron", "2020-04-06 17:23:33", "2020-04-06 19:23:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("489", "169", "action lancée via WP Cron", "2020-04-06 17:23:33", "2020-04-06 19:23:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("490", "169", "action terminée via WP Cron", "2020-04-06 17:23:33", "2020-04-06 19:23:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("491", "170", "action créée", "2020-04-06 17:42:04", "2020-04-06 19:42:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("492", "171", "action créée", "2020-04-06 17:42:04", "2020-04-06 19:42:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("493", "170", "action lancée via WP Cron", "2020-04-06 17:42:09", "2020-04-06 19:42:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("494", "170", "action terminée via WP Cron", "2020-04-06 17:42:09", "2020-04-06 19:42:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("495", "171", "action lancée via WP Cron", "2020-04-06 17:42:09", "2020-04-06 19:42:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("496", "171", "action terminée via WP Cron", "2020-04-06 17:42:09", "2020-04-06 19:42:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("497", "172", "action créée", "2020-04-06 17:48:06", "2020-04-06 19:48:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("498", "173", "action créée", "2020-04-06 17:48:06", "2020-04-06 19:48:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("499", "172", "action lancée via WP Cron", "2020-04-06 17:48:22", "2020-04-06 19:48:22");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("500", "172", "action terminée via WP Cron", "2020-04-06 17:48:22", "2020-04-06 19:48:22");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("501", "173", "action lancée via WP Cron", "2020-04-06 17:48:22", "2020-04-06 19:48:22");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("502", "173", "action terminée via WP Cron", "2020-04-06 17:48:22", "2020-04-06 19:48:22");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("503", "174", "action créée", "2020-04-06 17:49:59", "2020-04-06 19:49:59");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("504", "175", "action créée", "2020-04-06 17:50:00", "2020-04-06 19:50:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("505", "174", "action lancée via WP Cron", "2020-04-06 17:50:23", "2020-04-06 19:50:23");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("506", "174", "action terminée via WP Cron", "2020-04-06 17:50:23", "2020-04-06 19:50:23");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("507", "175", "action lancée via WP Cron", "2020-04-06 17:50:23", "2020-04-06 19:50:23");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("508", "175", "action terminée via WP Cron", "2020-04-06 17:50:23", "2020-04-06 19:50:23");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("509", "176", "action créée", "2020-04-06 17:55:17", "2020-04-06 19:55:17");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("510", "177", "action créée", "2020-04-06 17:55:17", "2020-04-06 19:55:17");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("511", "176", "action lancée via WP Cron", "2020-04-06 17:56:41", "2020-04-06 19:56:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("512", "176", "action terminée via WP Cron", "2020-04-06 17:56:41", "2020-04-06 19:56:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("513", "177", "action lancée via WP Cron", "2020-04-06 17:56:41", "2020-04-06 19:56:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("514", "177", "action terminée via WP Cron", "2020-04-06 17:56:41", "2020-04-06 19:56:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("515", "178", "action créée", "2020-04-06 17:59:59", "2020-04-06 19:59:59");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("516", "179", "action créée", "2020-04-06 17:59:59", "2020-04-06 19:59:59");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("517", "178", "action lancée via Async Request", "2020-04-06 18:00:47", "2020-04-06 20:00:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("518", "178", "action terminée via Async Request", "2020-04-06 18:00:47", "2020-04-06 20:00:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("519", "179", "action lancée via Async Request", "2020-04-06 18:00:47", "2020-04-06 20:00:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("520", "179", "action terminée via Async Request", "2020-04-06 18:00:47", "2020-04-06 20:00:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("521", "180", "action créée", "2020-04-06 18:02:24", "2020-04-06 20:02:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("522", "181", "action créée", "2020-04-06 18:02:24", "2020-04-06 20:02:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("523", "180", "action lancée via Async Request", "2020-04-06 18:03:09", "2020-04-06 20:03:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("524", "180", "action terminée via Async Request", "2020-04-06 18:03:09", "2020-04-06 20:03:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("525", "181", "action lancée via Async Request", "2020-04-06 18:03:09", "2020-04-06 20:03:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("526", "181", "action terminée via Async Request", "2020-04-06 18:03:09", "2020-04-06 20:03:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("527", "182", "action créée", "2020-04-06 18:04:56", "2020-04-06 20:04:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("528", "183", "action créée", "2020-04-06 18:04:56", "2020-04-06 20:04:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("529", "182", "action lancée via WP Cron", "2020-04-06 18:05:30", "2020-04-06 20:05:30");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("530", "182", "action terminée via WP Cron", "2020-04-06 18:05:30", "2020-04-06 20:05:30");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("531", "183", "action lancée via WP Cron", "2020-04-06 18:05:30", "2020-04-06 20:05:30");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("532", "183", "action terminée via WP Cron", "2020-04-06 18:05:30", "2020-04-06 20:05:30");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("533", "184", "action créée", "2020-04-06 18:08:21", "2020-04-06 20:08:21");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("534", "185", "action créée", "2020-04-06 18:08:21", "2020-04-06 20:08:21");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("535", "184", "action lancée via WP Cron", "2020-04-06 18:10:15", "2020-04-06 20:10:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("536", "184", "action terminée via WP Cron", "2020-04-06 18:10:15", "2020-04-06 20:10:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("537", "185", "action lancée via WP Cron", "2020-04-06 18:10:15", "2020-04-06 20:10:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("538", "185", "action terminée via WP Cron", "2020-04-06 18:10:15", "2020-04-06 20:10:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("539", "186", "action créée", "2020-04-06 19:32:07", "2020-04-06 21:32:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("540", "186", "action lancée via Async Request", "2020-04-06 19:32:34", "2020-04-06 21:32:34");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("541", "186", "action terminée via Async Request", "2020-04-06 19:32:34", "2020-04-06 21:32:34");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("542", "187", "action créée", "2020-04-07 11:08:00", "2020-04-07 13:08:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("543", "188", "action créée", "2020-04-07 11:08:00", "2020-04-07 13:08:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("544", "189", "action créée", "2020-04-07 11:08:00", "2020-04-07 13:08:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("545", "190", "action créée", "2020-04-07 11:08:00", "2020-04-07 13:08:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("546", "191", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("547", "192", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("548", "193", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("549", "194", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("550", "195", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("551", "196", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("552", "197", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("553", "198", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("554", "199", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("555", "200", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("556", "201", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("557", "202", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("558", "203", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("559", "204", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("560", "205", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("561", "187", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("562", "187", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("563", "188", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("564", "188", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("565", "206", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("566", "189", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("567", "189", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("568", "190", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("569", "190", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("570", "191", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("571", "191", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("572", "207", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("573", "192", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("574", "192", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("575", "193", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("576", "193", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("577", "194", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("578", "194", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("579", "195", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("580", "208", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("581", "195", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("582", "196", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("583", "196", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("584", "197", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("585", "197", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("586", "198", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("587", "209", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("588", "198", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("589", "210", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("590", "211", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("591", "212", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("592", "213", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("593", "214", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("594", "215", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("595", "216", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("596", "217", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("597", "218", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("598", "219", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("599", "220", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("600", "221", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("601", "222", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("602", "199", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("603", "199", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("604", "200", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("605", "200", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("606", "201", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("607", "201", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("608", "202", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("609", "202", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("610", "203", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("611", "203", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("612", "204", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("613", "204", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("614", "205", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("615", "205", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("616", "206", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("617", "206", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("618", "207", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("619", "207", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("620", "208", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("621", "208", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("622", "209", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("623", "209", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("624", "210", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("625", "210", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("626", "211", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("627", "211", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("628", "212", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("629", "212", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("630", "213", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("631", "213", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("632", "214", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("633", "214", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("634", "215", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("635", "215", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("636", "216", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("637", "216", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("638", "217", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("639", "217", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("640", "218", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("641", "218", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("642", "219", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("643", "219", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("644", "220", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("645", "220", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("646", "221", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("647", "221", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("648", "222", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("649", "222", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("650", "223", "action créée", "2020-04-07 11:28:25", "2020-04-07 13:28:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("651", "223", "action lancée via Async Request", "2020-04-07 11:28:33", "2020-04-07 13:28:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("652", "223", "action terminée via Async Request", "2020-04-07 11:28:33", "2020-04-07 13:28:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("653", "224", "action créée", "2020-04-07 11:28:40", "2020-04-07 13:28:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("654", "224", "action lancée via WP Cron", "2020-04-07 11:29:11", "2020-04-07 13:29:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("655", "224", "action terminée via WP Cron", "2020-04-07 11:29:11", "2020-04-07 13:29:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("656", "225", "action created", "2020-04-07 11:52:16", "2020-04-07 13:52:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("657", "225", "action started via Async Request", "2020-04-07 11:53:03", "2020-04-07 13:53:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("658", "225", "action complete via Async Request", "2020-04-07 11:53:03", "2020-04-07 13:53:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("659", "226", "action créée", "2020-04-07 12:00:28", "2020-04-07 14:00:28");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("660", "226", "action lancée via WP Cron", "2020-04-07 12:01:20", "2020-04-07 14:01:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("661", "226", "action terminée via WP Cron", "2020-04-07 12:01:20", "2020-04-07 14:01:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("662", "227", "action créée", "2020-04-07 12:01:34", "2020-04-07 14:01:34");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("663", "227", "action lancée via WP Cron", "2020-04-07 12:02:13", "2020-04-07 14:02:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("664", "227", "action terminée via WP Cron", "2020-04-07 12:02:13", "2020-04-07 14:02:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("665", "228", "action créée", "2020-04-07 12:02:14", "2020-04-07 14:02:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("666", "228", "action lancée via Async Request", "2020-04-07 12:02:31", "2020-04-07 14:02:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("667", "228", "action terminée via Async Request", "2020-04-07 12:02:31", "2020-04-07 14:02:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("668", "163", "action lancée via WP Cron", "2020-04-07 14:29:20", "2020-04-07 16:29:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("669", "163", "action terminée via WP Cron", "2020-04-07 14:29:20", "2020-04-07 16:29:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("670", "229", "action créée", "2020-04-07 14:29:20", "2020-04-07 16:29:20");

/* INSERT TABLE DATA: wp_onecleantalk_sessions */
INSERT INTO `wp_onecleantalk_sessions` VALUES("1d569e7cbe187af6dabb4d938ec6adc4d0dcd2e812355d5fa5ba0bb80d3d0447", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:44:05");
INSERT INTO `wp_onecleantalk_sessions` VALUES("2f483dd46af3815468a3c6f3a2692b7fc9f6d518bad76e5b4d42bb10a9a10d5e", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:24:46");
INSERT INTO `wp_onecleantalk_sessions` VALUES("3212f1bb0d4c088f0f162528ee5b1bdb0eff98826558996c05956adf6c065a7e", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:24:46");
INSERT INTO `wp_onecleantalk_sessions` VALUES("3d6e083a4ca6d199e5e41c80140d0ae01ae1e0599c484b713bc60942d8a951f9", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:44:05");
INSERT INTO `wp_onecleantalk_sessions` VALUES("464f106226f2e3f673646832b77ff164ff651aebf11f8f1802b7cb87e15304ee", "apbct_site_referer", "UNKNOWN", "2020-04-08 11:01:13");
INSERT INTO `wp_onecleantalk_sessions` VALUES("6098f056c53293d158bb3480508c3732fe13a2519d4ec2bc1917501716b72f7b", "apbct_site_referer", "UNKNOWN", "2020-04-06 16:27:06");
INSERT INTO `wp_onecleantalk_sessions` VALUES("6e5bb4980ae20335f60e3aa11ac0d10678b03e580a614cf3666d0bccf59dc2cc", "apbct_site_referer", "UNKNOWN", "2020-04-06 19:34:34");
INSERT INTO `wp_onecleantalk_sessions` VALUES("85a35b5266b1ef9b77508f6bf6bf3fa08b0e99545e6b9d31f388029bb2598e20", "apbct_site_referer", "UNKNOWN", "2020-04-06 19:23:59");
INSERT INTO `wp_onecleantalk_sessions` VALUES("87c35fd083472c9b15ecc0a59f854e9286e515c288805d8aaec7a8b013b53d24", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:49:48");
INSERT INTO `wp_onecleantalk_sessions` VALUES("94c195f3d39c3c37d71dcfe1d88b7913dfa8dbd2a2e65a0fd452a0fb4805eff9", "apbct_site_referer", "UNKNOWN", "2020-04-05 21:47:32");
INSERT INTO `wp_onecleantalk_sessions` VALUES("989dfdfb40458987ac3f55ac7b8ac88b2a8515a6beb9c1fcbbc896d22bbd74a4", "apbct_site_referer", "UNKNOWN", "2020-04-06 16:46:56");
INSERT INTO `wp_onecleantalk_sessions` VALUES("9a17f357eb134af84f34d9194b1193b4f6b9387ba2cd53d0309438bcfc1ac67c", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:51:52");
INSERT INTO `wp_onecleantalk_sessions` VALUES("a025337dab3dea1055c85a5d2d4b7822cde8c91092fe7d9f2cf33b58022e53e9", "apbct_site_referer", "UNKNOWN", "2020-04-08 01:31:35");
INSERT INTO `wp_onecleantalk_sessions` VALUES("ab7e5e06318ebb1695a8983834ef4b5d4b3da612dee0b118c8818cdd897dba4b", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:44:05");
INSERT INTO `wp_onecleantalk_sessions` VALUES("ac94352456189b14443103c62a54e2b3bb573322bb0c0a35045989ac0ad263b8", "apbct_site_referer", "UNKNOWN", "2020-04-06 19:24:40");
INSERT INTO `wp_onecleantalk_sessions` VALUES("b0f19bc2e58fe2aec16ac300112c362dadbc7515e1c7c7e9319e9ca6badfb6b9", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:24:48");
INSERT INTO `wp_onecleantalk_sessions` VALUES("b75a1b167fdd2464d2f50ee6df38657cc574cbaa687443d354b7e42003c0099c", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:50:27");
INSERT INTO `wp_onecleantalk_sessions` VALUES("befac3dc7d03d095fdb986f2f2bb65a7bb93d0b226c40e390692df8252e6212b", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:24:48");
INSERT INTO `wp_onecleantalk_sessions` VALUES("c26d4b7f496cf85095fc48a64a35bec52b4f4f7cb8ee0c01a1f9d815902d0160", "apbct_site_referer", "https://l.messenger.com/", "2020-04-06 19:28:28");
INSERT INTO `wp_onecleantalk_sessions` VALUES("c86806e0e046f81d1d150f346b548974addb7da9febf4f1ae26dd08357872c9b", "apbct_site_referer", "UNKNOWN", "2020-04-06 15:18:47");
INSERT INTO `wp_onecleantalk_sessions` VALUES("e287a1482adb182e3f4328ec36cc7e40dbfe044a448fb6754f09aca101c22d2c", "apbct_site_referer", "UNKNOWN", "2020-04-06 19:23:58");
INSERT INTO `wp_onecleantalk_sessions` VALUES("e6cf1951ba7c5f0828e8976b11c24179a82af9df74e9b29e0684430b3ebe25b0", "apbct_site_referer", "UNKNOWN", "2020-04-06 14:44:04");
INSERT INTO `wp_onecleantalk_sessions` VALUES("ef99dc8678820f704f33e3595137b71b4ae126581b78113903f539115c241a7f", "apbct_site_referer", "UNKNOWN", "2020-04-06 11:12:18");
INSERT INTO `wp_onecleantalk_sessions` VALUES("f9dafc9e688f5b7639eff3ff7c6294e726fe1d775b19a43c9a02d34a35e9ac80", "apbct_site_referer", "UNKNOWN", "2020-04-06 19:23:57");
INSERT INTO `wp_onecleantalk_sessions` VALUES("fa6365048a8627a62c875dafcf2809461f8ddba493e415a9ce8fa69fb32d1cc7", "apbct_site_referer", "UNKNOWN", "2020-04-06 19:23:59");
INSERT INTO `wp_onecleantalk_sessions` VALUES("1d569e7cbe187af6dabb4d938ec6adc4d0dcd2e812355d5fa5ba0bb80d3d0447", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586184245]}", "2020-04-06 14:44:05");
INSERT INTO `wp_onecleantalk_sessions` VALUES("2f483dd46af3815468a3c6f3a2692b7fc9f6d518bad76e5b4d42bb10a9a10d5e", "apbct_urls", "{\"one.mylocalshop.fr\\/informations-importantes\":[1586183086]}", "2020-04-06 14:24:46");
INSERT INTO `wp_onecleantalk_sessions` VALUES("3212f1bb0d4c088f0f162528ee5b1bdb0eff98826558996c05956adf6c065a7e", "apbct_urls", "{\"one.mylocalshop.fr\\/informations-importantes\\/\":[1586183086]}", "2020-04-06 14:24:46");
INSERT INTO `wp_onecleantalk_sessions` VALUES("3d6e083a4ca6d199e5e41c80140d0ae01ae1e0599c484b713bc60942d8a951f9", "apbct_urls", "{\"one.mylocalshop.fr\\/informations-importantes\":[1586183093],\"one.mylocalshop.fr\\/informations-importantes\\/\":[1586183093],\"one.mylocalshop.fr\\/contact\\/\":[1586184245]}", "2020-04-06 14:44:05");
INSERT INTO `wp_onecleantalk_sessions` VALUES("464f106226f2e3f673646832b77ff164ff651aebf11f8f1802b7cb87e15304ee", "apbct_urls", "{\"core.mylocalshop.fr\\/robots.txt\":[1586256760,1586269759],\"core.mylocalshop.fr\\/favicon.ico\":[1586256763,1586258402,1586258657],\"core.mylocalshop.fr\\/\":[1586257646,1586260772,1586261530,1586269759,1586343673],\"core.mylocalshop.fr\\/informations-importantes\\/\":[1586261491],\"core.mylocalshop.fr\\/my-account\\/\":[1586261501,1586261508],\"core.mylocalshop.fr\\/my-account\\/customer-logout\\/?_wpnonce=50cb7d2a75\":[1586261508],\"core.mylocalshop.fr\\/contact\\/\":[1586261519]}", "2020-04-08 11:01:13");
INSERT INTO `wp_onecleantalk_sessions` VALUES("6098f056c53293d158bb3480508c3732fe13a2519d4ec2bc1917501716b72f7b", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586190426]}", "2020-04-06 16:27:06");
INSERT INTO `wp_onecleantalk_sessions` VALUES("6e5bb4980ae20335f60e3aa11ac0d10678b03e580a614cf3666d0bccf59dc2cc", "apbct_urls", "{\"one.mylocalshop.fr\\/produit\\/baguette\\/\":[1586196279],\"one.mylocalshop.fr\\/checkout\\/order-received\\/726\\/?key=wc_order_MWwS0ANrrXlXP\":[1586196297],\"one.mylocalshop.fr\\/checkout\\/\":[1586196497],\"one.mylocalshop.fr\\/checkout\\/order-received\\/727\\/?key=wc_order_zoTWjf7oj04PN\":[1586196502],\"one.mylocalshop.fr\\/?customize_changeset_uuid=77bff85a-ef63-434c-ac8e-f37729001958&customize_theme=oceanwp&customize_messenger_channel=preview-0\":[1586200272],\"one.mylocalshop.fr\\/favicon.ico\":[1586200612],\"one.mylocalshop.fr\\/?customize_changeset_uuid=55e35358-ad8c-413a-b399-f14923aa4bc6&customize_theme=oceanwp&customize_messenger_channel=preview-0\":[1586200872],\"one.mylocalshop.fr\\/?customize_changeset_uuid=55e35358-ad8c-413a-b399-f14923aa4bc6&customize_theme=oceanwp&customize_messenger_channel=preview-1&customize_autosaved=on\":[1586200891],\"core.mylocalshop.fr\\/\":[1586208559],\"core.mylocalshop.fr\\/informations-importantes\\/\":[1586208616]}", "2020-04-06 21:30:16");
INSERT INTO `wp_onecleantalk_sessions` VALUES("85a35b5266b1ef9b77508f6bf6bf3fa08b0e99545e6b9d31f388029bb2598e20", "apbct_urls", "{\"one.mylocalshop.fr\\/\":[1586201039]}", "2020-04-06 19:23:59");
INSERT INTO `wp_onecleantalk_sessions` VALUES("87c35fd083472c9b15ecc0a59f854e9286e515c288805d8aaec7a8b013b53d24", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586184588]}", "2020-04-06 14:49:48");
INSERT INTO `wp_onecleantalk_sessions` VALUES("94c195f3d39c3c37d71dcfe1d88b7913dfa8dbd2a2e65a0fd452a0fb4805eff9", "apbct_urls", "{\"one.mylocalshop.fr\\/\":[1586123252],\"one.mylocalshop.fr\\/favicon.ico\":[1586123254]}", "2020-04-05 21:47:34");
INSERT INTO `wp_onecleantalk_sessions` VALUES("989dfdfb40458987ac3f55ac7b8ac88b2a8515a6beb9c1fcbbc896d22bbd74a4", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586184244,1586191616]}", "2020-04-06 16:46:56");
INSERT INTO `wp_onecleantalk_sessions` VALUES("9a17f357eb134af84f34d9194b1193b4f6b9387ba2cd53d0309438bcfc1ac67c", "apbct_urls", "{\"one.mylocalshop.fr\\/\":[1586184712,1586184843,1586185027,1586185544,1586185600,1586185613,1586185772],\"one.mylocalshop.fr\\/informations-importantes\\/\":[1586184749],\"one.mylocalshop.fr\\/my-account\\/\":[1586184801],\"one.mylocalshop.fr\\/contact\\/\":[1586184804,1586185671],\"one.mylocalshop.fr\\/produit\\/baguette\\/\":[1586184876],\"one.mylocalshop.fr\\/produit\\/pain-de-campagne\\/\":[1586184893],\"one.mylocalshop.fr\\/cart\\/\":[1586185022,1586185606,1586185663,1586185691],\"one.mylocalshop.fr\\/checkout\\/\":[1586185146,1586185694],\"one.mylocalshop.fr\\/categorie-produit\\/viennoiseries\\/\":[1586185585],\"one.mylocalshop.fr\\/produit\\/brioche\\/\":[1586185596]}", "2020-04-06 15:09:32");
INSERT INTO `wp_onecleantalk_sessions` VALUES("a025337dab3dea1055c85a5d2d4b7822cde8c91092fe7d9f2cf33b58022e53e9", "apbct_urls", "{\"core.mylocalshop.fr\\/\":[1586309495]}", "2020-04-08 01:31:35");
INSERT INTO `wp_onecleantalk_sessions` VALUES("ab7e5e06318ebb1695a8983834ef4b5d4b3da612dee0b118c8818cdd897dba4b", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586184245]}", "2020-04-06 14:44:05");
INSERT INTO `wp_onecleantalk_sessions` VALUES("ac94352456189b14443103c62a54e2b3bb573322bb0c0a35045989ac0ad263b8", "apbct_urls", "{\"one.mylocalshop.fr\\/\":[1586201080,1586201114],\"one.mylocalshop.fr\\/categorie-produit\\/pains\\/\":[1586201094],\"one.mylocalshop.fr\\/categorie-produit\\/viennoiseries\\/\":[1586201099]}", "2020-04-06 19:25:14");
INSERT INTO `wp_onecleantalk_sessions` VALUES("b0f19bc2e58fe2aec16ac300112c362dadbc7515e1c7c7e9319e9ca6badfb6b9", "apbct_urls", "{\"one.mylocalshop.fr\\/informations-importantes\\/\":[1586183088]}", "2020-04-06 14:24:48");
INSERT INTO `wp_onecleantalk_sessions` VALUES("b75a1b167fdd2464d2f50ee6df38657cc574cbaa687443d354b7e42003c0099c", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586184599,1586184627]}", "2020-04-06 14:50:27");
INSERT INTO `wp_onecleantalk_sessions` VALUES("befac3dc7d03d095fdb986f2f2bb65a7bb93d0b226c40e390692df8252e6212b", "apbct_urls", "{\"one.mylocalshop.fr\\/informations-importantes\\/\":[1586183088]}", "2020-04-06 14:24:48");
INSERT INTO `wp_onecleantalk_sessions` VALUES("c26d4b7f496cf85095fc48a64a35bec52b4f4f7cb8ee0c01a1f9d815902d0160", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586185973,1586196393],\"one.mylocalshop.fr\\/favicon.ico\":[1586185976],\"one.mylocalshop.fr\\/\":[1586185982,1586201131,1586201179,1586201308,1586201322,1586201328,1586201330,1586201449,1586201683],\"one.mylocalshop.fr\\/?fbclid=IwAR0Vsr37pkIdaqs5KGNoNq3NEdQTNPpdCKFzHtgWSgqz2nvSL0ej-R6oIjA\":[1586201090],\"one.mylocalshop.fr\\/informations-importantes\\/\":[1586201105],\"one.mylocalshop.fr\\/checkout\\/\":[1586201142,1586201412,1586201422,1586201467],\"one.mylocalshop.fr\\/cart\\/\":[1586201385,1586201386,1586201418,1586201427,1586201464],\"one.mylocalshop.fr\\/checkout\\/order-received\\/735\\/?key=wc_order_xvWagqPlOU8m3\":[1586201529]}", "2020-04-06 19:34:43");
INSERT INTO `wp_onecleantalk_sessions` VALUES("c86806e0e046f81d1d150f346b548974addb7da9febf4f1ae26dd08357872c9b", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586186327]}", "2020-04-06 15:18:47");
INSERT INTO `wp_onecleantalk_sessions` VALUES("e287a1482adb182e3f4328ec36cc7e40dbfe044a448fb6754f09aca101c22d2c", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\":[1586184244],\"one.mylocalshop.fr\\/\":[1586201037]}", "2020-04-06 19:23:57");
INSERT INTO `wp_onecleantalk_sessions` VALUES("e6cf1951ba7c5f0828e8976b11c24179a82af9df74e9b29e0684430b3ebe25b0", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\\/\":[1586184244]}", "2020-04-06 14:44:04");
INSERT INTO `wp_onecleantalk_sessions` VALUES("ef99dc8678820f704f33e3595137b71b4ae126581b78113903f539115c241a7f", "apbct_urls", "{\"one.mylocalshop.fr\\/robots.txt\":[1586171538],\"one.mylocalshop.fr\\/favicon.ico\":[1586171541,1586184609],\"one.mylocalshop.fr\\/wp-login.php\":[1586171558]}", "2020-04-06 14:50:09");
INSERT INTO `wp_onecleantalk_sessions` VALUES("f9dafc9e688f5b7639eff3ff7c6294e726fe1d775b19a43c9a02d34a35e9ac80", "apbct_urls", "{\"one.mylocalshop.fr\\/\":[1586201037]}", "2020-04-06 19:23:57");
INSERT INTO `wp_onecleantalk_sessions` VALUES("fa6365048a8627a62c875dafcf2809461f8ddba493e415a9ce8fa69fb32d1cc7", "apbct_urls", "{\"one.mylocalshop.fr\\/contact\":[1586184250],\"one.mylocalshop.fr\\/contact\\/\":[1586184250],\"one.mylocalshop.fr\\/\":[1586201039]}", "2020-04-06 19:23:59");

/* INSERT TABLE DATA: wp_onecleantalk_sfw */
INSERT INTO `wp_onecleantalk_sfw` VALUES("18113804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("18113804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("18113804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("18113804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20195476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20195476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20195476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20195476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20239735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20239735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20239735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20239735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20252775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20252775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20252775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20252775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20312673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20312673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20312673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20312673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20333093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20333093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20333093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20333093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336235", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336235", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336235", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336235", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("20336370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("30909123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("30909123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("30909123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("30909123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("32126240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("32126240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("32126240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("32126240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36780199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36780199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36780199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36780199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36780439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36780439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36780439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36780439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36907851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36907851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36907851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("36907851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37260101", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37260101", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37260101", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37260101", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37295906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37296065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37296065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37296065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37296065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37328695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37328695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37328695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37328695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358665", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358665", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358665", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358665", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358677", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358677", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358677", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358677", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358701", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358701", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358701", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358701", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358720", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358720", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358720", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358720", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358750", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358750", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358750", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358750", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358767", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358767", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358767", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358767", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358786", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358786", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358786", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358786", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358792", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358792", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358792", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358792", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358797", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358797", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358797", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358797", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358810", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358810", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358810", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358810", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358816", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358816", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358816", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358816", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358821", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358821", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358821", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358821", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358839", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358839", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358839", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358839", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37358856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37366938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37366938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37366938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("37366938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39787057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39787057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39787057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39787057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39791717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39791717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39791717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39791717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39793129", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39793129", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39793129", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39793129", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39793520", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39793520", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39793520", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39793520", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39797380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39797380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39797380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39797380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39799517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39799517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39799517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39799517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39806480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39806480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39806480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39806480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39806532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39806532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39806532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39806532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39819865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39819865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39819865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39819865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39819947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39819947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39819947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39819947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39826747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39826747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39826747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39826747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39826763", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39826763", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39826763", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39826763", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39837572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39837572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39837572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("39837572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("45879700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("45879700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("45879700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("45879700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("48518994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("48518994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("48518994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("48518994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51302813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51302813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51302813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51302813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51466070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51466070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51466070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51466070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51504561", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51504561", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51504561", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51504561", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51654379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51654379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51654379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51654379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51725900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51725900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51725900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51725900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51739589", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51739589", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51739589", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("51739589", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("52561218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("52561218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("52561218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("52561218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("55909939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("55909939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("55909939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("55909939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("55975490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("55975490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("55975490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("55975490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("56331511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("56331511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("56331511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("56331511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("57730419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("57730419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("57730419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("57730419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58225755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58225755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58225755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58225755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58496194", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58496194", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58496194", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58496194", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58653120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58653120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58653120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58653120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58856364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58856364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58856364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("58856364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("59073761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("59073761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("59073761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("59073761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64246044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64246044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64246044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64246044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64680197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64680197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64680197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64680197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64860937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64860937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64860937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64860937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64972832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64972832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64972832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("64972832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726464", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726464", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726464", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726464", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726567", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726567", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726567", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726567", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726568", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726568", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726568", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726568", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726571", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726571", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726571", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726571", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726573", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726573", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726573", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726573", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726574", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726574", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726574", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726574", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726576", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726576", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726576", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726576", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726578", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726578", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726578", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726578", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726579", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726579", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726579", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726579", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726580", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726580", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726580", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726580", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726581", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726581", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726581", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726581", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726582", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726582", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726582", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726582", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726586", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726586", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726586", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("65726586", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035685", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035685", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035685", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035685", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035694", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035694", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035694", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035694", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035697", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035697", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035697", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84035697", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84037010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84037010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84037010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84037010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84037555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84037555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84037555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84037555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84051335", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84051335", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84051335", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84051335", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84065303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84065303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84065303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84065303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138597", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138597", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138597", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138597", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138613", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138613", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138613", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138613", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138694", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138694", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138694", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138694", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138812", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138812", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138812", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84138812", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139173", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139173", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139173", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139173", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139560", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139560", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139560", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139560", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84139997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84478542", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84478542", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84478542", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84478542", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84503806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84503806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84503806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84503806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84513837", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84513837", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84513837", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("84513837", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86160081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86160081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86160081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86160081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176150", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176150", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176150", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86176150", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86177443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86177443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86177443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86177443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86177453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86177453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86177453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86177453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86192234", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86192234", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86192234", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86192234", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86443278", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86443278", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86443278", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86443278", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86450128", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86450128", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86450128", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86450128", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86461161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86461161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86461161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86461161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86464292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86464292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86464292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86464292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86813143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86813143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86813143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86813143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86844762", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86844762", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86844762", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86844762", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86855898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86855898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86855898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86855898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("86856253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87572143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87572143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87572143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87572143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87790396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87790396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87790396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87790396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87791038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87791038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87791038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87791038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87898273", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87898273", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87898273", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87898273", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87898676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87898676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87898676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87898676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87954469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87955478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87955478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87955478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87955478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87958428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87961943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87963977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964714", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964714", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964714", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87964714", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87965227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87965227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87965227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("87965227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("88005657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("88005657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("88005657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("88005657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("89091376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("89091376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("89091376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("89091376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("90505425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("90505425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("90505425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("90505425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("90615111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("90615111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("90615111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("90615111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92321300", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92321300", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92321300", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92321300", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605300", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605300", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605300", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605300", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92605303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92703237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92703237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92703237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92703237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92736807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92736807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92736807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92736807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92766644", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92766644", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92766644", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92766644", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92775550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92775550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92775550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92775550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92782051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92782051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92782051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("92782051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("93036322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("93036322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("93036322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("93036322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94175744", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94175744", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94175744", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94175744", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94177292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94177292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94177292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94177292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94177314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94177314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94177314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94177314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178224", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178224", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178224", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178224", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94178261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179110", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179110", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179110", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179110", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179133", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179133", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179133", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179133", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179273", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179273", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179273", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179273", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179308", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179308", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179308", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179308", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94179588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94180096", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94180096", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94180096", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94180096", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94181908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94181908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94181908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94181908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94181953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94181953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94181953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94181953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94182026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94182026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94182026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94182026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94188783", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94188783", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94188783", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94188783", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94189638", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94189638", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94189638", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94189638", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94190773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94190773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94190773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94190773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94191016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94191016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94191016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94191016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94416913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94416913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94416913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94416913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94683990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684631", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684631", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684631", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684631", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684776", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684776", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684776", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684776", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684809", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684809", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684809", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684809", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94684867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685383", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685383", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685383", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685383", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685570", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685570", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685570", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685570", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94685872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94686018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94686018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94686018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94686018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94687929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94688942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689628", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689628", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689628", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689628", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689730", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689730", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689730", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689730", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94689894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690504", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690504", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690504", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690504", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94690627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691021", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691021", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691021", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691021", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94691155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94717039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94717039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94717039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94717039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816740", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816740", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816740", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816740", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94816951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94817119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94817119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94817119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94817119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94818906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94819029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94819029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94819029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94819029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94834061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94834061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94834061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("94834061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95209290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95209290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95209290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95209290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95571924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95571924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95571924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95571924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95599381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95599381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95599381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95599381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95718186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95718186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95718186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95718186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738926", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738926", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738926", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738926", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738992", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738992", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738992", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738992", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95738993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739053", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739053", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739053", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739053", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739094", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739094", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739094", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95739094", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95745024", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95745024", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95745024", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95745024", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781771", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781771", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781771", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95781771", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95867620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95867620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95867620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95867620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902746", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902746", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902746", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902746", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902752", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902752", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902752", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902752", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902794", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902794", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902794", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902794", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902896", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902896", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902896", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902896", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902907", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902907", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902907", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902907", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95902944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95903051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95903051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95903051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95903051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95903081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95903081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95903081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("95903081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96159459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96159459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96159459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96159459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96159534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96159534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96159534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96159534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228354", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228354", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228354", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228354", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228432", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228432", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228432", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228432", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228512", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228512", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228512", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228512", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228559", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228559", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228559", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228559", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228572", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228582", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228582", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228582", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228582", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96228585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231220", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231220", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231220", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231220", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231224", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231224", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231224", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231224", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231225", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231225", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231225", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231225", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231243", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231243", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231243", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231243", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96231245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260640", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260640", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260640", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260640", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260644", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260644", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260644", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260644", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260649", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260649", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260649", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260649", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260664", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260664", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260664", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260664", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260665", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260665", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260665", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260665", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260669", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260669", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260669", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260669", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260691", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260691", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260691", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260691", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260936", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260936", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260936", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96260936", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96306663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96306663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96306663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96306663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96309893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96309893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96309893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96309893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96315120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96315120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96315120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96315120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96318663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96318663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96318663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96318663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96320599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96320599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96320599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96320599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96323340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96323340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96323340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96323340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96333725", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96333725", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96333725", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96333725", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96738085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96738085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96738085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96738085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96747850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96747850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96747850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96747850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96783533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96783533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96783533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96783533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96961212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96961212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96961212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96961212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96962411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96962411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96962411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96962411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96964414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96964414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96964414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("96964414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("98843069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("98843069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("98843069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("98843069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100196413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100196413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100196413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100196413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100471457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100471457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100471457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100471457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100471487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100471487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100471487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100471487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100592099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100592099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100592099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("100592099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("134811403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("134811403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("134811403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("134811403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("135008620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("135008620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("135008620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("135008620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("168430090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("168430090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("168430090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("168430090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("222464768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("222464768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("222464768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("222464768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("233538306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("233538306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("233538306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("233538306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("241591853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("241591853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("241591853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("241591853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("244181116", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("244181116", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("244181116", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("244181116", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("244316890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("244316890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("244316890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("244316890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("248459203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("248459203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("248459203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("248459203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("248471680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("248471680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("248471680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("248471680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("250734427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("250734427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("250734427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("250734427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("251155223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("251155223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("251155223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("251155223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("262470149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("262470149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("262470149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("262470149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("265187031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("265187031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("265187031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("265187031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("303233041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("303233041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("303233041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("303233041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("303810044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("303810044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("303810044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("303810044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("311141191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("311141191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("311141191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("311141191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("311171136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("311171136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("311171136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("311171136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315291132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315291132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315291132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315291132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315554089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315554089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315554089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315554089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315699219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315699219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315699219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315699219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315814159", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315814159", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315814159", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315814159", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315951912", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315951912", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315951912", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("315951912", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("316159353", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("316159353", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("316159353", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("316159353", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129353", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129353", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129353", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129353", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129539", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129539", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129539", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129539", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129558", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129558", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129558", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129558", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387129964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387130005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387130005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387130005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387130005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387141632", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387141632", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387141632", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387141632", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387152896", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387152896", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387152896", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387152896", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387184700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387184700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387184700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387184700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387710846", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387710846", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387710846", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("387710846", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143711", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143711", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143711", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143711", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143726", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143726", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143726", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143726", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143754", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143754", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143754", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143754", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143767", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143767", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143767", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143767", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143773", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143776", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143776", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143776", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143776", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143795", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143795", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143795", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143795", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143799", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143799", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143799", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143799", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143897", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143897", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143897", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143897", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391143928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391196951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391196951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391196951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391196951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197279", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197279", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197279", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197279", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391197333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391199178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391199178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391199178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391199178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391201678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391201678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391201678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391201678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391201698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391201698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391201698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391201698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243151", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243151", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243151", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243151", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391243205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391253528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391253528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391253528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391253528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337800", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337800", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337800", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337800", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391337827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338681", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338681", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338681", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338681", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338742", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338742", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338742", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391338742", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339294", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339294", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339294", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339294", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391339517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391348872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391348872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391348872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391348872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391349396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391349396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391349396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391349396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391644160", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391644160", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391644160", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391644160", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391648012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391648012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391648012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391648012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391667712", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391667712", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391667712", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391667712", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391669760", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391669760", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391669760", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391669760", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391679474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391679474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391679474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391679474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391691855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391691855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391691855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391691855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391691882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391691882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391691882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391691882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391716993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391716993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391716993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391716993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391740011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391740011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391740011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391740011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391742523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391742523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391742523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391742523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751168", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751168", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751168", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751168", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751239", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751239", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751239", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751239", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391751260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391752559", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391752559", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391752559", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391752559", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391770226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391770226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391770226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391770226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391770418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391770418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391770418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391770418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391771947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391771947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391771947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391771947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772056", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772056", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772056", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772056", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391772650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391773372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391773372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391773372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391773372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391781924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782352", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782352", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782352", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782352", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391782386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391784448", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391784448", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391784448", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391784448", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936000", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936000", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936000", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936000", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936256", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936256", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936256", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936256", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936512", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936512", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936512", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("391936512", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037515", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037515", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037515", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037515", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037522", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037522", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037522", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037522", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392037525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392038420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392038420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392038420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392038420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392038599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392038599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392038599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392038599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392040448", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392040448", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392040448", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392040448", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392041624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392041624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392041624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392041624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392041630", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392041630", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392041630", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392041630", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392042240", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392042240", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392042240", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392042240", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392043520", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392043520", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392043520", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392043520", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044631", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044631", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044631", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044631", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044772", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044772", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044772", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392044772", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392047994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392047994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392047994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392047994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048506", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048506", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048506", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048506", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048509", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048509", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048509", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392048509", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051520", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051520", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051520", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051520", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051536", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051536", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051536", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051536", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392051565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392053985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392053985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392053985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392053985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392054014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392054014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392054014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392054014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392055552", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392055552", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392055552", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392055552", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392056757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392056757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392056757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392056757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392056832", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392056832", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392056832", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392056832", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392058429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392058429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392058429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392058429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059795", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059795", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059795", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059795", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392059890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392062760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392064112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392064112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392064112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392064112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392066048", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392066048", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392066048", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392066048", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392067848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392067848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392067848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392067848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392070635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392070635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392070635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392070635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073259", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073259", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073259", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073259", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392073948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392074240", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392074240", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392074240", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392074240", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392075834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392075834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392075834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392075834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392075933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392075933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392075933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392075933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392076889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392077990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392078002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392078002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392078002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392078002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392079532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392079532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392079532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392079532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392079543", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392079543", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392079543", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392079543", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392080290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392080290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392080290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392080290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392080297", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392080297", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392080297", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392080297", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392081575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392081575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392081575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392081575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392081599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392081599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392081599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392081599", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392083935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392084927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392084927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392084927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392084927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088787", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088787", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088787", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392088787", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089276", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089276", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089276", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089276", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392089277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392096768", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392096768", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392096768", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392096768", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100388", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100388", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100388", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100388", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392100396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103792", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103792", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103792", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103792", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392103804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392106496", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392106496", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392106496", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392106496", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392119462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392119462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392119462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392119462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392122368", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392122368", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392122368", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392122368", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392126963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392126963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392126963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392126963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392126967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392126967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392126967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392126967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392127381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392127381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392127381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392127381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392128230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392128230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392128230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392128230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392128311", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392128311", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392128311", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392128311", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392129406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392129406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392129406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392129406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392130684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392130684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392130684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392130684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392131760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392131760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392131760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392131760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148613", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148613", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148613", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148613", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148659", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148659", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148659", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148659", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148668", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148668", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148668", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392148668", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392150207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392150207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392150207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392150207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392153244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392153244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392153244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392153244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154235", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154235", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154235", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392154235", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392157184", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392157184", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392157184", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392157184", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392158901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392158901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392158901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392158901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392161531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392161531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392161531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392161531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162600", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162600", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162600", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162600", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162718", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162718", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162718", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162718", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162761", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392162793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392163139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392163139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392163139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392163139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392732990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392733134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392738989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392739067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392776386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392776386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392776386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392776386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797578", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797578", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797578", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797578", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797587", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797587", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797587", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797587", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797628", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797628", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797628", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797628", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797970", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797970", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797970", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392797970", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798059", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798059", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798059", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798059", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392798192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392800951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392800951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392800951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392800951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392827774", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392827774", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392827774", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392827774", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392827813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392827813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392827813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392827813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392875288", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392875288", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392875288", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392875288", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392875358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392875358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392875358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392875358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878289", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878289", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878289", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878289", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878988", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878988", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878988", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392878988", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879036", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879036", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879036", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879036", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879055", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879055", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879055", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879055", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392879100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392954979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392955064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958612", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958612", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958612", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958612", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392958624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960202", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960202", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960202", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960202", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960225", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960225", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960225", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392960225", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965148", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965148", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965148", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965148", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965252", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965252", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965252", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965252", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965257", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965257", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965257", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965257", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965506", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965506", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965506", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965506", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965524", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965524", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965524", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965524", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965667", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965667", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965667", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965667", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965727", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965727", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965727", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965727", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965755", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392965989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966299", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966299", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966299", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966299", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966356", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966356", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966356", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966356", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966724", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966724", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966724", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966724", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966775", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392966929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392975893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392975893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392975893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392975893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392976022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392976022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392976022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392976022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392976080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392976080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392976080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392976080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392977818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392977818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392977818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392977818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392994816", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392994816", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392994816", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392994816", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392995840", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392995840", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392995840", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("392995840", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393002994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393002994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393002994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393002994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013670", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013670", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013670", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013670", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393013702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018941", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018941", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018941", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018941", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393018977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("393019127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346677", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346677", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346677", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346677", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346679", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346679", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346679", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346679", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346681", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346681", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346681", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346681", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346685", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346685", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346685", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346685", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346686", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346686", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346686", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346686", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346688", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346688", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346688", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346688", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346691", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346691", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346691", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346691", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346692", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346692", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346692", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346692", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346697", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346697", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346697", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346697", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346698", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346700", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346701", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346701", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346701", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346701", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346703", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346703", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346703", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346703", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346704", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346704", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346704", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346704", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346705", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346705", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346705", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346705", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346711", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346711", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346711", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346711", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346712", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346712", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346712", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346712", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("394346713", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400719872", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400719872", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400719872", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400719872", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400884431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400884431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400884431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400884431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400885900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400885900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400885900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400885900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400886379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400886379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400886379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400886379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400886751", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400886751", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400886751", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400886751", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400887508", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400887508", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400887508", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400887508", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400889465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400889465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400889465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400889465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890221", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890221", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890221", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890221", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400890451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891341", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891341", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891341", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891341", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891715", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891715", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891715", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891715", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400891758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400892468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894743", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894743", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894743", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894743", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400894749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400897966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400898255", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400898255", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400898255", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400898255", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400898587", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400898587", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400898587", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400898587", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900280", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900280", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900280", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900280", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900315", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900315", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900315", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900315", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400900319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902537", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902537", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902537", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902537", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902610", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902610", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902610", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902610", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902732", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902732", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902732", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902732", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400902974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400903197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400903197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400903197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400903197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400903233", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400903233", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400903233", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400903233", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400906844", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400906844", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400906844", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400906844", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907448", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907448", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907448", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907448", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400907453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400909425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400909425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400909425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400909425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400913555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400913555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400913555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("400913555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018152", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018152", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018152", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018152", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018292", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018349", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018349", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018349", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018349", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401018731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023563", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023563", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023563", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023563", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023689", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401023717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024540", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024540", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024540", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024540", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024780", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024780", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024780", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024780", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024783", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024783", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024783", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024783", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024804", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024812", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024812", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024812", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024812", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024984", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024984", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024984", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024984", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024998", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024998", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024998", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401024998", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401043184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401043184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401043184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401043184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341732", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341732", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341732", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341732", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341737", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341737", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341737", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401341737", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401376505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380366", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380366", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380366", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380366", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401380538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401381400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401381400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401381400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401381400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401381405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401381405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401381405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401381405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401382523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401382523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401382523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401382523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401382617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401382617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401382617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401382617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401386369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401386369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401386369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401386369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401388834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401388834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401388834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401388834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401396352", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401396352", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401396352", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401396352", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401396415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401396415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401396415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401396415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401399759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401324", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401339", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401339", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401339", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401339", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401563", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401563", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401563", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401563", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401401678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401402296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401533657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401533657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401533657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401533657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401590272", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401590272", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401590272", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401590272", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401882385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401882385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401882385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401882385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401889007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401889007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401889007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401889007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401898357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401898357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401898357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401898357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401912511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401912511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401912511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401912511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401926893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401926893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401926893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401926893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401950123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401950123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401950123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401950123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401951075", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401951075", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401951075", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401951075", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401960083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401960083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401960083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401960083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401964603", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401964603", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401964603", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401964603", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971280", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971280", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971280", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971280", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971294", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971294", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971294", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971294", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971322", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971539", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971539", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971539", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971539", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401971830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401973248", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401973248", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401973248", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401973248", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401976320", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401976320", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401976320", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401976320", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401981950", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401981950", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401981950", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401981950", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401982308", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401982308", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401982308", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401982308", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401985332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401985332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401985332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401985332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401990650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401990650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401990650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401990650", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401997444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401997444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401997444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401997444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401997445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401997445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401997445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("401997445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402260378", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402260378", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402260378", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402260378", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402261232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402261232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402261232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402261232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402263032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402263032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402263032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402263032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402264531", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402265983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402265983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402265983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402265983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266135", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266135", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266135", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266135", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266671", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266671", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266671", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266671", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266816", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266816", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266816", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266816", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402266829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402269437", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402269437", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402269437", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402269437", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402269985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402269985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402269985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402269985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402270942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402271365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402271365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402271365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402271365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273630", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273630", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273630", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402273630", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402274039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402274039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402274039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402274039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402274279", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402274279", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402274279", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402274279", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402275431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402275431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402275431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402275431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402280217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402280217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402280217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402280217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402282971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402282971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402282971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402282971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402284281", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402284281", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402284281", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402284281", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402284285", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402284285", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402284285", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402284285", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402285434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287568", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287568", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287568", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287568", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287774", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287774", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287774", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287774", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287788", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287788", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287788", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287788", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402287874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288610", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288610", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288610", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402288610", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402290901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402290901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402290901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402290901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402291162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402291162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402291162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402291162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402292638", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402292638", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402292638", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402292638", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402333802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402333802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402333802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402333802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402523436", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402523436", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402523436", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402523436", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402523746", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402523746", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402523746", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402523746", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524248", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524248", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524248", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524248", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402524894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402525099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402525099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402525099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402525099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402525345", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402525345", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402525345", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402525345", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402526519", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402526519", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402526519", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402526519", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402526557", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402526557", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402526557", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402526557", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402527421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402527421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402527421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402527421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402527423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402527423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402527423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402527423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402533809", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402533809", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402533809", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402533809", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402533967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402533967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402533967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402533967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402534209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402534209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402534209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402534209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402534230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402534230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402534230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402534230", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536567", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536567", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536567", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402536567", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402538874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402538874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402538874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402538874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402539569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402539569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402539569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402539569", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402539573", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402539573", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402539573", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402539573", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402543421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402555641", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402555641", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402555641", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("402555641", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("405106966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("405106966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("405106966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("405106966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("416139895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("416139895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("416139895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("416139895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("419022606", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("419022606", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("419022606", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("419022606", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("455230500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("455230500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("455230500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("455230500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("456566484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("456566484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("456566484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("456566484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("457737314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("457737314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("457737314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("457737314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("457837546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("457837546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("457837546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("457837546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("458162583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("458162583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("458162583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("458162583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("458218084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("458218084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("458218084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("458218084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("461102533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("461102533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("461102533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("461102533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("462840054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("462840054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("462840054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("462840054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("462841092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("462841092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("462841092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("462841092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463058467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463058467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463058467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463058467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463059090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463059090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463059090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463059090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463068913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463069088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463069088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463069088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463069088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463157095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463157095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463157095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("463157095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466704749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466704749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466704749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466704749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466705301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466705301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466705301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466705301", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466705657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466705657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466705657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("466705657", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("469759013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("469759013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("469759013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("469759013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520491786", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520491786", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520491786", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520491786", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520502497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520502497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520502497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520502497", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520600532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520600532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520600532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520600532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520994640", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520994640", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520994640", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520994640", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520995623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520995623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520995623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("520995623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521029958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521029958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521029958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521029958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030196", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030196", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030196", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030196", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030198", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030198", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030198", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030198", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030200", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030200", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030200", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030200", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030204", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030204", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030204", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030204", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030212", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030213", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030213", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030213", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030213", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030214", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030215", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030215", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030215", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521030215", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521044806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521044806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521044806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521044806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521621018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521621018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521621018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521621018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521625031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521625031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521625031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521625031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521638390", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521638390", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521638390", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521638390", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521644751", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521644751", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521644751", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521644751", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521645283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521645283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521645283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521645283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521654430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521654430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521654430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521654430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521659431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521659431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521659431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521659431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521661503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521661503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521661503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521661503", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521766736", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521766736", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521766736", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("521766736", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522143768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522143768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522143768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522143768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522773228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522930304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522930304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522930304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522930304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522932566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522932566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522932566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("522932566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("523770064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("523770064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("523770064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("523770064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("528636254", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("528636254", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("528636254", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("528636254", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("528798608", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("528798608", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("528798608", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("528798608", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("529670070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("529670070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("529670070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("529670070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("530715111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("530715111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("530715111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("530715111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("530833442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("530833442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("530833442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("530833442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531431673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531431673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531431673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531431673", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531437785", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531437785", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531437785", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531437785", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531437971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531437971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531437971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531437971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531438875", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531438875", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531438875", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531438875", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453391", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453391", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453391", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453391", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453876", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453876", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453876", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531453876", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531458032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531458032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531458032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531458032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531797704", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531797704", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531797704", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("531797704", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532244501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532285530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532285530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532285530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532285530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532704064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532704064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532704064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532704064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532792323", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532792323", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532792323", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("532792323", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("533669233", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("533669233", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("533669233", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("533669233", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512259", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512259", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512259", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512259", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512262", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512262", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512262", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("534512262", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("583610054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("583610054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("583610054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("583610054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("583815327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("583815327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("583815327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("583815327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("584023349", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("584023349", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("584023349", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("584023349", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585387699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585387699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585387699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585387699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585476082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585476082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585476082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585476082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585483510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585483510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585483510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585483510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585541735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585541735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585541735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585541735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585597446", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585597446", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585597446", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("585597446", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601680098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601680098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601680098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601680098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601700238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601700238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601700238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601700238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601702392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601702392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601702392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("601702392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("605561123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("605561123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("605561123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("605561123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("605780753", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("605780753", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("605780753", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("605780753", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("606450747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("606450747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("606450747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("606450747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608365459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608365459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608365459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608365459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608383930", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608383930", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608383930", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608383930", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608399213", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608399213", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608399213", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608399213", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608432201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608432201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608432201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("608432201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609220764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609220764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609220764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609220764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609823089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609823089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609823089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609823089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609876841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609876841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609876841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609876841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609889838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609889838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609889838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609889838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609890081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609890081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609890081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609890081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609890272", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609890272", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609890272", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609890272", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609954365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609954365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609954365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("609954365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("610009375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("610009375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("610009375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("610009375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274063", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274063", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274063", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274063", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274995", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274995", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274995", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620274995", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275281", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275281", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275281", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620275281", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410836", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410836", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410836", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620410836", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620411175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620411175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620411175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620411175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620778871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620778871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620778871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620778871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620874191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620874191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620874191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620874191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620874452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620874452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620874452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("620874452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621150443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621150443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621150443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621150443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621361858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621361858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621361858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621361858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621381253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621381253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621381253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("621381253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("622631492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("622631492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("622631492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("622631492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("623665227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("623665227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("623665227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("623665227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("623705600", "4294966784");
INSERT INTO `wp_onecleantalk_sfw` VALUES("623705600", "4294966784");
INSERT INTO `wp_onecleantalk_sfw` VALUES("623705600", "4294966784");
INSERT INTO `wp_onecleantalk_sfw` VALUES("623705600", "4294966784");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624493556", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624493556", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624493556", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624493556", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624513298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624513298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624513298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624513298", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624635728", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624635728", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624635728", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624635728", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624636972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624636972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624636972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624636972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624638295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624638295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624638295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624638295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624639091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624639091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624639091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("624639091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625523398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625705426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625705426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625705426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625705426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625831112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625831112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625831112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625831112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625934699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625934699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625934699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625934699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625937869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625937869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625937869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625937869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625939358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625939358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625939358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625939358", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625967483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625967483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625967483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("625967483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628165074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628165074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628165074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628165074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628172218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628172218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628172218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628172218", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628174169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628174169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628174169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628174169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628178221", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628178221", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628178221", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628178221", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628178593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628178593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628178593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628178593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628202566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628202566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628202566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628202566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628206623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628206623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628206623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628206623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628210764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628210764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628210764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628210764", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628210811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628210811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628210811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628210811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628342106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628342106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628342106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628342106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628343985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628343985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628343985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628343985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628350024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628350024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628350024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628350024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628658874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628661130", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628661130", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628661130", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628661130", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628661255", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628661255", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628661255", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628661255", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628665946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628665946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628665946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628665946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628668445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628668445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628668445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628668445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628670962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628671013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628671013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628671013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628671013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673287", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673305", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673305", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673305", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673305", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628673357", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628674974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628674974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628674974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628674974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("628676973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629868648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629868648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629868648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629868648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629872143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629872143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629872143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629872143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629981184", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629981184", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629981184", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("629981184", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630063768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630063768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630063768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630063768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630125743", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630125743", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630125743", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630125743", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144545", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144545", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144545", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144545", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630144948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630389655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630389655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630389655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630389655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630588186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630588186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630588186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630588186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630588368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630588368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630588368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630588368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630996505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630996505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630996505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("630996505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("631035904", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("631035904", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("631035904", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("631035904", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("631093257", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("631093257", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("631093257", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("631093257", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633035326", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633035326", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633035326", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633035326", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633062769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633062769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633062769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633062769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633076332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633076332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633076332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633076332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633570477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633570477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633570477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("633570477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634127932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634127932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634127932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634127932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634497050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634497050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634497050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634497050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634664928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634664928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634664928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634664928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634665336", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634665336", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634665336", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634665336", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634667523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634667523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634667523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634667523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634670604", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634670604", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634670604", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634670604", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634674676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634674676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634674676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634674676", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634796376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634796376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634796376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634796376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634816430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634816430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634816430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634816430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634817466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634817466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634817466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("634817466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180675", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180675", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180675", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180675", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180710", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180710", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180710", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180710", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180722", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180722", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180722", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180722", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180724", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180724", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180724", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180724", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635180731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635292878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635292878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635292878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635292878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635732226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635732226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635732226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635732226", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635815122", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635815122", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635815122", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("635815122", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("636170343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("636170343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("636170343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("636170343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("636956054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("636956054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("636956054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("636956054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("637274006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("637274006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("637274006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("637274006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("640149877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("640149877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("640149877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("640149877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("642000205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("642000205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("642000205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("642000205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("642000407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("642000407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("642000407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("642000407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("643181403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("643181403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("643181403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("643181403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645785991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645786011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645786011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645786011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("645786011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646110228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646110228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646110228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646110228", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646301790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646301790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646301790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646301790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646389807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646389807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646389807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646389807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646856594", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646856594", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646856594", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646856594", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("646931482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116617", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116633", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116633", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116633", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116633", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116649", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116649", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116649", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("647116649", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656725084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656725084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656725084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656725084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656725533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656725533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656725533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656725533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656796878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656796878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656796878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("656796878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("657111927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("657111927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("657111927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("657111927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("660647735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("660647735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("660647735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("660647735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("660752935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("660752935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("660752935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("660752935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661226268", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661226268", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661226268", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661226268", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661284179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661284179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661284179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661284179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661315462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661315462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661315462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661315462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661402738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661402738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661402738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661402738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661405395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661405395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661405395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("661405395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307526", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307526", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307526", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307526", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663307530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314246", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314246", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314246", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314246", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314248", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314248", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314248", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314248", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314249", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314249", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314249", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314249", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314250", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314250", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314250", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314250", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314251", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314251", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314251", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663314251", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663317346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663317346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663317346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("663317346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("692876738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("692876738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("692876738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("692876738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("700326306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("700326306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("700326306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("700326306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("701725991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("701725991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("701725991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("701725991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703005985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703005985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703005985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703005985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703006005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703006005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703006005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703006005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703018555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703018555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703018555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("703018555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712041385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712041385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712041385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712041385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712085570", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712085570", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712085570", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712085570", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712248343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712248343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712248343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712248343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712323389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712329590", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712329590", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712329590", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712329590", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712358380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712358380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712358380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712358380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712412261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712412261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712412261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("712412261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("717106304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("717106304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("717106304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("717106304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("736402716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("736402716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("736402716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("736402716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("736450022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("736450022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("736450022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("736450022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737485252", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737485252", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737485252", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737485252", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737528430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737528430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737528430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737528430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737899940", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737899940", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737899940", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("737899940", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("738069290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("738069290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("738069290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("738069290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("753292329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("753292329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("753292329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("753292329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("753293852", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("753293852", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("753293852", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("753293852", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755492741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755492741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755492741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755492741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755564444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755625493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755625493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755625493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755625493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689504", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689504", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689504", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689504", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689511", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689517", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689522", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689522", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689522", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689522", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689523", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689529", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689529", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689529", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689529", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689540", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689540", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689540", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689540", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689547", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689547", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689547", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689547", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755689577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755690496", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755690496", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755690496", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755690496", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755806208", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755806208", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755806208", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755806208", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755817738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755817738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755817738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755817738", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755817858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755817858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755817858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755817858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755818018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755818018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755818018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755818018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885174", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885174", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885174", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885174", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885229", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885229", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885229", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885229", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885302", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885754", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885754", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885754", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755885754", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("755930210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757074968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757074968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757074968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757074968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757077521", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757077521", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757077521", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757077521", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757088023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757088023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757088023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757088023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757093325", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757093325", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757093325", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757093325", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757098295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757098295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757098295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757098295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757098325", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757098325", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757098325", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757098325", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757102310", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757102310", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757102310", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757102310", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757103026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757103026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757103026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757103026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757103370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757103370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757103370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757103370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757111851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757111851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757111851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757111851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757113898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757113898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757113898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757113898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757117360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757117360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757117360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757117360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757117624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757117624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757117624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757117624", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757118463", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757118463", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757118463", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757118463", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757122946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757122946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757122946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757122946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757134048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757134048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757134048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757134048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757134588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757134588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757134588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757134588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757135232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757135232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757135232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757135232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757378032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757378032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757378032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757378032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757621997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757622106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757622106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757622106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757622106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757622634", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757622634", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757622634", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("757622634", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758580514", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758580514", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758580514", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758580514", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758595132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758595132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758595132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758595132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758613848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758613848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758613848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758613848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758619961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758619961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758619961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758619961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758623720", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758623720", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758623720", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758623720", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683326", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683326", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683326", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683326", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758683924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745793", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745803", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745803", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745803", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745803", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758745853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758747334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758747334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758747334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758747334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758747993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758747993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758747993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758747993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758749451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758749451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758749451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758749451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758752253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758752253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758752253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758752253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758752731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758752731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758752731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758752731", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758764735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758764735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758764735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758764735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758765687", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766828", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766828", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766828", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766828", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758766832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758769778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758769778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758769778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("758769778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013634", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013634", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013634", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013634", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013636", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013661", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013661", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013661", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013661", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013845", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013845", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013845", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759013845", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014313", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014313", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014313", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759014313", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015595", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759015882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016066", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016066", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016066", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016066", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016241", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016241", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016241", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016241", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759016716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759108513", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759108513", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759108513", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759108513", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759110162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759110162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759110162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759110162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759126012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759126012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759126012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759126012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759129585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759129585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759129585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759129585", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759130927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759130927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759130927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759130927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759132757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759132757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759132757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759132757", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759203526", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759203526", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759203526", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759203526", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759212299", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759212299", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759212299", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759212299", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759309091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759309091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759309091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759309091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759369216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759369216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759369216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759369216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759419904", "4294966784");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759419904", "4294966784");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759419904", "4294966784");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759419904", "4294966784");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693499", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693516", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693516", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693516", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693516", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693562", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693562", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693562", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693562", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759693565", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759696285", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759696285", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759696285", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759696285", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759696373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759696373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759696373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759696373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759699452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759699452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759699452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759699452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759700029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759700029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759700029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759700029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759702521", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759702521", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759702521", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759702521", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759711340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759711340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759711340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759711340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759711696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759711696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759711696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759711696", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759712346", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759721342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759721342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759721342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759721342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759721365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759721365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759721365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759721365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759834487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759834487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759834487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759834487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759959223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759959223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759959223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759959223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759960749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759960749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759960749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759960749", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759965584", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759965584", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759965584", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759965584", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759975457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759975457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759975457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759975457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759984430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759984430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759984430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759984430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759986127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759986127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759986127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759986127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987147", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987147", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987147", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987147", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759987978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759988655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759988655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759988655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759988655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759990891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759990891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759990891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759990891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759993501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759993501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759993501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("759993501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760001849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760001849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760001849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760001849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760003404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760003404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760003404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760003404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760003817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760003817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760003817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760003817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760015032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760015032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760015032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760015032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760015127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760015127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760015127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760015127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760019863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760019863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760019863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760019863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760030113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760030113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760030113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760030113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760031319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760031319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760031319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760031319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760031819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760031819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760031819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760031819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760032434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760032434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760032434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760032434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760033144", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760033144", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760033144", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760033144", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760034695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760034695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760034695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760034695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760035945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760035945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760035945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760035945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760037260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760037260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760037260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760037260", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760049708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760049708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760049708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760049708", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760055978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760055978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760055978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760055978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760064171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760064171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760064171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760064171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760065449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760065449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760065449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760065449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760072890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760072890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760072890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760072890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760076798", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760076798", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760076798", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760076798", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760078455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760078455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760078455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760078455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760081253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760081253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760081253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760081253", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760081355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760081355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760081355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760081355", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760082239", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760082239", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760082239", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760082239", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760083662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760083662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760083662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760083662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760084564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760084564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760084564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760084564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760173337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760173337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760173337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760173337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760192359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760192359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760192359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760192359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760202637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760202637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760202637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760202637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760340500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760340500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760340500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760340500", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366097", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366097", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366097", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366097", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366103", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366103", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366103", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366103", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760366980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760399340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760399340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760399340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760399340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760399348", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760399348", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760399348", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760399348", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760525247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760525247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760525247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760525247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614656", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614656", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614656", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760614656", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760662969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760662969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760662969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760662969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760662977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760662977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760662977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760662977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760663001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760663001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760663001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760663001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760730680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760730680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760730680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760730680", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869124", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869124", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869124", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869124", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869240", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869268", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869268", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869268", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869268", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869271", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869271", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869271", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869271", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869274", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869274", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869274", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869274", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869276", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869276", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869276", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869276", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869283", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869286", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869286", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869286", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869286", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869289", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869289", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869289", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869289", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869314", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869316", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869316", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869316", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("760869316", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761195475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208165", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208165", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208165", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208165", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761208170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761260855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761260855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761260855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761260855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761260886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761260886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761260886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("761260886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762467962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762467962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762467962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762467962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762827790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762827790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762827790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762827790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762827869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762827869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762827869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762827869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851794", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851794", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851794", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851794", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762851972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852219", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("762852304", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763027398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763027398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763027398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763027398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763183405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763183405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763183405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763183405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763183472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763183472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763183472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763183472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763222577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763222577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763222577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763222577", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229548", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229670", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229670", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229670", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763229670", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763397618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763397618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763397618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763397618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763411457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763411457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763411457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763411457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763623494", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763623494", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763623494", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763623494", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763623501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763623501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763623501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763623501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763652466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763652466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763652466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763652466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763674629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763674629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763674629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763674629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763674690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763674690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763674690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763674690", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763720740", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763720740", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763720740", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763720740", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734554", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734554", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734554", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734554", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734620", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734626", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734633", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734633", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734633", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734633", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734635", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734660", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763734693", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763869818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763869818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763869818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763869818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("763992825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764000327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764000327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764000327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764000327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764044034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764044034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764044034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764044034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764091401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764091401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764091401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764091401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764096525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764096525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764096525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764096525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764096527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764096527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764096527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764096527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764136208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764136208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764136208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764136208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764163943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764163943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764163943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764163943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764193467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764193467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764193467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764193467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764202662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764202662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764202662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764202662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764255714", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764255714", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764255714", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764255714", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764412666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764412666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764412666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764412666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764508134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764508134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764508134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764508134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764734057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764734057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764734057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764734057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764944384", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764944384", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764944384", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764944384", "4294966272");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764958038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764958038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764958038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764958038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982922", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982922", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982922", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982922", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764982937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764986954", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764986954", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764986954", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764986954", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987216", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987222", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987222", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987222", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987222", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987286", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987286", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987286", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("764987286", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765042291", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765042291", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765042291", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765042291", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765042647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765042647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765042647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765042647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057295", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057305", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057305", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057305", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057305", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057359", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057435", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057435", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057435", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057435", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057507", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057507", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057507", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057507", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765057525", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765129994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765129994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765129994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765129994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765129999", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765129999", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765129999", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765129999", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130232", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765130238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765132588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765132588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765132588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765132588", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765318505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765318505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765318505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("765318505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("766266742", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("766266742", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("766266742", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("766266742", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("766748806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("766748806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("766748806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("766748806", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("767320354", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("767320354", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("767320354", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("767320354", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("769781575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("769781575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("769781575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("769781575", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("769891394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("769891394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("769891394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("769891394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("770480215", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("770480215", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("770480215", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("770480215", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771266315", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771266315", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771266315", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771266315", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771266318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771266318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771266318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771266318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771403427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553296", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553303", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553306", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("771553898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772019337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772019337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772019337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772019337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772027666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772027666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772027666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772027666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772063653", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772063653", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772063653", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772063653", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772073206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772073206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772073206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772073206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772076042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772076042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772076042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772076042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772339459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772339459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772339459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("772339459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773206313", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773206313", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773206313", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773206313", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716222", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716222", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716222", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716222", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716532", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716614", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716614", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716614", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716614", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716618", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716662", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773716769", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773717899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773914502", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773914502", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773914502", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773914502", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773947140", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773947140", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773947140", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("773947140", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774013046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774013046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774013046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774013046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774092758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774092758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774092758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774092758", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774092987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774092987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774092987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774092987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774105092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774105092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774105092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774105092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774109629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774109629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774109629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774109629", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774184899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774184899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774184899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774184899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774220923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774220923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774220923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774220923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774302478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774302478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774302478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774302478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774458937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774458937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774458937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774458937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774994363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774994363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774994363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("774994363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775214530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775214530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775214530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775214530", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775440428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775440428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775440428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775440428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775763083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775763083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775763083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775763083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775764155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775764155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775764155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("775764155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778374611", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778374611", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778374611", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778374611", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778379067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778379067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778379067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778379067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778385860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778385860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778385860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778385860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778387419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778387419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778387419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778387419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778392741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778392741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778392741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778392741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778399949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778399949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778399949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778399949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778402519", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778402519", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778402519", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778402519", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778402854", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778402854", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778402854", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778402854", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778403745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778403745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778403745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778403745", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778409481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778409481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778409481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778409481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778414195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778414195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778414195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778414195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778416625", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778416625", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778416625", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778416625", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778429405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778429405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778429405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778429405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778435334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778435334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778435334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778435334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778500421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778500421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778500421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778500421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778655655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778655655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778655655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778655655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778659396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778659396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778659396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778659396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778670481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778670481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778670481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778670481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778823290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778823290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778823290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("778823290", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514244", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514782", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514782", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514782", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779514782", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779515217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779515217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779515217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779515217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779517684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779517684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779517684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779517684", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779517914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779517914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779517914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779517914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779524902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779524902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779524902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779524902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779581217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779581217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779581217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779581217", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779581382", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779581382", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779581382", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779581382", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779583389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779583389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779583389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779583389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779592605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779592605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779592605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779592605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779592608", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779592608", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779592608", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("779592608", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("780545885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("780545885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("780545885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("780545885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("780577371", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("780577371", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("780577371", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("780577371", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("781456440", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("781456440", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("781456440", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("781456440", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("781457939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("781457939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("781457939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("781457939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782151237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782151237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782151237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782151237", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782306881", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782306881", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782306881", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782306881", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782418197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782418197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782418197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782418197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782566546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782566546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782566546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782566546", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782624261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782624261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782624261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782624261", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782628250", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782628250", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782628250", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782628250", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782628524", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782628524", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782628524", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782628524", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782664092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782664092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782664092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782664092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782666607", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782666607", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782666607", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782666607", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782667639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782667639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782667639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782667639", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782667776", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782667776", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782667776", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782667776", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782671942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782671942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782671942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782671942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782678016", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782678016", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782678016", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782678016", "4294965248");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782758968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782758968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782758968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782758968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782758971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782758971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782758971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("782758971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783041868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783041868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783041868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783041868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783041955", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783041955", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783041955", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783041955", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783045835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783045835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783045835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783045835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783098853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783098853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783098853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783098853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783706814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783706814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783706814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("783706814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784093707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784093707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784093707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784093707", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784097802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784097802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784097802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784097802", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784304667", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784304667", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784304667", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784304667", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784304808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784304808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784304808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784304808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784326889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784326889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784326889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784326889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784328895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784328895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784328895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784328895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784328987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784328987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784328987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784328987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784329115", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784329115", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784329115", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784329115", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784329184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784329184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784329184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("784329184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("785473658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("785473658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("785473658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("785473658", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("785475866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("785475866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("785475866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("785475866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786157583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786157583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786157583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786157583", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786157721", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786157721", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786157721", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786157721", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786159591", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786159591", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786159591", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786159591", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786161495", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786161495", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786161495", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786161495", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786161561", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786161561", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786161561", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786161561", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786163616", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786163616", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786163616", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786163616", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786637971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786637971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786637971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786637971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786670178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786670178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786670178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786670178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802817", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802818", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802819", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802820", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802821", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802821", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802821", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802821", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802823", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802824", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802826", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802826", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802826", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802826", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802827", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802828", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802828", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802828", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802828", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802829", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802830", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802831", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802831", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802831", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802831", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802832", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802833", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802834", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802835", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802836", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802836", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802836", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802836", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802837", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802837", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802837", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802837", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802838", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802839", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802839", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802839", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802839", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802840", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802840", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802840", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802840", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802841", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("786802851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787020170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787020170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787020170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787020170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787020735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787020735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787020735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787020735", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787614666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787614666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787614666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787614666", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787733808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787733808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787733808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787733808", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890605", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890619", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890619", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890619", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890619", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890647", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890652", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890654", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890654", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890654", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787890654", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787900946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787900946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787900946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("787900946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("788118282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("788118282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("788118282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("788118282", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("788453699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("788453699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("788453699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("788453699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("791743653", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("791743653", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("791743653", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("791743653", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("791743656", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("791743656", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("791743656", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("791743656", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("792257957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("792257957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("792257957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("792257957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793383344", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793383344", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793383344", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793383344", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793417807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793417807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793417807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793417807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793426627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793426627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793426627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793426627", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793440364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793440364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793440364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793440364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793476683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793476683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793476683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793476683", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793488430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793488430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793488430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("793488430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794339403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794339403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794339403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794339403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794366535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794366535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794366535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794366535", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794407709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794407709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794407709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794407709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794425098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794425098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794425098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794425098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794475598", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794475598", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794475598", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794475598", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794526319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794526319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794526319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794526319", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794549367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794549367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794549367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794549367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794580203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794580203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794580203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794580203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794627813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794627813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794627813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794627813", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794715822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794715822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794715822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794715822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794729449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794729449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794729449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794729449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794982509", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794982509", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794982509", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794982509", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794985564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794985564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794985564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("794985564", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795054407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795054407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795054407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795054407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795085395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795085395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795085395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795085395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795133320", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795133320", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795133320", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795133320", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795144321", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795144321", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795144321", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795144321", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795160327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795160327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795160327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795160327", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795197699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795197699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795197699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795197699", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795204266", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795204266", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795204266", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795204266", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795362481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795362481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795362481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795362481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795408543", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795408543", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795408543", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795408543", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795585104", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795585104", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795585104", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("795585104", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804268100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804268100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804268100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804268100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804280576", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804280576", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804280576", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804280576", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804323510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804323510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804323510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804323510", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804333003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804333003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804333003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804333003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804522368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804522368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804522368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804522368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804522369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804522369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804522369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804522369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804523466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804523466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804523466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804523466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804524814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804524814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804524814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804524814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804525247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804525247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804525247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804525247", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804562886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804562886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804562886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("804562886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("805045991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("805045991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("805045991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("805045991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("822874076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("822874076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("822874076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("822874076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("822881566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("822881566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("822881566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("822881566", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824558759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824558759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824558759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824558759", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824558811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824558811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824558811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824558811", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824559169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824559169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824559169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("824559169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("825313544", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("825313544", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("825313544", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("825313544", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("825317715", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("825317715", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("825317715", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("825317715", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948996", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948996", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948996", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827948996", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827949010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827949010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827949010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827949010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827968529", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827968529", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827968529", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827968529", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827981209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827981209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827981209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827981209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827981312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827981312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827981312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("827981312", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("831540254", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("831540254", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("831540254", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("831540254", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("832448822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("832448822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("832448822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("832448822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("837371331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("837371331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("837371331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("837371331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("837514479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("837514479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("837514479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("837514479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106747", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106861", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106861", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106861", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106861", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839106874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107695", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107725", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107725", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107725", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107725", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839107842", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839108003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839108003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839108003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839108003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839947655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839947655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839947655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("839947655", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840721932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840721932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840721932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840721932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894737", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894737", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894737", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894737", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894766", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894766", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894766", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894766", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894807", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894822", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894846", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894846", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894846", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894846", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894873", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894873", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894873", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894873", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894911", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894911", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894911", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894911", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("840894948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("841061514", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("841061514", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("841061514", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("841061514", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("844599296", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("844599296", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("844599296", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("844599296", "4294967040");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846440534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846440534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846440534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846440534", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846487779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846487779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846487779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846487779", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554637", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554678", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554702", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554741", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554760", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554777", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554777", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554777", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554777", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554825", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554862", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554862", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554862", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("846554862", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("851743939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("851743939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("851743939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("851743939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("852007982", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("852007982", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("852007982", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("852007982", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854141538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854141538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854141538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854141538", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854853889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854853889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854853889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854853889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854956505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854956505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854956505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("854956505", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("855259265", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("855259265", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("855259265", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("855259265", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("855495485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("855495485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("855495485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("855495485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856625060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856625060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856625060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856625060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856625528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856625528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856625528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856625528", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856630625", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856630625", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856630625", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856630625", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856632269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856632269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856632269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856632269", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856633734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856633734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856633734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856633734", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856641550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856641550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856641550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856641550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856643234", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856643234", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856643234", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856643234", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856646716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856646716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856646716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856646716", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856648256", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856648256", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856648256", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856648256", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856649501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856649501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856649501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856649501", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856651058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856651058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856651058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856651058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856651361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856651361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856651361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856651361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856664709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856664709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856664709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856664709", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856666433", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856666433", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856666433", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856666433", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856681427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856681427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856681427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("856681427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858138010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858138010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858138010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858138010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858138590", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858138590", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858138590", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858138590", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858144581", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858144581", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858144581", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858144581", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858144904", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858144904", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858144904", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858144904", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858161442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858161442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858161442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858161442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858170088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858170088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858170088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858170088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858188125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858188125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858188125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("858188125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860124987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860124987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860124987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860124987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860130199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860130199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860130199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860130199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860133614", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860133614", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860133614", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860133614", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860142778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860142778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860142778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860142778", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860146042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860147537", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860147537", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860147537", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860147537", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860149293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860149293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860149293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860149293", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860149703", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860149703", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860149703", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860149703", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860157199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860157199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860157199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860157199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860559318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860559318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860559318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860559318", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860566646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860566646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860566646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860566646", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567593", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567594", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567594", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567594", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567594", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567596", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567596", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567596", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860567596", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860569623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860569623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860569623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860569623", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860585412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860585412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860585412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860585412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860590123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860590123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860590123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860590123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860598047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860604814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860604814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860604814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860604814", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860610209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860610209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860610209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860610209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860616459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860616459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860616459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860616459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860694527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860694527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860694527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860694527", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860710905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860710905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860710905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860710905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860711969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860711969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860711969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860711969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860720238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860720238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860720238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860720238", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860720265", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860720265", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860720265", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860720265", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860733648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860733648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860733648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860733648", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860741438", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860741438", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860741438", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860741438", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860744790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860744790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860744790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860744790", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860744791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860744791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860744791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860744791", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829062", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829062", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829062", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829062", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860829084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837549", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837549", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837549", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837549", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837550", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837551", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837551", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837551", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837551", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837553", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837553", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837553", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837553", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837556", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837556", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837556", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837556", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837557", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837557", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837557", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860837557", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860848619", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860848619", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860848619", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("860848619", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011402", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011402", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011402", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011402", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011408", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011408", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011408", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011408", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011471", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011471", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011471", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011471", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011486", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011486", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011486", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861011486", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861078164", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861078164", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861078164", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861078164", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861097099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861097099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861097099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861097099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861105245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861105245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861105245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861105245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861474424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861474424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861474424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861474424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861476682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861476682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861476682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861476682", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861480884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861480884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861480884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861480884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861502840", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861502840", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861502840", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861502840", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508422", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508422", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508422", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508422", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861508426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861511012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861511012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861511012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861511012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522025", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522025", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522025", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522025", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522028", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522028", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522028", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522028", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861522046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525328", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525328", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525328", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525328", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525329", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525330", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525331", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525332", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525334", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525335", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525335", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525335", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525335", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525336", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525336", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525336", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525336", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525337", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525338", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525339", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525339", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525339", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525339", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525340", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525341", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525341", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525341", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525341", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525342", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861525343", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861606154", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861606154", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861606154", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861606154", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861608014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861608014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861608014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861608014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861616350", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861616350", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861616350", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861616350", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861627207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861627207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861627207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861627207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861656223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861656223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861656223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("861656223", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866010180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866010180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866010180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866010180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866010245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866010245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866010245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866010245", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866017913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866017913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866017913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866017913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866021277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866021277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866021277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866021277", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866021362", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866021362", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866021362", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866021362", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866022065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866022065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866022065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866022065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866023256", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866023256", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866023256", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866023256", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866024227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866024227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866024227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866024227", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866024442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866024442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866024442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866024442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866034962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866034962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866034962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866034962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866036901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866036901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866036901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866036901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866038934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866038934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866038934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866038934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866038963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866038963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866038963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866038963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866040404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866040404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866040404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866040404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866040562", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866040562", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866040562", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866040562", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866063632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866063632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866063632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866063632", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866200555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866200555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866200555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("866200555", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("867316981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("867316981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("867316981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("867316981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872288489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872288489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872288489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872288489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872289768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872289768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872289768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872289768", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872308410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872308410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872308410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872308410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872309333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872309333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872309333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872309333", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872314592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872314592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872314592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872314592", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872320864", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872320864", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872320864", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872320864", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872330728", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872330728", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872330728", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872330728", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872335170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872335170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872335170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872335170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872335706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872335706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872335706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872335706", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872336800", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872336800", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872336800", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872336800", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872353752", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872353752", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872353752", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872353752", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872361360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872361360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872361360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872361360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872362879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872362879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872362879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872362879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872366138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872366138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872366138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872366138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872371076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872371076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872371076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872371076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872375560", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872375560", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872375560", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872375560", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872376917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872376917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872376917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872376917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872391853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872391853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872391853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872391853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872393418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872393418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872393418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872393418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872400663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872400663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872400663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872400663", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872403884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872403884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872403884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872403884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872542488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872542488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872542488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872542488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872588533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872588533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872588533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872588533", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872601870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872601870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872601870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("872601870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("873972368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("873972368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("873972368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("873972368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("873980083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("873980083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("873980083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("873980083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("877667095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("877667095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("877667095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("877667095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("877673208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("877673208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("877673208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("877673208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("878373987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("878373987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("878373987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("878373987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("880954887", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("880954887", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("880954887", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("880954887", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("885619717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("885619717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("885619717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("885619717", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("885665361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("885665361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("885665361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("885665361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908356770", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908356770", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908356770", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908356770", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908360072", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908360072", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908360072", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908360072", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366848", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366849", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366850", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366851", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366852", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366852", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366852", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366852", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366853", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366854", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366854", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366854", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366854", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366855", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366856", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366857", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366857", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366857", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366857", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366858", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366859", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366860", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366861", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366861", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366861", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366861", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366862", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366862", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366862", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366862", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366863", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366864", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366864", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366864", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366864", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366865", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366866", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366867", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366868", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366869", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366870", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366871", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366872", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366873", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366873", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366873", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366873", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366874", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366875", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366875", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366875", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366875", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366876", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366876", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366876", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366876", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366877", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366878", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366879", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366880", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366881", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366881", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366881", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366881", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366882", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366883", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366884", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366885", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366886", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366887", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366887", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366887", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366887", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366888", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366889", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366890", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366891", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366892", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366893", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366894", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366895", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366896", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366896", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366896", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366896", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366897", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366897", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366897", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366897", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366898", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366899", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366900", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366901", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366902", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366903", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366904", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366904", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366904", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366904", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366905", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366906", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366907", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366907", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366907", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366907", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366908", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366909", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366910", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366910", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366910", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366910", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366911", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366911", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366911", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366911", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366912", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366912", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366912", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366912", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366913", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366914", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366915", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366916", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366917", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366918", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366919", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366920", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366921", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366922", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366922", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366922", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366922", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366923", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366924", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366925", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366926", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366926", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366926", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366926", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366927", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366928", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366929", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366930", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366930", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366930", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366930", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366931", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366931", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366931", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366931", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366932", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366933", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366934", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366935", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366936", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366936", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366936", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366936", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366937", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366938", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366939", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366940", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366940", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366940", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366940", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366941", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366941", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366941", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366941", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366942", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366943", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366944", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366945", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366946", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366947", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366948", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366949", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366950", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366950", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366950", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366950", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366951", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366952", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366952", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366952", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366952", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366953", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366954", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366954", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366954", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366954", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366955", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366955", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366955", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366955", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366956", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366957", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366958", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366959", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366959", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366959", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366959", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366960", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366960", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366960", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366960", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366961", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366962", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366963", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366964", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366965", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366965", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366965", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366965", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366966", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366967", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366968", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366969", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366970", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366970", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366970", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366970", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366971", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366972", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366973", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366974", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366975", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366975", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366975", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366975", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366976", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366976", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366976", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366976", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366977", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366978", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366979", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366980", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366981", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366982", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366982", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366982", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366982", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366983", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366984", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366984", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366984", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366984", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366985", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366986", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366986", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366986", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366986", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366987", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366988", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366988", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366988", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366988", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366989", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366990", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366991", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366992", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366992", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366992", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366992", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366993", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366994", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366995", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366995", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366995", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366995", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366996", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366996", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366996", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366996", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366997", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366998", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366998", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366998", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366998", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366999", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366999", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366999", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908366999", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367000", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367000", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367000", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367000", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367001", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367002", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367003", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367004", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367005", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367006", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367007", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367008", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367009", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367010", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367011", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367012", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367013", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367014", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367015", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367016", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367017", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367018", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367019", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367020", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367021", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367021", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367021", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367021", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367022", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367023", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367024", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367025", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367025", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367025", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367025", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367026", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367027", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367028", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367028", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367028", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367028", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367029", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367030", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367031", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367032", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367033", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367034", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367035", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367036", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367036", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367036", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367036", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367037", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367038", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367039", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367040", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367041", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367042", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367043", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367044", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367045", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367046", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367047", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367048", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367049", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367049", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367049", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367049", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367050", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367051", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367052", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367053", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367053", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367053", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367053", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367054", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367055", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367055", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367055", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367055", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367056", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367056", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367056", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367056", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367057", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367058", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367059", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367059", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367059", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367059", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367060", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367061", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367062", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367062", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367062", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367062", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367063", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367063", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367063", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367063", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367064", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367065", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367066", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367066", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367066", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367066", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367067", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367068", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367068", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367068", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367068", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367069", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367070", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367071", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367072", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367072", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367072", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367072", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367073", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367074", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367075", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367075", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367075", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367075", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367076", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367077", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367078", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367078", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367078", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367078", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367079", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367079", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367079", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367079", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367080", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367081", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367082", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367083", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367084", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367085", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367086", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367087", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367087", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367087", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367087", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367088", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367089", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367090", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367091", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367092", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367093", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367094", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367094", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367094", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367094", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367095", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367096", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367096", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367096", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367096", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367097", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367097", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367097", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367097", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367098", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367099", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367100", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367101", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367101", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367101", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367101", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367102", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367102", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367102", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367102", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367103", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367103", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367103", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367103", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367104", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367104", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367104", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367104", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367105", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367105", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367105", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367105", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367106", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367107", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367107", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367107", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367107", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367108", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367108", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367108", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367108", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367109", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367110", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367110", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367110", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367110", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367111", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367112", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367113", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367114", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367114", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367114", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367114", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367115", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367115", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367115", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367115", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367116", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367116", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367116", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367116", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367117", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367118", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367119", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367120", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367121", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367121", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367121", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367121", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367122", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367122", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367122", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367122", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367123", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367124", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367124", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367124", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367124", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367125", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367126", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367126", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367126", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367126", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367127", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367128", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367128", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367128", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367128", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367129", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367129", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367129", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367129", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367130", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367130", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367130", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367130", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367131", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367131", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367131", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367131", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367132", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367133", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367133", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367133", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367133", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367134", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367135", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367135", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367135", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367135", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367136", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367137", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367138", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367139", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367140", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367140", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367140", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367140", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367141", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367141", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367141", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367141", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367142", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367142", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367142", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367142", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367143", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367144", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367144", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367144", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367144", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367145", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367145", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367145", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367145", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367146", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367146", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367146", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367146", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367147", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367147", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367147", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367147", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367148", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367148", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367148", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367148", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367149", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367150", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367150", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367150", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367150", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367151", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367151", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367151", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367151", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367152", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367152", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367152", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367152", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367153", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367153", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367153", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367153", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367154", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367154", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367154", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367154", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367155", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367156", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367156", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367156", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367156", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367157", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367157", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367157", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367157", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367158", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367158", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367158", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367158", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367159", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367159", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367159", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367159", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367160", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367160", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367160", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367160", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367161", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367162", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367163", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367163", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367163", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367163", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367164", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367164", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367164", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367164", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367165", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367165", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367165", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367165", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367166", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367167", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367168", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367168", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367168", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367168", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367169", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367170", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367171", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367172", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367172", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367172", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367172", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367173", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367173", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367173", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367173", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367174", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367174", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367174", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367174", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367175", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367176", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367176", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367176", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367176", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367177", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367177", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367177", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367177", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367178", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367179", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367180", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367181", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367181", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367181", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367181", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367182", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367183", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367183", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367183", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367183", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367184", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367185", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367185", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367185", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367185", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367186", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367187", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367187", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367187", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367187", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367188", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367189", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367190", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367190", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367190", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367190", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367191", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367192", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367193", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367194", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367194", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367194", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367194", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367195", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367196", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367196", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367196", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367196", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367197", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367198", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367198", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367198", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367198", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367199", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367200", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367200", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367200", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367200", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367201", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367202", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367202", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367202", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367202", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367203", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367204", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367204", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367204", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367204", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367205", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367206", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367207", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367208", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367209", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367210", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367211", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367360", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367361", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367362", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367362", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367362", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367362", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367363", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367364", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367365", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367366", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367366", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367366", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367366", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367367", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367368", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367369", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367370", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367371", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367371", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367371", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367371", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367372", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367373", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367374", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367374", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367374", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367374", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367375", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367376", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367377", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367378", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367378", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367378", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367378", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367379", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367380", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367381", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367382", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367382", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367382", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367382", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367383", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367383", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367383", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367383", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367384", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367385", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367386", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367387", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367388", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367388", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367388", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367388", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367389", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367390", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367390", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367390", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367390", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367391", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367391", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367391", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367391", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367392", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367393", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367394", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367395", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367396", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367397", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367398", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367399", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367400", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367401", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367402", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367402", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367402", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367402", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367403", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367404", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367405", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367406", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367407", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367408", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367408", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367408", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367408", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367409", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367410", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367411", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367412", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367413", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367414", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367415", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367416", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367417", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367418", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367419", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367420", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367421", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367422", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367422", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367422", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367422", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367423", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367424", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367425", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367426", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367427", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367428", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367429", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367430", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367431", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367432", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367432", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367432", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367432", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367433", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367433", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367433", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367433", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367434", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367435", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367435", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367435", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367435", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367436", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367436", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367436", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367436", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367437", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367437", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367437", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367437", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367438", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367438", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367438", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367438", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367439", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367440", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367440", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367440", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367440", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367441", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367441", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367441", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367441", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367442", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367443", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367444", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367445", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367446", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367446", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367446", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367446", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367447", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367447", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367447", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367447", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367448", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367448", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367448", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367448", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367449", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367450", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367450", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367450", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367450", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367451", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367452", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367453", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367454", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367454", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367454", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367454", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367455", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367456", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367457", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367458", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367459", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367460", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367460", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367460", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367460", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367461", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367462", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367463", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367463", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367463", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367463", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367464", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367464", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367464", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367464", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367465", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367466", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367467", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367468", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367469", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367470", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367471", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367471", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367471", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367471", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367472", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367473", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367474", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367475", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367476", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367477", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367478", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367479", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367480", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367481", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367482", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367483", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367484", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367485", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367486", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367486", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367486", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367486", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367487", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367488", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367489", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367490", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367491", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367492", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367493", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367494", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367494", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367494", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367494", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367495", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367495", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367495", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367495", "4294967295");
INSERT INTO `wp_onecleantalk_sfw` VALUES("908367496", "4