/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2020-04-14 21:44:00 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_oneactionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=234 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneactionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=896 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneactionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneactionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=683 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onecommentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onecomments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneduplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_onelinks` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`),
  KEY `link_owner` (`link_owner`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneoptions` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2313 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onepostmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6915 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneposts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=744 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneterm_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneterm_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onetermmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneterms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onetm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onetm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `class_identifier` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `attempts` int(11) DEFAULT '0',
  `description` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_locked_at` bigint(20) DEFAULT '0',
  `status` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneusermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_oneusers` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `fk_wp_onewc_download_log_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `wp_onewoocommerce_downloadable_product_permissions` (`permission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=170 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewoocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_onewpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wp_oneactionscheduler_actions */
INSERT INTO `wp_oneactionscheduler_actions` VALUES("6", "action_scheduler/migration_hook", "complete", "2020-04-04 00:49:12", "2020-04-04 02:49:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585961352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585961352;}", "1", "1", "2020-04-04 00:49:14", "2020-04-04 02:49:14", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("7", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-05 00:00:00", "2020-04-05 02:00:00", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586044800;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586044800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-05 12:34:05", "2020-04-05 14:34:05", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("8", "wc-admin_import_orders", "complete", "2020-04-04 01:09:07", "2020-04-04 03:09:07", "[536]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962547;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962547;}", "3", "1", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("9", "wc-admin_import_orders", "complete", "2020-04-04 01:09:07", "2020-04-04 03:09:07", "[559]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962547;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962547;}", "3", "1", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("10", "wc-admin_import_orders", "complete", "2020-04-04 01:09:07", "2020-04-04 03:09:07", "[570]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962547;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962547;}", "3", "1", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("11", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[575]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("12", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[578]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("13", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[599]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("14", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[446]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("15", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[448]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("16", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[450]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("17", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[451]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("18", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[542]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("19", "wc-admin_import_orders", "complete", "2020-04-04 01:09:08", "2020-04-04 03:09:08", "[543]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962548;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("20", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[554]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("21", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[560]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("22", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[601]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("23", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[610]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("24", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("25", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[615]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("26", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[624]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("27", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[625]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("28", "wc-admin_import_orders", "complete", "2020-04-04 01:09:09", "2020-04-04 03:09:09", "[629]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962549;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("29", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[632]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("30", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[633]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("31", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[634]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("32", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[636]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("33", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("34", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[563]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("35", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[565]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("36", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[568]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("37", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[569]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("38", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[571]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("39", "wc-admin_import_orders", "complete", "2020-04-04 01:09:10", "2020-04-04 03:09:10", "[572]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962550;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("40", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[574]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("41", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[577]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("42", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[585]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("43", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[593]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("44", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[594]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("45", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[598]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("46", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[600]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("47", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[602]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("48", "wc-admin_import_orders", "complete", "2020-04-04 01:09:11", "2020-04-04 03:09:11", "[603]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962551;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("49", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[605]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("50", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[606]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("51", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[617]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("52", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[618]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("53", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[627]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("54", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[630]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("55", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[631]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("56", "wc-admin_import_orders", "complete", "2020-04-04 01:09:12", "2020-04-04 03:09:12", "[635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585962552;}", "3", "1", "2020-04-04 01:09:13", "2020-04-04 03:09:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("57", "wc-admin_import_customers", "complete", "2020-04-04 01:29:36", "2020-04-04 03:29:36", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963776;}", "3", "1", "2020-04-04 01:30:11", "2020-04-04 03:30:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("58", "wc-admin_import_orders", "complete", "2020-04-04 01:29:36", "2020-04-04 03:29:36", "[654]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963776;}", "3", "1", "2020-04-04 01:30:11", "2020-04-04 03:30:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("59", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("60", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[636]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("61", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("62", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[634]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("63", "wc-admin_import_orders", "complete", "2020-04-04 01:32:54", "2020-04-04 03:32:54", "[633]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963974;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("64", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[632]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("65", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[631]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("66", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[630]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("67", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[629]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("68", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[627]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:08", "2020-04-04 03:33:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("69", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[625]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("70", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[624]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("71", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[618]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("72", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[617]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("73", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[615]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("74", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("75", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[610]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("76", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[606]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("77", "wc-admin_import_orders", "complete", "2020-04-04 01:32:55", "2020-04-04 03:32:55", "[605]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963975;}", "3", "1", "2020-04-04 01:33:09", "2020-04-04 03:33:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("78", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("79", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[636]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("80", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("81", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[634]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("82", "wc-admin_import_orders", "complete", "2020-04-04 01:33:18", "2020-04-04 03:33:18", "[633]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963998;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("83", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[632]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("84", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[631]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("85", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[630]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("86", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[629]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("87", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[627]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("88", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[625]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("89", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[624]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("90", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[618]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("91", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[617]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("92", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[615]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("93", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("94", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[610]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("95", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[606]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("96", "wc-admin_import_orders", "complete", "2020-04-04 01:33:19", "2020-04-04 03:33:19", "[605]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1585963999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1585963999;}", "3", "1", "2020-04-04 01:34:25", "2020-04-04 03:34:25", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("97", "wc-admin_import_customers", "complete", "2020-04-04 14:06:58", "2020-04-04 16:06:58", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586009218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586009218;}", "3", "1", "2020-04-04 14:07:38", "2020-04-04 16:07:38", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("98", "wc-admin_import_orders", "complete", "2020-04-04 14:06:58", "2020-04-04 16:06:58", "[666]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586009218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586009218;}", "3", "1", "2020-04-04 14:07:38", "2020-04-04 16:07:38", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("99", "wc-admin_import_customers", "complete", "2020-04-04 16:14:20", "2020-04-04 18:14:20", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586016860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586016860;}", "3", "1", "2020-04-04 16:21:06", "2020-04-04 18:21:06", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("100", "wc-admin_import_orders", "complete", "2020-04-04 16:14:20", "2020-04-04 18:14:20", "[668]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586016860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586016860;}", "3", "1", "2020-04-04 16:21:06", "2020-04-04 18:21:06", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("101", "wc-admin_import_customers", "complete", "2020-04-04 17:44:10", "2020-04-04 19:44:10", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586022250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586022250;}", "3", "1", "2020-04-04 17:45:50", "2020-04-04 19:45:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("102", "wc-admin_import_orders", "complete", "2020-04-04 17:44:10", "2020-04-04 19:44:10", "[669]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586022250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586022250;}", "3", "1", "2020-04-04 17:45:50", "2020-04-04 19:45:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("103", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-06 12:34:05", "2020-04-06 14:34:05", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586176445;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586176445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-06 12:54:31", "2020-04-06 14:54:31", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("104", "wc-admin_import_customers", "complete", "2020-04-05 18:17:31", "2020-04-05 20:17:31", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586110651;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586110651;}", "3", "1", "2020-04-05 18:18:15", "2020-04-05 20:18:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("105", "wc-admin_import_orders", "complete", "2020-04-05 18:17:31", "2020-04-05 20:17:31", "[687]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586110651;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586110651;}", "3", "1", "2020-04-05 18:18:15", "2020-04-05 20:18:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("106", "wc-admin_import_customers", "complete", "2020-04-05 20:46:00", "2020-04-05 22:46:00", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586119560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586119560;}", "3", "1", "2020-04-05 20:46:42", "2020-04-05 22:46:42", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("107", "wc-admin_import_orders", "complete", "2020-04-05 20:46:00", "2020-04-05 22:46:00", "[691]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586119560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586119560;}", "3", "1", "2020-04-05 20:46:42", "2020-04-05 22:46:42", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("108", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[691]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:55", "2020-04-05 23:15:55", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("109", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[687]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:55", "2020-04-05 23:15:55", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("110", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[669]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("111", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[668]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("112", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[666]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("113", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[654]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("114", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("115", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[636]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("116", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("117", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[634]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("118", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[633]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("119", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[632]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("120", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[631]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("121", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[630]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("122", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[629]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("123", "wc-admin_import_orders", "complete", "2020-04-05 21:15:29", "2020-04-05 23:15:29", "[627]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121329;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("124", "wc-admin_import_orders", "complete", "2020-04-05 21:15:30", "2020-04-05 23:15:30", "[625]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121330;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("125", "wc-admin_import_orders", "complete", "2020-04-05 21:15:30", "2020-04-05 23:15:30", "[624]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121330;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("126", "wc-admin_import_orders", "complete", "2020-04-05 21:15:30", "2020-04-05 23:15:30", "[618]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121330;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("127", "wc-admin_import_orders", "complete", "2020-04-05 21:15:30", "2020-04-05 23:15:30", "[617]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121330;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("128", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[615]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("129", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("130", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[610]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("131", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[606]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("132", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[605]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("133", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[603]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("134", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[602]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("135", "wc-admin_import_orders", "complete", "2020-04-05 21:15:45", "2020-04-05 23:15:45", "[601]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121345;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("136", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[600]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("137", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[599]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("138", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[598]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("139", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[594]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("140", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[593]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:56", "2020-04-05 23:15:56", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("141", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[585]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("142", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[578]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("143", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[577]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("144", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[575]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("145", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[574]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("146", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[572]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("147", "wc-admin_import_orders", "complete", "2020-04-05 21:15:46", "2020-04-05 23:15:46", "[571]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121346;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("148", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[570]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("149", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[569]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("150", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[568]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("151", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[565]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("152", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[563]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("153", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[560]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("154", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[559]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("155", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[554]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("156", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[543]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("157", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[542]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("158", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[536]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("159", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[451]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("160", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[448]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("161", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[450]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("162", "wc-admin_import_orders", "complete", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "[446]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586121357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586121357;}", "3", "1", "2020-04-05 21:15:57", "2020-04-05 23:15:57", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("163", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-07 12:54:31", "2020-04-07 14:54:31", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586264071;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586264071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-07 14:29:20", "2020-04-07 16:29:20", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("164", "wc-admin_import_customers", "complete", "2020-04-06 17:02:38", "2020-04-06 19:02:38", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586192558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586192558;}", "3", "1", "2020-04-06 17:03:47", "2020-04-06 19:03:47", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("165", "wc-admin_import_orders", "complete", "2020-04-06 17:02:38", "2020-04-06 19:02:38", "[717]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586192558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586192558;}", "3", "1", "2020-04-06 17:03:47", "2020-04-06 19:03:47", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("166", "wc-admin_import_customers", "complete", "2020-04-06 17:06:10", "2020-04-06 19:06:10", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586192770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586192770;}", "3", "1", "2020-04-06 17:06:16", "2020-04-06 19:06:16", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("167", "wc-admin_import_orders", "complete", "2020-04-06 17:06:10", "2020-04-06 19:06:10", "[718]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586192770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586192770;}", "3", "1", "2020-04-06 17:06:16", "2020-04-06 19:06:16", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("168", "wc-admin_import_customers", "complete", "2020-04-06 17:22:17", "2020-04-06 19:22:17", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586193737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586193737;}", "3", "1", "2020-04-06 17:23:33", "2020-04-06 19:23:33", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("169", "wc-admin_import_orders", "complete", "2020-04-06 17:22:18", "2020-04-06 19:22:18", "[719]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586193738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586193738;}", "3", "1", "2020-04-06 17:23:33", "2020-04-06 19:23:33", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("170", "wc-admin_import_customers", "complete", "2020-04-06 17:42:09", "2020-04-06 19:42:09", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586194929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586194929;}", "3", "1", "2020-04-06 17:42:09", "2020-04-06 19:42:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("171", "wc-admin_import_orders", "complete", "2020-04-06 17:42:09", "2020-04-06 19:42:09", "[720]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586194929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586194929;}", "3", "1", "2020-04-06 17:42:09", "2020-04-06 19:42:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("172", "wc-admin_import_customers", "complete", "2020-04-06 17:48:11", "2020-04-06 19:48:11", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195291;}", "3", "1", "2020-04-06 17:48:22", "2020-04-06 19:48:22", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("173", "wc-admin_import_orders", "complete", "2020-04-06 17:48:11", "2020-04-06 19:48:11", "[721]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195291;}", "3", "1", "2020-04-06 17:48:22", "2020-04-06 19:48:22", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("174", "wc-admin_import_customers", "complete", "2020-04-06 17:50:04", "2020-04-06 19:50:04", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195404;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195404;}", "3", "1", "2020-04-06 17:50:23", "2020-04-06 19:50:23", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("175", "wc-admin_import_orders", "complete", "2020-04-06 17:50:05", "2020-04-06 19:50:05", "[722]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195405;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195405;}", "3", "1", "2020-04-06 17:50:23", "2020-04-06 19:50:23", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("176", "wc-admin_import_customers", "complete", "2020-04-06 17:55:21", "2020-04-06 19:55:21", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195721;}", "3", "1", "2020-04-06 17:56:41", "2020-04-06 19:56:41", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("177", "wc-admin_import_orders", "complete", "2020-04-06 17:55:22", "2020-04-06 19:55:22", "[723]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586195722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586195722;}", "3", "1", "2020-04-06 17:56:41", "2020-04-06 19:56:41", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("178", "wc-admin_import_customers", "complete", "2020-04-06 18:00:04", "2020-04-06 20:00:04", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196004;}", "3", "1", "2020-04-06 18:00:47", "2020-04-06 20:00:47", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("179", "wc-admin_import_orders", "complete", "2020-04-06 18:00:04", "2020-04-06 20:00:04", "[724]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196004;}", "3", "1", "2020-04-06 18:00:47", "2020-04-06 20:00:47", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("180", "wc-admin_import_customers", "complete", "2020-04-06 18:02:29", "2020-04-06 20:02:29", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196149;}", "3", "1", "2020-04-06 18:03:09", "2020-04-06 20:03:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("181", "wc-admin_import_orders", "complete", "2020-04-06 18:02:29", "2020-04-06 20:02:29", "[725]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196149;}", "3", "1", "2020-04-06 18:03:09", "2020-04-06 20:03:09", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("182", "wc-admin_import_customers", "complete", "2020-04-06 18:05:01", "2020-04-06 20:05:01", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196301;}", "3", "1", "2020-04-06 18:05:30", "2020-04-06 20:05:30", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("183", "wc-admin_import_orders", "complete", "2020-04-06 18:05:01", "2020-04-06 20:05:01", "[726]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196301;}", "3", "1", "2020-04-06 18:05:30", "2020-04-06 20:05:30", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("184", "wc-admin_import_customers", "complete", "2020-04-06 18:08:26", "2020-04-06 20:08:26", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196506;}", "3", "1", "2020-04-06 18:10:15", "2020-04-06 20:10:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("185", "wc-admin_import_orders", "complete", "2020-04-06 18:08:26", "2020-04-06 20:08:26", "[727]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586196506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586196506;}", "3", "1", "2020-04-06 18:10:15", "2020-04-06 20:10:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("186", "wc-admin_import_orders", "complete", "2020-04-06 19:32:12", "2020-04-06 21:32:12", "[735]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586201532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586201532;}", "3", "1", "2020-04-06 19:32:34", "2020-04-06 21:32:34", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("187", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:05", "2020-04-07 13:08:05", "[717]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257685;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("188", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:05", "2020-04-07 13:08:05", "[718]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257685;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("189", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:05", "2020-04-07 13:08:05", "[719]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257685;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("190", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:05", "2020-04-07 13:08:05", "[720]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257685;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("191", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[721]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("192", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[722]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("193", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[723]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("194", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[724]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("195", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[725]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("196", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[726]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("197", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[727]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("198", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:06", "2020-04-07 13:08:06", "[735]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257686;}", "3", "1", "2020-04-07 11:08:15", "2020-04-07 13:08:15", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("199", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[735]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("200", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[727]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("201", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[726]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("202", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[725]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("203", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[724]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("204", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[723]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("205", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[722]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("206", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[721]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("207", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[720]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("208", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[719]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("209", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[718]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("210", "wc-admin_import_orders", "complete", "2020-04-07 11:08:20", "2020-04-07 13:08:20", "[717]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257700;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("211", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[717]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:50", "2020-04-07 13:08:50", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("212", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[718]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("213", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[719]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("214", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[720]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("215", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[721]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("216", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[722]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("217", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[723]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("218", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[724]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("219", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[725]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("220", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[726]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("221", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[727]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("222", "wc-admin_anonymize_customers", "complete", "2020-04-07 11:08:36", "2020-04-07 13:08:36", "[735]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586257716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586257716;}", "3", "1", "2020-04-07 11:08:51", "2020-04-07 13:08:51", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("223", "action_scheduler/migration_hook", "complete", "2020-04-07 11:28:25", "2020-04-07 13:28:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586258905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586258905;}", "1", "1", "2020-04-07 11:28:33", "2020-04-07 13:28:33", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("224", "action_scheduler/migration_hook", "complete", "2020-04-07 11:28:40", "2020-04-07 13:28:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586258920;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586258920;}", "1", "1", "2020-04-07 11:29:11", "2020-04-07 13:29:11", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("225", "action_scheduler/migration_hook", "complete", "2020-04-07 11:52:16", "2020-04-07 13:52:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586260336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586260336;}", "1", "1", "2020-04-07 11:53:03", "2020-04-07 13:53:03", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("226", "action_scheduler/migration_hook", "complete", "2020-04-07 12:00:28", "2020-04-07 14:00:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586260828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586260828;}", "1", "1", "2020-04-07 12:01:20", "2020-04-07 14:01:20", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("227", "action_scheduler/migration_hook", "complete", "2020-04-07 12:01:34", "2020-04-07 14:01:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586260894;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586260894;}", "1", "1", "2020-04-07 12:02:13", "2020-04-07 14:02:13", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("228", "action_scheduler/migration_hook", "complete", "2020-04-07 12:02:14", "2020-04-07 14:02:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586260934;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586260934;}", "1", "1", "2020-04-07 12:02:31", "2020-04-07 14:02:31", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("229", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-08 14:29:20", "2020-04-08 16:29:20", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586356160;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586356160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-11 16:03:52", "2020-04-11 18:03:52", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("230", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-12 16:03:52", "2020-04-12 18:03:52", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586707432;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586707432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-12 20:27:53", "2020-04-12 22:27:53", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("231", "action_scheduler/migration_hook", "complete", "2020-04-11 16:04:55", "2020-04-11 18:04:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1586621095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1586621095;}", "1", "1", "2020-04-11 16:05:08", "2020-04-11 18:05:08", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("232", "wpforms_process_entry_emails_meta_cleanup", "complete", "2020-04-13 20:27:53", "2020-04-13 22:27:53", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586809673;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586809673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2020-04-14 21:41:42", "2020-04-14 23:41:42", "0", NULL);
INSERT INTO `wp_oneactionscheduler_actions` VALUES("233", "wpforms_process_entry_emails_meta_cleanup", "pending", "2020-04-15 21:41:42", "2020-04-15 23:41:42", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1586986902;s:18:\"\0*\0first_timestamp\";i:1586044800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1586986902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_oneactionscheduler_groups */
INSERT INTO `wp_oneactionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_oneactionscheduler_groups` VALUES("2", "wpforms");
INSERT INTO `wp_oneactionscheduler_groups` VALUES("3", "wc-admin-data");

/* INSERT TABLE DATA: wp_oneactionscheduler_logs */
INSERT INTO `wp_oneactionscheduler_logs` VALUES("1", "6", "action created", "2020-04-04 00:49:12", "2020-04-04 02:49:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("2", "6", "action started via Async Request", "2020-04-04 00:49:14", "2020-04-04 02:49:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("3", "6", "action complete via Async Request", "2020-04-04 00:49:14", "2020-04-04 02:49:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("4", "7", "action created", "2020-04-04 00:51:16", "2020-04-04 02:51:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("5", "8", "action créée", "2020-04-04 01:09:02", "2020-04-04 03:09:02");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("6", "9", "action créée", "2020-04-04 01:09:02", "2020-04-04 03:09:02");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("7", "10", "action créée", "2020-04-04 01:09:02", "2020-04-04 03:09:02");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("8", "11", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("9", "12", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("10", "13", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("11", "14", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("12", "15", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("13", "16", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("14", "17", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("15", "18", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("16", "19", "action créée", "2020-04-04 01:09:03", "2020-04-04 03:09:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("17", "20", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("18", "21", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("19", "22", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("20", "23", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("21", "24", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("22", "25", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("23", "26", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("24", "27", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("25", "28", "action créée", "2020-04-04 01:09:04", "2020-04-04 03:09:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("26", "29", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("27", "30", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("28", "31", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("29", "32", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("30", "33", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("31", "34", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("32", "35", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("33", "36", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("34", "37", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("35", "38", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("36", "39", "action créée", "2020-04-04 01:09:05", "2020-04-04 03:09:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("37", "40", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("38", "41", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("39", "42", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("40", "43", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("41", "44", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("42", "45", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("43", "46", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("44", "47", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("45", "48", "action créée", "2020-04-04 01:09:06", "2020-04-04 03:09:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("46", "49", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("47", "50", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("48", "51", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("49", "52", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("50", "53", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("51", "54", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("52", "55", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("53", "56", "action créée", "2020-04-04 01:09:07", "2020-04-04 03:09:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("54", "8", "action lancée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("55", "8", "action terminée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("56", "9", "action lancée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("57", "9", "action terminée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("58", "10", "action lancée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("59", "10", "action terminée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("60", "11", "action lancée via Async Request", "2020-04-04 01:09:11", "2020-04-04 03:09:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("61", "11", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("62", "12", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("63", "12", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("64", "13", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("65", "13", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("66", "14", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("67", "14", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("68", "15", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("69", "15", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("70", "16", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("71", "16", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("72", "17", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("73", "17", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("74", "18", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("75", "18", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("76", "19", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("77", "19", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("78", "20", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("79", "20", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("80", "21", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("81", "21", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("82", "22", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("83", "22", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("84", "23", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("85", "23", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("86", "24", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("87", "24", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("88", "25", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("89", "25", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("90", "26", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("91", "26", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("92", "27", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("93", "27", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("94", "28", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("95", "28", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("96", "29", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("97", "29", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("98", "30", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("99", "30", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("100", "31", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("101", "31", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("102", "32", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("103", "32", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("104", "33", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("105", "33", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("106", "34", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("107", "34", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("108", "35", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("109", "35", "action terminée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("110", "36", "action lancée via Async Request", "2020-04-04 01:09:12", "2020-04-04 03:09:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("111", "36", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("112", "37", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("113", "37", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("114", "38", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("115", "38", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("116", "39", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("117", "39", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("118", "40", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("119", "40", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("120", "41", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("121", "41", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("122", "42", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("123", "42", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("124", "43", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("125", "43", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("126", "44", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("127", "44", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("128", "45", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("129", "45", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("130", "46", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("131", "46", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("132", "47", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("133", "47", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("134", "48", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("135", "48", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("136", "49", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("137", "49", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("138", "50", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("139", "50", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("140", "51", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("141", "51", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("142", "52", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("143", "52", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("144", "53", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("145", "53", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("146", "54", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("147", "54", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("148", "55", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("149", "55", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("150", "56", "action lancée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("151", "56", "action terminée via Async Request", "2020-04-04 01:09:13", "2020-04-04 03:09:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("152", "57", "action créée", "2020-04-04 01:29:31", "2020-04-04 03:29:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("153", "58", "action créée", "2020-04-04 01:29:31", "2020-04-04 03:29:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("154", "57", "action lancée via WP Cron", "2020-04-04 01:30:11", "2020-04-04 03:30:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("155", "57", "action terminée via WP Cron", "2020-04-04 01:30:11", "2020-04-04 03:30:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("156", "58", "action lancée via WP Cron", "2020-04-04 01:30:11", "2020-04-04 03:30:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("157", "58", "action terminée via WP Cron", "2020-04-04 01:30:11", "2020-04-04 03:30:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("158", "59", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("159", "60", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("160", "61", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("161", "62", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("162", "63", "action créée", "2020-04-04 01:32:49", "2020-04-04 03:32:49");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("163", "64", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("164", "65", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("165", "66", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("166", "67", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("167", "68", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("168", "69", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("169", "70", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("170", "71", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("171", "72", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("172", "73", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("173", "74", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("174", "75", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("175", "76", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("176", "77", "action créée", "2020-04-04 01:32:50", "2020-04-04 03:32:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("177", "59", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("178", "59", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("179", "60", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("180", "60", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("181", "61", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("182", "61", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("183", "62", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("184", "62", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("185", "63", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("186", "63", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("187", "64", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("188", "64", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("189", "65", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("190", "65", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("191", "66", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("192", "66", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("193", "67", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("194", "67", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("195", "68", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("196", "68", "action terminée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("197", "69", "action lancée via WP Cron", "2020-04-04 01:33:08", "2020-04-04 03:33:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("198", "69", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("199", "70", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("200", "70", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("201", "71", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("202", "71", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("203", "72", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("204", "72", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("205", "73", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("206", "73", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("207", "74", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("208", "74", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("209", "75", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("210", "75", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("211", "76", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("212", "76", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("213", "77", "action lancée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("214", "77", "action terminée via WP Cron", "2020-04-04 01:33:09", "2020-04-04 03:33:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("215", "78", "action créée", "2020-04-04 01:33:13", "2020-04-04 03:33:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("216", "79", "action créée", "2020-04-04 01:33:13", "2020-04-04 03:33:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("217", "80", "action créée", "2020-04-04 01:33:13", "2020-04-04 03:33:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("218", "81", "action créée", "2020-04-04 01:33:13", "2020-04-04 03:33:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("219", "82", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("220", "83", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("221", "84", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("222", "85", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("223", "86", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("224", "87", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("225", "88", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("226", "89", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("227", "90", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("228", "91", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("229", "92", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("230", "93", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("231", "94", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("232", "95", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("233", "96", "action créée", "2020-04-04 01:33:14", "2020-04-04 03:33:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("234", "78", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("235", "78", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("236", "79", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("237", "79", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("238", "80", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("239", "80", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("240", "81", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("241", "81", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("242", "82", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("243", "82", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("244", "83", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("245", "83", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("246", "84", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("247", "84", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("248", "85", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("249", "85", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("250", "86", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("251", "86", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("252", "87", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("253", "87", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("254", "88", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("255", "88", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("256", "89", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("257", "89", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("258", "90", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("259", "90", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("260", "91", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("261", "91", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("262", "92", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("263", "92", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("264", "93", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("265", "93", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("266", "94", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("267", "94", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("268", "95", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("269", "95", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("270", "96", "action lancée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("271", "96", "action terminée via WP Cron", "2020-04-04 01:34:25", "2020-04-04 03:34:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("272", "97", "action créée", "2020-04-04 14:06:53", "2020-04-04 16:06:53");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("273", "98", "action créée", "2020-04-04 14:06:53", "2020-04-04 16:06:53");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("274", "97", "action lancée via WP Cron", "2020-04-04 14:07:38", "2020-04-04 16:07:38");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("275", "97", "action terminée via WP Cron", "2020-04-04 14:07:38", "2020-04-04 16:07:38");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("276", "98", "action lancée via WP Cron", "2020-04-04 14:07:38", "2020-04-04 16:07:38");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("277", "98", "action terminée via WP Cron", "2020-04-04 14:07:38", "2020-04-04 16:07:38");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("278", "99", "action créée", "2020-04-04 16:14:15", "2020-04-04 18:14:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("279", "100", "action créée", "2020-04-04 16:14:15", "2020-04-04 18:14:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("280", "99", "action lancée via WP Cron", "2020-04-04 16:21:06", "2020-04-04 18:21:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("281", "99", "action terminée via WP Cron", "2020-04-04 16:21:06", "2020-04-04 18:21:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("282", "100", "action lancée via WP Cron", "2020-04-04 16:21:06", "2020-04-04 18:21:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("283", "100", "action terminée via WP Cron", "2020-04-04 16:21:06", "2020-04-04 18:21:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("284", "101", "action créée", "2020-04-04 17:44:05", "2020-04-04 19:44:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("285", "102", "action créée", "2020-04-04 17:44:05", "2020-04-04 19:44:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("286", "101", "action lancée via Async Request", "2020-04-04 17:45:50", "2020-04-04 19:45:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("287", "101", "action terminée via Async Request", "2020-04-04 17:45:50", "2020-04-04 19:45:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("288", "102", "action lancée via Async Request", "2020-04-04 17:45:50", "2020-04-04 19:45:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("289", "102", "action terminée via Async Request", "2020-04-04 17:45:50", "2020-04-04 19:45:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("290", "7", "action lancée via WP Cron", "2020-04-05 12:34:05", "2020-04-05 14:34:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("291", "7", "action terminée via WP Cron", "2020-04-05 12:34:05", "2020-04-05 14:34:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("292", "103", "action créée", "2020-04-05 12:34:05", "2020-04-05 14:34:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("293", "104", "action créée", "2020-04-05 18:17:26", "2020-04-05 20:17:26");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("294", "105", "action créée", "2020-04-05 18:17:26", "2020-04-05 20:17:26");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("295", "104", "action lancée via WP Cron", "2020-04-05 18:18:15", "2020-04-05 20:18:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("296", "104", "action terminée via WP Cron", "2020-04-05 18:18:15", "2020-04-05 20:18:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("297", "105", "action lancée via WP Cron", "2020-04-05 18:18:15", "2020-04-05 20:18:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("298", "105", "action terminée via WP Cron", "2020-04-05 18:18:15", "2020-04-05 20:18:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("299", "106", "action créée", "2020-04-05 20:45:55", "2020-04-05 22:45:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("300", "107", "action créée", "2020-04-05 20:45:55", "2020-04-05 22:45:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("301", "106", "action lancée via Async Request", "2020-04-05 20:46:42", "2020-04-05 22:46:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("302", "106", "action terminée via Async Request", "2020-04-05 20:46:42", "2020-04-05 22:46:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("303", "107", "action lancée via Async Request", "2020-04-05 20:46:42", "2020-04-05 22:46:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("304", "107", "action terminée via Async Request", "2020-04-05 20:46:42", "2020-04-05 22:46:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("305", "108", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("306", "109", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("307", "110", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("308", "111", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("309", "112", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("310", "113", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("311", "114", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("312", "115", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("313", "116", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("314", "117", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("315", "118", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("316", "119", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("317", "120", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("318", "121", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("319", "122", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("320", "123", "action créée", "2020-04-05 21:15:24", "2020-04-05 23:15:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("321", "124", "action créée", "2020-04-05 21:15:25", "2020-04-05 23:15:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("322", "125", "action créée", "2020-04-05 21:15:25", "2020-04-05 23:15:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("323", "126", "action créée", "2020-04-05 21:15:25", "2020-04-05 23:15:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("324", "127", "action créée", "2020-04-05 21:15:25", "2020-04-05 23:15:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("325", "128", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("326", "129", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("327", "130", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("328", "131", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("329", "132", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("330", "133", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("331", "134", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("332", "135", "action créée", "2020-04-05 21:15:40", "2020-04-05 23:15:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("333", "136", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("334", "137", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("335", "138", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("336", "139", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("337", "140", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("338", "141", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("339", "142", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("340", "143", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("341", "144", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("342", "145", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("343", "146", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("344", "147", "action créée", "2020-04-05 21:15:41", "2020-04-05 23:15:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("345", "148", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("346", "149", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("347", "150", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("348", "151", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("349", "152", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("350", "153", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("351", "154", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("352", "155", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("353", "156", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("354", "157", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("355", "158", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("356", "159", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("357", "160", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("358", "161", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("359", "162", "action créée", "2020-04-05 21:15:52", "2020-04-05 23:15:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("360", "108", "action lancée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("361", "108", "action terminée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("362", "109", "action lancée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("363", "109", "action terminée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("364", "110", "action lancée via Async Request", "2020-04-05 21:15:55", "2020-04-05 23:15:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("365", "110", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("366", "111", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("367", "111", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("368", "112", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("369", "112", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("370", "113", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("371", "113", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("372", "114", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("373", "114", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("374", "115", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("375", "115", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("376", "116", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("377", "116", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("378", "117", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("379", "117", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("380", "118", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("381", "118", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("382", "119", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("383", "119", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("384", "120", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("385", "120", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("386", "121", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("387", "121", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("388", "122", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("389", "122", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("390", "123", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("391", "123", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("392", "124", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("393", "124", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("394", "125", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("395", "125", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("396", "126", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("397", "126", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("398", "127", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("399", "127", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("400", "128", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("401", "128", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("402", "129", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("403", "129", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("404", "130", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("405", "130", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("406", "131", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("407", "131", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("408", "132", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("409", "132", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("410", "133", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("411", "133", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("412", "134", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("413", "134", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("414", "135", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("415", "135", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("416", "136", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("417", "136", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("418", "137", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("419", "137", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("420", "138", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("421", "138", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("422", "139", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("423", "139", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("424", "140", "action lancée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("425", "140", "action terminée via Async Request", "2020-04-05 21:15:56", "2020-04-05 23:15:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("426", "141", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("427", "141", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("428", "142", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("429", "142", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("430", "143", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("431", "143", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("432", "144", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("433", "144", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("434", "145", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("435", "145", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("436", "146", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("437", "146", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("438", "147", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("439", "147", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("440", "148", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("441", "148", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("442", "149", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("443", "149", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("444", "150", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("445", "150", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("446", "151", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("447", "151", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("448", "152", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("449", "152", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("450", "153", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("451", "153", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("452", "154", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("453", "154", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("454", "155", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("455", "155", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("456", "156", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("457", "156", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("458", "157", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("459", "157", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("460", "158", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("461", "158", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("462", "159", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("463", "159", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("464", "160", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("465", "160", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("466", "161", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("467", "161", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("468", "162", "action lancée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("469", "162", "action terminée via Async Request", "2020-04-05 21:15:57", "2020-04-05 23:15:57");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("470", "103", "action lancée via WP Cron", "2020-04-06 12:54:31", "2020-04-06 14:54:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("471", "103", "action terminée via WP Cron", "2020-04-06 12:54:31", "2020-04-06 14:54:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("472", "163", "action créée", "2020-04-06 12:54:31", "2020-04-06 14:54:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("473", "164", "action créée", "2020-04-06 17:02:33", "2020-04-06 19:02:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("474", "165", "action créée", "2020-04-06 17:02:33", "2020-04-06 19:02:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("475", "164", "action lancée via WP Cron", "2020-04-06 17:03:47", "2020-04-06 19:03:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("476", "164", "action terminée via WP Cron", "2020-04-06 17:03:47", "2020-04-06 19:03:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("477", "165", "action lancée via WP Cron", "2020-04-06 17:03:47", "2020-04-06 19:03:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("478", "165", "action terminée via WP Cron", "2020-04-06 17:03:47", "2020-04-06 19:03:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("479", "166", "action créée", "2020-04-06 17:06:05", "2020-04-06 19:06:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("480", "167", "action créée", "2020-04-06 17:06:05", "2020-04-06 19:06:05");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("481", "166", "action lancée via Async Request", "2020-04-06 17:06:16", "2020-04-06 19:06:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("482", "166", "action terminée via Async Request", "2020-04-06 17:06:16", "2020-04-06 19:06:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("483", "167", "action lancée via Async Request", "2020-04-06 17:06:16", "2020-04-06 19:06:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("484", "167", "action terminée via Async Request", "2020-04-06 17:06:16", "2020-04-06 19:06:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("485", "168", "action créée", "2020-04-06 17:22:12", "2020-04-06 19:22:12");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("486", "169", "action créée", "2020-04-06 17:22:13", "2020-04-06 19:22:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("487", "168", "action lancée via WP Cron", "2020-04-06 17:23:33", "2020-04-06 19:23:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("488", "168", "action terminée via WP Cron", "2020-04-06 17:23:33", "2020-04-06 19:23:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("489", "169", "action lancée via WP Cron", "2020-04-06 17:23:33", "2020-04-06 19:23:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("490", "169", "action terminée via WP Cron", "2020-04-06 17:23:33", "2020-04-06 19:23:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("491", "170", "action créée", "2020-04-06 17:42:04", "2020-04-06 19:42:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("492", "171", "action créée", "2020-04-06 17:42:04", "2020-04-06 19:42:04");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("493", "170", "action lancée via WP Cron", "2020-04-06 17:42:09", "2020-04-06 19:42:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("494", "170", "action terminée via WP Cron", "2020-04-06 17:42:09", "2020-04-06 19:42:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("495", "171", "action lancée via WP Cron", "2020-04-06 17:42:09", "2020-04-06 19:42:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("496", "171", "action terminée via WP Cron", "2020-04-06 17:42:09", "2020-04-06 19:42:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("497", "172", "action créée", "2020-04-06 17:48:06", "2020-04-06 19:48:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("498", "173", "action créée", "2020-04-06 17:48:06", "2020-04-06 19:48:06");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("499", "172", "action lancée via WP Cron", "2020-04-06 17:48:22", "2020-04-06 19:48:22");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("500", "172", "action terminée via WP Cron", "2020-04-06 17:48:22", "2020-04-06 19:48:22");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("501", "173", "action lancée via WP Cron", "2020-04-06 17:48:22", "2020-04-06 19:48:22");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("502", "173", "action terminée via WP Cron", "2020-04-06 17:48:22", "2020-04-06 19:48:22");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("503", "174", "action créée", "2020-04-06 17:49:59", "2020-04-06 19:49:59");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("504", "175", "action créée", "2020-04-06 17:50:00", "2020-04-06 19:50:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("505", "174", "action lancée via WP Cron", "2020-04-06 17:50:23", "2020-04-06 19:50:23");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("506", "174", "action terminée via WP Cron", "2020-04-06 17:50:23", "2020-04-06 19:50:23");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("507", "175", "action lancée via WP Cron", "2020-04-06 17:50:23", "2020-04-06 19:50:23");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("508", "175", "action terminée via WP Cron", "2020-04-06 17:50:23", "2020-04-06 19:50:23");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("509", "176", "action créée", "2020-04-06 17:55:17", "2020-04-06 19:55:17");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("510", "177", "action créée", "2020-04-06 17:55:17", "2020-04-06 19:55:17");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("511", "176", "action lancée via WP Cron", "2020-04-06 17:56:41", "2020-04-06 19:56:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("512", "176", "action terminée via WP Cron", "2020-04-06 17:56:41", "2020-04-06 19:56:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("513", "177", "action lancée via WP Cron", "2020-04-06 17:56:41", "2020-04-06 19:56:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("514", "177", "action terminée via WP Cron", "2020-04-06 17:56:41", "2020-04-06 19:56:41");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("515", "178", "action créée", "2020-04-06 17:59:59", "2020-04-06 19:59:59");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("516", "179", "action créée", "2020-04-06 17:59:59", "2020-04-06 19:59:59");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("517", "178", "action lancée via Async Request", "2020-04-06 18:00:47", "2020-04-06 20:00:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("518", "178", "action terminée via Async Request", "2020-04-06 18:00:47", "2020-04-06 20:00:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("519", "179", "action lancée via Async Request", "2020-04-06 18:00:47", "2020-04-06 20:00:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("520", "179", "action terminée via Async Request", "2020-04-06 18:00:47", "2020-04-06 20:00:47");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("521", "180", "action créée", "2020-04-06 18:02:24", "2020-04-06 20:02:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("522", "181", "action créée", "2020-04-06 18:02:24", "2020-04-06 20:02:24");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("523", "180", "action lancée via Async Request", "2020-04-06 18:03:09", "2020-04-06 20:03:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("524", "180", "action terminée via Async Request", "2020-04-06 18:03:09", "2020-04-06 20:03:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("525", "181", "action lancée via Async Request", "2020-04-06 18:03:09", "2020-04-06 20:03:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("526", "181", "action terminée via Async Request", "2020-04-06 18:03:09", "2020-04-06 20:03:09");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("527", "182", "action créée", "2020-04-06 18:04:56", "2020-04-06 20:04:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("528", "183", "action créée", "2020-04-06 18:04:56", "2020-04-06 20:04:56");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("529", "182", "action lancée via WP Cron", "2020-04-06 18:05:30", "2020-04-06 20:05:30");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("530", "182", "action terminée via WP Cron", "2020-04-06 18:05:30", "2020-04-06 20:05:30");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("531", "183", "action lancée via WP Cron", "2020-04-06 18:05:30", "2020-04-06 20:05:30");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("532", "183", "action terminée via WP Cron", "2020-04-06 18:05:30", "2020-04-06 20:05:30");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("533", "184", "action créée", "2020-04-06 18:08:21", "2020-04-06 20:08:21");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("534", "185", "action créée", "2020-04-06 18:08:21", "2020-04-06 20:08:21");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("535", "184", "action lancée via WP Cron", "2020-04-06 18:10:15", "2020-04-06 20:10:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("536", "184", "action terminée via WP Cron", "2020-04-06 18:10:15", "2020-04-06 20:10:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("537", "185", "action lancée via WP Cron", "2020-04-06 18:10:15", "2020-04-06 20:10:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("538", "185", "action terminée via WP Cron", "2020-04-06 18:10:15", "2020-04-06 20:10:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("539", "186", "action créée", "2020-04-06 19:32:07", "2020-04-06 21:32:07");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("540", "186", "action lancée via Async Request", "2020-04-06 19:32:34", "2020-04-06 21:32:34");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("541", "186", "action terminée via Async Request", "2020-04-06 19:32:34", "2020-04-06 21:32:34");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("542", "187", "action créée", "2020-04-07 11:08:00", "2020-04-07 13:08:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("543", "188", "action créée", "2020-04-07 11:08:00", "2020-04-07 13:08:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("544", "189", "action créée", "2020-04-07 11:08:00", "2020-04-07 13:08:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("545", "190", "action créée", "2020-04-07 11:08:00", "2020-04-07 13:08:00");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("546", "191", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("547", "192", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("548", "193", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("549", "194", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("550", "195", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("551", "196", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("552", "197", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("553", "198", "action créée", "2020-04-07 11:08:01", "2020-04-07 13:08:01");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("554", "199", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("555", "200", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("556", "201", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("557", "202", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("558", "203", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("559", "204", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("560", "205", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("561", "187", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("562", "187", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("563", "188", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("564", "188", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("565", "206", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("566", "189", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("567", "189", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("568", "190", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("569", "190", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("570", "191", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("571", "191", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("572", "207", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("573", "192", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("574", "192", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("575", "193", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("576", "193", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("577", "194", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("578", "194", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("579", "195", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("580", "208", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("581", "195", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("582", "196", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("583", "196", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("584", "197", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("585", "197", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("586", "198", "action lancée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("587", "209", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("588", "198", "action terminée via WP Cron", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("589", "210", "action créée", "2020-04-07 11:08:15", "2020-04-07 13:08:15");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("590", "211", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("591", "212", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("592", "213", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("593", "214", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("594", "215", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("595", "216", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("596", "217", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("597", "218", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("598", "219", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("599", "220", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("600", "221", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("601", "222", "action créée", "2020-04-07 11:08:31", "2020-04-07 13:08:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("602", "199", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("603", "199", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("604", "200", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("605", "200", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("606", "201", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("607", "201", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("608", "202", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("609", "202", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("610", "203", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("611", "203", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("612", "204", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("613", "204", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("614", "205", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("615", "205", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("616", "206", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("617", "206", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("618", "207", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("619", "207", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("620", "208", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("621", "208", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("622", "209", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("623", "209", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("624", "210", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("625", "210", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("626", "211", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("627", "211", "action terminée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("628", "212", "action lancée via Async Request", "2020-04-07 11:08:50", "2020-04-07 13:08:50");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("629", "212", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("630", "213", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("631", "213", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("632", "214", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("633", "214", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("634", "215", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("635", "215", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("636", "216", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("637", "216", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("638", "217", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("639", "217", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("640", "218", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("641", "218", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("642", "219", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("643", "219", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("644", "220", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("645", "220", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("646", "221", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("647", "221", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("648", "222", "action lancée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("649", "222", "action terminée via Async Request", "2020-04-07 11:08:51", "2020-04-07 13:08:51");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("650", "223", "action créée", "2020-04-07 11:28:25", "2020-04-07 13:28:25");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("651", "223", "action lancée via Async Request", "2020-04-07 11:28:33", "2020-04-07 13:28:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("652", "223", "action terminée via Async Request", "2020-04-07 11:28:33", "2020-04-07 13:28:33");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("653", "224", "action créée", "2020-04-07 11:28:40", "2020-04-07 13:28:40");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("654", "224", "action lancée via WP Cron", "2020-04-07 11:29:11", "2020-04-07 13:29:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("655", "224", "action terminée via WP Cron", "2020-04-07 11:29:11", "2020-04-07 13:29:11");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("656", "225", "action created", "2020-04-07 11:52:16", "2020-04-07 13:52:16");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("657", "225", "action started via Async Request", "2020-04-07 11:53:03", "2020-04-07 13:53:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("658", "225", "action complete via Async Request", "2020-04-07 11:53:03", "2020-04-07 13:53:03");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("659", "226", "action créée", "2020-04-07 12:00:28", "2020-04-07 14:00:28");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("660", "226", "action lancée via WP Cron", "2020-04-07 12:01:20", "2020-04-07 14:01:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("661", "226", "action terminée via WP Cron", "2020-04-07 12:01:20", "2020-04-07 14:01:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("662", "227", "action créée", "2020-04-07 12:01:34", "2020-04-07 14:01:34");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("663", "227", "action lancée via WP Cron", "2020-04-07 12:02:13", "2020-04-07 14:02:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("664", "227", "action terminée via WP Cron", "2020-04-07 12:02:13", "2020-04-07 14:02:13");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("665", "228", "action créée", "2020-04-07 12:02:14", "2020-04-07 14:02:14");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("666", "228", "action lancée via Async Request", "2020-04-07 12:02:31", "2020-04-07 14:02:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("667", "228", "action terminée via Async Request", "2020-04-07 12:02:31", "2020-04-07 14:02:31");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("668", "163", "action lancée via WP Cron", "2020-04-07 14:29:20", "2020-04-07 16:29:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("669", "163", "action terminée via WP Cron", "2020-04-07 14:29:20", "2020-04-07 16:29:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("670", "229", "action créée", "2020-04-07 14:29:20", "2020-04-07 16:29:20");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("671", "229", "action lancée via WP Cron", "2020-04-11 16:03:52", "2020-04-11 18:03:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("672", "229", "action terminée via WP Cron", "2020-04-11 16:03:52", "2020-04-11 18:03:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("673", "230", "action créée", "2020-04-11 16:03:52", "2020-04-11 18:03:52");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("674", "231", "action créée", "2020-04-11 16:04:55", "2020-04-11 18:04:55");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("675", "231", "action lancée via WP Cron", "2020-04-11 16:05:08", "2020-04-11 18:05:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("676", "231", "action terminée via WP Cron", "2020-04-11 16:05:08", "2020-04-11 18:05:08");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("677", "230", "action lancée via WP Cron", "2020-04-12 20:27:53", "2020-04-12 22:27:53");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("678", "230", "action terminée via WP Cron", "2020-04-12 20:27:53", "2020-04-12 22:27:53");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("679", "232", "action créée", "2020-04-12 20:27:53", "2020-04-12 22:27:53");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("680", "232", "action lancée via Async Request", "2020-04-14 21:41:42", "2020-04-14 23:41:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("681", "232", "action terminée via Async Request", "2020-04-14 21:41:42", "2020-04-14 23:41:42");
INSERT INTO `wp_oneactionscheduler_logs` VALUES("682", "233", "action créée", "2020-04-14 21:41:42", "2020-04-14 23:41:42");

/* INSERT TABLE DATA: wp_oneduplicator_packages */
INSERT INTO `wp_oneduplicator_packages` VALUES("3", "MyLocalShopCoreV101", "956c62809a0d157d8389_20200407120452", "100", "2020-04-07 12:05:17", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-07 12:04:52\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:3:\"5.4\";s:9:\"VersionDB\";s:6:\"5.6.46\";s:10:\"VersionPHP\";s:6:\"7.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:19:\"MyLocalShopCoreV101\";s:4:\"Hash\";s:35:\"956c62809a0d157d8389_20200407120452\";s:8:\"NameHash\";s:55:\"MyLocalShopCoreV101_956c62809a0d157d8389_20200407120452\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/mylocalslb/demo/core/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://core.mylocalshop.fr/wp-snapshots/\";s:8:\"ScanFile\";s:65:\"MyLocalShopCoreV101_956c62809a0d157d8389_20200407120452_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"21.53 sec.\";s:7:\"ExeSize\";s:7:\"60.53KB\";s:7:\"ZipSize\";s:7:\"44.84MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:67:\"MyLocalShopCoreV101_956c62809a0d157d8389_20200407120452_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/mylocalslb/demo/core\";s:4:\"Size\";i:47013378;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:8037;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/mylocalslb/demo/core/wp-admin\";i:1;s:45:\"/home/mylocalslb/demo/core/wp-content/uploads\";i:2;s:47:\"/home/mylocalslb/demo/core/wp-content/languages\";i:3;s:44:\"/home/mylocalslb/demo/core/wp-content/themes\";i:4;s:38:\"/home/mylocalslb/demo/core/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/mylocalslb/demo/core\";i:1;s:37:\"/home/mylocalslb/demo/core/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:38:\"/home/mylocalslb/demo/core/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:69:\"MyLocalShopCoreV101_956c62809a0d157d8389_20200407120452_installer.php\";s:4:\"Size\";i:61981;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4589370;s:4:\"File\";s:68:\"MyLocalShopCoreV101_956c62809a0d157d8389_20200407120452_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:2:{i:0;s:22:\"utf8mb4_unicode_520_ci\";i:1;s:17:\"latin1_swedish_ci\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:14:\"mylocalslbcore\";s:15:\"tablesBaseCount\";i:49;s:16:\"tablesFinalCount\";i:49;s:14:\"tablesRowCount\";s:6:\"41,561\";s:16:\"tablesSizeOnDisk\";s:6:\"7.66MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.6.46\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:49:{s:29:\"wp_oneactionscheduler_actions\";s:3:\"223\";s:28:\"wp_oneactionscheduler_claims\";s:1:\"0\";s:28:\"wp_oneactionscheduler_groups\";s:1:\"3\";s:26:\"wp_oneactionscheduler_logs\";s:3:\"667\";s:24:\"wp_onecleantalk_sessions\";s:2:\"48\";s:19:\"wp_onecleantalk_sfw\";s:5:\"40468\";s:24:\"wp_onecleantalk_sfw_logs\";s:1:\"0\";s:17:\"wp_onecommentmeta\";s:1:\"0\";s:14:\"wp_onecomments\";s:1:\"0\";s:25:\"wp_oneduplicator_packages\";s:1:\"1\";s:11:\"wp_onelinks\";s:1:\"0\";s:13:\"wp_oneoptions\";s:3:\"404\";s:14:\"wp_onepostmeta\";s:3:\"554\";s:11:\"wp_oneposts\";s:2:\"36\";s:24:\"wp_oneterm_relationships\";s:2:\"38\";s:19:\"wp_oneterm_taxonomy\";s:2:\"36\";s:14:\"wp_onetermmeta\";s:2:\"20\";s:11:\"wp_oneterms\";s:2:\"36\";s:17:\"wp_onetm_taskmeta\";s:1:\"0\";s:14:\"wp_onetm_tasks\";s:1:\"0\";s:14:\"wp_oneusermeta\";s:2:\"18\";s:11:\"wp_oneusers\";s:1:\"1\";s:27:\"wp_onewc_admin_note_actions\";s:1:\"9\";s:20:\"wp_onewc_admin_notes\";s:1:\"8\";s:24:\"wp_onewc_category_lookup\";s:1:\"0\";s:24:\"wp_onewc_customer_lookup\";s:1:\"0\";s:21:\"wp_onewc_download_log\";s:1:\"0\";s:28:\"wp_onewc_order_coupon_lookup\";s:1:\"0\";s:29:\"wp_onewc_order_product_lookup\";s:1:\"0\";s:20:\"wp_onewc_order_stats\";s:1:\"0\";s:25:\"wp_onewc_order_tax_lookup\";s:1:\"0\";s:28:\"wp_onewc_product_meta_lookup\";s:1:\"7\";s:25:\"wp_onewc_tax_rate_classes\";s:1:\"2\";s:17:\"wp_onewc_webhooks\";s:1:\"0\";s:26:\"wp_onewoocommerce_api_keys\";s:1:\"0\";s:38:\"wp_onewoocommerce_attribute_taxonomies\";s:1:\"0\";s:50:\"wp_onewoocommerce_downloadable_product_permissions\";s:1:\"0\";s:21:\"wp_onewoocommerce_log\";s:1:\"0\";s:32:\"wp_onewoocommerce_order_itemmeta\";s:1:\"0\";s:29:\"wp_onewoocommerce_order_items\";s:1:\"0\";s:35:\"wp_onewoocommerce_payment_tokenmeta\";s:1:\"0\";s:32:\"wp_onewoocommerce_payment_tokens\";s:1:\"0\";s:26:\"wp_onewoocommerce_sessions\";s:1:\"3\";s:41:\"wp_onewoocommerce_shipping_zone_locations\";s:1:\"0\";s:39:\"wp_onewoocommerce_shipping_zone_methods\";s:1:\"0\";s:32:\"wp_onewoocommerce_shipping_zones\";s:1:\"0\";s:36:\"wp_onewoocommerce_tax_rate_locations\";s:1:\"0\";s:27:\"wp_onewoocommerce_tax_rates\";s:1:\"3\";s:24:\"wp_onewpforms_tasks_meta\";s:1:\"1\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:112:\"/home/mylocalslb/demo/core/wp-snapshots/tmp/MyLocalShopCoreV101_956c62809a0d157d8389_20200407120452_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-07 12:04:52\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:3:\"5.4\";s:9:\"VersionDB\";s:6:\"5.6.46\";s:10:\"VersionPHP\";s:6:\"7.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"MyLocalShopCoreV101\";s:4:\"Hash\";s:35:\"956c62809a0d157d8389_20200407120452\";s:8:\"NameHash\";s:55:\"MyLocalShopCoreV101_956c62809a0d157d8389_20200407120452\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/mylocalslb/demo/core/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://core.mylocalshop.fr/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:170;}}}");
INSERT INTO `wp_oneduplicator_packages` VALUES("5", "MyLocalShopCoreV102", "8c6abc529e2508c65569_20200414214334", "21", "2020-04-14 21:44:00", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-14 21:43:34\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:3:\"5.4\";s:9:\"VersionDB\";s:6:\"5.6.46\";s:10:\"VersionPHP\";s:6:\"7.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:19:\"MyLocalShopCoreV102\";s:4:\"Hash\";s:35:\"8c6abc529e2508c65569_20200414214334\";s:8:\"NameHash\";s:55:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/mylocalslb/demo/core/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://core.mylocalshop.fr/wp-snapshots/\";s:8:\"ScanFile\";s:65:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.3\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:67:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/mylocalslb/demo/core\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-14 21:43:34\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:3:\"5.4\";s:9:\"VersionDB\";s:6:\"5.6.46\";s:10:\"VersionPHP\";s:6:\"7.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"MyLocalShopCoreV102\";s:4:\"Hash\";s:35:\"8c6abc529e2508c65569_20200414214334\";s:8:\"NameHash\";s:55:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/mylocalslb/demo/core/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://core.mylocalshop.fr/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:69:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:68:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:5:{s:29:\"wp_oneactionscheduler_actions\";s:3:\"228\";s:28:\"wp_oneactionscheduler_claims\";s:1:\"0\";s:28:\"wp_oneactionscheduler_groups\";s:1:\"3\";s:26:\"wp_oneactionscheduler_logs\";s:3:\"682\";s:17:\"wp_onecommentmeta\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:112:\"/home/mylocalslb/demo/core/wp-snapshots/tmp/MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/mylocalslb/demo/core/wp-admin\";i:1;s:45:\"/home/mylocalslb/demo/core/wp-content/uploads\";i:2;s:47:\"/home/mylocalslb/demo/core/wp-content/languages\";i:3;s:44:\"/home/mylocalslb/demo/core/wp-content/themes\";i:4;s:38:\"/home/mylocalslb/demo/core/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/mylocalslb/demo/core\";i:1;s:37:\"/home/mylocalslb/demo/core/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:134;}");

/* INSERT TABLE DATA: wp_oneoptions */
INSERT INTO `wp_oneoptions` VALUES("1", "siteurl", "http://core.mylocalshop.fr", "yes");
INSERT INTO `wp_oneoptions` VALUES("2", "home", "http://core.mylocalshop.fr", "yes");
INSERT INTO `wp_oneoptions` VALUES("3", "blogname", "MyLocalShop", "yes");
INSERT INTO `wp_oneoptions` VALUES("4", "blogdescription", "Solution gratuite mise à la disposition des commerçants", "yes");
INSERT INTO `wp_oneoptions` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("6", "admin_email", "changeyouremail@mylocalshop.fr", "yes");
INSERT INTO `wp_oneoptions` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_oneoptions` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_oneoptions` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_oneoptions` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_oneoptions` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_oneoptions` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_oneoptions` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_oneoptions` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("22", "posts_per_page", "6", "yes");
INSERT INTO `wp_oneoptions` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_oneoptions` VALUES("24", "time_format", "G \\h i \\m\\i\\n", "yes");
INSERT INTO `wp_oneoptions` VALUES("25", "links_updated_date_format", "j F Y G \\h i \\m\\i\\n", "yes");
INSERT INTO `wp_oneoptions` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_oneoptions` VALUES("29", "rewrite_rules", "a:164:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"wpforms_log_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wpforms_log_type=$matches[1]&feed=$matches[2]\";s:52:\"wpforms_log_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wpforms_log_type=$matches[1]&feed=$matches[2]\";s:33:\"wpforms_log_type/([^/]+)/embed/?$\";s:49:\"index.php?wpforms_log_type=$matches[1]&embed=true\";s:45:\"wpforms_log_type/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?wpforms_log_type=$matches[1]&paged=$matches[2]\";s:27:\"wpforms_log_type/([^/]+)/?$\";s:38:\"index.php?wpforms_log_type=$matches[1]\";s:56:\"categorie-produit/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:51:\"categorie-produit/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:32:\"categorie-produit/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:44:\"categorie-produit/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:26:\"categorie-produit/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:58:\"etiquette-produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:53:\"etiquette-produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:34:\"etiquette-produit/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:46:\"etiquette-produit/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:28:\"etiquette-produit/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"produit/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"produit/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"produit/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"produit/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"produit/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"produit/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"produit/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"produit/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"produit/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"produit/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"produit/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"produit/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"produit/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"produit/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"produit/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"produit/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"produit/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"produit/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"produit/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"produit/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=7&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_oneoptions` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_oneoptions` VALUES("33", "active_plugins", "a:9:{i:0;s:32:\"blackhole-bad-bots/blackhole.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:28:\"fast-velocity-minify/fvm.php\";i:4;s:45:\"ocean-custom-sidebar/ocean-custom-sidebar.php\";i:5;s:27:\"ocean-extra/ocean-extra.php\";i:6;s:47:\"ocean-product-sharing/ocean-product-sharing.php\";i:7;s:27:\"woocommerce/woocommerce.php\";i:8;s:24:\"wpforms-lite/wpforms.php\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_oneoptions` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_oneoptions` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_oneoptions` VALUES("40", "template", "oceanwp", "yes");
INSERT INTO `wp_oneoptions` VALUES("41", "stylesheet", "oceanwp", "yes");
INSERT INTO `wp_oneoptions` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_oneoptions` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_oneoptions` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_oneoptions` VALUES("48", "db_version", "47018", "yes");
INSERT INTO `wp_oneoptions` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_oneoptions` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_oneoptions` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_oneoptions` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_oneoptions` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_oneoptions` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_oneoptions` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_oneoptions` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_oneoptions` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_oneoptions` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_oneoptions` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_oneoptions` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_oneoptions` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_oneoptions` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_oneoptions` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_oneoptions` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_oneoptions` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("79", "widget_text", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("81", "uninstall_plugins", "a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";s:28:\"fast-velocity-minify/fvm.php\";s:29:\"fastvelocity_plugin_uninstall\";}", "no");
INSERT INTO `wp_oneoptions` VALUES("82", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `wp_oneoptions` VALUES("83", "page_for_posts", "31", "yes");
INSERT INTO `wp_oneoptions` VALUES("84", "page_on_front", "7", "yes");
INSERT INTO `wp_oneoptions` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_oneoptions` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_oneoptions` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("93", "admin_email_lifespan", "1601512829", "yes");
INSERT INTO `wp_oneoptions` VALUES("94", "initial_db_version", "47018", "yes");
INSERT INTO `wp_oneoptions` VALUES("95", "wp_oneuser_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:114:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("96", "fresh_site", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("97", "WPLANG", "fr_FR", "yes");
INSERT INTO `wp_oneoptions` VALUES("98", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("99", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("100", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("101", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("102", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("103", "sidebars_widgets", "a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:20:\"ocean_social_share-1\";i:4;s:17:\"ocean_mailchimp-1\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:10:\"footer-one\";a:1:{i:0;s:20:\"ocean_contact_info-1\";}s:10:\"footer-two\";a:1:{i:0;s:32:\"woocommerce_product_categories-2\";}s:12:\"footer-three\";a:1:{i:0;s:14:\"ocean_social-1\";}s:11:\"footer-four\";a:1:{i:0;s:13:\"custom_html-2\";}s:11:\"woo_sidebar\";a:4:{i:0;s:32:\"woocommerce_product_categories-1\";i:1;s:28:\"woocommerce_product_search-2\";i:2;s:25:\"woocommerce_widget_cart-2\";i:3;s:38:\"woocommerce_recently_viewed_products-2\";}s:12:\"ocs-men-menu\";a:1:{i:0;s:6:\"text-1\";}s:14:\"ocs-women-menu\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("104", "cron", "a:21:{i:1586900655;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1586901600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586902044;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1586902052;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1586904030;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1586904140;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1586911230;a:4:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586911244;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586911245;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586911739;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586912847;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586915862;a:1:{s:21:\"wpo_plugin_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1586930011;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1586951621;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586951862;a:1:{s:29:\"wpo_smush_clear_backup_images\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586962411;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1586966756;a:1:{s:33:\"fastvelocity_purge_old_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1587256830;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1587384000;a:1:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"wpforms_email_summaries_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1587556471;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("107", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("108", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("109", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("110", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("111", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("112", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("113", "widget_custom_html", "a:2:{i:2;a:2:{s:5:\"title\";s:11:\"MyLocalShop\";s:7:\"content\";s:229:\"<p>\r\n	Cette boutique a été créée à partir de la solution gratuite et open-source <b>MyLocalShop</b>. 	\r\n</p>\r\n<p>\r\n	<a href=\"https://mylocalshop.fr\">Vous souhaitez en savoir plus sur la solution <b>MyLocalShop</b>?</a>\r\n</p>\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("115", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1585961322;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("116", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("131", "can_compress_scripts", "0", "no");
INSERT INTO `wp_oneoptions` VALUES("144", "recently_activated", "a:1:{s:36:\"cleantalk-spam-protect/cleantalk.php\";i:1586621094;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("155", "current_theme", "OceanWP", "yes");
INSERT INTO `wp_oneoptions` VALUES("156", "theme_mods_oceanwp", "a:98:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:9:\"main_menu\";i:58;s:11:\"topbar_menu\";i:59;s:11:\"footer_menu\";i:57;}s:18:\"custom_css_post_id\";i:443;s:19:\"ocean_primary_color\";s:7:\"#3c94c4\";s:25:\"ocean_hover_primary_color\";s:7:\"#0094ce\";s:27:\"ocean_search_custom_sidebar\";b:0;s:28:\"ocean_page_header_background\";s:7:\"#322b2b\";s:29:\"ocean_page_header_title_color\";s:7:\"#ffffff\";s:28:\"ocean_breadcrumbs_text_color\";s:7:\"#efefef\";s:33:\"ocean_breadcrumbs_seperator_color\";s:7:\"#efefef\";s:28:\"ocean_breadcrumbs_link_color\";s:7:\"#ffffff\";s:34:\"ocean_breadcrumbs_link_color_hover\";s:7:\"#fe5252\";s:15:\"ocean_onsale_bg\";s:7:\"#3fc387\";s:22:\"ocean_scroll_top_arrow\";s:21:\"fa fa-angle-double-up\";s:25:\"ocean_scroll_top_bg_hover\";s:7:\"#fe5252\";s:19:\"ocean_input_padding\";s:9:\"11px 15px\";s:24:\"ocean_input_border_color\";s:7:\"#ececec\";s:30:\"ocean_input_border_color_focus\";s:7:\"#dddddd\";s:17:\"ocean_input_color\";s:7:\"#666666\";s:15:\"body_typography\";a:1:{s:11:\"font-family\";s:4:\"Lato\";}s:15:\"menu_typography\";a:4:{s:11:\"font-weight\";s:3:\"600\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"12\";s:14:\"letter-spacing\";s:1:\"1\";}s:25:\"ocean_top_bar_top_padding\";s:2:\"16\";s:28:\"ocean_top_bar_bottom_padding\";s:2:\"16\";s:24:\"ocean_top_bar_link_color\";s:7:\"#888888\";s:30:\"ocean_top_bar_link_color_hover\";s:7:\"#333333\";s:19:\"top_menu_typography\";a:2:{s:9:\"font-size\";s:2:\"13\";s:14:\"letter-spacing\";s:3:\"0.6\";}s:19:\"ocean_top_bar_style\";s:3:\"two\";s:21:\"ocean_top_bar_content\";s:0:\"\";s:27:\"ocean_top_bar_social_target\";s:4:\"self\";s:29:\"ocean_top_bar_social_profiles\";a:9:{s:7:\"twitter\";s:1:\"#\";s:8:\"facebook\";s:1:\"#\";s:10:\"googleplus\";s:1:\"#\";s:9:\"pinterest\";s:1:\"#\";s:8:\"dribbble\";s:1:\"#\";s:9:\"instagram\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";s:4:\"vine\";s:1:\"#\";s:3:\"rss\";s:1:\"#\";}s:19:\"ocean_header_height\";s:2:\"90\";s:20:\"ocean_footer_padding\";s:13:\"60px 0 60px 0\";s:23:\"ocean_footer_background\";s:7:\"#322b2b\";s:27:\"ocean_bottom_footer_padding\";s:13:\"30px 0 30px 0\";s:30:\"ocean_bottom_footer_background\";s:7:\"#221d1d\";s:27:\"ocean_footer_copyright_text\";s:36:\"© Copyright - OceanWP Theme by Nick\";s:24:\"menu_dropdown_typography\";a:2:{s:9:\"font-size\";s:2:\"13\";s:11:\"line-height\";s:3:\"1.8\";}s:16:\"ofc_callout_text\";s:0:\"\";s:18:\"ofc_callout_button\";b:0;s:14:\"ofc_callout_bg\";s:7:\"#221d1d\";s:18:\"ofc_callout_border\";s:7:\"#221d1d\";s:24:\"osh_shrink_header_height\";s:2:\"80\";s:30:\"ocean_scroll_top_border_radius\";s:2:\"40\";s:17:\"ocean_retina_logo\";s:0:\"\";s:17:\"ocean_logo_height\";s:2:\"50\";s:16:\"ocean_logo_width\";s:3:\"122\";s:26:\"ofc_callout_bottom_padding\";s:1:\"0\";s:19:\"ocean_menu_position\";s:10:\"right-menu\";s:19:\"ofc_callout_page_id\";s:0:\"\";s:24:\"ocean_blog_related_count\";s:1:\"2\";s:26:\"ocean_blog_related_columns\";s:1:\"2\";s:22:\"ocean_mobile_menu_text\";s:4:\"Menu\";s:37:\"ocean_woocommerce_tablet_shop_columns\";s:1:\"2\";s:22:\"oss_social_share_sites\";a:5:{i:0;s:7:\"twitter\";i:1;s:8:\"facebook\";i:2;s:11:\"google_plus\";i:3;s:9:\"pinterest\";i:4;s:8:\"linkedin\";}s:21:\"oss_social_share_name\";b:1;s:24:\"oss_social_share_heading\";s:0:\"\";s:22:\"oss_social_share_style\";s:7:\"colored\";s:36:\"oss_social_share_style_border_radius\";s:3:\"4px\";s:20:\"ofc_callout_template\";s:3:\"580\";s:23:\"ofc_callout_top_padding\";s:2:\"20\";s:27:\"ocean_woo_off_canvas_filter\";b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1521993202;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:6:{i:0;s:14:\"ocean_social-1\";i:1;s:14:\"ocean_flickr-1\";i:2;s:12:\"categories-3\";i:3;s:17:\"ocean_mailchimp-1\";i:4;s:20:\"ocean_recent_posts-1\";i:5;s:11:\"tag_cloud-1\";}s:9:\"sidebar-2\";a:0:{}s:10:\"footer-one\";a:1:{i:0;s:20:\"ocean_contact_info-1\";}s:10:\"footer-two\";a:1:{i:0;s:20:\"ocean_recent_posts-2\";}s:12:\"footer-three\";a:2:{i:0;s:20:\"ocean_custom_links-1\";i:1;s:20:\"ocean_custom_links-2\";}s:11:\"footer-four\";a:2:{i:0;s:31:\"woocommerce_product_tag_cloud-1\";i:1;s:14:\"ocean_social-2\";}s:11:\"woo_sidebar\";a:4:{i:0;s:26:\"woocommerce_price_filter-1\";i:1;s:14:\"ocean_social-3\";i:2;s:32:\"woocommerce_product_categories-2\";i:3;s:32:\"woocommerce_top_rated_products-1\";}s:12:\"ocs-men-menu\";a:1:{i:0;s:6:\"text-1\";}s:14:\"ocs-women-menu\";a:1:{i:0;s:6:\"text-2\";}}}s:33:\"ocean_mobile_elements_positioning\";s:3:\"two\";s:38:\"ocean_mobile_menu_display_opening_text\";b:0;s:32:\"ocean_mobile_menu_open_hamburger\";s:8:\"collapse\";s:23:\"ocean_mobile_menu_style\";s:8:\"dropdown\";s:29:\"ocean_woo_product_image_width\";s:2:\"52\";s:31:\"ocean_woo_product_summary_width\";s:2:\"44\";s:33:\"ocean_woo_product_addtocart_style\";s:6:\"normal\";s:29:\"ocean_woo_product_tabs_layout\";s:10:\"horizontal\";s:23:\"osh_sticky_header_style\";s:6:\"shrink\";s:26:\"ocean_blog_archives_layout\";s:10:\"full-width\";s:16:\"ocean_blog_style\";s:10:\"grid-entry\";s:23:\"ocean_main_border_color\";s:0:\"\";s:17:\"ocean_links_color\";s:0:\"\";s:23:\"ocean_links_color_hover\";s:0:\"\";s:18:\"ocean_header_style\";s:7:\"minimal\";s:23:\"ocean_header_full_width\";b:0;s:30:\"ocean_has_header_border_bottom\";b:1;s:13:\"ocean_top_bar\";b:0;s:30:\"ocean_menu_dropdown_top_border\";b:1;s:23:\"ocean_menu_links_effect\";s:3:\"one\";s:23:\"ocean_menu_search_style\";s:8:\"disabled\";s:23:\"ocean_header_background\";s:7:\"#f1f1f1\";s:36:\"ocean_woocommerce_display_navigation\";b:1;s:34:\"ocean_woo_product_ajax_add_to_cart\";b:1;s:36:\"ocean_woo_product_meta_tabs_position\";s:4:\"left\";s:11:\"custom_logo\";i:688;s:20:\"ocean_logo_max_width\";i:200;s:38:\"ocean_woo_floating_bar_addtocart_color\";s:7:\"#050200\";s:19:\"ocean_woo_menu_icon\";s:19:\"fa fa-shopping-cart\";s:38:\"ocean_product_entry_addtocart_bg_color\";s:7:\"#3c94c4\";s:42:\"ocean_product_entry_addtocart_border_style\";s:4:\"none\";s:35:\"ocean_product_entry_addtocart_color\";s:7:\"#ffffff\";s:48:\"ocean_product_entry_addtocart_border_color_hover\";s:18:\"rgba(19,175,240,0)\";s:44:\"ocean_product_entry_addtocart_bg_color_hover\";s:7:\"#13aff0\";s:41:\"ocean_product_entry_addtocart_color_hover\";s:7:\"#ffffff\";s:19:\"ocean_footer_bottom\";b:0;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("157", "theme_switched", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("160", "ocean-extra-version", "1.6.2", "yes");
INSERT INTO `wp_oneoptions` VALUES("162", "action_scheduler_hybrid_store_demarkation", "5", "yes");
INSERT INTO `wp_oneoptions` VALUES("163", "schema-ActionScheduler_StoreSchema", "3.0.1585961348", "yes");
INSERT INTO `wp_oneoptions` VALUES("164", "schema-ActionScheduler_LoggerSchema", "2.0.1585961348", "yes");
INSERT INTO `wp_oneoptions` VALUES("165", "wpforms_version", "1.5.9.5", "yes");
INSERT INTO `wp_oneoptions` VALUES("166", "wpforms_activated", "a:1:{s:4:\"lite\";i:1585961348;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("170", "action_scheduler_lock_async-request-runner", "1586900699", "yes");
INSERT INTO `wp_oneoptions` VALUES("171", "wpforms_version_lite", "1.5.9.5", "yes");
INSERT INTO `wp_oneoptions` VALUES("172", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:29:\"ocean-extra/includes/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:7:\"2.3.2.1\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1585961353;s:11:\"plugin_path\";s:27:\"ocean-extra/ocean-extra.php\";}}s:7:\"abspath\";s:27:\"/home/mylocalslb/demo/core/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:27:\"ocean-extra/ocean-extra.php\";s:8:\"sdk_path\";s:29:\"ocean-extra/includes/freemius\";s:7:\"version\";s:7:\"2.3.2.1\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1586260933;}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("173", "fs_debug_mode", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("174", "fs_accounts", "a:9:{s:21:\"id_slug_type_path_map\";a:5:{i:3752;a:3:{s:4:\"slug\";s:7:\"oceanwp\";s:4:\"type\";s:5:\"theme\";s:4:\"path\";s:21:\"oceanwp/functions.php\";}i:3810;a:3:{s:4:\"slug\";s:20:\"ocean-custom-sidebar\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:45:\"ocean-custom-sidebar/ocean-custom-sidebar.php\";}i:3809;a:3:{s:4:\"slug\";s:21:\"ocean-product-sharing\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:47:\"ocean-product-sharing/ocean-product-sharing.php\";}i:3807;a:3:{s:4:\"slug\";s:20:\"ocean-social-sharing\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:45:\"ocean-social-sharing/ocean-social-sharing.php\";}i:3815;a:3:{s:4:\"slug\";s:20:\"ocean-stick-anything\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:45:\"ocean-stick-anything/ocean-stick-anything.php\";}}s:10:\"theme_data\";a:1:{s:7:\"oceanwp\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"oceanwp/functions.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1585961353;s:17:\"was_plugin_loaded\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:7:\"2.3.2.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.8.2\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:18:\"one.mylocalshop.fr\";s:9:\"server_ip\";s:14:\"91.134.248.249\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1585961353;s:7:\"version\";s:5:\"1.8.2\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;s:21:\"is_pending_activation\";b:1;}}s:13:\"file_slug_map\";a:5:{s:7:\"oceanwp\";s:7:\"oceanwp\";s:45:\"ocean-custom-sidebar/ocean-custom-sidebar.php\";s:20:\"ocean-custom-sidebar\";s:47:\"ocean-product-sharing/ocean-product-sharing.php\";s:21:\"ocean-product-sharing\";s:45:\"ocean-social-sharing/ocean-social-sharing.php\";s:20:\"ocean-social-sharing\";s:45:\"ocean-stick-anything/ocean-stick-anything.php\";s:20:\"ocean-stick-anything\";}s:6:\"themes\";a:1:{s:7:\"oceanwp\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:7:\"OceanWP\";s:4:\"slug\";s:7:\"oceanwp\";s:12:\"premium_slug\";s:15:\"oceanwp-premium\";s:4:\"type\";s:5:\"theme\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:7:\"oceanwp\";s:7:\"version\";s:5:\"1.8.2\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";s:4:\"3767\";s:17:\"bundle_public_key\";s:32:\"pk_c334eb1ae413deac41e30bf00b9dc\";s:10:\"public_key\";s:32:\"pk_043077b34f20f5e11334af3c12493\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3752\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"cc7096db1a462a1fedf3eb9e76d93b4a\";s:13:\"admin_notices\";a:5:{s:13:\"oceanwp:theme\";a:0:{}s:20:\"ocean-custom-sidebar\";a:0:{}s:21:\"ocean-product-sharing\";a:0:{}s:20:\"ocean-social-sharing\";a:0:{}s:20:\"ocean-stick-anything\";a:0:{}}s:6:\"addons\";a:1:{i:3752;a:22:{i:0;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:20:\"Ocean Footer Callout\";s:4:\"slug\";s:20:\"ocean-footer-callout\";s:12:\"premium_slug\";s:20:\"ocean-footer-callout\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3754\";s:11:\"description\";s:280:\"<ul>\n<li>Display/hide the callout on any page/post</li>\n<li>Edit the content and button url on any page/post</li>\n<li>Display the page content on the callout</li>\n<li>Enable/disable the callout button</li>\n<li>Add your own padding top/bottom</li>\n<li>Add your own color</li> </ul>\";s:17:\"short_description\";s:65:\"Add some important information about your company in your footer.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/card_banner.png\";s:15:\"selling_point_0\";s:41:\"Display/hide the callout on any page/post\";s:15:\"selling_point_1\";s:48:\"Edit the content and button url on any page/post\";s:15:\"selling_point_2\";s:39:\"Display the page content on the callout\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/screenshots/2.png\";}s:2:\"id\";s:3:\"821\";s:7:\"updated\";s:19:\"2019-08-04 06:53:40\";s:7:\"created\";s:19:\"2019-05-16 04:54:10\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_c3ff094ed1cbaf287c6f833d3ba09\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3754\";s:7:\"updated\";s:19:\"2020-04-14 20:53:21\";s:7:\"created\";s:19:\"2019-05-06 13:24:01\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:19:\"Ocean Sticky Header\";s:4:\"slug\";s:19:\"ocean-sticky-header\";s:12:\"premium_slug\";s:19:\"ocean-sticky-header\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3755\";s:11:\"description\";s:512:\"<ul>\n<li>Stick manually, perfect for the Custom Header style</li>\n<li>Fixed the top bar</li>\n<li>Add sticky mobile</li>\n<li>Choose between two sticky styles: Shrink or Fixed</li>\n<li>Choose between two sticky effects</li>\n<li>Enter the height of the header during scroll for the shrink style</li>\n<li>Add logo when scrolling</li>\n<li>Enter the height of the logo during scroll for the shrink style</li>\n<li>Choose the header opacity during scroll</li>\n<li>Choose the background and color during scroll</li> </ul>\";s:17:\"short_description\";s:63:\"Attach an eye-catching header at the top of your website pages.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/card_banner.png\";s:15:\"selling_point_0\";s:51:\"Stick manually, perfect for the Custom Header style\";s:15:\"selling_point_1\";s:17:\"Fixed the top bar\";s:15:\"selling_point_2\";s:17:\"Add sticky mobile\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/screenshots/2.png\";}s:2:\"id\";s:3:\"829\";s:7:\"updated\";s:19:\"2019-08-04 07:27:06\";s:7:\"created\";s:19:\"2019-05-16 05:01:04\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_21f01f3d0a79bcd65042e3c332188\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3755\";s:7:\"updated\";s:19:\"2020-04-14 21:05:54\";s:7:\"created\";s:19:\"2019-05-06 13:27:16\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:2;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:16:\"Ocean Side Panel\";s:4:\"slug\";s:16:\"ocean-side-panel\";s:12:\"premium_slug\";s:16:\"ocean-side-panel\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:3;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3756\";s:11:\"description\";s:443:\"<ul>\n<li>Add your widgets into the Side Panel sidebar</li>\n<li>Choose your icon for the opening button</li>\n<li>Add text for the opening button</li>\n<li>Add a custom width for the panel</li>\n<li>Display the panel to the left or right</li>\n<li>Displace or not the panel</li>\n<li>Add an overlay when the panel is opened</li>\n<li>Show/Hide the close button of the panel</li>\n<li>Change the close button text</li>\n<li>Add your own color</li> </ul>\";s:17:\"short_description\";s:63:\"Add a responsive side panel with your preferred widgets inside.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3756/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3756/card_banner.png\";s:15:\"selling_point_0\";s:44:\"Add your widgets into the Side Panel sidebar\";s:15:\"selling_point_1\";s:39:\"Choose your icon for the opening button\";s:15:\"selling_point_2\";s:31:\"Add text for the opening button\";s:11:\"screenshots\";O:8:\"stdClass\":1:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3756/screenshots/0.png\";}s:2:\"id\";s:3:\"827\";s:7:\"updated\";s:19:\"2019-08-04 07:22:03\";s:7:\"created\";s:19:\"2019-05-16 05:00:01\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_95ab9dabcffc015befcfaf19dd91e\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3756\";s:7:\"updated\";s:19:\"2020-04-14 20:38:21\";s:7:\"created\";s:19:\"2019-05-06 13:30:08\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:3;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:23:\"Ocean Elementor Widgets\";s:4:\"slug\";s:23:\"ocean-elementor-widgets\";s:12:\"premium_slug\";s:23:\"ocean-elementor-widgets\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:4;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3757\";s:11:\"description\";s:1290:\"<ul>\n<li>Accordions widget</li>\n<li>Advanced Custom Field widget, thanks to Bruno Tritsch for the help</li>\n<li>Advanced Heading widget</li>\n<li>Animated Heading widget</li>\n<li>Banner widget</li>\n<li>Brands widget</li>\n<li>Business Hours widget</li>\n<li>Button Effects widget</li>\n<li>Buttons widget</li>\n<li>Call To Action widget</li>\n<li>Circle Progress widget</li>\n<li>Countdown widget</li>\n<li>Divider widget, to add a text or an icon in the divider</li>\n<li>Flip Box widget</li>\n<li>Google Maps widget</li>\n<li>Hotspots widget</li>\n<li>Image Comparison widget</li>\n<li>Image Gallery widget</li>\n<li>Info Box widget</li>\n<li>Instagram Feed widget</li>\n<li>Link Effects widget</li>\n<li>Login widget</li>\n<li>Lost Password widget</li>\n<li>Register widget</li>\n<li>Modal widget</li>\n<li>Navbar widget</li>\n<li>Off Canvas widget</li>\n<li>Price List widget</li>\n<li>Recipe widget</li>\n<li>Scroll Up widget</li>\n<li>Switch widget</li>\n<li>Table widget</li>\n<li>Tabs widget</li>\n<li>Team Members widget</li>\n<li>Timeline widget</li>\n<li>Contact Form 7 widget</li>\n<li>Gravity Forms widget</li>\n<li>WPForms widget</li>\n<li>Caldera Forms widget</li>\n<li>Ninja Forms widget</li>\n<li>WooCommerce Products widget</li>\n<li>WooCommerce Categories widget</li>\n<li>WooCommerce Slider widget</li> </ul>\";s:17:\"short_description\";s:75:\"Add many new powerful widgets to the popular free page builder - Elementor.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/card_banner.png\";s:15:\"selling_point_0\";s:23:\"Image Comparison widget\";s:15:\"selling_point_1\";s:21:\"Instagram Feed widget\";s:15:\"selling_point_2\";s:12:\"Table widget\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/screenshots/2.png\";s:12:\"screenshot_3\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/screenshots/3.png\";}s:2:\"id\";s:3:\"820\";s:7:\"updated\";s:19:\"2019-08-04 06:51:31\";s:7:\"created\";s:19:\"2019-05-16 04:53:49\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_25eeed8cddc1b8bede158756886e8\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3757\";s:7:\"updated\";s:19:\"2020-04-14 21:39:17\";s:7:\"created\";s:19:\"2019-05-06 13:36:11\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:4;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:11:\"Ocean Hooks\";s:4:\"slug\";s:11:\"ocean-hooks\";s:12:\"premium_slug\";s:11:\"ocean-hooks\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3758\";s:11:\"description\";s:278:\"<ul>\n<li>Add different content for the same hook location</li>\n<li>Add shortcode</li>\n<li>Add PHP code</li>\n<li>Add content only for logged in/out users</li>\n<li>Display your code on the page/post/taxonomy you want</li>\n<li>Display your code on the user role you want</li> </ul>\";s:17:\"short_description\";s:60:\"Add your custom content throughout various areas of OceanWP.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/card_banner.png\";s:15:\"selling_point_0\";s:48:\"Add different content for the same hook location\";s:15:\"selling_point_1\";s:13:\"Add shortcode\";s:15:\"selling_point_2\";s:12:\"Add PHP code\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/screenshots/2.png\";}s:2:\"id\";s:3:\"823\";s:7:\"updated\";s:19:\"2019-08-04 07:02:53\";s:7:\"created\";s:19:\"2019-05-16 04:54:56\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_bf5672ee85c0032b2b4d7c0a3d244\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3758\";s:7:\"updated\";s:19:\"2020-04-14 20:37:21\";s:7:\"created\";s:19:\"2019-05-06 13:39:32\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:5;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:19:\"Ocean Sticky Footer\";s:4:\"slug\";s:19:\"ocean-sticky-footer\";s:12:\"premium_slug\";s:19:\"ocean-sticky-footer\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3759\";s:11:\"description\";s:163:\"<ul>\n<li>Add menu in the footer bar</li>\n<li>Add text in the footer bar</li>\n<li>Choose your own colors</li>\n<li>Hide Menu and/or text on mobile screens</li> </ul>\";s:17:\"short_description\";s:69:\"A simple extension to attach your footer to the bottom of the screen.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/card_banner.png\";s:15:\"selling_point_0\";s:26:\"Add menu in the footer bar\";s:15:\"selling_point_1\";s:26:\"Add text in the footer bar\";s:15:\"selling_point_2\";s:22:\"Choose your own colors\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/screenshots/2.png\";}s:2:\"id\";s:3:\"828\";s:7:\"updated\";s:19:\"2019-08-04 07:25:54\";s:7:\"created\";s:19:\"2019-05-16 05:00:32\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_5552f1b8d38d0f09df4b2990b57b2\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3759\";s:7:\"updated\";s:19:\"2020-04-14 21:09:41\";s:7:\"created\";s:19:\"2019-05-06 13:41:42\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:6;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:15:\"Ocean Woo Popup\";s:4:\"slug\";s:15:\"ocean-woo-popup\";s:12:\"premium_slug\";s:23:\"ocean-woo-popup-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3760\";s:11:\"description\";s:333:\"<ul>\n<li>Select an Elementor template (or a page if you use another page builder) to replace the content of the popup</li>\n<li>Control width, height, padding and the border radius</li>\n<li>Show/hide and reorganize the elements of the popup</li>\n<li>Replace all the texts from the customizer</li>\n<li>Choose your own colors</li> </ul>\";s:17:\"short_description\";s:79:\"A simple extension to display a popup when you click on the Add To Cart button.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/card_banner.png\";s:15:\"selling_point_0\";s:108:\"Select an Elementor template (or a page if you use another page builder) to replace the content of the popup\";s:15:\"selling_point_1\";s:52:\"Control width, height, padding and the border radius\";s:15:\"selling_point_2\";s:50:\"Show/hide and reorganize the elements of the popup\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/screenshots/2.png\";}s:2:\"id\";s:3:\"831\";s:7:\"updated\";s:19:\"2019-08-04 07:39:37\";s:7:\"created\";s:19:\"2019-05-16 05:02:03\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_9414dbc7719b150c20046f728e994\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3760\";s:7:\"updated\";s:19:\"2020-04-14 20:38:51\";s:7:\"created\";s:19:\"2019-05-06 13:53:08\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:7;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:15:\"Ocean Portfolio\";s:4:\"slug\";s:15:\"ocean-portfolio\";s:12:\"premium_slug\";s:15:\"ocean-portfolio\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:3;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3761\";s:11:\"description\";s:473:\"<ul>\n<li>Display your portfolio anywhere you want via a page template or a shortcode</li>\n<li>Show/hide the filter bar</li>\n<li>Control the filter bar positioning, styling and typography</li>\n<li>Control the portfolio items styling like the margin, padding, color, overlay color,\ntypography, etc...</li>\n<li>Add your own images width and height</li>\n<li>Display items by author, categories or tags, sort by order and exclude categories</li>\n<li>And a lot more...</li> </ul>\";s:17:\"short_description\";s:75:\"A complete extension to display your portfolio and work in a beautiful way.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/card_banner.png\";s:15:\"selling_point_0\";s:75:\"Display your portfolio anywhere you want via a page template or a shortcode\";s:15:\"selling_point_1\";s:24:\"Show/hide the filter bar\";s:15:\"selling_point_2\";s:58:\"Control the filter bar positioning, styling and typography\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/screenshots/2.png\";}s:2:\"id\";s:3:\"826\";s:7:\"updated\";s:19:\"2019-08-04 07:20:12\";s:7:\"created\";s:19:\"2019-05-16 04:56:11\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_d0109c81ea2f48fdfa29c30d9d20b\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3761\";s:7:\"updated\";s:19:\"2020-04-14 21:00:05\";s:7:\"created\";s:19:\"2019-05-06 13:55:52\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:8;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:17:\"Ocean White Label\";s:4:\"slug\";s:17:\"ocean-white-label\";s:12:\"premium_slug\";s:17:\"ocean-white-label\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3762\";s:11:\"description\";s:302:\"<ul>\n<li>Add your own branding name in the admin pages</li>\n<li>Add your own theme name</li>\n<li>Add your own theme author</li>\n<li>Add your own theme author url</li>\n<li>Add your own theme description</li>\n<li>Add your own theme screenshot</li>\n<li>Remove the White Label box in Theme Panel</li> </ul>\";s:17:\"short_description\";s:69:\"Impress clients by replacing the OceanWP name by your own brand name.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/card_banner.png\";s:15:\"selling_point_0\";s:45:\"Add your own branding name in the admin pages\";s:15:\"selling_point_1\";s:68:\"Add your own theme name, author, author url, description, screenshot\";s:15:\"selling_point_2\";s:41:\"Remove the White Label box in Theme Panel\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/screenshots/2.png\";}s:2:\"id\";s:3:\"830\";s:7:\"updated\";s:19:\"2019-08-04 07:36:38\";s:7:\"created\";s:19:\"2019-05-16 05:01:36\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_c9bb8f8d46af4c19cc2b66105accb\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3762\";s:7:\"updated\";s:19:\"2020-04-14 20:38:44\";s:7:\"created\";s:19:\"2019-05-06 13:57:59\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:9;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:15:\"Ocean Instagram\";s:4:\"slug\";s:15:\"ocean-instagram\";s:12:\"premium_slug\";s:15:\"ocean-instagram\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:1;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3763\";s:11:\"description\";s:224:\"<ul>\n<li>Display your Instagram photos</li>\n<li>Choose the column number</li>\n<li>Show/hide the likes &amp; comments</li>\n<li>Show/hide the captions</li>\n<li>Display your username, follow, posts, biograhpy, etc...</li> </ul>\";s:17:\"short_description\";s:70:\"Fetch and customize your Instagram feed to display in a beautiful way.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/card_banner.png\";s:15:\"selling_point_0\";s:29:\"Display your Instagram photos\";s:15:\"selling_point_1\";s:24:\"Choose the column number\";s:15:\"selling_point_2\";s:34:\"Show/hide the likes &amp; comments\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/screenshots/2.png\";}s:2:\"id\";s:3:\"824\";s:7:\"updated\";s:19:\"2019-08-04 07:11:09\";s:7:\"created\";s:19:\"2019-05-16 04:55:16\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_60babf307a20c89d435bcd61d54e8\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3763\";s:7:\"updated\";s:19:\"2020-04-14 21:05:02\";s:7:\"created\";s:19:\"2019-05-06 14:00:21\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:10;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:17:\"Ocean Popup Login\";s:4:\"slug\";s:17:\"ocean-popup-login\";s:12:\"premium_slug\";s:17:\"ocean-popup-login\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:5;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3764\";s:11:\"description\";s:185:\"<ul>\n<li>Add the login/register link where you want</li>\n<li>Style the form</li>\n<li>Add a background image in the form</li>\n<li>Change the title and description for the form</li> </ul>\";s:17:\"short_description\";s:59:\"A plugin to add a popup login/register form where you want.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/card_banner.png\";s:15:\"selling_point_0\";s:42:\"Add the login/register link where you want\";s:15:\"selling_point_1\";s:14:\"Style the form\";s:15:\"selling_point_2\";s:34:\"Add a background image in the form\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/screenshots/2.png\";}s:2:\"id\";s:3:\"825\";s:7:\"updated\";s:19:\"2019-08-04 07:12:58\";s:7:\"created\";s:19:\"2019-05-16 04:55:50\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e0499681c773af2bbac0016bb24ff\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3764\";s:7:\"updated\";s:19:\"2020-04-14 20:38:37\";s:7:\"created\";s:19:\"2019-05-06 14:02:12\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:11;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:19:\"Ocean Cookie Notice\";s:4:\"slug\";s:19:\"ocean-cookie-notice\";s:12:\"premium_slug\";s:19:\"ocean-cookie-notice\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3765\";s:11:\"description\";s:368:\"<ul>\n<li>Add scripts that will be loaded only after the user consent</li>\n<li>Choose to reload the page after the cookie accept</li>\n<li>Two notice styles</li>\n<li>Add your own content</li>\n<li>Add your own button text</li>\n<li>Choose between a button or a close icon to close the notice</li>\n<li>Many styling settings to customize every parts of the notice</li> </ul>\";s:17:\"short_description\";s:91:\"\nInform users that you are using cookies to comply with the EU cookie law GDPR regulations.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/card_banner.png\";s:15:\"selling_point_0\";s:59:\"Add scripts that will be loaded only after the user consent\";s:15:\"selling_point_1\";s:49:\"Choose to reload the page after the cookie accept\";s:15:\"selling_point_2\";s:17:\"Two notice styles\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/screenshots/2.png\";s:12:\"screenshot_3\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/screenshots/3.png\";}s:2:\"id\";s:3:\"817\";s:7:\"updated\";s:19:\"2019-08-04 06:36:09\";s:7:\"created\";s:19:\"2019-05-15 10:13:47\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_2ebffcd411ce5f21e543822065b7d\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3765\";s:7:\"updated\";s:19:\"2020-04-14 21:04:03\";s:7:\"created\";s:19:\"2019-05-06 14:04:05\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:12;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:17:\"Ocean Full Screen\";s:4:\"slug\";s:17:\"ocean-full-screen\";s:12:\"premium_slug\";s:17:\"ocean-full-screen\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3766\";s:11:\"description\";s:241:\"<ul>\n<li>Very easy to use</li>\n<li>Add your own scrolling speed</li>\n<li>Add a side navigation</li>\n<li>Change the navigation color</li>\n<li>Add tooltips to the navigation</li>\n<li>Disable the scrolling effect at the size you want</li> </ul>\";s:17:\"short_description\";s:63:\"A simple and easy way to create a fullscreen scrolling website.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/card_banner.png\";s:15:\"selling_point_0\";s:16:\"Very easy to use\";s:15:\"selling_point_1\";s:28:\"Add your own scrolling speed\";s:15:\"selling_point_2\";s:21:\"Add a side navigation\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/screenshots/2.png\";}s:2:\"id\";s:3:\"822\";s:7:\"updated\";s:19:\"2019-08-04 06:57:28\";s:7:\"created\";s:19:\"2019-05-16 04:54:33\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e0f5fb19e66d3b97f64adb891fae5\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3766\";s:7:\"updated\";s:19:\"2020-04-14 20:37:53\";s:7:\"created\";s:19:\"2019-05-06 14:06:43\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:13;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:15:\"Ocean Pro Demos\";s:4:\"slug\";s:15:\"ocean-pro-demos\";s:12:\"premium_slug\";s:15:\"ocean-pro-demos\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_a34c58ab5e7159d54e88175c1c03f\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3797\";s:7:\"updated\";s:19:\"2020-04-14 21:16:37\";s:7:\"created\";s:19:\"2019-05-14 12:39:32\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:14;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:11:\"Ocean Extra\";s:4:\"slug\";s:11:\"ocean-extra\";s:12:\"premium_slug\";s:19:\"ocean-extra-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3806\";s:11:\"description\";s:759:\"<ul>\n<li style=\"color: #333;font-weight: 600\">Meta Boxes</li>\n<li>Change the layout per page/post</li>\n<li>Select the sidebar per page/post</li>\n<li>Enable/Disable the margins top/bottom</li>\n<li>Enable/Disable the title</li>\n<li>Add a custom title</li>\n<li>Add a subheading for your title</li>\n<li>Select the style of your title</li>\n<li>Unique options for the different post format</li>\n<li>Add gallery image for the gallery post format</li>\n<li>And much more...</li>\n<li style=\"color: #333;font-weight: 600;margin-top: 20px\">Theme Panel</li>\n<li>Enable/Disable the Customizer panels</li>\n<li>Activate the licenses of the OceanWP extensions</li>\n<li>Enable/Disable all the theme scripts &amp; styles</li>\n<li>Import/Export the customizer settings</li> </ul>\";s:17:\"short_description\";N;s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/card_banner.png\";s:15:\"selling_point_0\";s:31:\"Change the layout per page/post\";s:15:\"selling_point_1\";s:32:\"Select the sidebar per page/post\";s:15:\"selling_point_2\";s:45:\"Add gallery image for the gallery post format\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/screenshots/2.png\";}s:2:\"id\";s:3:\"832\";s:7:\"updated\";s:19:\"2019-08-04 07:50:27\";s:7:\"created\";s:19:\"2019-05-16 08:37:18\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_dc69e18411e45b6f22272ac4586b1\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3806\";s:7:\"updated\";s:19:\"2019-05-16 07:48:04\";s:7:\"created\";s:19:\"2019-05-16 07:48:04\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:15;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:20:\"Ocean Social Sharing\";s:4:\"slug\";s:20:\"ocean-social-sharing\";s:12:\"premium_slug\";s:28:\"ocean-social-sharing-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3807\";s:11:\"description\";s:336:\"<ul>\n<li>Add social networks: Twitter, Facebook, LinkedIn, Google+, Pinterest, Viber, VK, Reddit, Tumblr and Viadeo.</li>\n<li>Alter the social sharing buttons.</li>\n<li>Choose between three styles.</li>\n<li>Add the social names.</li>\n<li>Choose the heading position.</li>\n<li>Add or edit the social sharing via a child theme.</li> </ul>\";s:17:\"short_description\";s:58:\"A simple plugin to add social share buttons to your posts.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/card_banner.png\";s:15:\"selling_point_0\";s:106:\"Add social networks: Twitter, Facebook, LinkedIn, Google+, Pinterest, Viber, VK, Reddit, Tumblr and Viadeo\";s:15:\"selling_point_1\";s:32:\"Alter the social sharing buttons\";s:15:\"selling_point_2\";s:27:\"Choose between three styles\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/screenshots/2.png\";s:12:\"screenshot_3\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/screenshots/3.png\";}s:2:\"id\";s:3:\"838\";s:7:\"updated\";s:19:\"2019-08-04 08:00:26\";s:7:\"created\";s:19:\"2019-05-16 08:44:21\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_0aa6121ff893b29efa9a58d6c0ad5\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3807\";s:7:\"updated\";s:19:\"2020-04-14 21:42:05\";s:7:\"created\";s:19:\"2019-05-16 07:53:38\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:16;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:21:\"Ocean Product Sharing\";s:4:\"slug\";s:21:\"ocean-product-sharing\";s:12:\"premium_slug\";s:29:\"ocean-product-sharing-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3809\";s:11:\"description\";s:177:\"<ul>\n<li>Add social twitter, facebook, pinterest and email sharing</li>\n<li>Alter the social sharing buttons</li>\n<li>Add or edit the social sharing via a child theme</li> </ul>\";s:17:\"short_description\";s:121:\"A simple plugin to add social share buttons to your product page, compatible with WooCommerce and Easy Digital Downloads.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/card_banner.png\";s:15:\"selling_point_0\";s:57:\"Add social twitter, facebook, pinterest and email sharing\";s:15:\"selling_point_1\";s:32:\"Alter the social sharing buttons\";s:15:\"selling_point_2\";s:48:\"Add or edit the social sharing via a child theme\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/screenshots/2.png\";}s:2:\"id\";s:3:\"837\";s:7:\"updated\";s:19:\"2019-08-04 07:55:00\";s:7:\"created\";s:19:\"2019-05-16 08:43:10\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e8cc3b7980be98f86dc7286572cc0\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3809\";s:7:\"updated\";s:19:\"2020-04-14 21:42:04\";s:7:\"created\";s:19:\"2019-05-16 08:00:39\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:17;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:20:\"Ocean Custom Sidebar\";s:4:\"slug\";s:20:\"ocean-custom-sidebar\";s:12:\"premium_slug\";s:28:\"ocean-custom-sidebar-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3810\";s:11:\"description\";s:58:\"<ul>\n<li>Create an unlimited number of sidebars</li> </ul>\";s:17:\"short_description\";s:136:\"Generates an unlimited number of sidebars and place them anywhere you wish. Go to Theme Panel > Sidebars to create your custom sidebars.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/card_banner.png\";s:15:\"selling_point_0\";s:38:\"Create an unlimited number of sidebars\";s:15:\"selling_point_1\";N;s:15:\"selling_point_2\";N;s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/screenshots/2.png\";}s:2:\"id\";s:3:\"833\";s:7:\"updated\";s:19:\"2019-08-04 07:47:46\";s:7:\"created\";s:19:\"2019-05-16 08:38:20\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e1fc615375e847fd4d955c62b2a34\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3810\";s:7:\"updated\";s:19:\"2020-04-14 21:42:03\";s:7:\"created\";s:19:\"2019-05-16 08:04:08\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:18;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:17:\"Ocean Demo Import\";s:4:\"slug\";s:17:\"ocean-demo-import\";s:12:\"premium_slug\";s:27:\"activity-log-mainwp-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3811\";s:11:\"description\";s:55:\"<ul>\n<li>Import the sample data in one click</li> </ul>\";s:17:\"short_description\";s:80:\"Import the OceanWP demo content, widgets and customizer settings with one click.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/card_banner.png\";s:15:\"selling_point_0\";s:35:\"Import the sample data in one click\";s:15:\"selling_point_1\";N;s:15:\"selling_point_2\";N;s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/screenshots/2.png\";}s:2:\"id\";s:3:\"834\";s:7:\"updated\";s:19:\"2019-08-04 07:48:57\";s:7:\"created\";s:19:\"2019-05-16 08:39:11\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_28285e0f391b4955f4460589da147\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3811\";s:7:\"updated\";s:19:\"2020-04-14 21:34:47\";s:7:\"created\";s:19:\"2019-05-16 08:06:15\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:19;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:18:\"Ocean Posts Slider\";s:4:\"slug\";s:18:\"ocean-posts-slider\";s:12:\"premium_slug\";s:26:\"ocean-posts-slider-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3813\";s:11:\"description\";s:373:\"<ul>\n<li>Choose your slider style</li>\n<li>Enter the number of posts to display</li>\n<li>Select the size of the images</li>\n<li>Change the read more text</li>\n<li>Enter a margin to add a space between the slider and your content</li>\n<li>Enter the transition speed of the slides</li>\n<li>Exclude categories of posts</li>\n<li>Choose the order and oder by of posts</li> </ul>\";s:17:\"short_description\";s:71:\"Display your latest posts in a beautiful slider with different options.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/card_banner.png\";s:15:\"selling_point_0\";s:24:\"Choose your slider style\";s:15:\"selling_point_1\";s:36:\"Enter the number of posts to display\";s:15:\"selling_point_2\";s:29:\"Select the size of the images\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/screenshots/2.png\";}s:2:\"id\";s:3:\"836\";s:7:\"updated\";s:19:\"2019-08-04 07:53:25\";s:7:\"created\";s:19:\"2019-05-16 08:42:09\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_eae1ef26c136dd8af5ef7a6cf7557\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3813\";s:7:\"updated\";s:19:\"2020-04-14 21:34:21\";s:7:\"created\";s:19:\"2019-05-16 08:08:26\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:20;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:18:\"Ocean Modal Window\";s:4:\"slug\";s:18:\"ocean-modal-window\";s:12:\"premium_slug\";s:26:\"ocean-modal-window-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3814\";s:11:\"description\";s:203:\"<ul>\n<li>Create as many modals as you want</li>\n<li>Choose your custom width</li>\n<li>Insert the content you want (shortcodes allowed)</li>\n<li>Choose your own colors</li>\n<li>Fully responsive</li> </ul>\";s:17:\"short_description\";s:80:\"Insert any content in a modals and place the opening button anywhere to open it.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/card_banner.png\";s:15:\"selling_point_0\";s:33:\"Create as many modals as you want\";s:15:\"selling_point_1\";s:24:\"Choose your custom width\";s:15:\"selling_point_2\";s:48:\"Insert the content you want (shortcodes allowed)\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/screenshots/2.png\";}s:2:\"id\";s:3:\"835\";s:7:\"updated\";s:19:\"2019-08-04 07:51:54\";s:7:\"created\";s:19:\"2019-05-16 08:40:03\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_7e254472063a1abd3b7e342930210\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3814\";s:7:\"updated\";s:19:\"2020-04-14 21:36:58\";s:7:\"created\";s:19:\"2019-05-16 08:10:28\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:21;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:20:\"Ocean Stick Anything\";s:4:\"slug\";s:20:\"ocean-stick-anything\";s:12:\"premium_slug\";s:28:\"ocean-stick-anything-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:4:\"3815\";s:11:\"description\";s:190:\"<ul>\n<li>Stick one or several elements</li>\n<li>Add an offset to add a spacing between the top of the page and your sticky element</li>\n<li>Destroy the sticky on the size you want</li>\n</ul>\";s:17:\"short_description\";s:43:\"A simple plugin to stick anything you want.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/card_banner.png\";s:15:\"selling_point_0\";s:29:\"Stick one or several elements\";s:15:\"selling_point_1\";s:82:\"Add an offset to add a spacing between the top of the page and your sticky element\";s:15:\"selling_point_2\";s:39:\"Destroy the sticky on the size you want\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/screenshots/2.png\";}s:2:\"id\";s:3:\"839\";s:7:\"updated\";s:19:\"2019-08-04 08:03:54\";s:7:\"created\";s:19:\"2019-05-16 08:45:08\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_f9a790f52e74ee60eb2812ba763dd\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3815\";s:7:\"updated\";s:19:\"2020-04-14 21:42:07\";s:7:\"created\";s:19:\"2019-05-16 08:12:51\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}s:11:\"plugin_data\";a:4:{s:20:\"ocean-custom-sidebar\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:45:\"ocean-custom-sidebar/ocean-custom-sidebar.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1585962401;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:7:\"2.3.2.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.0.6\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:18:\"one.mylocalshop.fr\";s:9:\"server_ip\";s:13:\"86.233.128.69\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1585962401;s:7:\"version\";s:5:\"1.0.6\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}s:21:\"ocean-product-sharing\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:47:\"ocean-product-sharing/ocean-product-sharing.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1585962405;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:7:\"2.3.2.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.1.0\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:18:\"one.mylocalshop.fr\";s:9:\"server_ip\";s:13:\"86.233.128.69\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1585962405;s:7:\"version\";s:5:\"1.1.0\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}s:20:\"ocean-social-sharing\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:45:\"ocean-social-sharing/ocean-social-sharing.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1585962410;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:7:\"2.3.2.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.1.0\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:18:\"one.mylocalshop.fr\";s:9:\"server_ip\";s:13:\"86.233.128.69\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1585962410;s:7:\"version\";s:5:\"1.1.0\";}s:15:\"prev_is_premium\";b:0;s:16:\"uninstall_reason\";O:8:\"stdClass\":3:{s:2:\"id\";s:2:\"15\";s:4:\"info\";s:0:\"\";s:12:\"is_anonymous\";b:0;}}s:20:\"ocean-stick-anything\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:45:\"ocean-stick-anything/ocean-stick-anything.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1585962414;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:7:\"2.3.2.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.0.4\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:18:\"one.mylocalshop.fr\";s:9:\"server_ip\";s:13:\"86.233.128.69\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1585962414;s:7:\"version\";s:5:\"1.0.4\";}s:15:\"prev_is_premium\";b:0;s:16:\"uninstall_reason\";O:8:\"stdClass\":3:{s:2:\"id\";s:2:\"15\";s:4:\"info\";s:0:\"\";s:12:\"is_anonymous\";b:0;}}}s:7:\"plugins\";a:4:{s:20:\"ocean-custom-sidebar\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:20:\"Ocean Custom Sidebar\";s:4:\"slug\";s:20:\"ocean-custom-sidebar\";s:12:\"premium_slug\";s:20:\"ocean-custom-sidebar\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:45:\"ocean-custom-sidebar/ocean-custom-sidebar.php\";s:7:\"version\";s:5:\"1.0.6\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e1fc615375e847fd4d955c62b2a34\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3810\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:21:\"ocean-product-sharing\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:21:\"Ocean Product Sharing\";s:4:\"slug\";s:21:\"ocean-product-sharing\";s:12:\"premium_slug\";s:21:\"ocean-product-sharing\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:47:\"ocean-product-sharing/ocean-product-sharing.php\";s:7:\"version\";s:5:\"1.1.0\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e8cc3b7980be98f86dc7286572cc0\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3809\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:20:\"ocean-social-sharing\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:20:\"Ocean Social Sharing\";s:4:\"slug\";s:20:\"ocean-social-sharing\";s:12:\"premium_slug\";s:20:\"ocean-social-sharing\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:45:\"ocean-social-sharing/ocean-social-sharing.php\";s:7:\"version\";s:5:\"1.1.0\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_0aa6121ff893b29efa9a58d6c0ad5\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3807\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:20:\"ocean-stick-anything\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:5:\"title\";s:20:\"Ocean Stick Anything\";s:4:\"slug\";s:20:\"ocean-stick-anything\";s:12:\"premium_slug\";s:20:\"ocean-stick-anything\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:45:\"ocean-stick-anything/ocean-stick-anything.php\";s:7:\"version\";s:5:\"1.0.4\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_f9a790f52e74ee60eb2812ba763dd\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3815\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("175", "fs_gdpr", "a:1:{s:2:\"u1\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("176", "elementor_version", "2.9.7", "yes");
INSERT INTO `wp_oneoptions` VALUES("177", "widget_ocean_about_me", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("178", "widget_ocean_contact_info", "a:2:{i:1;a:29:{s:5:\"title\";s:12:\"Informations\";s:4:\"text\";s:33:\"Retrouvez toutes nos informations\";s:7:\"address\";s:34:\"12 rue de la liberté, 75019 Paris\";s:5:\"phone\";s:14:\"06 01 02 03 04\";s:6:\"mobile\";s:0:\"\";s:3:\"fax\";s:0:\"\";s:5:\"email\";s:16:\"exemple@mail.com\";s:8:\"emailtxt\";s:16:\"exemple@mail.com\";s:3:\"web\";s:0:\"\";s:6:\"webtxt\";s:0:\"\";s:5:\"skype\";s:0:\"\";s:8:\"skypetxt\";s:0:\"\";s:12:\"address_icon\";s:17:\"icon-location-pin\";s:12:\"address_text\";s:8:\"Address:\";s:10:\"phone_icon\";s:10:\"icon-phone\";s:10:\"phone_text\";s:12:\"Téléphone:\";s:11:\"mobile_icon\";s:22:\"icon-screen-smartphone\";s:11:\"mobile_text\";s:7:\"Mobile:\";s:8:\"fax_icon\";s:12:\"icon-printer\";s:8:\"fax_text\";s:4:\"Fax:\";s:10:\"email_icon\";s:13:\"icon-envelope\";s:10:\"email_text\";s:6:\"Email:\";s:8:\"web_icon\";s:9:\"icon-link\";s:8:\"web_text\";s:8:\"Website:\";s:5:\"style\";s:7:\"default\";s:6:\"target\";s:5:\"blank\";s:12:\"address_link\";s:0:\"\";s:10:\"phone_link\";s:0:\"\";s:11:\"mobile_link\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("179", "widget_ocean_custom_links", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("180", "widget_ocean_custom_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("181", "widget_ocean_facebook", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("182", "widget_ocean_flickr", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("183", "widget_ocean_instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("184", "widget_ocean_mailchimp", "a:2:{i:1;a:7:{s:5:\"title\";s:10:\"Newsletter\";s:14:\"subscribe_text\";s:47:\"Get all latest content delivered to your email!\";s:15:\"mailchimpaction\";s:1:\"#\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"placeholder\";s:10:\"Your Email\";s:11:\"submit_text\";s:2:\"Go\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("185", "widget_ocean_recent_posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("186", "widget_ocean_social", "a:2:{i:1;a:14:{s:5:\"title\";s:16:\"Réseaux sociaux\";s:5:\"style\";s:7:\"colored\";s:10:\"transition\";s:5:\"float\";s:6:\"target\";s:5:\"blank\";s:4:\"size\";s:4:\"48px\";s:13:\"border_radius\";s:3:\"50%\";s:9:\"font_size\";s:4:\"13px\";s:15:\"social_services\";a:20:{s:7:\"twitter\";a:2:{s:4:\"name\";s:7:\"Twitter\";s:3:\"url\";s:1:\"#\";}s:8:\"facebook\";a:2:{s:4:\"name\";s:8:\"Facebook\";s:3:\"url\";s:1:\"#\";}s:9:\"instagram\";a:2:{s:4:\"name\";s:9:\"Instagram\";s:3:\"url\";s:0:\"\";}s:11:\"google-plus\";a:2:{s:4:\"name\";s:10:\"GooglePlus\";s:3:\"url\";s:0:\"\";}s:8:\"linkedin\";a:2:{s:4:\"name\";s:8:\"LinkedIn\";s:3:\"url\";s:1:\"#\";}s:9:\"pinterest\";a:2:{s:4:\"name\";s:9:\"Pinterest\";s:3:\"url\";s:0:\"\";}s:4:\"yelp\";a:2:{s:4:\"name\";s:4:\"Yelp\";s:3:\"url\";s:0:\"\";}s:8:\"dribbble\";a:2:{s:4:\"name\";s:8:\"Dribbble\";s:3:\"url\";s:0:\"\";}s:6:\"flickr\";a:2:{s:4:\"name\";s:6:\"Flickr\";s:3:\"url\";s:0:\"\";}s:2:\"vk\";a:2:{s:4:\"name\";s:2:\"VK\";s:3:\"url\";s:0:\"\";}s:6:\"github\";a:2:{s:4:\"name\";s:6:\"GitHub\";s:3:\"url\";s:0:\"\";}s:6:\"tumblr\";a:2:{s:4:\"name\";s:6:\"Tumblr\";s:3:\"url\";s:0:\"\";}s:5:\"skype\";a:2:{s:4:\"name\";s:5:\"Skype\";s:3:\"url\";s:0:\"\";}s:6:\"trello\";a:2:{s:4:\"name\";s:6:\"Trello\";s:3:\"url\";s:0:\"\";}s:10:\"foursquare\";a:2:{s:4:\"name\";s:10:\"Foursquare\";s:3:\"url\";s:0:\"\";}s:4:\"xing\";a:2:{s:4:\"name\";s:4:\"Xing\";s:3:\"url\";s:0:\"\";}s:12:\"vimeo-square\";a:2:{s:4:\"name\";s:5:\"Vimeo\";s:3:\"url\";s:0:\"\";}s:4:\"vine\";a:2:{s:4:\"name\";s:4:\"Vine\";s:3:\"url\";s:0:\"\";}s:7:\"youtube\";a:2:{s:4:\"name\";s:7:\"Youtube\";s:3:\"url\";s:0:\"\";}s:3:\"rss\";a:2:{s:4:\"name\";s:3:\"RSS\";s:3:\"url\";s:0:\"\";}}s:8:\"bg_color\";s:0:\"\";s:14:\"bg_hover_color\";s:0:\"\";s:5:\"color\";s:0:\"\";s:11:\"color_hover\";s:0:\"\";s:12:\"border_color\";s:0:\"\";s:18:\"border_hover_color\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("187", "widget_ocean_social_share", "a:2:{i:1;a:9:{s:5:\"title\";s:17:\"Please share this\";s:5:\"style\";s:7:\"minimal\";s:13:\"border_radius\";s:3:\"4px\";s:12:\"border_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:5:\"color\";s:0:\"\";s:16:\"twitter_username\";s:14:\"OceanWordPRess\";s:11:\"social_name\";i:1;s:12:\"social_share\";a:4:{i:0;s:7:\"twitter\";i:1;s:8:\"facebook\";i:2;s:10:\"googleplus\";i:3;s:9:\"pinterest\";}}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("188", "widget_ocean_tags", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("189", "widget_ocean_twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("190", "widget_ocean_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("191", "widget_ocean_custom_header_logo", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("192", "widget_ocean_custom_header_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("193", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("206", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:2:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}}s:10:\"categories\";s:247:\"[\"404 page\",\"about\",\"archive\",\"call to action\",\"clients\",\"contact\",\"faq\",\"features\",\"footer\",\"header\",\"hero\",\"portfolio\",\"pricing\",\"product archive\",\"services\",\"single page\",\"single post\",\"single product\",\"stats\",\"subscribe\",\"team\",\"testimonials\"]\";s:9:\"templates\";a:670:{i:0;a:14:{s:2:\"id\";s:4:\"5525\";s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";s:10:\"1520443532\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"11\";s:11:\"trend_index\";s:1:\"6\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:1;a:14:{s:2:\"id\";s:5:\"10107\";s:5:\"title\";s:34:\"Classic | Promotion | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/balls_small.png\";s:12:\"tmpl_created\";s:10:\"1547851373\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-promotion-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"265\";s:11:\"trend_index\";s:3:\"178\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:2;a:14:{s:2:\"id\";s:4:\"5533\";s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";s:10:\"1520443534\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"31\";s:11:\"trend_index\";s:2:\"17\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:3;a:14:{s:2:\"id\";s:4:\"5575\";s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443543\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"17\";s:11:\"trend_index\";s:1:\"7\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:4;a:14:{s:2:\"id\";s:4:\"5615\";s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443551\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"33\";s:11:\"trend_index\";s:2:\"20\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:5;a:14:{s:2:\"id\";s:4:\"5624\";s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443553\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"80\";s:11:\"trend_index\";s:2:\"62\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:6;a:14:{s:2:\"id\";s:4:\"5684\";s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443565\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"72\";s:11:\"trend_index\";s:2:\"59\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:7;a:14:{s:2:\"id\";s:5:\"10158\";s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/coco_small.png\";s:12:\"tmpl_created\";s:10:\"1547852227\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"287\";s:11:\"trend_index\";s:3:\"215\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:8;a:14:{s:2:\"id\";s:4:\"5693\";s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443567\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"205\";s:11:\"trend_index\";s:3:\"248\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:9;a:14:{s:2:\"id\";s:4:\"5703\";s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443569\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"30\";s:11:\"trend_index\";s:2:\"15\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:10;a:14:{s:2:\"id\";s:4:\"5711\";s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443571\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"200\";s:11:\"trend_index\";s:3:\"203\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:11;a:14:{s:2:\"id\";s:5:\"10190\";s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/engage_small.png\";s:12:\"tmpl_created\";s:10:\"1547885703\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"280\";s:11:\"trend_index\";s:3:\"197\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:12;a:14:{s:2:\"id\";s:4:\"5719\";s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443573\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"126\";s:11:\"trend_index\";s:3:\"114\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:13;a:14:{s:2:\"id\";s:4:\"5729\";s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520443575\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"301\";s:11:\"trend_index\";s:3:\"350\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:14;a:14:{s:2:\"id\";s:4:\"5737\";s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443576\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"158\";s:11:\"trend_index\";s:3:\"172\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:15;a:14:{s:2:\"id\";s:4:\"5746\";s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520443578\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"203\";s:11:\"trend_index\";s:3:\"192\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:16;a:14:{s:2:\"id\";s:4:\"5755\";s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443580\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"92\";s:11:\"trend_index\";s:3:\"118\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:17;a:14:{s:2:\"id\";s:4:\"5764\";s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";s:10:\"1520443582\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"307\";s:11:\"trend_index\";s:3:\"359\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:18;a:14:{s:2:\"id\";s:5:\"10256\";s:5:\"title\";s:20:\"Classic | Sale | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/fruit_small.png\";s:12:\"tmpl_created\";s:10:\"1547888909\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"426\";s:11:\"trend_index\";s:3:\"448\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:19;a:14:{s:2:\"id\";s:4:\"5773\";s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";s:10:\"1520443584\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"34\";s:11:\"trend_index\";s:2:\"26\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:20;a:14:{s:2:\"id\";s:5:\"10267\";s:5:\"title\";s:29:\"Classic | Contact | Christmas\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/christmas_small.png\";s:12:\"tmpl_created\";s:10:\"1547889047\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-contact-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"321\";s:11:\"trend_index\";s:3:\"265\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:21;a:14:{s:2:\"id\";s:4:\"5783\";s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";s:10:\"1520443586\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"345\";s:11:\"trend_index\";s:3:\"368\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:22;a:14:{s:2:\"id\";s:4:\"5792\";s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";s:10:\"1520443588\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"217\";s:11:\"trend_index\";s:3:\"229\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:23;a:14:{s:2:\"id\";s:4:\"5801\";s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";s:10:\"1520443589\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"19\";s:11:\"trend_index\";s:1:\"8\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:24;a:14:{s:2:\"id\";s:4:\"5811\";s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";s:10:\"1520443591\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"112\";s:11:\"trend_index\";s:3:\"104\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:25;a:14:{s:2:\"id\";s:5:\"10307\";s:5:\"title\";s:43:\"Fly In | Promotion | Christmas | Teddy Bear\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/teddy_small.png\";s:12:\"tmpl_created\";s:10:\"1547893266\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/fly-in-promotion-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"570\";s:11:\"trend_index\";s:3:\"646\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:26;a:14:{s:2:\"id\";s:4:\"5820\";s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443593\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"177\";s:11:\"trend_index\";s:3:\"187\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:27;a:14:{s:2:\"id\";s:5:\"10318\";s:5:\"title\";s:27:\"Classic | Contact | Bicycle\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/by_small.png\";s:12:\"tmpl_created\";s:10:\"1547893367\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"356\";s:11:\"trend_index\";s:3:\"251\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:28;a:14:{s:2:\"id\";s:4:\"5828\";s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443595\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"293\";s:11:\"trend_index\";s:3:\"331\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:29;a:14:{s:2:\"id\";s:4:\"5836\";s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443597\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"114\";s:11:\"trend_index\";s:3:\"120\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:30;a:14:{s:2:\"id\";s:5:\"10339\";s:5:\"title\";s:22:\"Fly In | Contact | Spa\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small.png\";s:12:\"tmpl_created\";s:10:\"1547893603\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-contact-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"415\";s:11:\"trend_index\";s:3:\"356\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:31;a:14:{s:2:\"id\";s:4:\"5844\";s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443599\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"285\";s:11:\"trend_index\";s:3:\"306\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:32;a:14:{s:2:\"id\";s:5:\"10352\";s:5:\"title\";s:23:\"Fly In | Contact | Wine\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_wine_small.png\";s:12:\"tmpl_created\";s:10:\"1547915335\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/fly-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"440\";s:11:\"trend_index\";s:3:\"444\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:33;a:14:{s:2:\"id\";s:4:\"5852\";s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";s:10:\"1520443600\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-34/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"482\";s:11:\"trend_index\";s:3:\"481\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:34;a:14:{s:2:\"id\";s:4:\"5947\";s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443621\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"341\";s:11:\"trend_index\";s:3:\"411\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:35;a:14:{s:2:\"id\";s:5:\"10372\";s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/phone_small.png\";s:12:\"tmpl_created\";s:10:\"1547915554\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"569\";s:11:\"trend_index\";s:3:\"613\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:36;a:14:{s:2:\"id\";s:4:\"5956\";s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443623\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"477\";s:11:\"trend_index\";s:3:\"529\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:37;a:14:{s:2:\"id\";s:5:\"10382\";s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom_pink_small.png\";s:12:\"tmpl_created\";s:10:\"1547916616\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/bottom-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"296\";s:11:\"trend_index\";s:3:\"270\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:38;a:14:{s:2:\"id\";s:4:\"5963\";s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443626\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"65\";s:11:\"trend_index\";s:2:\"80\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:39;a:14:{s:2:\"id\";s:4:\"5974\";s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443629\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"62\";s:11:\"trend_index\";s:2:\"74\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:40;a:14:{s:2:\"id\";s:4:\"5983\";s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520443630\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:11:\"[\"featues\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"236\";s:11:\"trend_index\";s:3:\"210\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:41;a:14:{s:2:\"id\";s:4:\"5991\";s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443632\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"122\";s:11:\"trend_index\";s:3:\"115\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:42;a:14:{s:2:\"id\";s:4:\"5999\";s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";s:10:\"1520443634\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"83\";s:11:\"trend_index\";s:2:\"99\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:43;a:14:{s:2:\"id\";s:5:\"10434\";s:5:\"title\";s:27:\"Classic | Sale | Headphones\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/head_small.png\";s:12:\"tmpl_created\";s:10:\"1547961950\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"381\";s:11:\"trend_index\";s:3:\"345\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:44;a:14:{s:2:\"id\";s:4:\"6008\";s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";s:10:\"1520443636\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"69\";s:11:\"trend_index\";s:2:\"68\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:45;a:14:{s:2:\"id\";s:5:\"10444\";s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/plant_small.png\";s:12:\"tmpl_created\";s:10:\"1547962029\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"418\";s:11:\"trend_index\";s:3:\"278\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:46;a:14:{s:2:\"id\";s:4:\"6027\";s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";s:10:\"1520443639\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-5-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"41\";s:11:\"trend_index\";s:2:\"24\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:47;a:14:{s:2:\"id\";s:4:\"6036\";s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";s:10:\"1520443641\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-6-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"88\";s:11:\"trend_index\";s:2:\"71\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:48;a:14:{s:2:\"id\";s:5:\"10467\";s:5:\"title\";s:27:\"Bottom Bar | Contact | Lego\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small.png\";s:12:\"tmpl_created\";s:10:\"1547962277\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/bottom-bar-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"624\";s:11:\"trend_index\";s:3:\"623\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:49;a:14:{s:2:\"id\";s:4:\"6044\";s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443643\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"70\";s:11:\"trend_index\";s:2:\"48\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:50;a:14:{s:2:\"id\";s:4:\"6053\";s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";s:10:\"1520443645\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"166\";s:11:\"trend_index\";s:3:\"152\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:51;a:14:{s:2:\"id\";s:5:\"10487\";s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/acc_small.png\";s:12:\"tmpl_created\";s:10:\"1547964527\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"508\";s:11:\"trend_index\";s:3:\"467\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:52;a:14:{s:2:\"id\";s:4:\"6063\";s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443647\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"156\";s:11:\"trend_index\";s:3:\"181\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:53;a:14:{s:2:\"id\";s:5:\"10498\";s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small-1.png\";s:12:\"tmpl_created\";s:10:\"1547964616\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"432\";s:11:\"trend_index\";s:3:\"511\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:54;a:14:{s:2:\"id\";s:4:\"6071\";s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443649\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"155\";s:11:\"trend_index\";s:3:\"151\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:55;a:14:{s:2:\"id\";s:4:\"6079\";s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443651\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"263\";s:11:\"trend_index\";s:3:\"259\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:56;a:14:{s:2:\"id\";s:5:\"10519\";s:5:\"title\";s:27:\"Hello Bar | Promotion | App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small-1.png\";s:12:\"tmpl_created\";s:10:\"1547964801\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-promotion-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"536\";s:11:\"trend_index\";s:3:\"480\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:57;a:14:{s:2:\"id\";s:4:\"6089\";s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443653\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"175\";s:11:\"trend_index\";s:3:\"174\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:58;a:14:{s:2:\"id\";s:4:\"6097\";s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443655\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"260\";s:11:\"trend_index\";s:3:\"236\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:59;a:14:{s:2:\"id\";s:4:\"6106\";s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520443657\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"325\";s:11:\"trend_index\";s:3:\"365\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:60;a:14:{s:2:\"id\";s:4:\"6114\";s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";s:10:\"1520443659\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"364\";s:11:\"trend_index\";s:3:\"385\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:61;a:14:{s:2:\"id\";s:4:\"6122\";s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";s:10:\"1520443661\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"38\";s:11:\"trend_index\";s:2:\"34\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:62;a:14:{s:2:\"id\";s:5:\"10569\";s:5:\"title\";s:15:\"Slide In | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/off_small.png\";s:12:\"tmpl_created\";s:10:\"1547967812\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/slide-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"491\";s:11:\"trend_index\";s:3:\"457\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:63;a:14:{s:2:\"id\";s:4:\"6135\";s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443663\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"85\";s:11:\"trend_index\";s:2:\"95\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:64;a:14:{s:2:\"id\";s:4:\"6144\";s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";s:10:\"1520443664\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"149\";s:11:\"trend_index\";s:3:\"161\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:65;a:14:{s:2:\"id\";s:5:\"10590\";s:5:\"title\";s:19:\"Full Screen | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pass1_small.png\";s:12:\"tmpl_created\";s:10:\"1547967978\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"479\";s:11:\"trend_index\";s:3:\"563\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:66;a:14:{s:2:\"id\";s:4:\"6152\";s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443666\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"238\";s:11:\"trend_index\";s:3:\"291\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:67;a:14:{s:2:\"id\";s:5:\"10600\";s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/orange_small.png\";s:12:\"tmpl_created\";s:10:\"1547968080\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"463\";s:11:\"trend_index\";s:3:\"417\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:68;a:14:{s:2:\"id\";s:4:\"6162\";s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443668\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"324\";s:11:\"trend_index\";s:3:\"374\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:69;a:14:{s:2:\"id\";s:4:\"6170\";s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443670\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"319\";s:11:\"trend_index\";s:3:\"328\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:70;a:14:{s:2:\"id\";s:5:\"10622\";s:5:\"title\";s:34:\"Full Screen | Contact | Headphones\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/full_hear_small.png\";s:12:\"tmpl_created\";s:10:\"1547969678\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"502\";s:11:\"trend_index\";s:3:\"460\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:71;a:14:{s:2:\"id\";s:4:\"6178\";s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443676\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"373\";s:11:\"trend_index\";s:3:\"472\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:72;a:14:{s:2:\"id\";s:5:\"10633\";s:5:\"title\";s:23:\"Slide In | Login | Lego\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small-1.png\";s:12:\"tmpl_created\";s:10:\"1547969858\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/slide-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"591\";s:11:\"trend_index\";s:3:\"584\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:73;a:14:{s:2:\"id\";s:4:\"6186\";s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443678\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"450\";s:11:\"trend_index\";s:3:\"451\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:74;a:14:{s:2:\"id\";s:5:\"10644\";s:5:\"title\";s:26:\"Fly In | Contact | Webinar\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small-1.png\";s:12:\"tmpl_created\";s:10:\"1547970814\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"446\";s:11:\"trend_index\";s:3:\"380\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:75;a:14:{s:2:\"id\";s:4:\"6196\";s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520443680\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"108\";s:11:\"trend_index\";s:3:\"101\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:76;a:14:{s:2:\"id\";s:5:\"10654\";s:5:\"title\";s:31:\"Full Screen | Login | Christmas\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/full_login_small.png\";s:12:\"tmpl_created\";s:10:\"1547970917\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/full-screen-login-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"583\";s:11:\"trend_index\";s:3:\"615\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:77;a:14:{s:2:\"id\";s:4:\"6204\";s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";s:10:\"1520443681\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"214\";s:11:\"trend_index\";s:3:\"257\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:78;a:14:{s:2:\"id\";s:5:\"10664\";s:5:\"title\";s:34:\"Slide In | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_gym_small.png\";s:12:\"tmpl_created\";s:10:\"1547973928\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"494\";s:11:\"trend_index\";s:3:\"515\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:79;a:14:{s:2:\"id\";s:4:\"6212\";s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520443684\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"77\";s:11:\"trend_index\";s:2:\"86\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:80;a:14:{s:2:\"id\";s:5:\"10675\";s:5:\"title\";s:35:\"Full Screen | Login | Gym | Fitness\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/gym_full_small.png\";s:12:\"tmpl_created\";s:10:\"1547974110\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"487\";s:11:\"trend_index\";s:3:\"463\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:81;a:14:{s:2:\"id\";s:4:\"6220\";s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520443685\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"81\";s:11:\"trend_index\";s:2:\"89\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:82;a:14:{s:2:\"id\";s:4:\"6230\";s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443687\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"370\";s:11:\"trend_index\";s:3:\"372\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:83;a:14:{s:2:\"id\";s:4:\"9719\";s:5:\"title\";s:30:\"Classic | Subscribe | Register\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/register_small.png\";s:12:\"tmpl_created\";s:10:\"1547976107\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-subscribe-register/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"437\";s:11:\"trend_index\";s:3:\"485\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:84;a:14:{s:2:\"id\";s:4:\"6239\";s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443689\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"26\";s:11:\"trend_index\";s:2:\"22\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:85;a:14:{s:2:\"id\";s:4:\"6249\";s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443691\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"57\";s:11:\"trend_index\";s:2:\"39\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:86;a:14:{s:2:\"id\";s:4:\"6258\";s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520443693\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"406\";s:11:\"trend_index\";s:3:\"426\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:87;a:14:{s:2:\"id\";s:5:\"10137\";s:5:\"title\";s:34:\"Full Screen | Contact | Restaurant\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rest_small.png\";s:12:\"tmpl_created\";s:10:\"1547976342\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"504\";s:11:\"trend_index\";s:3:\"486\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:88;a:14:{s:2:\"id\";s:4:\"6266\";s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520443695\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"51\";s:11:\"trend_index\";s:2:\"55\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:89;a:14:{s:2:\"id\";s:5:\"10244\";s:5:\"title\";s:17:\"Bottom Bar | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/wow_small.png\";s:12:\"tmpl_created\";s:10:\"1547976402\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/bottom-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"550\";s:11:\"trend_index\";s:3:\"538\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:90;a:14:{s:2:\"id\";s:4:\"6274\";s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";s:10:\"1520443698\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"96\";s:11:\"trend_index\";s:2:\"79\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:91;a:14:{s:2:\"id\";s:4:\"6017\";s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";s:10:\"1520520331\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"159\";s:11:\"trend_index\";s:3:\"190\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:92;a:14:{s:2:\"id\";s:5:\"10127\";s:5:\"title\";s:35:\"Fly In | Announcement | Maintenance\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pizza_small.png\";s:12:\"tmpl_created\";s:10:\"1547984061\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"604\";s:11:\"trend_index\";s:3:\"589\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:93;a:14:{s:2:\"id\";s:4:\"4826\";s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520520544\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"259\";s:11:\"trend_index\";s:3:\"260\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:94;a:14:{s:2:\"id\";s:4:\"4835\";s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520520546\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"377\";s:11:\"trend_index\";s:3:\"361\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:95;a:14:{s:2:\"id\";s:4:\"4843\";s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520520548\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"397\";s:11:\"trend_index\";s:3:\"443\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:96;a:14:{s:2:\"id\";s:4:\"4854\";s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520520549\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"537\";s:11:\"trend_index\";s:3:\"596\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:97;a:14:{s:2:\"id\";s:4:\"4863\";s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520520551\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"252\";s:11:\"trend_index\";s:3:\"274\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:98;a:14:{s:2:\"id\";s:5:\"10776\";s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social1_small.png\";s:12:\"tmpl_created\";s:10:\"1548047055\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"609\";s:11:\"trend_index\";s:3:\"604\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:99;a:14:{s:2:\"id\";s:4:\"4871\";s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520520552\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"241\";s:11:\"trend_index\";s:3:\"261\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:100;a:14:{s:2:\"id\";s:5:\"10785\";s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social2_small.png\";s:12:\"tmpl_created\";s:10:\"1548047593\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/fly-in-contact-social-share-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"451\";s:11:\"trend_index\";s:3:\"418\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:101;a:14:{s:2:\"id\";s:4:\"4880\";s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";s:10:\"1520520554\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"385\";s:11:\"trend_index\";s:3:\"428\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:102;a:14:{s:2:\"id\";s:4:\"4889\";s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";s:10:\"1520520556\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"473\";s:11:\"trend_index\";s:3:\"490\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:103;a:14:{s:2:\"id\";s:4:\"4897\";s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520520557\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"75\";s:11:\"trend_index\";s:2:\"63\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:104;a:14:{s:2:\"id\";s:4:\"4905\";s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520520559\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"111\";s:11:\"trend_index\";s:3:\"100\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:105;a:14:{s:2:\"id\";s:4:\"4913\";s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520520561\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"224\";s:11:\"trend_index\";s:3:\"273\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:106;a:14:{s:2:\"id\";s:4:\"4921\";s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";s:10:\"1520520562\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"213\";s:11:\"trend_index\";s:3:\"147\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:107;a:14:{s:2:\"id\";s:4:\"4929\";s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520520564\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"42\";s:11:\"trend_index\";s:2:\"37\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:108;a:14:{s:2:\"id\";s:4:\"4939\";s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";s:10:\"1520520565\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"89\";s:11:\"trend_index\";s:3:\"106\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:109;a:14:{s:2:\"id\";s:4:\"4947\";s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";s:10:\"1520520567\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"190\";s:11:\"trend_index\";s:3:\"262\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:110;a:14:{s:2:\"id\";s:4:\"4955\";s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";s:10:\"1520520569\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"332\";s:11:\"trend_index\";s:3:\"379\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:111;a:14:{s:2:\"id\";s:4:\"4963\";s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";s:10:\"1520520570\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"386\";s:11:\"trend_index\";s:3:\"497\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:112;a:14:{s:2:\"id\";s:4:\"4971\";s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";s:10:\"1520520572\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"547\";s:11:\"trend_index\";s:3:\"581\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:113;a:14:{s:2:\"id\";s:4:\"4979\";s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";s:10:\"1520520573\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"489\";s:11:\"trend_index\";s:3:\"561\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:114;a:14:{s:2:\"id\";s:4:\"4987\";s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";s:10:\"1520520575\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"144\";s:11:\"trend_index\";s:3:\"132\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:115;a:14:{s:2:\"id\";s:4:\"4995\";s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";s:10:\"1520520577\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"362\";s:11:\"trend_index\";s:3:\"330\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:116;a:14:{s:2:\"id\";s:4:\"5007\";s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520520578\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"43\";s:11:\"trend_index\";s:2:\"29\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:117;a:14:{s:2:\"id\";s:4:\"5019\";s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520520580\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"164\";s:11:\"trend_index\";s:3:\"157\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:118;a:14:{s:2:\"id\";s:4:\"5027\";s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520520581\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"295\";s:11:\"trend_index\";s:3:\"286\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:119;a:14:{s:2:\"id\";s:5:\"10794\";s:5:\"title\";s:34:\"Classic | Contact | Social | Share\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/s_small.png\";s:12:\"tmpl_created\";s:10:\"1548067619\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"436\";s:11:\"trend_index\";s:3:\"399\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:120;a:14:{s:2:\"id\";s:4:\"5037\";s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520520583\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"267\";s:11:\"trend_index\";s:3:\"245\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:121;a:14:{s:2:\"id\";s:4:\"5057\";s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520520586\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"222\";s:11:\"trend_index\";s:3:\"281\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:122;a:14:{s:2:\"id\";s:4:\"5071\";s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520520588\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"274\";s:11:\"trend_index\";s:3:\"227\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:123;a:14:{s:2:\"id\";s:5:\"10871\";s:5:\"title\";s:20:\"Bottom Bar | Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/m_small.png\";s:12:\"tmpl_created\";s:10:\"1548074396\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"608\";s:11:\"trend_index\";s:3:\"609\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:124;a:14:{s:2:\"id\";s:4:\"5082\";s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520520589\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"448\";s:11:\"trend_index\";s:3:\"524\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:125;a:14:{s:2:\"id\";s:5:\"10936\";s:5:\"title\";s:25:\"Full Screen | Toggle Menu\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/menu_small.png\";s:12:\"tmpl_created\";s:10:\"1548874587\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-toggle-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"433\";s:11:\"trend_index\";s:3:\"376\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:126;a:14:{s:2:\"id\";s:4:\"5090\";s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520520591\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"174\";s:11:\"trend_index\";s:3:\"159\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:127;a:14:{s:2:\"id\";s:4:\"5098\";s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520520593\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"152\";s:11:\"trend_index\";s:3:\"103\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:128;a:14:{s:2:\"id\";s:4:\"5107\";s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";s:10:\"1520520594\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"357\";s:11:\"trend_index\";s:3:\"342\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:129;a:14:{s:2:\"id\";s:5:\"10964\";s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/love_small.png\";s:12:\"tmpl_created\";s:10:\"1550039106\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-promotion-coupon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"564\";s:11:\"trend_index\";s:3:\"508\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:130;a:14:{s:2:\"id\";s:4:\"5115\";s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520520596\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"25\";s:11:\"trend_index\";s:2:\"18\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:131;a:14:{s:2:\"id\";s:5:\"10992\";s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/02/h_small.png\";s:12:\"tmpl_created\";s:10:\"1550072007\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-promotion-coupon-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"596\";s:11:\"trend_index\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:132;a:14:{s:2:\"id\";s:4:\"5125\";s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";s:10:\"1520520597\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"225\";s:11:\"trend_index\";s:3:\"246\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:133;a:14:{s:2:\"id\";s:5:\"11005\";s:5:\"title\";s:50:\"Classic | Promotion | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/bear_small.png\";s:12:\"tmpl_created\";s:10:\"1550073303\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-promotion-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"590\";s:11:\"trend_index\";s:3:\"557\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:134;a:14:{s:2:\"id\";s:4:\"5133\";s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";s:10:\"1520520599\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"167\";s:11:\"trend_index\";s:3:\"196\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:135;a:14:{s:2:\"id\";s:4:\"5141\";s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";s:10:\"1520520601\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"349\";s:11:\"trend_index\";s:3:\"509\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:136;a:14:{s:2:\"id\";s:4:\"5149\";s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";s:10:\"1520520602\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"343\";s:11:\"trend_index\";s:3:\"479\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:137;a:14:{s:2:\"id\";s:4:\"5542\";s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520520681\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"161\";s:11:\"trend_index\";s:3:\"207\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:138;a:14:{s:2:\"id\";s:4:\"5550\";s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520520682\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-33/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"271\";s:11:\"trend_index\";s:3:\"206\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:139;a:14:{s:2:\"id\";s:4:\"5558\";s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520520684\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"132\";s:11:\"trend_index\";s:3:\"126\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:140;a:14:{s:2:\"id\";s:4:\"5567\";s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520520685\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"162\";s:11:\"trend_index\";s:3:\"105\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:141;a:14:{s:2:\"id\";s:5:\"11231\";s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";s:10:\"1564642380\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"197\";s:11:\"trend_index\";s:2:\"85\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:142;a:14:{s:2:\"id\";s:4:\"5583\";s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520520689\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"196\";s:11:\"trend_index\";s:2:\"69\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:143;a:14:{s:2:\"id\";s:5:\"11220\";s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";s:10:\"1564642385\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"154\";s:11:\"trend_index\";s:2:\"42\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:144;a:14:{s:2:\"id\";s:4:\"5591\";s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520520691\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"125\";s:11:\"trend_index\";s:3:\"122\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:145;a:14:{s:2:\"id\";s:5:\"11204\";s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";s:10:\"1564642389\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"361\";s:11:\"trend_index\";s:3:\"239\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:146;a:14:{s:2:\"id\";s:4:\"5599\";s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520520693\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"275\";s:11:\"trend_index\";s:3:\"211\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:147;a:14:{s:2:\"id\";s:5:\"11198\";s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Header_small_3.jpg\";s:12:\"tmpl_created\";s:10:\"1564642395\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"header\",\"marketing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"61\";s:11:\"trend_index\";s:2:\"14\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:148;a:14:{s:2:\"id\";s:4:\"5607\";s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";s:10:\"1520520695\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"99\";s:11:\"trend_index\";s:2:\"10\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:149;a:14:{s:2:\"id\";s:5:\"11192\";s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";s:10:\"1564642399\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"footer\",\"marketing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"239\";s:11:\"trend_index\";s:3:\"137\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:150;a:14:{s:2:\"id\";s:4:\"5634\";s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520520699\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"171\";s:11:\"trend_index\";s:3:\"166\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:151;a:14:{s:2:\"id\";s:4:\"5642\";s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";s:10:\"1520520701\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"215\";s:11:\"trend_index\";s:3:\"232\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:152;a:14:{s:2:\"id\";s:4:\"5650\";s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520520702\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"101\";s:11:\"trend_index\";s:2:\"46\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:153;a:14:{s:2:\"id\";s:4:\"5658\";s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";s:10:\"1520520704\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"193\";s:11:\"trend_index\";s:3:\"169\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:154;a:14:{s:2:\"id\";s:4:\"5667\";s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520520705\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"150\";s:11:\"trend_index\";s:3:\"213\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:155;a:14:{s:2:\"id\";s:4:\"5675\";s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";s:10:\"1520520707\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"360\";s:11:\"trend_index\";s:3:\"392\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:156;a:14:{s:2:\"id\";s:4:\"5860\";s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";s:10:\"1520520746\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"133\";s:11:\"trend_index\";s:3:\"136\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:157;a:14:{s:2:\"id\";s:4:\"5869\";s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";s:10:\"1520520747\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"297\";s:11:\"trend_index\";s:3:\"378\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:158;a:14:{s:2:\"id\";s:4:\"5877\";s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";s:10:\"1520520749\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"469\";s:11:\"trend_index\";s:3:\"466\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:159;a:14:{s:2:\"id\";s:5:\"11468\";s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";s:10:\"1567393182\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"619\";s:11:\"trend_index\";s:3:\"595\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:160;a:14:{s:2:\"id\";s:4:\"5885\";s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";s:10:\"1520520751\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"284\";s:11:\"trend_index\";s:3:\"221\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:161;a:14:{s:2:\"id\";s:5:\"11461\";s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Header_Small.png\";s:12:\"tmpl_created\";s:10:\"1567393219\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/blocks/gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"header\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"283\";s:11:\"trend_index\";s:3:\"140\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:162;a:14:{s:2:\"id\";s:4:\"5893\";s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";s:10:\"1520520752\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"248\";s:11:\"trend_index\";s:3:\"323\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:163;a:14:{s:2:\"id\";s:5:\"11453\";s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";s:10:\"1567393224\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"footer\",\"Gym\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"339\";s:11:\"trend_index\";s:3:\"199\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:164;a:14:{s:2:\"id\";s:4:\"5904\";s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";s:10:\"1520520754\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"430\";s:11:\"trend_index\";s:3:\"560\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:165;a:14:{s:2:\"id\";s:5:\"11445\";s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";s:10:\"1567393229\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"447\";s:11:\"trend_index\";s:3:\"375\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:166;a:14:{s:2:\"id\";s:4:\"5912\";s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";s:10:\"1520520755\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"568\";s:11:\"trend_index\";s:3:\"535\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:167;a:14:{s:2:\"id\";s:5:\"11435\";s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";s:10:\"1567393296\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"434\";s:11:\"trend_index\";s:3:\"352\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:168;a:14:{s:2:\"id\";s:4:\"5921\";s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";s:10:\"1520520757\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"257\";s:11:\"trend_index\";s:3:\"258\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:169;a:14:{s:2:\"id\";s:5:\"11424\";s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";s:10:\"1567393309\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"611\";s:11:\"trend_index\";s:3:\"542\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:170;a:14:{s:2:\"id\";s:4:\"5930\";s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";s:10:\"1520520758\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"73\";s:11:\"trend_index\";s:2:\"82\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:171;a:14:{s:2:\"id\";s:4:\"5939\";s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";s:10:\"1520520760\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"176\";s:11:\"trend_index\";s:3:\"184\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:172;a:14:{s:2:\"id\";s:4:\"7596\";s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";s:10:\"1521546999\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"35\";s:11:\"trend_index\";s:2:\"35\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:173;a:14:{s:2:\"id\";s:4:\"7615\";s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";s:10:\"1521547237\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"29\";s:11:\"trend_index\";s:2:\"36\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:174;a:14:{s:2:\"id\";s:4:\"7627\";s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";s:10:\"1521547332\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"110\";s:11:\"trend_index\";s:2:\"96\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:175;a:14:{s:2:\"id\";s:5:\"11822\";s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";s:10:\"1569429896\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"586\";s:11:\"trend_index\";s:3:\"582\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:176;a:14:{s:2:\"id\";s:4:\"7638\";s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";s:10:\"1521547502\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"124\";s:11:\"trend_index\";s:3:\"123\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:177;a:14:{s:2:\"id\";s:5:\"11877\";s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";s:10:\"1569429954\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"598\";s:11:\"trend_index\";s:3:\"544\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:178;a:14:{s:2:\"id\";s:4:\"7663\";s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";s:10:\"1521547761\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"45\";s:11:\"trend_index\";s:2:\"45\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:179;a:14:{s:2:\"id\";s:5:\"11870\";s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";s:10:\"1569429964\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"579\";s:11:\"trend_index\";s:3:\"517\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:180;a:14:{s:2:\"id\";s:4:\"7650\";s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";s:10:\"1521557736\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"97\";s:11:\"trend_index\";s:3:\"127\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:181;a:14:{s:2:\"id\";s:5:\"11861\";s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";s:10:\"1569429975\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"577\";s:11:\"trend_index\";s:3:\"425\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:182;a:14:{s:2:\"id\";s:4:\"7686\";s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";s:10:\"1521558047\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"120\";s:11:\"trend_index\";s:2:\"94\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:183;a:14:{s:2:\"id\";s:5:\"11854\";s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";s:10:\"1569429983\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"488\";s:11:\"trend_index\";s:3:\"389\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:184;a:14:{s:2:\"id\";s:4:\"4676\";s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";s:10:\"1522014215\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer_7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"219\";s:11:\"trend_index\";s:3:\"267\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:185;a:14:{s:2:\"id\";s:5:\"11847\";s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";s:10:\"1569430010\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"371\";s:11:\"trend_index\";s:3:\"171\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:186;a:14:{s:2:\"id\";s:4:\"7997\";s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";s:10:\"1524582343\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-014/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"87\";s:11:\"trend_index\";s:2:\"67\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:187;a:14:{s:2:\"id\";s:5:\"11839\";s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";s:10:\"1569430015\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"327\";s:11:\"trend_index\";s:3:\"163\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:188;a:14:{s:2:\"id\";s:4:\"7982\";s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";s:10:\"1524582468\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-013/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"232\";s:11:\"trend_index\";s:3:\"186\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:189;a:14:{s:2:\"id\";s:5:\"11832\";s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";s:10:\"1569430019\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"footer\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"354\";s:11:\"trend_index\";s:3:\"176\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:190;a:14:{s:2:\"id\";s:4:\"7959\";s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";s:10:\"1524582605\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-012/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"183\";s:11:\"trend_index\";s:3:\"179\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:191;a:14:{s:2:\"id\";s:5:\"11807\";s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";s:10:\"1569430070\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"526\";s:11:\"trend_index\";s:3:\"386\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:192;a:14:{s:2:\"id\";s:4:\"7950\";s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";s:10:\"1524582631\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-011/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"253\";s:11:\"trend_index\";s:3:\"271\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:193;a:14:{s:2:\"id\";s:4:\"7937\";s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";s:10:\"1524582665\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-010/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"209\";s:11:\"trend_index\";s:3:\"180\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:194;a:14:{s:2:\"id\";s:5:\"11897\";s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";s:10:\"1569494236\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"643\";s:11:\"trend_index\";s:3:\"597\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:195;a:14:{s:2:\"id\";s:4:\"7927\";s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";s:10:\"1524582691\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"181\";s:11:\"trend_index\";s:3:\"193\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:196;a:14:{s:2:\"id\";s:5:\"11890\";s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";s:10:\"1571907344\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"376\";s:11:\"trend_index\";s:3:\"282\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:197;a:14:{s:2:\"id\";s:4:\"7917\";s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";s:10:\"1524582788\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"95\";s:11:\"trend_index\";s:2:\"72\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:198;a:14:{s:2:\"id\";s:4:\"7904\";s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";s:10:\"1524582814\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"201\";s:11:\"trend_index\";s:3:\"233\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:199;a:14:{s:2:\"id\";s:4:\"7837\";s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";s:10:\"1524582852\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"429\";s:11:\"trend_index\";s:3:\"369\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:200;a:14:{s:2:\"id\";s:4:\"7852\";s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";s:10:\"1524582875\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"216\";s:11:\"trend_index\";s:3:\"200\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:201;a:14:{s:2:\"id\";s:4:\"7862\";s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";s:10:\"1524582903\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"140\";s:11:\"trend_index\";s:3:\"160\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:202;a:14:{s:2:\"id\";s:5:\"12212\";s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";s:10:\"1572846914\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"424\";s:11:\"trend_index\";s:3:\"325\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:203;a:14:{s:2:\"id\";s:4:\"7871\";s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";s:10:\"1524582927\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"98\";s:11:\"trend_index\";s:3:\"116\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:204;a:14:{s:2:\"id\";s:5:\"12203\";s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";s:10:\"1572846925\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"554\";s:11:\"trend_index\";s:3:\"527\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:205;a:14:{s:2:\"id\";s:4:\"7884\";s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";s:10:\"1524582944\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"71\";s:11:\"trend_index\";s:3:\"156\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:206;a:14:{s:2:\"id\";s:5:\"12194\";s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/header.png\";s:12:\"tmpl_created\";s:10:\"1572846935\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"178\";s:11:\"trend_index\";s:2:\"38\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:207;a:14:{s:2:\"id\";s:4:\"7892\";s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";s:10:\"1524583015\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"116\";s:11:\"trend_index\";s:3:\"218\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:208;a:14:{s:2:\"id\";s:5:\"12179\";s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";s:10:\"1572846958\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"462\";s:11:\"trend_index\";s:3:\"298\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:209;a:14:{s:2:\"id\";s:4:\"4212\";s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443248\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"130\";s:11:\"trend_index\";s:3:\"121\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:210;a:14:{s:2:\"id\";s:4:\"7825\";s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";s:10:\"1524583273\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"78\";s:11:\"trend_index\";s:2:\"81\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:211;a:14:{s:2:\"id\";s:5:\"12170\";s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";s:10:\"1572846967\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"478\";s:11:\"trend_index\";s:3:\"309\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:212;a:14:{s:2:\"id\";s:4:\"4227\";s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443250\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"333\";s:11:\"trend_index\";s:3:\"381\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:213;a:14:{s:2:\"id\";s:4:\"7812\";s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";s:10:\"1524583298\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"109\";s:11:\"trend_index\";s:3:\"112\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:214;a:14:{s:2:\"id\";s:5:\"12164\";s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";s:10:\"1572846979\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"645\";s:11:\"trend_index\";s:3:\"593\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:215;a:14:{s:2:\"id\";s:4:\"4235\";s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443251\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"286\";s:11:\"trend_index\";s:3:\"250\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:216;a:14:{s:2:\"id\";s:4:\"7724\";s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";s:10:\"1524583367\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"32\";s:11:\"trend_index\";s:2:\"41\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:217;a:14:{s:2:\"id\";s:4:\"4244\";s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443253\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"458\";s:11:\"trend_index\";s:3:\"507\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:218;a:14:{s:2:\"id\";s:4:\"7734\";s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";s:10:\"1524583436\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"39\";s:11:\"trend_index\";s:2:\"58\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:219;a:14:{s:2:\"id\";s:4:\"4252\";s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443255\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"46\";s:11:\"trend_index\";s:2:\"31\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:220;a:14:{s:2:\"id\";s:4:\"7771\";s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";s:10:\"1524583540\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"104\";s:11:\"trend_index\";s:2:\"90\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:221;a:14:{s:2:\"id\";s:4:\"4260\";s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520443257\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"189\";s:11:\"trend_index\";s:3:\"183\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:222;a:14:{s:2:\"id\";s:4:\"7787\";s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";s:10:\"1524583598\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"107\";s:11:\"trend_index\";s:3:\"134\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:223;a:14:{s:2:\"id\";s:4:\"4268\";s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443259\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"160\";s:11:\"trend_index\";s:3:\"155\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:224;a:14:{s:2:\"id\";s:4:\"7801\";s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";s:10:\"1524583659\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"55\";s:11:\"trend_index\";s:2:\"53\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:225;a:14:{s:2:\"id\";s:4:\"4276\";s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520443261\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"344\";s:11:\"trend_index\";s:3:\"412\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:226;a:14:{s:2:\"id\";s:4:\"7754\";s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";s:10:\"1524583712\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"79\";s:11:\"trend_index\";s:3:\"162\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:227;a:14:{s:2:\"id\";s:4:\"4284\";s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443263\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"50\";s:11:\"trend_index\";s:2:\"11\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:228;a:14:{s:2:\"id\";s:4:\"7713\";s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";s:10:\"1524584780\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"48\";s:11:\"trend_index\";s:2:\"43\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:229;a:14:{s:2:\"id\";s:4:\"4293\";s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520443265\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"278\";s:11:\"trend_index\";s:3:\"272\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:230;a:14:{s:2:\"id\";s:4:\"7744\";s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";s:10:\"1524584784\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"56\";s:11:\"trend_index\";s:3:\"130\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:231;a:14:{s:2:\"id\";s:4:\"4302\";s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520443266\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"68\";s:11:\"trend_index\";s:2:\"44\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:232;a:14:{s:2:\"id\";s:5:\"12229\";s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";s:10:\"1572847842\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"552\";s:11:\"trend_index\";s:3:\"468\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:233;a:14:{s:2:\"id\";s:4:\"4313\";s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520443268\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"128\";s:11:\"trend_index\";s:3:\"117\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:234;a:14:{s:2:\"id\";s:4:\"8523\";s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";s:10:\"1526415291\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"303\";s:11:\"trend_index\";s:3:\"287\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:235;a:14:{s:2:\"id\";s:5:\"12550\";s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";s:10:\"1575960263\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"665\";s:11:\"trend_index\";s:3:\"640\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:236;a:14:{s:2:\"id\";s:4:\"4324\";s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";s:10:\"1520443270\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"292\";s:11:\"trend_index\";s:3:\"300\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:237;a:14:{s:2:\"id\";s:4:\"8524\";s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";s:10:\"1526415337\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"299\";s:11:\"trend_index\";s:3:\"371\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:238;a:14:{s:2:\"id\";s:5:\"12540\";s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";s:10:\"1575960267\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"628\";s:11:\"trend_index\";s:3:\"547\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:239;a:14:{s:2:\"id\";s:4:\"4332\";s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";s:10:\"1520443272\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"143\";s:11:\"trend_index\";s:3:\"124\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:240;a:14:{s:2:\"id\";s:4:\"8525\";s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";s:10:\"1526415374\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"457\";s:11:\"trend_index\";s:3:\"493\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:241;a:14:{s:2:\"id\";s:5:\"12492\";s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";s:10:\"1575960358\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"505\";s:11:\"trend_index\";s:3:\"364\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:242;a:14:{s:2:\"id\";s:4:\"4341\";s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";s:10:\"1520443274\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"141\";s:11:\"trend_index\";s:3:\"133\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:243;a:14:{s:2:\"id\";s:4:\"8513\";s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";s:10:\"1526415417\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"411\";s:11:\"trend_index\";s:3:\"440\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:244;a:14:{s:2:\"id\";s:5:\"12500\";s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Header_s.png\";s:12:\"tmpl_created\";s:10:\"1575960371\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"460\";s:11:\"trend_index\";s:3:\"321\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:245;a:14:{s:2:\"id\";s:4:\"4349\";s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";s:10:\"1520443275\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"314\";s:11:\"trend_index\";s:3:\"302\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:246;a:14:{s:2:\"id\";s:4:\"8512\";s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";s:10:\"1526415449\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"449\";s:11:\"trend_index\";s:3:\"525\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:247;a:14:{s:2:\"id\";s:5:\"12509\";s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";s:10:\"1575960378\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/travel-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"651\";s:11:\"trend_index\";s:3:\"651\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:248;a:14:{s:2:\"id\";s:4:\"4357\";s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";s:10:\"1520443277\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"47\";s:11:\"trend_index\";s:2:\"28\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:249;a:14:{s:2:\"id\";s:4:\"8526\";s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";s:10:\"1526415474\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"456\";s:11:\"trend_index\";s:3:\"495\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:250;a:14:{s:2:\"id\";s:5:\"12516\";s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";s:10:\"1575960387\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"519\";s:11:\"trend_index\";s:3:\"367\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:251;a:14:{s:2:\"id\";s:4:\"4368\";s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";s:10:\"1520443279\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"66\";s:11:\"trend_index\";s:2:\"70\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:252;a:14:{s:2:\"id\";s:4:\"8505\";s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";s:10:\"1526415501\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"538\";s:11:\"trend_index\";s:3:\"539\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:253;a:14:{s:2:\"id\";s:5:\"12524\";s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";s:10:\"1575960397\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"571\";s:11:\"trend_index\";s:3:\"422\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:254;a:14:{s:2:\"id\";s:4:\"4376\";s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";s:10:\"1520443281\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"145\";s:11:\"trend_index\";s:3:\"149\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:255;a:14:{s:2:\"id\";s:4:\"8511\";s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";s:10:\"1526415528\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"359\";s:11:\"trend_index\";s:3:\"461\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:256;a:14:{s:2:\"id\";s:5:\"12531\";s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";s:10:\"1575960404\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"584\";s:11:\"trend_index\";s:3:\"501\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:257;a:14:{s:2:\"id\";s:4:\"4391\";s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";s:10:\"1520443283\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"147\";s:11:\"trend_index\";s:3:\"145\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:258;a:14:{s:2:\"id\";s:4:\"8514\";s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";s:10:\"1526415558\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"410\";s:11:\"trend_index\";s:3:\"438\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:259;a:14:{s:2:\"id\";s:4:\"4400\";s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";s:10:\"1520443285\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"262\";s:11:\"trend_index\";s:3:\"304\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:260;a:14:{s:2:\"id\";s:4:\"8676\";s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";s:10:\"1527682423\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"329\";s:11:\"trend_index\";s:3:\"384\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:261;a:14:{s:2:\"id\";s:4:\"4411\";s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443287\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"93\";s:11:\"trend_index\";s:3:\"108\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:262;a:14:{s:2:\"id\";s:4:\"8678\";s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";s:10:\"1527682780\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"179\";s:11:\"trend_index\";s:3:\"235\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:263;a:14:{s:2:\"id\";s:4:\"4420\";s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443289\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"180\";s:11:\"trend_index\";s:3:\"230\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:264;a:14:{s:2:\"id\";s:4:\"8679\";s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";s:10:\"1527682847\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"195\";s:11:\"trend_index\";s:3:\"188\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:265;a:14:{s:2:\"id\";s:4:\"4428\";s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443291\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"103\";s:11:\"trend_index\";s:3:\"135\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:266;a:14:{s:2:\"id\";s:4:\"8680\";s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";s:10:\"1527682896\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"405\";s:11:\"trend_index\";s:3:\"397\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:267;a:14:{s:2:\"id\";s:4:\"4436\";s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443293\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"163\";s:11:\"trend_index\";s:3:\"231\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:268;a:14:{s:2:\"id\";s:4:\"8681\";s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";s:10:\"1527682969\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"308\";s:11:\"trend_index\";s:3:\"340\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:269;a:14:{s:2:\"id\";s:4:\"4444\";s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443295\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"91\";s:11:\"trend_index\";s:2:\"78\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:270;a:14:{s:2:\"id\";s:4:\"8682\";s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";s:10:\"1527683026\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"428\";s:11:\"trend_index\";s:3:\"491\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:271;a:14:{s:2:\"id\";s:4:\"4452\";s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443296\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"146\";s:11:\"trend_index\";s:3:\"125\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:272;a:14:{s:2:\"id\";s:4:\"8703\";s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";s:10:\"1527683072\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"401\";s:11:\"trend_index\";s:3:\"492\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:273;a:14:{s:2:\"id\";s:4:\"4460\";s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443298\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"121\";s:11:\"trend_index\";s:2:\"98\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:274;a:14:{s:2:\"id\";s:4:\"8961\";s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";s:10:\"1528639909\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"82\";s:11:\"trend_index\";s:3:\"146\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:275;a:14:{s:2:\"id\";s:4:\"4468\";s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443301\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"137\";s:11:\"trend_index\";s:3:\"111\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:276;a:14:{s:2:\"id\";s:4:\"8969\";s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";s:10:\"1528700014\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"218\";s:11:\"trend_index\";s:3:\"349\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:277;a:14:{s:2:\"id\";s:5:\"12716\";s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";s:10:\"1579060659\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"575\";s:11:\"trend_index\";s:3:\"450\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:278;a:14:{s:2:\"id\";s:4:\"4476\";s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443303\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"244\";s:11:\"trend_index\";s:3:\"234\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:279;a:14:{s:2:\"id\";s:4:\"8973\";s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";s:10:\"1528700205\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"172\";s:11:\"trend_index\";s:3:\"202\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:280;a:14:{s:2:\"id\";s:5:\"12707\";s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";s:10:\"1579060669\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"561\";s:11:\"trend_index\";s:3:\"290\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:281;a:14:{s:2:\"id\";s:4:\"4484\";s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520443305\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"323\";s:11:\"trend_index\";s:3:\"324\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:282;a:14:{s:2:\"id\";s:4:\"8977\";s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";s:10:\"1528700326\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"338\";s:11:\"trend_index\";s:3:\"415\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:283;a:14:{s:2:\"id\";s:5:\"12699\";s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";s:10:\"1579060680\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"513\";s:11:\"trend_index\";s:3:\"263\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:284;a:14:{s:2:\"id\";s:4:\"4492\";s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443307\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"44\";s:11:\"trend_index\";s:2:\"25\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:285;a:14:{s:2:\"id\";s:4:\"8981\";s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";s:10:\"1528700484\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"302\";s:11:\"trend_index\";s:3:\"332\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:286;a:14:{s:2:\"id\";s:5:\"12688\";s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";s:10:\"1579060692\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"501\";s:11:\"trend_index\";s:3:\"264\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:287;a:14:{s:2:\"id\";s:4:\"4500\";s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443308\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"441\";s:11:\"trend_index\";s:3:\"391\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:288;a:14:{s:2:\"id\";s:4:\"8985\";s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";s:10:\"1528700612\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"207\";s:11:\"trend_index\";s:3:\"237\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:289;a:14:{s:2:\"id\";s:5:\"12678\";s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Header_s.png\";s:12:\"tmpl_created\";s:10:\"1579060701\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"header\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"389\";s:11:\"trend_index\";s:3:\"141\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:290;a:14:{s:2:\"id\";s:4:\"4509\";s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443310\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"605\";s:11:\"trend_index\";s:3:\"616\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:291;a:14:{s:2:\"id\";s:4:\"8989\";s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";s:10:\"1528701063\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"198\";s:11:\"trend_index\";s:3:\"252\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:292;a:14:{s:2:\"id\";s:5:\"12669\";s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";s:10:\"1579060715\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"footer\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"517\";s:11:\"trend_index\";s:3:\"401\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:293;a:14:{s:2:\"id\";s:4:\"4521\";s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443312\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"315\";s:11:\"trend_index\";s:3:\"320\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:294;a:14:{s:2:\"id\";s:4:\"8996\";s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";s:10:\"1528701290\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"199\";s:11:\"trend_index\";s:3:\"312\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:295;a:14:{s:2:\"id\";s:5:\"12661\";s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";s:10:\"1579060722\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-search/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"535\";s:11:\"trend_index\";s:3:\"214\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:296;a:14:{s:2:\"id\";s:4:\"4529\";s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443314\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"534\";s:11:\"trend_index\";s:3:\"571\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:297;a:14:{s:2:\"id\";s:4:\"9001\";s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";s:10:\"1528701433\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"249\";s:11:\"trend_index\";s:3:\"394\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:298;a:14:{s:2:\"id\";s:5:\"12652\";s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";s:10:\"1579060730\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"563\";s:11:\"trend_index\";s:3:\"329\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:299;a:14:{s:2:\"id\";s:4:\"4537\";s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443315\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"503\";s:11:\"trend_index\";s:3:\"502\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:300;a:14:{s:2:\"id\";s:4:\"9119\";s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";s:10:\"1532428138\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/blocks/demo/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"251\";s:11:\"trend_index\";s:3:\"249\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:301;a:14:{s:2:\"id\";s:5:\"12643\";s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";s:10:\"1579060737\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"498\";s:11:\"trend_index\";s:3:\"220\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:302;a:14:{s:2:\"id\";s:4:\"4545\";s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520443317\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"602\";s:11:\"trend_index\";s:3:\"628\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:303;a:14:{s:2:\"id\";s:4:\"9127\";s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";s:10:\"1532428699\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"53\";s:11:\"trend_index\";s:3:\"102\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:304;a:14:{s:2:\"id\";s:5:\"12635\";s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";s:10:\"1579060746\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/magazine-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"626\";s:11:\"trend_index\";s:3:\"475\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:305;a:14:{s:2:\"id\";s:4:\"4553\";s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443319\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"459\";s:11:\"trend_index\";s:3:\"383\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:306;a:14:{s:2:\"id\";s:5:\"12736\";s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";s:10:\"1579060978\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"661\";s:11:\"trend_index\";s:3:\"550\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:307;a:14:{s:2:\"id\";s:4:\"4562\";s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520443322\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"593\";s:11:\"trend_index\";s:3:\"619\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:308;a:14:{s:2:\"id\";s:5:\"12726\";s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";s:10:\"1579061019\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"540\";s:11:\"trend_index\";s:3:\"277\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:309;a:14:{s:2:\"id\";s:4:\"4572\";s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443324\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"306\";s:11:\"trend_index\";s:3:\"322\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:310;a:14:{s:2:\"id\";s:4:\"9174\";s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";s:10:\"1532950125\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"54\";s:11:\"trend_index\";s:2:\"21\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:311;a:14:{s:2:\"id\";s:5:\"13089\";s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";s:10:\"1582091623\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/photography-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"662\";s:11:\"trend_index\";s:3:\"564\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:312;a:14:{s:2:\"id\";s:4:\"4580\";s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520443326\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"496\";s:11:\"trend_index\";s:3:\"521\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:313;a:14:{s:2:\"id\";s:4:\"9178\";s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";s:10:\"1532951997\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"100\";s:11:\"trend_index\";s:2:\"47\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:314;a:14:{s:2:\"id\";s:5:\"13096\";s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";s:10:\"1582091742\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"632\";s:11:\"trend_index\";s:3:\"442\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:315;a:14:{s:2:\"id\";s:4:\"4589\";s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";s:10:\"1520443327\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"607\";s:11:\"trend_index\";s:3:\"608\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:316;a:14:{s:2:\"id\";s:4:\"9180\";s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";s:10:\"1532952302\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"142\";s:11:\"trend_index\";s:2:\"84\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:317;a:14:{s:2:\"id\";s:5:\"13103\";s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";s:10:\"1582091903\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"footer\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"548\";s:11:\"trend_index\";s:3:\"266\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:318;a:14:{s:2:\"id\";s:4:\"4597\";s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520443330\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"523\";s:11:\"trend_index\";s:3:\"598\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:319;a:14:{s:2:\"id\";s:4:\"9182\";s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";s:10:\"1532952606\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"157\";s:11:\"trend_index\";s:2:\"88\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:320;a:14:{s:2:\"id\";s:5:\"13120\";s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";s:10:\"1582092351\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"654\";s:11:\"trend_index\";s:3:\"555\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:321;a:14:{s:2:\"id\";s:4:\"4605\";s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";s:10:\"1520443332\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"623\";s:11:\"trend_index\";s:3:\"602\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:322;a:14:{s:2:\"id\";s:4:\"9239\";s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";s:10:\"1532953482\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"102\";s:11:\"trend_index\";s:2:\"52\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:323;a:14:{s:2:\"id\";s:5:\"13112\";s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Header_s.png\";s:12:\"tmpl_created\";s:10:\"1582092483\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"header\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"454\";s:11:\"trend_index\";s:2:\"92\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:324;a:14:{s:2:\"id\";s:4:\"4613\";s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520443334\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"492\";s:11:\"trend_index\";s:3:\"464\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:325;a:14:{s:2:\"id\";s:4:\"9247\";s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";s:10:\"1532953793\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"118\";s:11:\"trend_index\";s:2:\"64\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:326;a:14:{s:2:\"id\";s:5:\"13129\";s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";s:10:\"1582092645\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"639\";s:11:\"trend_index\";s:3:\"533\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:327;a:14:{s:2:\"id\";s:4:\"9254\";s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";s:10:\"1532954032\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"123\";s:11:\"trend_index\";s:2:\"77\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:328;a:14:{s:2:\"id\";s:4:\"9301\";s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";s:10:\"1537440661\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"211\";s:11:\"trend_index\";s:3:\"335\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:329;a:14:{s:2:\"id\";s:4:\"9296\";s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";s:10:\"1537440673\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"191\";s:11:\"trend_index\";s:3:\"269\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:330;a:14:{s:2:\"id\";s:4:\"9313\";s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";s:10:\"1537440798\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"168\";s:11:\"trend_index\";s:3:\"216\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:331;a:14:{s:2:\"id\";s:4:\"9343\";s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";s:10:\"1537443531\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"186\";s:11:\"trend_index\";s:3:\"305\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:332;a:14:{s:2:\"id\";s:4:\"9349\";s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";s:10:\"1537443903\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"135\";s:11:\"trend_index\";s:3:\"167\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:333;a:14:{s:2:\"id\";s:4:\"4690\";s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443348\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"230\";s:11:\"trend_index\";s:3:\"238\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:334;a:14:{s:2:\"id\";s:4:\"4698\";s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443350\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"394\";s:11:\"trend_index\";s:3:\"465\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:335;a:14:{s:2:\"id\";s:4:\"4706\";s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443352\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"139\";s:11:\"trend_index\";s:3:\"209\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:336;a:14:{s:2:\"id\";s:4:\"4718\";s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443354\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"173\";s:11:\"trend_index\";s:3:\"175\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:337;a:14:{s:2:\"id\";s:4:\"4727\";s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443356\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"358\";s:11:\"trend_index\";s:3:\"363\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:338;a:14:{s:2:\"id\";s:4:\"4736\";s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443358\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"138\";s:11:\"trend_index\";s:3:\"185\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:339;a:14:{s:2:\"id\";s:4:\"4746\";s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520443360\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"258\";s:11:\"trend_index\";s:3:\"308\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:340;a:14:{s:2:\"id\";s:4:\"4759\";s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443362\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"279\";s:11:\"trend_index\";s:3:\"403\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:341;a:14:{s:2:\"id\";s:4:\"4770\";s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520443364\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/team-12-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"375\";s:11:\"trend_index\";s:3:\"454\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:342;a:14:{s:2:\"id\";s:4:\"4781\";s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520443365\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"246\";s:11:\"trend_index\";s:3:\"279\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:343;a:14:{s:2:\"id\";s:4:\"9611\";s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Sale_small_01.png\";s:12:\"tmpl_created\";s:10:\"1546965350\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/hello-bar-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"546\";s:11:\"trend_index\";s:3:\"473\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:344;a:14:{s:2:\"id\";s:5:\"13274\";s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";s:10:\"1586148723\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"668\";s:11:\"trend_index\";s:3:\"346\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:345;a:14:{s:2:\"id\";s:4:\"4793\";s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520443367\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"187\";s:11:\"trend_index\";s:3:\"242\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:346;a:14:{s:2:\"id\";s:4:\"9622\";s:5:\"title\";s:19:\"Classic | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_promotion_small_02.png\";s:12:\"tmpl_created\";s:10:\"1546965896\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"549\";s:11:\"trend_index\";s:3:\"549\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:347;a:14:{s:2:\"id\";s:5:\"13267\";s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";s:10:\"1586148728\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"666\";s:11:\"trend_index\";s:3:\"314\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:348;a:14:{s:2:\"id\";s:4:\"4801\";s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";s:10:\"1520443369\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"326\";s:11:\"trend_index\";s:3:\"348\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:349;a:14:{s:2:\"id\";s:4:\"9631\";s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";s:10:\"1546968270\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"573\";s:11:\"trend_index\";s:3:\"583\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:350;a:14:{s:2:\"id\";s:5:\"13259\";s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";s:10:\"1586148733\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"660\";s:11:\"trend_index\";s:3:\"223\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:351;a:14:{s:2:\"id\";s:4:\"4809\";s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";s:10:\"1520443371\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"270\";s:11:\"trend_index\";s:3:\"405\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:352;a:14:{s:2:\"id\";s:5:\"13251\";s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";s:10:\"1586148737\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"670\";s:11:\"trend_index\";s:3:\"639\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:353;a:14:{s:2:\"id\";s:4:\"4818\";s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";s:10:\"1520443373\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"425\";s:11:\"trend_index\";s:3:\"484\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:354;a:14:{s:2:\"id\";s:5:\"13244\";s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";s:10:\"1586148742\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"business\",\"footer\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"647\";s:11:\"trend_index\";s:3:\"168\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:355;a:14:{s:2:\"id\";s:4:\"5045\";s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443423\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"531\";s:11:\"trend_index\";s:3:\"576\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:356;a:14:{s:2:\"id\";s:4:\"9662\";s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottom-Bar_Register_small_01.png\";s:12:\"tmpl_created\";s:10:\"1547009087\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/bottom-bar-register-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"592\";s:11:\"trend_index\";s:3:\"610\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:357;a:14:{s:2:\"id\";s:5:\"13236\";s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Header.png\";s:12:\"tmpl_created\";s:10:\"1586148746\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"business\",\"header\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"578\";s:11:\"trend_index\";s:2:\"27\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:358;a:14:{s:2:\"id\";s:4:\"5157\";s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443448\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"347\";s:11:\"trend_index\";s:3:\"373\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:359;a:14:{s:2:\"id\";s:5:\"13281\";s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";s:10:\"1586148801\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"interior design\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"669\";s:11:\"trend_index\";s:3:\"592\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:360;a:14:{s:2:\"id\";s:4:\"5165\";s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443450\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"472\";s:11:\"trend_index\";s:3:\"530\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:361;a:14:{s:2:\"id\";s:4:\"5173\";s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443452\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"276\";s:11:\"trend_index\";s:3:\"219\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:362;a:14:{s:2:\"id\";s:4:\"9690\";s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_01.png\";s:12:\"tmpl_created\";s:10:\"1547011716\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"388\";s:11:\"trend_index\";s:3:\"354\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:363;a:14:{s:2:\"id\";s:4:\"5181\";s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443454\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"414\";s:11:\"trend_index\";s:3:\"423\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:364;a:14:{s:2:\"id\";s:4:\"9699\";s:5:\"title\";s:33:\"Classic | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_02.png\";s:12:\"tmpl_created\";s:10:\"1547015827\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"443\";s:11:\"trend_index\";s:3:\"421\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:365;a:14:{s:2:\"id\";s:4:\"5189\";s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443456\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"404\";s:11:\"trend_index\";s:3:\"478\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:366;a:14:{s:2:\"id\";s:4:\"5198\";s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443458\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"480\";s:11:\"trend_index\";s:3:\"430\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:367;a:14:{s:2:\"id\";s:4:\"9571\";s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/FlyIn_Login_01_small.png\";s:12:\"tmpl_created\";s:10:\"1547726151\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/fly-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"560\";s:11:\"trend_index\";s:3:\"536\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:368;a:14:{s:2:\"id\";s:4:\"5206\";s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443459\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"509\";s:11:\"trend_index\";s:3:\"594\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:369;a:14:{s:2:\"id\";s:4:\"5214\";s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443462\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"202\";s:11:\"trend_index\";s:3:\"241\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:370;a:14:{s:2:\"id\";s:4:\"5222\";s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520443464\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"387\";s:11:\"trend_index\";s:3:\"477\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:371;a:14:{s:2:\"id\";s:4:\"9740\";s:5:\"title\";s:25:\"Classic | Promotion | App\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small.png\";s:12:\"tmpl_created\";s:10:\"1547822836\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/classic-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"542\";s:11:\"trend_index\";s:3:\"573\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:372;a:14:{s:2:\"id\";s:4:\"5230\";s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443466\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"318\";s:11:\"trend_index\";s:3:\"420\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:373;a:14:{s:2:\"id\";s:4:\"5238\";s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443468\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"525\";s:11:\"trend_index\";s:3:\"531\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:374;a:14:{s:2:\"id\";s:4:\"9762\";s:5:\"title\";s:36:\"Classic | Register | Subscribe | Spa\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small_classic.png\";s:12:\"tmpl_created\";s:10:\"1547824145\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-register-subscribe-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"444\";s:11:\"trend_index\";s:3:\"453\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:375;a:14:{s:2:\"id\";s:4:\"5249\";s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520443470\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-32/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"468\";s:11:\"trend_index\";s:3:\"534\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:376;a:14:{s:2:\"id\";s:4:\"9772\";s:5:\"title\";s:27:\"Hello bar | Promotion | App\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/app_hello_small.png\";s:12:\"tmpl_created\";s:10:\"1547824279\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"644\";s:11:\"trend_index\";s:3:\"660\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:377;a:14:{s:2:\"id\";s:4:\"5257\";s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443472\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"396\";s:11:\"trend_index\";s:3:\"572\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:378;a:14:{s:2:\"id\";s:4:\"5266\";s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443474\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"113\";s:11:\"trend_index\";s:2:\"91\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:379;a:14:{s:2:\"id\";s:4:\"9793\";s:5:\"title\";s:13:\"Fly In | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_black_small.png\";s:12:\"tmpl_created\";s:10:\"1547831151\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/popups/fly-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"582\";s:11:\"trend_index\";s:3:\"662\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:380;a:14:{s:2:\"id\";s:4:\"5275\";s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443476\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"331\";s:11:\"trend_index\";s:3:\"318\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:381;a:14:{s:2:\"id\";s:4:\"5283\";s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443478\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"290\";s:11:\"trend_index\";s:3:\"341\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:382;a:14:{s:2:\"id\";s:4:\"5290\";s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";s:10:\"1520443480\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"481\";s:11:\"trend_index\";s:3:\"522\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:383;a:14:{s:2:\"id\";s:4:\"5298\";s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443482\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"408\";s:11:\"trend_index\";s:3:\"489\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:384;a:14:{s:2:\"id\";s:4:\"9836\";s:5:\"title\";s:21:\"Classic | Login | Pop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/login_b_small.png\";s:12:\"tmpl_created\";s:10:\"1547835635\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/classic-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"553\";s:11:\"trend_index\";s:3:\"575\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:385;a:14:{s:2:\"id\";s:4:\"5306\";s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";s:10:\"1520443484\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"567\";s:11:\"trend_index\";s:3:\"600\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:386;a:14:{s:2:\"id\";s:4:\"9847\";s:5:\"title\";s:25:\"Fly In | Promotion | Lego\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_in_promotion_tro.png\";s:12:\"tmpl_created\";s:10:\"1547836956\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"631\";s:11:\"trend_index\";s:3:\"617\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:387;a:14:{s:2:\"id\";s:4:\"5315\";s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";s:10:\"1520443486\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"452\";s:11:\"trend_index\";s:3:\"546\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:388;a:14:{s:2:\"id\";s:4:\"9858\";s:5:\"title\";s:27:\"Slide In | Promotion | Wine\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_promotion_wine_small.png\";s:12:\"tmpl_created\";s:10:\"1547837100\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"656\";s:11:\"trend_index\";s:3:\"650\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:389;a:14:{s:2:\"id\";s:4:\"5324\";s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";s:10:\"1520443488\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"471\";s:11:\"trend_index\";s:3:\"512\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:390;a:14:{s:2:\"id\";s:4:\"5333\";s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520443489\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"237\";s:11:\"trend_index\";s:3:\"253\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:391;a:14:{s:2:\"id\";s:4:\"5341\";s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520443491\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"524\";s:11:\"trend_index\";s:3:\"570\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:392;a:14:{s:2:\"id\";s:4:\"5349\";s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520443493\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"234\";s:11:\"trend_index\";s:3:\"280\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:393;a:14:{s:2:\"id\";s:4:\"5357\";s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";s:10:\"1520443495\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"322\";s:11:\"trend_index\";s:3:\"404\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:394;a:14:{s:2:\"id\";s:4:\"5368\";s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520443497\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"233\";s:11:\"trend_index\";s:3:\"303\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:395;a:14:{s:2:\"id\";s:4:\"5381\";s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";s:10:\"1520443499\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"182\";s:11:\"trend_index\";s:3:\"173\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:396;a:14:{s:2:\"id\";s:4:\"5389\";s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";s:10:\"1520443501\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"383\";s:11:\"trend_index\";s:3:\"360\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:397;a:14:{s:2:\"id\";s:4:\"9944\";s:5:\"title\";s:33:\"Slide In | Promotion | Headphones\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_head_small.png\";s:12:\"tmpl_created\";s:10:\"1547841939\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"633\";s:11:\"trend_index\";s:3:\"654\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:398;a:14:{s:2:\"id\";s:4:\"5397\";s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";s:10:\"1520443503\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"151\";s:11:\"trend_index\";s:3:\"164\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:399;a:14:{s:2:\"id\";s:4:\"9955\";s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_login_lock_small.png\";s:12:\"tmpl_created\";s:10:\"1547842065\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/fly-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"514\";s:11:\"trend_index\";s:3:\"396\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:400;a:14:{s:2:\"id\";s:4:\"5405\";s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";s:10:\"1520443505\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"226\";s:11:\"trend_index\";s:3:\"194\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:401;a:14:{s:2:\"id\";s:4:\"9965\";s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_moon_small.png\";s:12:\"tmpl_created\";s:10:\"1547842174\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"506\";s:11:\"trend_index\";s:3:\"514\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:402;a:14:{s:2:\"id\";s:4:\"5413\";s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";s:10:\"1520443507\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"127\";s:11:\"trend_index\";s:2:\"50\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:403;a:14:{s:2:\"id\";s:4:\"5421\";s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";s:10:\"1520443509\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"243\";s:11:\"trend_index\";s:3:\"244\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:404;a:14:{s:2:\"id\";s:4:\"5429\";s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";s:10:\"1520443510\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"86\";s:11:\"trend_index\";s:2:\"51\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:405;a:14:{s:2:\"id\";s:4:\"9995\";s:5:\"title\";s:27:\"Slide In | Sale | Christmas\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_christmas_small.png\";s:12:\"tmpl_created\";s:10:\"1547844802\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"657\";s:11:\"trend_index\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:406;a:14:{s:2:\"id\";s:4:\"5438\";s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";s:10:\"1520443512\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"206\";s:11:\"trend_index\";s:3:\"154\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:407;a:14:{s:2:\"id\";s:4:\"5447\";s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";s:10:\"1520443514\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:2:\"59\";s:11:\"trend_index\";s:2:\"33\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:408;a:14:{s:2:\"id\";s:5:\"10016\";s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Hello-Bar_Promotion_bag_small.png\";s:12:\"tmpl_created\";s:10:\"1547845062\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/hello-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"667\";s:11:\"trend_index\";s:3:\"658\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:409;a:14:{s:2:\"id\";s:4:\"5455\";s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";s:10:\"1520443516\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"136\";s:11:\"trend_index\";s:3:\"150\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:410;a:14:{s:2:\"id\";s:5:\"10026\";s:5:\"title\";s:46:\"Classic | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_register_small.png\";s:12:\"tmpl_created\";s:10:\"1547845205\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"521\";s:11:\"trend_index\";s:3:\"637\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:411;a:14:{s:2:\"id\";s:4:\"5464\";s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";s:10:\"1520443518\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"231\";s:11:\"trend_index\";s:3:\"283\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:412;a:14:{s:2:\"id\";s:5:\"10036\";s:5:\"title\";s:43:\"Full Screen | Sale | Promotion | Headphones\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_sale_head_small.png\";s:12:\"tmpl_created\";s:10:\"1547845409\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"541\";s:11:\"trend_index\";s:3:\"494\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:413;a:14:{s:2:\"id\";s:4:\"5472\";s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";s:10:\"1520443520\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"208\";s:11:\"trend_index\";s:3:\"225\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:414;a:14:{s:2:\"id\";s:4:\"5480\";s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";s:10:\"1520443522\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-4-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"412\";s:11:\"trend_index\";s:3:\"519\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:415;a:14:{s:2:\"id\";s:5:\"10057\";s:5:\"title\";s:48:\"Hello Bar | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/hello-bar_register_sport_small.png\";s:12:\"tmpl_created\";s:10:\"1547847938\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/hello-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"650\";s:11:\"trend_index\";s:3:\"657\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:416;a:14:{s:2:\"id\";s:4:\"5488\";s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";s:10:\"1520443524\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"300\";s:11:\"trend_index\";s:3:\"459\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:417;a:14:{s:2:\"id\";s:4:\"5496\";s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";s:10:\"1520443526\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"466\";s:11:\"trend_index\";s:3:\"476\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:418;a:14:{s:2:\"id\";s:4:\"5504\";s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";s:10:\"1520443528\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"105\";s:11:\"trend_index\";s:3:\"142\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:419;a:14:{s:2:\"id\";s:5:\"10087\";s:5:\"title\";s:25:\"Full Screen | Login | Spa\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2019/01/full-screen_login_spa_small.png\";s:12:\"tmpl_created\";s:10:\"1547848301\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-login-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"557\";s:11:\"trend_index\";s:3:\"449\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:420;a:14:{s:2:\"id\";s:4:\"5515\";s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";s:10:\"1520443530\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"272\";s:11:\"trend_index\";s:3:\"297\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:421;a:14:{s:2:\"id\";s:5:\"10097\";s:5:\"title\";s:37:\"Classic | Register | Subscribe | Lego\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_lego_small.png\";s:12:\"tmpl_created\";s:10:\"1547848411\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"0\";s:16:\"popularity_index\";s:3:\"594\";s:11:\"trend_index\";s:3:\"552\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:422;a:14:{s:2:\"id\";s:4:\"1190\";s:5:\"title\";s:26:\"Landing Page &#8211; Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp2-l.png\";s:12:\"tmpl_created\";s:10:\"1490707391\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/landing-page-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"1\";s:16:\"popularity_index\";s:1:\"4\";s:11:\"trend_index\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:423;a:14:{s:2:\"id\";s:4:\"9816\";s:5:\"title\";s:30:\"Classic | Sale | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_sale_sport_small.png\";s:12:\"tmpl_created\";s:10:\"1547991876\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"1\";s:16:\"popularity_index\";s:3:\"603\";s:11:\"trend_index\";s:3:\"624\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:424;a:14:{s:2:\"id\";s:4:\"9602\";s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottombar_Announcement_small_01.png\";s:12:\"tmpl_created\";s:10:\"1546964559\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/bottom-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"1\";s:16:\"popularity_index\";s:3:\"539\";s:11:\"trend_index\";s:3:\"500\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:425;a:14:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:27:\"Homepage &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0016.png\";s:12:\"tmpl_created\";s:10:\"1470829872\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Homepage\",\"Restaurant\"]\";s:10:\"menu_order\";s:1:\"2\";s:16:\"popularity_index\";s:1:\"1\";s:11:\"trend_index\";s:1:\"2\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:426;a:14:{s:2:\"id\";s:3:\"463\";s:5:\"title\";s:22:\"Homepage &#8211; Study\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0022.png\";s:12:\"tmpl_created\";s:10:\"1477388340\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/homepage-study/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Education\",\"Homepage\",\"Study\"]\";s:10:\"menu_order\";s:1:\"3\";s:16:\"popularity_index\";s:1:\"5\";s:11:\"trend_index\";s:1:\"4\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:427;a:14:{s:2:\"id\";s:5:\"10277\";s:5:\"title\";s:36:\"Bottom Bar | Promotion | Sale | Book\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/book_small.png\";s:12:\"tmpl_created\";s:10:\"1548055999\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/bottom-bar-promotion-book/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"3\";s:16:\"popularity_index\";s:3:\"618\";s:11:\"trend_index\";s:3:\"652\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:428;a:14:{s:2:\"id\";s:5:\"11241\";s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";s:10:\"1564643043\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"3\";s:16:\"popularity_index\";s:3:\"392\";s:11:\"trend_index\";s:3:\"247\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:429;a:14:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:23:\"Homepage &#8211; Agency\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0019.png\";s:12:\"tmpl_created\";s:10:\"1470826567\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/homepage-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";s:1:\"4\";s:16:\"popularity_index\";s:1:\"3\";s:11:\"trend_index\";s:1:\"3\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:430;a:14:{s:2:\"id\";s:4:\"9903\";s:5:\"title\";s:34:\"Bottom Bar | Promotion | Olive Oil\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom-bar_promotion_olive_small.png\";s:12:\"tmpl_created\";s:10:\"1547838896\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"4\";s:16:\"popularity_index\";s:3:\"648\";s:11:\"trend_index\";s:3:\"647\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:431;a:14:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:19:\"Product &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0003.png\";s:12:\"tmpl_created\";s:10:\"1470829879\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/product-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"5\";s:16:\"popularity_index\";s:1:\"8\";s:11:\"trend_index\";s:1:\"5\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:432;a:14:{s:2:\"id\";s:5:\"10549\";s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/com_small.png\";s:12:\"tmpl_created\";s:10:\"1547967595\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/bottom-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"6\";s:16:\"popularity_index\";s:3:\"613\";s:11:\"trend_index\";s:3:\"659\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:433;a:14:{s:2:\"id\";s:5:\"13187\";s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";s:10:\"1586148661\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/interior-design-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"6\";s:16:\"popularity_index\";s:3:\"620\";s:11:\"trend_index\";s:2:\"83\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:434;a:14:{s:2:\"id\";s:5:\"13199\";s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";s:10:\"1586148666\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/interior-design-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"7\";s:16:\"popularity_index\";s:3:\"621\";s:11:\"trend_index\";s:2:\"87\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:435;a:14:{s:2:\"id\";s:5:\"13214\";s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";s:10:\"1586148672\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/interior-design-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"8\";s:16:\"popularity_index\";s:3:\"630\";s:11:\"trend_index\";s:3:\"113\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:436;a:14:{s:2:\"id\";s:5:\"10529\";s:5:\"title\";s:36:\"Classic | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/icon_small.png\";s:12:\"tmpl_created\";s:10:\"1548046309\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:1:\"9\";s:16:\"popularity_index\";s:3:\"438\";s:11:\"trend_index\";s:3:\"357\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:437;a:14:{s:2:\"id\";s:5:\"13229\";s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";s:10:\"1586148677\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/interior-design-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";s:1:\"9\";s:16:\"popularity_index\";s:3:\"638\";s:11:\"trend_index\";s:3:\"119\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:438;a:14:{s:2:\"id\";s:5:\"12948\";s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";s:10:\"1582093442\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/photography-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"10\";s:16:\"popularity_index\";s:3:\"384\";s:11:\"trend_index\";s:3:\"107\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:439;a:14:{s:2:\"id\";s:5:\"12798\";s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";s:10:\"1582093446\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/photography-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"11\";s:16:\"popularity_index\";s:3:\"533\";s:11:\"trend_index\";s:3:\"355\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:440;a:14:{s:2:\"id\";s:5:\"12868\";s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";s:10:\"1582093450\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/photography-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"12\";s:16:\"popularity_index\";s:3:\"558\";s:11:\"trend_index\";s:3:\"284\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:441;a:14:{s:2:\"id\";s:5:\"13056\";s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";s:10:\"1582093454\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/photography-wildlife/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"13\";s:16:\"popularity_index\";s:3:\"574\";s:11:\"trend_index\";s:3:\"334\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:442;a:14:{s:2:\"id\";s:5:\"12922\";s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";s:10:\"1582093457\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"14\";s:16:\"popularity_index\";s:3:\"595\";s:11:\"trend_index\";s:3:\"471\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:443;a:14:{s:2:\"id\";s:5:\"12875\";s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";s:10:\"1582093461\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"15\";s:16:\"popularity_index\";s:3:\"642\";s:11:\"trend_index\";s:3:\"427\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:444;a:14:{s:2:\"id\";s:5:\"12962\";s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";s:10:\"1582093465\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/photography-nature/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"16\";s:16:\"popularity_index\";s:3:\"585\";s:11:\"trend_index\";s:3:\"414\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:445;a:14:{s:2:\"id\";s:5:\"10413\";s:5:\"title\";s:28:\"Classic | Content Lock | Pop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/hot_small.png\";s:12:\"tmpl_created\";s:10:\"1547961774\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"17\";s:16:\"popularity_index\";s:3:\"634\";s:11:\"trend_index\";s:3:\"648\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:446;a:14:{s:2:\"id\";s:5:\"12833\";s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";s:10:\"1582093469\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"17\";s:16:\"popularity_index\";s:3:\"600\";s:11:\"trend_index\";s:3:\"458\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:447;a:14:{s:2:\"id\";s:5:\"12898\";s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";s:10:\"1582093473\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"18\";s:16:\"popularity_index\";s:3:\"635\";s:11:\"trend_index\";s:3:\"462\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:448;a:14:{s:2:\"id\";s:5:\"10223\";s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/welcome_small.png\";s:12:\"tmpl_created\";s:10:\"1547887343\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"19\";s:16:\"popularity_index\";s:3:\"453\";s:11:\"trend_index\";s:3:\"470\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:449;a:14:{s:2:\"id\";s:5:\"10559\";s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_small.png\";s:12:\"tmpl_created\";s:10:\"1547967711\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/bottom-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"19\";s:16:\"popularity_index\";s:3:\"597\";s:11:\"trend_index\";s:3:\"633\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:450;a:14:{s:2:\"id\";s:5:\"12994\";s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";s:10:\"1582093477\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/photography-pets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"19\";s:16:\"popularity_index\";s:3:\"606\";s:11:\"trend_index\";s:3:\"436\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:451;a:14:{s:2:\"id\";s:5:\"10403\";s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_small.png\";s:12:\"tmpl_created\";s:10:\"1548056371\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"20\";s:16:\"popularity_index\";s:3:\"543\";s:11:\"trend_index\";s:3:\"540\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:452;a:14:{s:2:\"id\";s:5:\"12805\";s:5:\"title\";s:38:\"Photography &#8211; B&#038;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";s:10:\"1582093481\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/photography-bw-portraits/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"20\";s:16:\"popularity_index\";s:3:\"646\";s:11:\"trend_index\";s:3:\"520\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:453;a:14:{s:2:\"id\";s:5:\"13031\";s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";s:10:\"1582093484\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"21\";s:16:\"popularity_index\";s:3:\"622\";s:11:\"trend_index\";s:3:\"496\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:454;a:14:{s:2:\"id\";s:4:\"9913\";s:5:\"title\";s:27:\"Classic | Login | Christmas\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/log_small.png\";s:12:\"tmpl_created\";s:10:\"1547841430\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"21\";s:16:\"popularity_index\";s:3:\"510\";s:11:\"trend_index\";s:3:\"506\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:455;a:14:{s:2:\"id\";s:5:\"12621\";s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";s:10:\"1579060604\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/magazine-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";s:2:\"22\";s:16:\"popularity_index\";s:3:\"310\";s:11:\"trend_index\";s:2:\"60\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:456;a:14:{s:2:\"id\";s:5:\"12352\";s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";s:10:\"1575960464\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:2:\"23\";s:16:\"popularity_index\";s:3:\"336\";s:11:\"trend_index\";s:3:\"204\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:457;a:14:{s:2:\"id\";s:5:\"12400\";s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";s:10:\"1575960441\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:2:\"24\";s:16:\"popularity_index\";s:3:\"439\";s:11:\"trend_index\";s:3:\"338\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:458;a:14:{s:2:\"id\";s:5:\"12479\";s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";s:10:\"1575960474\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:2:\"25\";s:16:\"popularity_index\";s:3:\"497\";s:11:\"trend_index\";s:3:\"413\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:459;a:14:{s:2:\"id\";s:5:\"12466\";s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";s:10:\"1575960469\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-testimonials/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:2:\"26\";s:16:\"popularity_index\";s:3:\"511\";s:11:\"trend_index\";s:3:\"382\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:460;a:14:{s:2:\"id\";s:4:\"9592\";s:5:\"title\";s:26:\"Classic | Promotion | Sale\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Promotion_small_01.png\";s:12:\"tmpl_created\";s:10:\"1546963720\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"26\";s:16:\"popularity_index\";s:3:\"576\";s:11:\"trend_index\";s:3:\"585\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:461;a:14:{s:2:\"id\";s:5:\"10210\";s:5:\"title\";s:29:\"Classic | Promotion | Webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-1.png\";s:12:\"tmpl_created\";s:10:\"1547886103\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"27\";s:16:\"popularity_index\";s:3:\"663\";s:11:\"trend_index\";s:3:\"644\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:462;a:14:{s:2:\"id\";s:5:\"12443\";s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";s:10:\"1575960459\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/travel-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:2:\"27\";s:16:\"popularity_index\";s:3:\"484\";s:11:\"trend_index\";s:3:\"393\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:463;a:14:{s:2:\"id\";s:5:\"12431\";s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";s:10:\"1575960453\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/travel-faq/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:2:\"28\";s:16:\"popularity_index\";s:3:\"522\";s:11:\"trend_index\";s:3:\"295\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:464;a:14:{s:2:\"id\";s:5:\"12421\";s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";s:10:\"1575960445\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-contact-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";s:2:\"29\";s:16:\"popularity_index\";s:3:\"532\";s:11:\"trend_index\";s:3:\"446\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:465;a:14:{s:2:\"id\";s:5:\"11763\";s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";s:10:\"1569428959\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/portfolio-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"30\";s:16:\"popularity_index\";s:3:\"305\";s:11:\"trend_index\";s:3:\"212\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:466;a:14:{s:2:\"id\";s:5:\"10047\";s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/yellow_small.png\";s:12:\"tmpl_created\";s:10:\"1547847757\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"30\";s:16:\"popularity_index\";s:3:\"483\";s:11:\"trend_index\";s:3:\"370\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:467;a:14:{s:2:\"id\";s:5:\"11781\";s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";s:10:\"1569428955\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/portfolio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"31\";s:16:\"popularity_index\";s:3:\"365\";s:11:\"trend_index\";s:3:\"285\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:468;a:14:{s:2:\"id\";s:4:\"9879\";s:5:\"title\";s:38:\"Classic | Register | Subscribe | Leads\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/dog_small.png\";s:12:\"tmpl_created\";s:10:\"1547838416\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"31\";s:16:\"popularity_index\";s:3:\"580\";s:11:\"trend_index\";s:3:\"611\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:469;a:14:{s:2:\"id\";s:5:\"11793\";s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";s:10:\"1569428951\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/portfolio-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"32\";s:16:\"popularity_index\";s:3:\"422\";s:11:\"trend_index\";s:3:\"347\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:470;a:14:{s:2:\"id\";s:5:\"11800\";s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";s:10:\"1569428946\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/portfolio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";s:2:\"33\";s:16:\"popularity_index\";s:3:\"467\";s:11:\"trend_index\";s:3:\"333\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:471;a:14:{s:2:\"id\";s:5:\"11163\";s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";s:10:\"1564641877\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/digital-agency-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:2:\"34\";s:16:\"popularity_index\";s:2:\"90\";s:11:\"trend_index\";s:2:\"32\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:472;a:14:{s:2:\"id\";s:5:\"10297\";s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/s_yellow_small.png\";s:12:\"tmpl_created\";s:10:\"1548056099\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"35\";s:16:\"popularity_index\";s:3:\"520\";s:11:\"trend_index\";s:3:\"469\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:473;a:14:{s:2:\"id\";s:5:\"11129\";s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";s:10:\"1564641889\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/digital-agency-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:2:\"35\";s:16:\"popularity_index\";s:3:\"220\";s:11:\"trend_index\";s:3:\"131\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:474;a:14:{s:2:\"id\";s:5:\"10393\";s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small.png\";s:12:\"tmpl_created\";s:10:\"1548056682\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"36\";s:16:\"popularity_index\";s:3:\"588\";s:11:\"trend_index\";s:3:\"635\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:475;a:14:{s:2:\"id\";s:5:\"11074\";s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";s:10:\"1564641872\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/digital-agency-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:2:\"36\";s:16:\"popularity_index\";s:3:\"184\";s:11:\"trend_index\";s:2:\"93\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:476;a:14:{s:2:\"id\";s:5:\"11056\";s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";s:10:\"1564641867\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/digital-agency-social-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:2:\"37\";s:16:\"popularity_index\";s:3:\"312\";s:11:\"trend_index\";s:3:\"195\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:477;a:14:{s:2:\"id\";s:5:\"10579\";s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/sale1_small.png\";s:12:\"tmpl_created\";s:10:\"1547967887\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"38\";s:16:\"popularity_index\";s:3:\"612\";s:11:\"trend_index\";s:3:\"636\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:478;a:14:{s:2:\"id\";s:5:\"11094\";s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";s:10:\"1564641885\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/digital-agency-clients/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:2:\"38\";s:16:\"popularity_index\";s:3:\"417\";s:11:\"trend_index\";s:3:\"316\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:479;a:14:{s:2:\"id\";s:5:\"11034\";s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";s:10:\"1564641881\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/contact-digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";s:2:\"39\";s:16:\"popularity_index\";s:3:\"227\";s:11:\"trend_index\";s:2:\"97\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:480;a:14:{s:2:\"id\";s:3:\"519\";s:5:\"title\";s:24:\"Homepage &#8211; Fitness\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0023.png\";s:12:\"tmpl_created\";s:10:\"1477388808\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/homepage-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Fitness\",\"Gym\",\"Health\",\"Homepage\",\"Sport\"]\";s:10:\"menu_order\";s:2:\"40\";s:16:\"popularity_index\";s:1:\"9\";s:11:\"trend_index\";s:2:\"30\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:481;a:14:{s:2:\"id\";s:4:\"9139\";s:5:\"title\";s:25:\"Homepage &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/07/Get_Started_250.png\";s:12:\"tmpl_created\";s:10:\"1532949924\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:167:\"[\"Agency\",\"bootstrap\",\"business\",\"corporate\",\"Landing Page\",\"marketing campaign\",\"marketing landing page\",\"product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";s:2:\"41\";s:16:\"popularity_index\";s:1:\"6\";s:11:\"trend_index\";s:1:\"9\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:482;a:14:{s:2:\"id\";s:4:\"1504\";s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app2.png\";s:12:\"tmpl_created\";s:10:\"1494352112\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"42\";s:16:\"popularity_index\";s:3:\"148\";s:11:\"trend_index\";s:3:\"256\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:483;a:14:{s:2:\"id\";s:5:\"10180\";s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_small.png\";s:12:\"tmpl_created\";s:10:\"1548045309\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"43\";s:16:\"popularity_index\";s:3:\"589\";s:11:\"trend_index\";s:3:\"548\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:484;a:14:{s:2:\"id\";s:4:\"1503\";s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app1.png\";s:12:\"tmpl_created\";s:10:\"1494352113\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"43\";s:16:\"popularity_index\";s:3:\"153\";s:11:\"trend_index\";s:3:\"153\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:485;a:14:{s:2:\"id\";s:4:\"1634\";s:5:\"title\";s:33:\"Landing Page &#8211; Chiropractor\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Chiropractor.png\";s:12:\"tmpl_created\";s:10:\"1494352119\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-chiropractor/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"44\";s:16:\"popularity_index\";s:3:\"204\";s:11:\"trend_index\";s:3:\"240\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:486;a:14:{s:2:\"id\";s:5:\"12155\";s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";s:10:\"1572847054\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/law-firm-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:2:\"45\";s:16:\"popularity_index\";s:3:\"281\";s:11:\"trend_index\";s:3:\"109\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:487;a:14:{s:2:\"id\";s:4:\"9731\";s:5:\"title\";s:26:\"Classic | Sale | Promotion\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/icecream_small.png\";s:12:\"tmpl_created\";s:10:\"1547976166\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/classic-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"46\";s:16:\"popularity_index\";s:3:\"555\";s:11:\"trend_index\";s:3:\"499\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:488;a:14:{s:2:\"id\";s:5:\"12143\";s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";s:10:\"1572847069\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/law-firm-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:2:\"46\";s:16:\"popularity_index\";s:3:\"427\";s:11:\"trend_index\";s:3:\"224\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:489;a:14:{s:2:\"id\";s:5:\"12133\";s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";s:10:\"1572847078\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-careers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:2:\"47\";s:16:\"popularity_index\";s:3:\"565\";s:11:\"trend_index\";s:3:\"488\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:490;a:14:{s:2:\"id\";s:5:\"12124\";s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";s:10:\"1572847096\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/law-firm-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:2:\"48\";s:16:\"popularity_index\";s:3:\"465\";s:11:\"trend_index\";s:3:\"268\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:491;a:14:{s:2:\"id\";s:5:\"12116\";s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";s:10:\"1572847105\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:2:\"49\";s:16:\"popularity_index\";s:3:\"486\";s:11:\"trend_index\";s:3:\"311\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:492;a:14:{s:2:\"id\";s:5:\"12091\";s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";s:10:\"1572847113\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/law-firm-team/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:2:\"50\";s:16:\"popularity_index\";s:3:\"419\";s:11:\"trend_index\";s:3:\"228\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:493;a:14:{s:2:\"id\";s:5:\"11572\";s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";s:10:\"1567392934\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:2:\"51\";s:16:\"popularity_index\";s:3:\"544\";s:11:\"trend_index\";s:3:\"455\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:494;a:14:{s:2:\"id\";s:5:\"12080\";s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";s:10:\"1572847120\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-partner/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:2:\"51\";s:16:\"popularity_index\";s:3:\"551\";s:11:\"trend_index\";s:3:\"402\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:495;a:14:{s:2:\"id\";s:5:\"11506\";s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";s:10:\"1567392930\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:2:\"52\";s:16:\"popularity_index\";s:3:\"527\";s:11:\"trend_index\";s:3:\"407\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:496;a:14:{s:2:\"id\";s:5:\"12044\";s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";s:10:\"1572847130\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";s:2:\"52\";s:16:\"popularity_index\";s:3:\"470\";s:11:\"trend_index\";s:3:\"315\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:497;a:14:{s:2:\"id\";s:5:\"11536\";s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";s:10:\"1567392927\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:2:\"53\";s:16:\"popularity_index\";s:3:\"566\";s:11:\"trend_index\";s:3:\"553\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:498;a:14:{s:2:\"id\";s:5:\"11545\";s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";s:10:\"1567392943\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/gym-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:2:\"53\";s:16:\"popularity_index\";s:3:\"328\";s:11:\"trend_index\";s:3:\"344\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:499;a:14:{s:2:\"id\";s:5:\"11563\";s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";s:10:\"1567392923\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:2:\"54\";s:16:\"popularity_index\";s:3:\"528\";s:11:\"trend_index\";s:3:\"523\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:500;a:14:{s:2:\"id\";s:5:\"11478\";s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";s:10:\"1567392939\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:99:\"https://library.elementor.com/gym-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:2:\"54\";s:16:\"popularity_index\";s:3:\"455\";s:11:\"trend_index\";s:3:\"398\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:501;a:14:{s:2:\"id\";s:5:\"10005\";s:5:\"title\";s:38:\"Fly In | Promotion | Spa | Body Lotion\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/Flyin_lotion_small.png\";s:12:\"tmpl_created\";s:10:\"1547844909\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"54\";s:16:\"popularity_index\";s:3:\"637\";s:11:\"trend_index\";s:3:\"663\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:502;a:14:{s:2:\"id\";s:5:\"10424\";s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/flower_small.png\";s:12:\"tmpl_created\";s:10:\"1547961866\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"55\";s:16:\"popularity_index\";s:3:\"572\";s:11:\"trend_index\";s:3:\"567\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:503;a:14:{s:2:\"id\";s:5:\"11528\";s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";s:10:\"1567392917\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";s:2:\"55\";s:16:\"popularity_index\";s:3:\"493\";s:11:\"trend_index\";s:3:\"483\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:504;a:14:{s:2:\"id\";s:4:\"9975\";s:5:\"title\";s:24:\"Fly In | Promotion | App\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_webinar_app_small.png\";s:12:\"tmpl_created\";s:10:\"1547842284\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/fly-in-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"55\";s:16:\"popularity_index\";s:3:\"658\";s:11:\"trend_index\";s:3:\"630\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:505;a:14:{s:2:\"id\";s:3:\"487\";s:5:\"title\";s:29:\"Landing Page &#8211; Vacation\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0021.png\";s:12:\"tmpl_created\";s:10:\"1477388357\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-vacation/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"56\";s:16:\"popularity_index\";s:2:\"24\";s:11:\"trend_index\";s:2:\"66\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:506;a:14:{s:2:\"id\";s:5:\"10067\";s:5:\"title\";s:31:\"Fly In | Announcement | Cookies\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/fly-in_cookie_yellow_small.png\";s:12:\"tmpl_created\";s:10:\"1547848075\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/fly-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"56\";s:16:\"popularity_index\";s:3:\"518\";s:11:\"trend_index\";s:3:\"474\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:507;a:14:{s:2:\"id\";s:3:\"855\";s:5:\"title\";s:37:\"Landing Page &#8211; Personal Trainer\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Personal-Trainer.png\";s:12:\"tmpl_created\";s:10:\"1494352061\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/landing-page-personal-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"57\";s:16:\"popularity_index\";s:3:\"247\";s:11:\"trend_index\";s:3:\"288\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:508;a:14:{s:2:\"id\";s:3:\"955\";s:5:\"title\";s:31:\"Landing Page &#8211; Law Office\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Law-Office.png\";s:12:\"tmpl_created\";s:10:\"1494352069\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-law-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:31:\"[\"Landing Page\",\"Law\",\"Office\"]\";s:10:\"menu_order\";s:2:\"58\";s:16:\"popularity_index\";s:3:\"165\";s:11:\"trend_index\";s:3:\"208\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:509;a:14:{s:2:\"id\";s:5:\"10329\";s:5:\"title\";s:25:\"Fly In | Sale | Promotion\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/organic_small.png\";s:12:\"tmpl_created\";s:10:\"1547893478\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"59\";s:16:\"popularity_index\";s:3:\"664\";s:11:\"trend_index\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:510;a:14:{s:2:\"id\";s:4:\"9373\";s:5:\"title\";s:33:\"Landing Page &#8211; Conference 5\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/11/conference-250.png\";s:12:\"tmpl_created\";s:10:\"1542811219\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"59\";s:16:\"popularity_index\";s:3:\"235\";s:11:\"trend_index\";s:3:\"366\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:511;a:14:{s:2:\"id\";s:3:\"974\";s:5:\"title\";s:28:\"Landing Page &#8211; Stylist\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/03/Landing-Page-Stylist.png\";s:12:\"tmpl_created\";s:10:\"1494352071\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-stylist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"cosmetics\",\"fashion\",\"girly\",\"hairdresser\",\"lifestyle\",\"makeup\",\"manicure\",\"pedicure\",\"products\",\"salon\",\"Shop\",\"skincare\",\"stylist\",\"wellness\"]\";s:10:\"menu_order\";s:2:\"60\";s:16:\"popularity_index\";s:3:\"288\";s:11:\"trend_index\";s:3:\"532\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:512;a:14:{s:2:\"id\";s:4:\"9650\";s:5:\"title\";s:36:\"Fly In | Register | Subscribe | Sale\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/Fly-In_Register_small_01a.png\";s:12:\"tmpl_created\";s:10:\"1547007598\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/fly-in-register_big-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"60\";s:16:\"popularity_index\";s:3:\"652\";s:11:\"trend_index\";s:3:\"655\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:513;a:14:{s:2:\"id\";s:5:\"11948\";s:5:\"title\";s:18:\"Maintenance Mode 3\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm3.png\";s:12:\"tmpl_created\";s:10:\"1572153978\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";s:2:\"61\";s:16:\"popularity_index\";s:3:\"269\";s:11:\"trend_index\";s:3:\"138\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:514;a:14:{s:2:\"id\";s:3:\"754\";s:5:\"title\";s:25:\"Services &#8211; Interior\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/Interior-Services.png\";s:12:\"tmpl_created\";s:10:\"1485269691\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/services-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"62\";s:16:\"popularity_index\";s:3:\"223\";s:11:\"trend_index\";s:3:\"254\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:515;a:14:{s:2:\"id\";s:3:\"752\";s:5:\"title\";s:24:\"Contact &#8211; Interior\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/01/interior-contact.png\";s:12:\"tmpl_created\";s:10:\"1485269737\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/contact-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"63\";s:16:\"popularity_index\";s:3:\"291\";s:11:\"trend_index\";s:3:\"327\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:516;a:14:{s:2:\"id\";s:5:\"10200\";s:5:\"title\";s:33:\"Full Screen | Content Lock | Wine\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/lock_wine_small.png\";s:12:\"tmpl_created\";s:10:\"1548055635\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/full-screen-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"63\";s:16:\"popularity_index\";s:3:\"614\";s:11:\"trend_index\";s:3:\"642\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:517;a:14:{s:2:\"id\";s:3:\"753\";s:5:\"title\";s:22:\"About &#8211; Interior\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/01/Interior-About.png\";s:12:\"tmpl_created\";s:10:\"1485269710\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/about-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"64\";s:16:\"popularity_index\";s:3:\"273\";s:11:\"trend_index\";s:3:\"275\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:518;a:14:{s:2:\"id\";s:5:\"10287\";s:5:\"title\";s:34:\"Full Screen | Register | Subscribe\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_pink_small.png\";s:12:\"tmpl_created\";s:10:\"1547994301\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"64\";s:16:\"popularity_index\";s:3:\"529\";s:11:\"trend_index\";s:3:\"558\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:519;a:14:{s:2:\"id\";s:3:\"751\";s:5:\"title\";s:25:\"Homepage &#8211; Interior\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/01/interior-home.png\";s:12:\"tmpl_created\";s:10:\"1485269743\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"65\";s:16:\"popularity_index\";s:3:\"229\";s:11:\"trend_index\";s:3:\"307\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:520;a:14:{s:2:\"id\";s:4:\"2402\";s:5:\"title\";s:32:\"Homepage &#8211; Interior Design\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2017/09/Interior.png\";s:12:\"tmpl_created\";s:10:\"1506441447\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/homepage-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:193:\"[\"Architecture\",\"building\",\"business\",\"Creative\",\"exterior design\",\"furniture design\",\"Gallery\",\"garden design\",\"house\",\"interior design\",\"landscape design\",\"multipurpose\",\"portfolio\",\"studio\"]\";s:10:\"menu_order\";s:2:\"66\";s:16:\"popularity_index\";s:2:\"84\";s:11:\"trend_index\";s:3:\"143\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:521;a:14:{s:2:\"id\";s:4:\"9889\";s:5:\"title\";s:28:\"Full Screen | Login | Cactus\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/cac_small.png\";s:12:\"tmpl_created\";s:10:\"1547838722\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/full-screen-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"66\";s:16:\"popularity_index\";s:3:\"636\";s:11:\"trend_index\";s:3:\"632\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:522;a:14:{s:2:\"id\";s:4:\"3626\";s:5:\"title\";s:30:\"Snowboard Site &#8211; Contact\";s:9:\"thumbnail\";s:62:\"https://library.elementor.com/wp-content/uploads/2017/12/3.png\";s:12:\"tmpl_created\";s:10:\"1513513193\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/snowboard-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"67\";s:16:\"popularity_index\";s:3:\"240\";s:11:\"trend_index\";s:3:\"362\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:523;a:14:{s:2:\"id\";s:5:\"10077\";s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_register_blue_small.png\";s:12:\"tmpl_created\";s:10:\"1547848197\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/fly-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"67\";s:16:\"popularity_index\";s:3:\"475\";s:11:\"trend_index\";s:3:\"432\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:524;a:14:{s:2:\"id\";s:5:\"11966\";s:5:\"title\";s:18:\"Maintenance mode 4\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm4.png\";s:12:\"tmpl_created\";s:10:\"1572154274\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";s:2:\"68\";s:16:\"popularity_index\";s:3:\"530\";s:11:\"trend_index\";s:3:\"439\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:525;a:14:{s:2:\"id\";s:5:\"10362\";s:5:\"title\";s:32:\"Full Screen | Login | Restaurant\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/vip_small.png\";s:12:\"tmpl_created\";s:10:\"1548056253\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"69\";s:16:\"popularity_index\";s:3:\"556\";s:11:\"trend_index\";s:3:\"574\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:526;a:14:{s:2:\"id\";s:4:\"3632\";s:5:\"title\";s:31:\"Snowboard Site &#8211; Services\";s:9:\"thumbnail\";s:62:\"https://library.elementor.com/wp-content/uploads/2017/12/2.png\";s:12:\"tmpl_created\";s:10:\"1513513171\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/snowboard-site-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"69\";s:16:\"popularity_index\";s:3:\"188\";s:11:\"trend_index\";s:3:\"243\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:527;a:14:{s:2:\"id\";s:4:\"3619\";s:5:\"title\";s:31:\"Snowboard Site &#8211; Homepage\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2017/12/home.png\";s:12:\"tmpl_created\";s:10:\"1513513137\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/snowboard-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"70\";s:16:\"popularity_index\";s:3:\"210\";s:11:\"trend_index\";s:3:\"276\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:528;a:14:{s:2:\"id\";s:5:\"10454\";s:5:\"title\";s:29:\"Full Screen | Promotion | App\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/appy_small.png\";s:12:\"tmpl_created\";s:10:\"1548056896\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"71\";s:16:\"popularity_index\";s:3:\"655\";s:11:\"trend_index\";s:3:\"625\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:529;a:14:{s:2:\"id\";s:4:\"9425\";s:5:\"title\";s:38:\"Black Friday &#8211;  80&#8217;s style\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/11/unnamed-file.png\";s:12:\"tmpl_created\";s:10:\"1542901234\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/black-friday-80s-style/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"71\";s:16:\"popularity_index\";s:3:\"313\";s:11:\"trend_index\";s:3:\"434\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:530;a:14:{s:2:\"id\";s:5:\"11973\";s:5:\"title\";s:18:\"Maintenance mode 5\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm5.png\";s:12:\"tmpl_created\";s:10:\"1572154523\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";s:2:\"72\";s:16:\"popularity_index\";s:3:\"499\";s:11:\"trend_index\";s:3:\"299\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:531;a:14:{s:2:\"id\";s:4:\"9803\";s:5:\"title\";s:41:\"Full Screen | Register | Contact | Meetup\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2019/01/designme_full_small.png\";s:12:\"tmpl_created\";s:10:\"1547831298\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/full-screen-register-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"72\";s:16:\"popularity_index\";s:3:\"601\";s:11:\"trend_index\";s:3:\"605\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:532;a:14:{s:2:\"id\";s:5:\"10611\";s:5:\"title\";s:18:\"Full Screen | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fla_small.png\";s:12:\"tmpl_created\";s:10:\"1547968868\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/full-screen-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"73\";s:16:\"popularity_index\";s:3:\"659\";s:11:\"trend_index\";s:3:\"666\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:533;a:14:{s:2:\"id\";s:5:\"10508\";s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/hand_small-1.png\";s:12:\"tmpl_created\";s:10:\"1547964711\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-welcome-mat-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"75\";s:16:\"popularity_index\";s:3:\"610\";s:11:\"trend_index\";s:3:\"638\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:534;a:14:{s:2:\"id\";s:4:\"9934\";s:5:\"title\";s:38:\"Full Screen | Welcome Mat | Teddy Bear\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_mat_teddy_small.png\";s:12:\"tmpl_created\";s:10:\"1547841787\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-welcome-mat/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"76\";s:16:\"popularity_index\";s:3:\"581\";s:11:\"trend_index\";s:3:\"503\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:535;a:14:{s:2:\"id\";s:4:\"9709\";s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2019/01/Full-Screen_Welcome-Mat_01_small-1.png\";s:12:\"tmpl_created\";s:10:\"1547023834\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-welcome-mat-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"78\";s:16:\"popularity_index\";s:3:\"616\";s:11:\"trend_index\";s:3:\"645\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:536;a:14:{s:2:\"id\";s:4:\"9671\";s:5:\"title\";s:34:\"Hello Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Announcement_small_01.png\";s:12:\"tmpl_created\";s:10:\"1547010259\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"79\";s:16:\"popularity_index\";s:3:\"562\";s:11:\"trend_index\";s:3:\"554\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:537;a:14:{s:2:\"id\";s:5:\"10234\";s:5:\"title\";s:38:\"Hello Bar | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small.png\";s:12:\"tmpl_created\";s:10:\"1548055049\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/hello-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"80\";s:16:\"popularity_index\";s:3:\"641\";s:11:\"trend_index\";s:3:\"590\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:538;a:14:{s:2:\"id\";s:5:\"11981\";s:5:\"title\";s:18:\"Maintenance mode 6\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm6.png\";s:12:\"tmpl_created\";s:10:\"1572155125\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";s:2:\"83\";s:16:\"popularity_index\";s:3:\"490\";s:11:\"trend_index\";s:3:\"406\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:539;a:14:{s:2:\"id\";s:4:\"9869\";s:5:\"title\";s:28:\"Hello Bar | Promotion | Sale\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/ru_small.png\";s:12:\"tmpl_created\";s:10:\"1547837269\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/hello-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"83\";s:16:\"popularity_index\";s:3:\"649\";s:11:\"trend_index\";s:3:\"664\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:540;a:14:{s:2:\"id\";s:5:\"10539\";s:5:\"title\";s:19:\"Hello Bar | Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_pink_small.png\";s:12:\"tmpl_created\";s:10:\"1548056994\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"84\";s:16:\"popularity_index\";s:3:\"615\";s:11:\"trend_index\";s:3:\"622\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:541;a:14:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:20:\"Homepage &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0004.png\";s:12:\"tmpl_created\";s:10:\"1470829868\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/homepage-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"App\",\"Homepage\"]\";s:10:\"menu_order\";s:2:\"87\";s:16:\"popularity_index\";s:1:\"2\";s:11:\"trend_index\";s:2:\"12\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:542;a:14:{s:2:\"id\";s:3:\"777\";s:5:\"title\";s:28:\"Homepage &#8211; Coffee Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/01/rest-home.jpg\";s:12:\"tmpl_created\";s:10:\"1485273092\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/homepage-coffee-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:41:\"[\"Coffee\",\"Homepage\",\"Restaurant\",\"Shop\"]\";s:10:\"menu_order\";s:2:\"88\";s:16:\"popularity_index\";s:3:\"134\";s:11:\"trend_index\";s:3:\"336\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:543;a:14:{s:2:\"id\";s:5:\"10147\";s:5:\"title\";s:34:\"Hello Bar | Sale | Promotion | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/donut_small.png\";s:12:\"tmpl_created\";s:10:\"1548055522\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/hello-bar-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"89\";s:16:\"popularity_index\";s:3:\"653\";s:11:\"trend_index\";s:3:\"665\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:544;a:14:{s:2:\"id\";s:4:\"2404\";s:5:\"title\";s:24:\"Homepage &#8211; Product\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/09/product.png\";s:12:\"tmpl_created\";s:10:\"1506441452\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/homepage-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:103:\"[\"business\",\"colorful\",\"ecommerce\",\"flat\",\"mobile\",\"modern\",\"responsive\",\"retina\",\"Shop\",\"woocommerce\"]\";s:10:\"menu_order\";s:2:\"89\";s:16:\"popularity_index\";s:3:\"131\";s:11:\"trend_index\";s:3:\"191\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:545;a:14:{s:2:\"id\";s:3:\"492\";s:5:\"title\";s:25:\"Homepage &#8211; Law firm\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0024.png\";s:12:\"tmpl_created\";s:10:\"1477388365\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-law-firm/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"Firm\",\"Homepage\",\"Law\"]\";s:10:\"menu_order\";s:2:\"90\";s:16:\"popularity_index\";s:2:\"12\";s:11:\"trend_index\";s:2:\"61\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:546;a:14:{s:2:\"id\";s:4:\"9923\";s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_ann_italian_small.png\";s:12:\"tmpl_created\";s:10:\"1547841537\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/slide-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"90\";s:16:\"popularity_index\";s:3:\"587\";s:11:\"trend_index\";s:3:\"653\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:547;a:14:{s:2:\"id\";s:5:\"10117\";s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/white_small.png\";s:12:\"tmpl_created\";s:10:\"1548066998\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"91\";s:16:\"popularity_index\";s:3:\"617\";s:11:\"trend_index\";s:3:\"578\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:548;a:14:{s:2:\"id\";s:4:\"3451\";s:5:\"title\";s:39:\"Homepage &#8211; Goodness meal services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/11/goodness-featured-image.png\";s:12:\"tmpl_created\";s:10:\"1512054116\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/homepage-goodness-meal-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"91\";s:16:\"popularity_index\";s:3:\"212\";s:11:\"trend_index\";s:3:\"319\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:549;a:14:{s:2:\"id\";s:4:\"2152\";s:5:\"title\";s:26:\"Homepage &#8211; Cake Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-home.png\";s:12:\"tmpl_created\";s:10:\"1499774132\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/homepage-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Cake\",\"Homepage\",\"Restaurant\",\"Shop\"]\";s:10:\"menu_order\";s:2:\"92\";s:16:\"popularity_index\";s:3:\"316\";s:11:\"trend_index\";s:3:\"545\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:550;a:14:{s:2:\"id\";s:4:\"9826\";s:5:\"title\";s:33:\"Slide In | Announcement | webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-2.png\";s:12:\"tmpl_created\";s:10:\"1547835513\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-announcement-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"92\";s:16:\"popularity_index\";s:3:\"629\";s:11:\"trend_index\";s:3:\"591\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:551;a:14:{s:2:\"id\";s:4:\"1068\";s:5:\"title\";s:27:\"Homepage &#8211; Copywriter\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/03/copywriter.png\";s:12:\"tmpl_created\";s:10:\"1488805928\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-copywriter/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"Copywriter\",\"Homepage\"]\";s:10:\"menu_order\";s:2:\"93\";s:16:\"popularity_index\";s:3:\"192\";s:11:\"trend_index\";s:3:\"408\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:552;a:14:{s:2:\"id\";s:5:\"10478\";s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_wow_small.png\";s:12:\"tmpl_created\";s:10:\"1548056829\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"93\";s:16:\"popularity_index\";s:3:\"516\";s:11:\"trend_index\";s:3:\"537\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:553;a:14:{s:2:\"id\";s:4:\"2813\";s:5:\"title\";s:32:\"Homepage &#8211; Creative Agency\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/11/Creative-Agency-–-Home-Page.png\";s:12:\"tmpl_created\";s:10:\"1509615049\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/homepage-creative-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";s:2:\"94\";s:16:\"popularity_index\";s:2:\"94\";s:11:\"trend_index\";s:3:\"189\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:554;a:14:{s:2:\"id\";s:3:\"728\";s:5:\"title\";s:33:\"Homepage &#8211; Delivery Company\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/01/delivery-company-home-page.jpg\";s:12:\"tmpl_created\";s:10:\"1485269993\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/homepage-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Delivery\",\"Homepage\"]\";s:10:\"menu_order\";s:2:\"95\";s:16:\"popularity_index\";s:3:\"255\";s:11:\"trend_index\";s:3:\"456\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:555;a:14:{s:2:\"id\";s:5:\"10685\";s:5:\"title\";s:32:\"Hello Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/env_small.png\";s:12:\"tmpl_created\";s:10:\"1547974729\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"96\";s:16:\"popularity_index\";s:3:\"599\";s:11:\"trend_index\";s:3:\"627\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:556;a:14:{s:2:\"id\";s:4:\"2403\";s:5:\"title\";s:29:\"Homepage &#8211; Luxury Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/09/Hotel.png\";s:12:\"tmpl_created\";s:10:\"1506441428\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/homepage-luxury-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"96\";s:16:\"popularity_index\";s:3:\"245\";s:11:\"trend_index\";s:3:\"390\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:557;a:14:{s:2:\"id\";s:4:\"1903\";s:5:\"title\";s:20:\"One Page &#8211; Spa\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/06/spa.png\";s:12:\"tmpl_created\";s:10:\"1496822325\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/one-page-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:132:\"[\"beauty\",\"care\",\"girly\",\"hair\",\"Health\",\"hospitality\",\"massage\",\"medical\",\"parlor\",\"physiotherapy\",\"salon\",\"spa\",\"wellness\",\"yoga\"]\";s:10:\"menu_order\";s:2:\"97\";s:16:\"popularity_index\";s:3:\"169\";s:11:\"trend_index\";s:3:\"222\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:558;a:14:{s:2:\"id\";s:4:\"2123\";s:5:\"title\";s:33:\"One Page &#8211; Architect Office\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/06/architect.png\";s:12:\"tmpl_created\";s:10:\"1499772989\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/one-page-architect-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"98\";s:16:\"popularity_index\";s:2:\"10\";s:11:\"trend_index\";s:2:\"23\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:559;a:14:{s:2:\"id\";s:4:\"9985\";s:5:\"title\";s:20:\"Slide In | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_promotion_av_small.png\";s:12:\"tmpl_created\";s:10:\"1547844661\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"98\";s:16:\"popularity_index\";s:3:\"640\";s:11:\"trend_index\";s:3:\"620\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:560;a:14:{s:2:\"id\";s:4:\"1888\";s:5:\"title\";s:32:\"One Page &#8211; Creative Meetup\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2017/06/creative-meetup.png\";s:12:\"tmpl_created\";s:10:\"1496822319\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/one-page-creative-meetup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:2:\"99\";s:16:\"popularity_index\";s:3:\"250\";s:11:\"trend_index\";s:3:\"504\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:561;a:14:{s:2:\"id\";s:4:\"1891\";s:5:\"title\";s:35:\"One Page &#8211; Textile Convention\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/06/textile-meetup.png\";s:12:\"tmpl_created\";s:10:\"1496822323\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/one-page-textile-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"100\";s:16:\"popularity_index\";s:3:\"382\";s:11:\"trend_index\";s:3:\"565\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:562;a:14:{s:2:\"id\";s:4:\"1880\";s:5:\"title\";s:24:\"One Page &#8211; Wedding\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/06/wedding.png\";s:12:\"tmpl_created\";s:10:\"1496822317\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/one-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"bride\",\"ceremony\",\"cute\",\"event\",\"fancy\",\"girly\",\"groom\",\"guestbook\",\"marriage\"]\";s:10:\"menu_order\";s:3:\"101\";s:16:\"popularity_index\";s:3:\"409\";s:11:\"trend_index\";s:3:\"626\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:563;a:14:{s:2:\"id\";s:4:\"1885\";s:5:\"title\";s:29:\"One Page &#8211; Yacht Rental\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/06/yacht-home.png\";s:12:\"tmpl_created\";s:10:\"1496822321\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/one-page-yacht-rental/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"102\";s:16:\"popularity_index\";s:3:\"185\";s:11:\"trend_index\";s:3:\"387\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:564;a:14:{s:2:\"id\";s:4:\"2723\";s:5:\"title\";s:34:\"Portfolio &#8211; Graphic Designer\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2017/11/Graphic-Designer-–-Portfolio.png\";s:12:\"tmpl_created\";s:10:\"1509633883\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/portfolio-graphic-designer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"103\";s:16:\"popularity_index\";s:3:\"170\";s:11:\"trend_index\";s:3:\"310\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:565;a:14:{s:2:\"id\";s:4:\"2145\";s:5:\"title\";s:30:\"About &#8211; Delivery Company\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-about.png\";s:12:\"tmpl_created\";s:10:\"1499774125\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/about-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:10:\"[\"moving\"]\";s:10:\"menu_order\";s:3:\"104\";s:16:\"popularity_index\";s:3:\"320\";s:11:\"trend_index\";s:3:\"435\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:566;a:14:{s:2:\"id\";s:4:\"2155\";s:5:\"title\";s:23:\"About &#8211; Cake Shop\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-about.png\";s:12:\"tmpl_created\";s:10:\"1499774130\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/about-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"Food\"]\";s:10:\"menu_order\";s:3:\"105\";s:16:\"popularity_index\";s:3:\"372\";s:11:\"trend_index\";s:3:\"518\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:567;a:14:{s:2:\"id\";s:4:\"9559\";s:5:\"title\";s:16:\"Slide In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_login_01_small.png\";s:12:\"tmpl_created\";s:10:\"1546946547\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/slide-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"105\";s:16:\"popularity_index\";s:3:\"512\";s:11:\"trend_index\";s:3:\"621\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:568;a:14:{s:2:\"id\";s:4:\"1085\";s:5:\"title\";s:21:\"About &#8211; Startup\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/03/Startup.png\";s:12:\"tmpl_created\";s:10:\"1488810874\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/about-startup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"About\",\"Startup\"]\";s:10:\"menu_order\";s:3:\"106\";s:16:\"popularity_index\";s:1:\"7\";s:11:\"trend_index\";s:2:\"13\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:569;a:14:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:22:\"About &#8211; Personal\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0010.png\";s:12:\"tmpl_created\";s:10:\"1470820447\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/about-personal/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"About\",\"Personal\"]\";s:10:\"menu_order\";s:3:\"107\";s:16:\"popularity_index\";s:2:\"22\";s:11:\"trend_index\";s:2:\"65\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:570;a:14:{s:2:\"id\";s:4:\"9752\";s:5:\"title\";s:27:\"Slide In | Sale | Promotion\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rush_small.png\";s:12:\"tmpl_created\";s:10:\"1547823982\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"107\";s:16:\"popularity_index\";s:3:\"627\";s:11:\"trend_index\";s:3:\"661\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:571;a:14:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:16:\"About &#8211; CV\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0018.png\";s:12:\"tmpl_created\";s:10:\"1470829785\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:98:\"https://library.elementor.com/about-cv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"creative portfolio\",\"Personal\",\"portfolio\",\"professional\",\"resume\",\"vcard\"]\";s:10:\"menu_order\";s:3:\"108\";s:16:\"popularity_index\";s:2:\"36\";s:11:\"trend_index\";s:3:\"139\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:572;a:14:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:25:\"About &#8211; Art Gallery\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0009.png\";s:12:\"tmpl_created\";s:10:\"1470820463\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/about-art-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"About\",\"Art\",\"Gallery\"]\";s:10:\"menu_order\";s:3:\"109\";s:16:\"popularity_index\";s:2:\"15\";s:11:\"trend_index\";s:2:\"57\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:573;a:14:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:26:\"About &#8211; Architecture\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0008.png\";s:12:\"tmpl_created\";s:10:\"1470829766\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/about-architecture/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"About\",\"Architecture\"]\";s:10:\"menu_order\";s:3:\"110\";s:16:\"popularity_index\";s:2:\"18\";s:11:\"trend_index\";s:2:\"54\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:574;a:14:{s:2:\"id\";s:4:\"2802\";s:5:\"title\";s:38:\"Portfolio &#8211; Fashion Photographer\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2017/11/Fashion-photographer-–-Portfolio.png\";s:12:\"tmpl_created\";s:10:\"1509615440\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/portfolio-fashion-photographer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"111\";s:16:\"popularity_index\";s:3:\"194\";s:11:\"trend_index\";s:3:\"388\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:575;a:14:{s:2:\"id\";s:5:\"10169\";s:5:\"title\";s:37:\"Slide In | Register | Subscribe | App\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/slideinapp_small.png\";s:12:\"tmpl_created\";s:10:\"1547852334\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"112\";s:16:\"popularity_index\";s:3:\"400\";s:11:\"trend_index\";s:3:\"618\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:576;a:14:{s:2:\"id\";s:4:\"2828\";s:5:\"title\";s:35:\"Landing Page &#8211; Law Convention\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2017/11/Law-Convention-–-Landing-Page.png\";s:12:\"tmpl_created\";s:10:\"1509631636\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/landing-page-law-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"Convention\",\"Landing Page\",\"Law\"]\";s:10:\"menu_order\";s:3:\"112\";s:16:\"popularity_index\";s:3:\"346\";s:11:\"trend_index\";s:3:\"579\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:577;a:14:{s:2:\"id\";s:4:\"1461\";s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-1.png\";s:12:\"tmpl_created\";s:10:\"1494352121\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:127:\"[\"App\",\"author\",\"book\",\"brochure\",\"download\",\"e-book\",\"ebook\",\"marketing\",\"product\",\"publisher\",\"sell online\",\"seo\",\"showcase\"]\";s:10:\"menu_order\";s:3:\"113\";s:16:\"popularity_index\";s:3:\"335\";s:11:\"trend_index\";s:3:\"433\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:578;a:14:{s:2:\"id\";s:4:\"1460\";s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-2.png\";s:12:\"tmpl_created\";s:10:\"1494352124\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"114\";s:16:\"popularity_index\";s:3:\"350\";s:11:\"trend_index\";s:3:\"505\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:579;a:14:{s:2:\"id\";s:4:\"1459\";s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-3.png\";s:12:\"tmpl_created\";s:10:\"1494352125\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"115\";s:16:\"popularity_index\";s:3:\"221\";s:11:\"trend_index\";s:3:\"337\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:580;a:14:{s:2:\"id\";s:4:\"9680\";s:5:\"title\";s:23:\"Slide In | Content Lock\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Content-lock_small_01.png\";s:12:\"tmpl_created\";s:10:\"1547010967\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/slide-in-content-lock-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"115\";s:16:\"popularity_index\";s:3:\"625\";s:11:\"trend_index\";s:3:\"629\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:581;a:14:{s:2:\"id\";s:4:\"1052\";s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 1\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/03/app.png\";s:12:\"tmpl_created\";s:10:\"1488810873\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-mobile-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"116\";s:16:\"popularity_index\";s:2:\"27\";s:11:\"trend_index\";s:2:\"75\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:582;a:14:{s:2:\"id\";s:4:\"1505\";s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app3.png\";s:12:\"tmpl_created\";s:10:\"1494352110\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"117\";s:16:\"popularity_index\";s:3:\"368\";s:11:\"trend_index\";s:3:\"498\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:583;a:14:{s:2:\"id\";s:4:\"9783\";s:5:\"title\";s:31:\"Slide In | Register | Subscribe\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_yellow_small.png\";s:12:\"tmpl_created\";s:10:\"1547831059\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/slide-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"117\";s:16:\"popularity_index\";s:3:\"474\";s:11:\"trend_index\";s:3:\"409\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:584;a:14:{s:2:\"id\";s:3:\"726\";s:5:\"title\";s:33:\"Landing Page &#8211; Conference 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/01/convention-landing-page.jpg\";s:12:\"tmpl_created\";s:10:\"1485270062\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"118\";s:16:\"popularity_index\";s:3:\"391\";s:11:\"trend_index\";s:3:\"551\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:585;a:14:{s:2:\"id\";s:4:\"1613\";s:5:\"title\";s:33:\"Landing Page &#8211; Conference 2\";s:9:\"thumbnail\";s:109:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-International-Womens-Day-Conference.png\";s:12:\"tmpl_created\";s:10:\"1494352129\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"119\";s:16:\"popularity_index\";s:3:\"407\";s:11:\"trend_index\";s:3:\"577\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:586;a:14:{s:2:\"id\";s:4:\"1612\";s:5:\"title\";s:33:\"Landing Page &#8211; Conference 3\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Tech-Conference.png\";s:12:\"tmpl_created\";s:10:\"1494352127\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"120\";s:16:\"popularity_index\";s:3:\"423\";s:11:\"trend_index\";s:3:\"601\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:587;a:14:{s:2:\"id\";s:4:\"1614\";s:5:\"title\";s:33:\"Landing Page &#8211; Conference 4\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Sustainability-Conference.png\";s:12:\"tmpl_created\";s:10:\"1494352131\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"121\";s:16:\"popularity_index\";s:3:\"355\";s:11:\"trend_index\";s:3:\"447\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:588;a:14:{s:2:\"id\";s:3:\"906\";s:5:\"title\";s:29:\"Landing Page &#8211;  Coacher\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/02/Landin-Page-Coacher.png\";s:12:\"tmpl_created\";s:10:\"1494352066\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-coacher/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"122\";s:16:\"popularity_index\";s:3:\"254\";s:11:\"trend_index\";s:3:\"317\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:589;a:14:{s:2:\"id\";s:3:\"879\";s:5:\"title\";s:41:\"Landing Page &#8211; Financial Consultant\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Financial-consultant.png\";s:12:\"tmpl_created\";s:10:\"1494352064\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/landing-page-financial-consultant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"123\";s:16:\"popularity_index\";s:3:\"261\";s:11:\"trend_index\";s:3:\"419\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:590;a:14:{s:2:\"id\";s:3:\"926\";s:5:\"title\";s:33:\"Landing Page &#8211; Private Chef\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Private-Chef.png\";s:12:\"tmpl_created\";s:10:\"1494352068\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-private-chef/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"124\";s:16:\"popularity_index\";s:3:\"367\";s:11:\"trend_index\";s:3:\"528\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:591;a:14:{s:2:\"id\";s:4:\"1032\";s:5:\"title\";s:27:\"Landing Page &#8211; Agency\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Agency.png\";s:12:\"tmpl_created\";s:10:\"1488810866\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/landing-page-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"125\";s:16:\"popularity_index\";s:3:\"366\";s:11:\"trend_index\";s:3:\"424\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:592;a:14:{s:2:\"id\";s:3:\"730\";s:5:\"title\";s:24:\"Landing Page &#8211; App\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/app.-landing-page.jpg\";s:12:\"tmpl_created\";s:10:\"1485273430\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/landing-page-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"126\";s:16:\"popularity_index\";s:3:\"340\";s:11:\"trend_index\";s:3:\"431\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:593;a:14:{s:2:\"id\";s:3:\"643\";s:5:\"title\";s:29:\"Landing Page &#8211; Festival\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2016/12/festival.jpg\";s:12:\"tmpl_created\";s:10:\"1481549290\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-festival/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"127\";s:16:\"popularity_index\";s:3:\"395\";s:11:\"trend_index\";s:3:\"649\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:594;a:14:{s:2:\"id\";s:3:\"542\";s:5:\"title\";s:28:\"Landing Page &#8211; Wedding\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0025.png\";s:12:\"tmpl_created\";s:10:\"1477388484\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"128\";s:16:\"popularity_index\";s:2:\"76\";s:11:\"trend_index\";s:3:\"198\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:595;a:14:{s:2:\"id\";s:4:\"1187\";s:5:\"title\";s:32:\"Landing Page &#8211; Photography\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp1-l.png\";s:12:\"tmpl_created\";s:10:\"1490707385\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/landing-page-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"129\";s:16:\"popularity_index\";s:2:\"37\";s:11:\"trend_index\";s:3:\"129\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:596;a:14:{s:2:\"id\";s:3:\"641\";s:5:\"title\";s:28:\"Landing Page &#8211; Fashion\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/12/fashion-landing-page.jpg\";s:12:\"tmpl_created\";s:10:\"1481549264\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-fashion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"130\";s:16:\"popularity_index\";s:3:\"298\";s:11:\"trend_index\";s:3:\"377\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:597;a:14:{s:2:\"id\";s:3:\"189\";s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 1\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0005.png\";s:12:\"tmpl_created\";s:10:\"1470820715\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-tourism/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"131\";s:16:\"popularity_index\";s:2:\"14\";s:11:\"trend_index\";s:2:\"40\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:598;a:14:{s:2:\"id\";s:4:\"1547\";s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-1.png\";s:12:\"tmpl_created\";s:10:\"1494352115\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"132\";s:16:\"popularity_index\";s:3:\"311\";s:11:\"trend_index\";s:3:\"343\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:599;a:14:{s:2:\"id\";s:4:\"1546\";s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-2.png\";s:12:\"tmpl_created\";s:10:\"1494352116\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"133\";s:16:\"popularity_index\";s:3:\"420\";s:11:\"trend_index\";s:3:\"612\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:600;a:14:{s:2:\"id\";s:4:\"1545\";s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-3.png\";s:12:\"tmpl_created\";s:10:\"1494352118\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"134\";s:16:\"popularity_index\";s:3:\"352\";s:11:\"trend_index\";s:3:\"516\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:601;a:14:{s:2:\"id\";s:4:\"2714\";s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 5\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/11/Vacation-–-Landing-Page.png\";s:12:\"tmpl_created\";s:10:\"1509631782\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"135\";s:16:\"popularity_index\";s:3:\"348\";s:11:\"trend_index\";s:3:\"556\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:602;a:14:{s:2:\"id\";s:3:\"195\";s:5:\"title\";s:28:\"Landing Page &#8211; Product\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0006.png\";s:12:\"tmpl_created\";s:10:\"1470820765\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"136\";s:16:\"popularity_index\";s:2:\"49\";s:11:\"trend_index\";s:3:\"170\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:603;a:14:{s:2:\"id\";s:3:\"197\";s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 1\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0007.png\";s:12:\"tmpl_created\";s:10:\"1470825711\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/landing-page-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"137\";s:16:\"popularity_index\";s:3:\"119\";s:11:\"trend_index\";s:3:\"294\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:604;a:14:{s:2:\"id\";s:4:\"1193\";s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 2\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";s:10:\"1490707422\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"138\";s:16:\"popularity_index\";s:2:\"58\";s:11:\"trend_index\";s:3:\"217\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:605;a:14:{s:2:\"id\";s:4:\"1415\";s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-1.png\";s:12:\"tmpl_created\";s:10:\"1494352106\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"139\";s:16:\"popularity_index\";s:3:\"334\";s:11:\"trend_index\";s:3:\"445\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:606;a:14:{s:2:\"id\";s:4:\"1414\";s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 4\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-2.png\";s:12:\"tmpl_created\";s:10:\"1494352107\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"140\";s:16:\"popularity_index\";s:3:\"445\";s:11:\"trend_index\";s:3:\"631\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:607;a:14:{s:2:\"id\";s:4:\"1413\";s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 5\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-3.png\";s:12:\"tmpl_created\";s:10:\"1494352109\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:134:\"[\"Agent\",\"business\",\"clean\",\"corporate\",\"flat\",\"google maps\",\"homes\",\"listing\",\"modern\",\"real estate\",\"realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";s:3:\"141\";s:16:\"popularity_index\";s:3:\"398\";s:11:\"trend_index\";s:3:\"437\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:608;a:14:{s:2:\"id\";s:4:\"1573\";s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-02.png\";s:12:\"tmpl_created\";s:10:\"1494352133\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"142\";s:16:\"popularity_index\";s:3:\"464\";s:11:\"trend_index\";s:3:\"641\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:609;a:14:{s:2:\"id\";s:4:\"1572\";s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-03.png\";s:12:\"tmpl_created\";s:10:\"1494352134\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"143\";s:16:\"popularity_index\";s:3:\"500\";s:11:\"trend_index\";s:3:\"603\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:610;a:14:{s:2:\"id\";s:4:\"1570\";s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 3\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-01.png\";s:12:\"tmpl_created\";s:10:\"1494352136\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"144\";s:16:\"popularity_index\";s:3:\"545\";s:11:\"trend_index\";s:3:\"569\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:611;a:14:{s:2:\"id\";s:4:\"1571\";s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 4\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-04.png\";s:12:\"tmpl_created\";s:10:\"1494352138\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"145\";s:16:\"popularity_index\";s:3:\"515\";s:11:\"trend_index\";s:3:\"566\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:612;a:14:{s:2:\"id\";s:3:\"192\";s:5:\"title\";s:28:\"Landing Page &#8211; Webinar\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0015.png\";s:12:\"tmpl_created\";s:10:\"1470820734\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"146\";s:16:\"popularity_index\";s:3:\"106\";s:11:\"trend_index\";s:3:\"296\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:613;a:14:{s:2:\"id\";s:4:\"2141\";s:5:\"title\";s:32:\"Contact &#8211; Delivery Company\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-contact.png\";s:12:\"tmpl_created\";s:10:\"1499774122\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/contact-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"147\";s:16:\"popularity_index\";s:3:\"304\";s:11:\"trend_index\";s:3:\"351\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:614;a:14:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Contact &#8211; Modern\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0013.png\";s:12:\"tmpl_created\";s:10:\"1470829828\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/contact-modern/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"148\";s:16:\"popularity_index\";s:2:\"40\";s:11:\"trend_index\";s:3:\"110\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:615;a:14:{s:2:\"id\";s:3:\"256\";s:5:\"title\";s:26:\"Contact &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0011.png\";s:12:\"tmpl_created\";s:10:\"1470829796\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/contact-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"149\";s:16:\"popularity_index\";s:3:\"117\";s:11:\"trend_index\";s:3:\"205\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:616;a:14:{s:2:\"id\";s:4:\"2150\";s:5:\"title\";s:25:\"Contact &#8211; Cake Shop\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-contact.png\";s:12:\"tmpl_created\";s:10:\"1499774127\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/contact-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"150\";s:16:\"popularity_index\";s:2:\"60\";s:11:\"trend_index\";s:3:\"144\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:617;a:14:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:21:\"Contact &#8211; Hotel\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0002.png\";s:12:\"tmpl_created\";s:10:\"1470820471\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/contact-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"151\";s:16:\"popularity_index\";s:3:\"115\";s:11:\"trend_index\";s:3:\"292\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:618;a:14:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:25:\"Contact &#8211; Corporate\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0012.png\";s:12:\"tmpl_created\";s:10:\"1470248619\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/contact-corporate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"152\";s:16:\"popularity_index\";s:2:\"13\";s:11:\"trend_index\";s:2:\"16\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:619;a:14:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:23:\"Services &#8211; Moving\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0017.png\";s:12:\"tmpl_created\";s:10:\"1470829889\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/services-moving/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"153\";s:16:\"popularity_index\";s:2:\"23\";s:11:\"trend_index\";s:2:\"56\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:620;a:14:{s:2:\"id\";s:3:\"625\";s:5:\"title\";s:31:\"Services &#8211; Cake Shop Menu\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2016/12/cake-shop-menu.jpg\";s:12:\"tmpl_created\";s:10:\"1481549196\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/services-cake-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"154\";s:16:\"popularity_index\";s:3:\"507\";s:11:\"trend_index\";s:3:\"634\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:621;a:14:{s:2:\"id\";s:3:\"187\";s:5:\"title\";s:20:\"Services &#8211; Fun\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0001.png\";s:12:\"tmpl_created\";s:10:\"1470829892\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/services-fun/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"155\";s:16:\"popularity_index\";s:2:\"64\";s:11:\"trend_index\";s:3:\"201\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:622;a:14:{s:2:\"id\";s:3:\"238\";s:5:\"title\";s:27:\"Services &#8211; Consulting\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0014.png\";s:12:\"tmpl_created\";s:10:\"1470829865\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/services-consulting/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"156\";s:16:\"popularity_index\";s:2:\"21\";s:11:\"trend_index\";s:2:\"49\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:623;a:14:{s:2:\"id\";s:3:\"647\";s:5:\"title\";s:33:\"Services &#8211; Coffee Shop Menu\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2016/12/restaurant-menu.jpg\";s:12:\"tmpl_created\";s:10:\"1481549320\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/services-coffee-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"157\";s:16:\"popularity_index\";s:3:\"421\";s:11:\"trend_index\";s:3:\"606\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:624;a:14:{s:2:\"id\";s:4:\"2138\";s:5:\"title\";s:33:\"Services &#8211; Delivery Company\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-services.png\";s:12:\"tmpl_created\";s:10:\"1499774119\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/services-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"158\";s:16:\"popularity_index\";s:3:\"363\";s:11:\"trend_index\";s:3:\"510\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:625;a:14:{s:2:\"id\";s:3:\"823\";s:5:\"title\";s:19:\"Pricing &#8211; App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2017/01/pricing-app.jpg\";s:12:\"tmpl_created\";s:10:\"1485272966\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/pricing-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"159\";s:16:\"popularity_index\";s:3:\"342\";s:11:\"trend_index\";s:3:\"541\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:626;a:14:{s:2:\"id\";s:3:\"824\";s:5:\"title\";s:24:\"Pricing &#8211; Software\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/01/pricing-software.png\";s:12:\"tmpl_created\";s:10:\"1485272900\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/pricing-software-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"160\";s:16:\"popularity_index\";s:3:\"353\";s:11:\"trend_index\";s:3:\"395\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:627;a:14:{s:2:\"id\";s:3:\"825\";s:5:\"title\";s:24:\"Product &#8211; Speakers\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/01/product-page.jpg\";s:12:\"tmpl_created\";s:10:\"1485272513\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/product-speakers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"161\";s:16:\"popularity_index\";s:3:\"369\";s:11:\"trend_index\";s:3:\"410\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:628;a:14:{s:2:\"id\";s:3:\"245\";s:5:\"title\";s:21:\"Product &#8211; Clean\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0020.png\";s:12:\"tmpl_created\";s:10:\"1470829876\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/product-clean/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"fast\",\"minimal\",\"minimalistic\",\"seo\",\"simple\"]\";s:10:\"menu_order\";s:3:\"162\";s:16:\"popularity_index\";s:2:\"74\";s:11:\"trend_index\";s:3:\"148\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:629;a:14:{s:2:\"id\";s:4:\"1075\";s:5:\"title\";s:19:\"Shop &#8211; Sweets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Sweets.png\";s:12:\"tmpl_created\";s:10:\"1488810871\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/shop-sweets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:154:\"[\"bakery\",\"beverage\",\"business\",\"cafe\",\"candy bar\",\"catering\",\"delivery service\",\"Food\",\"online shop\",\"pastry\",\"Restaurant\",\"store\",\"sweet shop\",\"sweets\"]\";s:10:\"menu_order\";s:3:\"163\";s:16:\"popularity_index\";s:2:\"52\";s:11:\"trend_index\";s:3:\"128\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:630;a:14:{s:2:\"id\";s:4:\"1051\";s:5:\"title\";s:24:\"Blog Post &#8211; Launch\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/03/post-cloud.png\";s:12:\"tmpl_created\";s:10:\"1488810869\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blog-post-launch/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:210:\"[\"Agency\",\"bootstrap\",\"business\",\"corporate\",\"Landing Page\",\"launch\",\"marketing campaign\",\"marketing landing page\",\"marketing template landing page\",\"product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";s:3:\"164\";s:16:\"popularity_index\";s:2:\"16\";s:11:\"trend_index\";s:2:\"19\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:631;a:14:{s:2:\"id\";s:4:\"1245\";s:5:\"title\";s:13:\"Coming Soon 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-1.png\";s:12:\"tmpl_created\";s:10:\"1491207184\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"165\";s:16:\"popularity_index\";s:3:\"256\";s:11:\"trend_index\";s:3:\"301\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:632;a:14:{s:2:\"id\";s:4:\"1247\";s:5:\"title\";s:13:\"Coming Soon 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-2.png\";s:12:\"tmpl_created\";s:10:\"1491207138\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"166\";s:16:\"popularity_index\";s:2:\"28\";s:11:\"trend_index\";s:2:\"73\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:633;a:14:{s:2:\"id\";s:4:\"1248\";s:5:\"title\";s:13:\"Coming Soon 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-3.png\";s:12:\"tmpl_created\";s:10:\"1491207050\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"167\";s:16:\"popularity_index\";s:3:\"374\";s:11:\"trend_index\";s:3:\"568\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:634;a:14:{s:2:\"id\";s:4:\"1249\";s:5:\"title\";s:13:\"Coming Soon 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-4.png\";s:12:\"tmpl_created\";s:10:\"1491207380\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"168\";s:16:\"popularity_index\";s:3:\"402\";s:11:\"trend_index\";s:3:\"562\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:635;a:14:{s:2:\"id\";s:4:\"1250\";s:5:\"title\";s:13:\"Coming Soon 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-5.png\";s:12:\"tmpl_created\";s:10:\"1491207450\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"169\";s:16:\"popularity_index\";s:2:\"63\";s:11:\"trend_index\";s:3:\"158\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:636;a:14:{s:2:\"id\";s:4:\"1260\";s:5:\"title\";s:18:\"Maintenance Mode 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-6.png\";s:12:\"tmpl_created\";s:10:\"1491207507\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";s:3:\"170\";s:16:\"popularity_index\";s:3:\"413\";s:11:\"trend_index\";s:3:\"586\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:637;a:14:{s:2:\"id\";s:4:\"1261\";s:5:\"title\";s:18:\"Maintenance Mode 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/04/Coming-Soon-7.png\";s:12:\"tmpl_created\";s:10:\"1491207584\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";s:3:\"171\";s:16:\"popularity_index\";s:2:\"67\";s:11:\"trend_index\";s:3:\"165\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:638;a:14:{s:2:\"id\";s:4:\"1272\";s:5:\"title\";s:13:\"Coming Soon 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-8.png\";s:12:\"tmpl_created\";s:10:\"1491207674\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"172\";s:16:\"popularity_index\";s:3:\"277\";s:11:\"trend_index\";s:3:\"353\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:639;a:14:{s:2:\"id\";s:4:\"1279\";s:5:\"title\";s:13:\"Coming Soon 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-9.png\";s:12:\"tmpl_created\";s:10:\"1491207756\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"173\";s:16:\"popularity_index\";s:3:\"129\";s:11:\"trend_index\";s:3:\"177\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:640;a:14:{s:2:\"id\";s:4:\"1745\";s:5:\"title\";s:14:\"Coming Soon 10\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-002.png\";s:12:\"tmpl_created\";s:10:\"1494849745\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/coming-soon-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"174\";s:16:\"popularity_index\";s:3:\"264\";s:11:\"trend_index\";s:3:\"416\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:641;a:14:{s:2:\"id\";s:4:\"1742\";s:5:\"title\";s:12:\"Login Page 1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-003.png\";s:12:\"tmpl_created\";s:10:\"1494849744\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/login-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"175\";s:16:\"popularity_index\";s:3:\"399\";s:11:\"trend_index\";s:3:\"400\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:642;a:14:{s:2:\"id\";s:4:\"1748\";s:5:\"title\";s:12:\"Login Page 2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-001.png\";s:12:\"tmpl_created\";s:10:\"1494849742\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/login-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"176\";s:16:\"popularity_index\";s:3:\"289\";s:11:\"trend_index\";s:3:\"313\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:643;a:14:{s:2:\"id\";s:4:\"3963\";s:5:\"title\";s:32:\"Restaurant Site &#8211; Homepage\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/01/R.HomepageThumb.png\";s:12:\"tmpl_created\";s:10:\"1516284821\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/restaurant-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";s:3:\"177\";s:16:\"popularity_index\";s:3:\"228\";s:11:\"trend_index\";s:3:\"182\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:644;a:14:{s:2:\"id\";s:4:\"3969\";s:5:\"title\";s:28:\"Restaurant Site &#8211; Menu\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/01/R.MenuThumb.png\";s:12:\"tmpl_created\";s:10:\"1516284829\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/restaurant-site-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";s:3:\"178\";s:16:\"popularity_index\";s:3:\"379\";s:11:\"trend_index\";s:3:\"607\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:645;a:14:{s:2:\"id\";s:4:\"3966\";s:5:\"title\";s:29:\"Restaurant Site &#8211; About\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/01/R.AboutThumb.png.png\";s:12:\"tmpl_created\";s:10:\"1516284839\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/restaurant-site-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";s:3:\"179\";s:16:\"popularity_index\";s:3:\"242\";s:11:\"trend_index\";s:3:\"255\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:646;a:14:{s:2:\"id\";s:4:\"3972\";s:5:\"title\";s:31:\"Restaurant Site &#8211; Contact\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/01/R.ContactThumb.png\";s:12:\"tmpl_created\";s:10:\"1516284847\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/restaurant-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";s:3:\"180\";s:16:\"popularity_index\";s:3:\"351\";s:11:\"trend_index\";s:3:\"429\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:647;a:14:{s:2:\"id\";s:4:\"2080\";s:5:\"title\";s:27:\"Ski Resort &#8211; Homepage\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Home-Page.png\";s:12:\"tmpl_created\";s:10:\"1508161124\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/ski-resort-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"181\";s:16:\"popularity_index\";s:3:\"317\";s:11:\"trend_index\";s:3:\"289\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:648;a:14:{s:2:\"id\";s:4:\"2088\";s:5:\"title\";s:24:\"Ski Resort &#8211; About\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-About.png\";s:12:\"tmpl_created\";s:10:\"1508161129\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/ski-resort-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"182\";s:16:\"popularity_index\";s:3:\"393\";s:11:\"trend_index\";s:3:\"559\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:649;a:14:{s:2:\"id\";s:4:\"2085\";s:5:\"title\";s:27:\"Ski Resort &#8211; Services\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Services.png\";s:12:\"tmpl_created\";s:10:\"1508161134\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/ski-resort-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"183\";s:16:\"popularity_index\";s:3:\"495\";s:11:\"trend_index\";s:3:\"656\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:650;a:14:{s:2:\"id\";s:4:\"2462\";s:5:\"title\";s:23:\"Architect &#8211; About\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/10/architect-–-about.png\";s:12:\"tmpl_created\";s:10:\"1508243317\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/architect-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"184\";s:16:\"popularity_index\";s:3:\"309\";s:11:\"trend_index\";s:3:\"358\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:651;a:14:{s:2:\"id\";s:4:\"2362\";s:5:\"title\";s:26:\"Architect &#8211; Projects\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2017/10/Architect-Projects.png\";s:12:\"tmpl_created\";s:10:\"1508243335\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/architect-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"185\";s:16:\"popularity_index\";s:3:\"378\";s:11:\"trend_index\";s:3:\"543\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:652;a:14:{s:2:\"id\";s:3:\"614\";s:5:\"title\";s:25:\"Architect &#8211; Contact\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2016/12/architect-contact.jpg\";s:12:\"tmpl_created\";s:10:\"1481549169\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/architect-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"186\";s:16:\"popularity_index\";s:3:\"282\";s:11:\"trend_index\";s:3:\"487\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:653;a:14:{s:2:\"id\";s:4:\"2126\";s:5:\"title\";s:37:\"Construction Company &#8211; Homepage\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Home-Page.png\";s:12:\"tmpl_created\";s:10:\"1508325849\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-company-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"187\";s:16:\"popularity_index\";s:3:\"266\";s:11:\"trend_index\";s:3:\"293\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:654;a:14:{s:2:\"id\";s:4:\"2129\";s:5:\"title\";s:34:\"Construction Company &#8211; About\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-About.png\";s:12:\"tmpl_created\";s:10:\"1508325881\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/construction-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"188\";s:16:\"popularity_index\";s:3:\"294\";s:11:\"trend_index\";s:3:\"326\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:655;a:14:{s:2:\"id\";s:4:\"2135\";s:5:\"title\";s:36:\"Construction Company &#8211; Contact\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Contact.png\";s:12:\"tmpl_created\";s:10:\"1508325922\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/construction-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"189\";s:16:\"popularity_index\";s:3:\"330\";s:11:\"trend_index\";s:3:\"452\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:656;a:14:{s:2:\"id\";s:4:\"2094\";s:5:\"title\";s:28:\"Plants Shop &#8211; Homepage\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-Home.png\";s:12:\"tmpl_created\";s:10:\"1509621053\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/plants-shop-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"190\";s:16:\"popularity_index\";s:3:\"268\";s:11:\"trend_index\";s:3:\"226\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:657;a:14:{s:2:\"id\";s:4:\"2120\";s:5:\"title\";s:25:\"Plants Shop &#8211; About\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-About.png\";s:12:\"tmpl_created\";s:10:\"1509631820\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/plants-shop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"191\";s:16:\"popularity_index\";s:3:\"337\";s:11:\"trend_index\";s:3:\"339\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:658;a:14:{s:2:\"id\";s:4:\"3153\";s:5:\"title\";s:14:\"Halloween Pack\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/10/halloween.png\";s:12:\"tmpl_created\";s:10:\"1508950132\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/halloween-pack/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"192\";s:16:\"popularity_index\";s:3:\"559\";s:11:\"trend_index\";s:3:\"643\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:659;a:14:{s:2:\"id\";s:4:\"3338\";s:5:\"title\";s:31:\"Black Friday &#8211; Nature Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-1.png\";s:12:\"tmpl_created\";s:10:\"1511203351\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/black-friday-nature-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"193\";s:16:\"popularity_index\";s:3:\"485\";s:11:\"trend_index\";s:3:\"587\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:660;a:14:{s:2:\"id\";s:4:\"3339\";s:5:\"title\";s:35:\"Black Friday &#8211; Pop-Styled Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-2.png\";s:12:\"tmpl_created\";s:10:\"1511203636\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/black-friday-pop-styled-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"194\";s:16:\"popularity_index\";s:3:\"431\";s:11:\"trend_index\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:661;a:14:{s:2:\"id\";s:4:\"3335\";s:5:\"title\";s:31:\"Black Friday &#8211; Retail Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-4.png\";s:12:\"tmpl_created\";s:10:\"1511203246\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/black-friday-retail-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"195\";s:16:\"popularity_index\";s:3:\"435\";s:11:\"trend_index\";s:3:\"513\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:662;a:14:{s:2:\"id\";s:4:\"3340\";s:5:\"title\";s:41:\"Black Friday &#8211; Software Product Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-3.png\";s:12:\"tmpl_created\";s:10:\"1511203713\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/black-friday-software-product-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"196\";s:16:\"popularity_index\";s:3:\"416\";s:11:\"trend_index\";s:3:\"482\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:663;a:14:{s:2:\"id\";s:4:\"3517\";s:5:\"title\";s:27:\"Christmas &#8211; Gift Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/12/XmasThumb.png\";s:12:\"tmpl_created\";s:10:\"1513877937\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/christmas-gift-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"197\";s:16:\"popularity_index\";s:3:\"476\";s:11:\"trend_index\";s:3:\"614\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:664;a:14:{s:2:\"id\";s:4:\"3734\";s:5:\"title\";s:28:\"Christmas &#8211; Car Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v3.png\";s:12:\"tmpl_created\";s:10:\"1514197794\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/christmas-car-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"198\";s:16:\"popularity_index\";s:3:\"461\";s:11:\"trend_index\";s:3:\"580\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:665;a:14:{s:2:\"id\";s:4:\"3764\";s:5:\"title\";s:33:\"Christmas &#8211; Interior Design\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v6.png\";s:12:\"tmpl_created\";s:10:\"1514198234\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/christmas-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"199\";s:16:\"popularity_index\";s:3:\"442\";s:11:\"trend_index\";s:3:\"599\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:666;a:14:{s:2:\"id\";s:4:\"3565\";s:5:\"title\";s:27:\"Christmas &#8211; Tree Shop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/12/XmasTreeThumb.png\";s:12:\"tmpl_created\";s:10:\"1514204382\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/christmas-tree-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"200\";s:16:\"popularity_index\";s:3:\"390\";s:11:\"trend_index\";s:3:\"441\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:667;a:14:{s:2:\"id\";s:4:\"3862\";s:5:\"title\";s:35:\"Christmas &#8211; Design Conference\";s:9:\"thumbnail\";s:63:\"https://library.elementor.com/wp-content/uploads/2017/12/q1.png\";s:12:\"tmpl_created\";s:10:\"1514206745\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/christmas-design-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"201\";s:16:\"popularity_index\";s:3:\"380\";s:11:\"trend_index\";s:3:\"526\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:668;a:14:{s:2:\"id\";s:4:\"3777\";s:5:\"title\";s:39:\"Christmas &#8211; Snowboard Competition\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v7.png\";s:12:\"tmpl_created\";s:10:\"1514205420\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/christmas-snowboard-competition/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"202\";s:16:\"popularity_index\";s:3:\"403\";s:11:\"trend_index\";s:3:\"588\";s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:669;a:14:{s:2:\"id\";s:3:\"420\";s:5:\"title\";s:11:\"Hero UI Kit\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/09/library-ui-kit-cover.png\";s:12:\"tmpl_created\";s:10:\"1475067229\";s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/hero-ui-kit/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";s:3:\"203\";s:16:\"popularity_index\";s:2:\"20\";s:11:\"trend_index\";s:2:\"76\";s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}}}", "no");
INSERT INTO `wp_oneoptions` VALUES("207", "elementor_remote_info_feed_data", "a:5:{i:0;a:5:{s:5:\"title\";s:61:\"How to Design Your WordPress Site Using Elementor Theme Style\";s:7:\"excerpt\";s:177:\"Elementor Theme Style allows you to customize your website easily. In this tutorial, we’ll show you how to use the theme style to quickly build a unique and compelling design.\";s:7:\"created\";s:10:\"1586863421\";s:5:\"badge\";s:0:\"\";s:3:\"url\";s:148:\"https://elementor.com/blog/design-your-wordpress-site-elementor-theme-style/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:43:\"Elementor Meetups — March 2020 Highlights\";s:7:\"excerpt\";s:202:\"This last month we had to adapt our meetup planning to the COVID-19 pandemic circumstances. From mid-March, all our off-line meetups were replaced by virtual events in order to keep our community safe. \";s:7:\"created\";s:10:\"1586240820\";s:5:\"badge\";s:0:\"\";s:3:\"url\";s:128:\"https://elementor.com/blog/elementor-meetups-march-2020/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:59:\"Monday Masterclass: How to Write Great Web Design Proposals\";s:7:\"excerpt\";s:196:\"This week we’re looking at work proposals, what to consider, what to include in your price quote, and a pricing system for your services, especially if you’re building websites with Elementor.\";s:7:\"created\";s:10:\"1586158429\";s:5:\"badge\";s:0:\"\";s:3:\"url\";s:116:\"https://elementor.com/blog/website-proposal/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:3;a:5:{s:5:\"title\";s:45:\"6 Ways to Monetize WordPress Websites in 2020\";s:7:\"excerpt\";s:211:\"There are many methods for monetizing your WordPress site that can reinforce your business cash flow. In this article, we delve into the most effective ways to sustain your business when circumstances are shaky.\";s:7:\"created\";s:10:\"1585838838\";s:5:\"badge\";s:0:\"\";s:3:\"url\";s:118:\"https://elementor.com/blog/monetize-wordpress/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:4;a:5:{s:5:\"title\";s:73:\"Introducing Elementor Experts: The New Discovery Network For Web Creators\";s:7:\"excerpt\";s:232:\"We are proud to launch Elementor Experts, a brand new expert discovery network for web creators. Experts will help you showcase your best work, get hired or hire professional designers, marketers, and developers, all in one place.\r\n\";s:7:\"created\";s:10:\"1585657322\";s:5:\"badge\";s:3:\"New\";s:3:\"url\";s:119:\"https://elementor.com/blog/introducing-experts/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "no");
INSERT INTO `wp_oneoptions` VALUES("211", "ocean_extra_installed_time", "1585962041", "yes");
INSERT INTO `wp_oneoptions` VALUES("212", "wpforms_review", "a:2:{s:4:\"time\";i:1585962041;s:9:\"dismissed\";b:0;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("213", "_elementor_installed_time", "1585962041", "yes");
INSERT INTO `wp_oneoptions` VALUES("214", "fs_api_cache", "a:1:{s:55:\"get:/v1/plugins/3752/addons.json?enriched=true&count=50\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:7:\"plugins\";a:22:{i:0;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629141\";s:4:\"slug\";s:20:\"ocean-footer-callout\";s:5:\"title\";s:20:\"Ocean Footer Callout\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/icons/bec506a5749cb71fe0d1547d7c893a87.png\";s:15:\"default_plan_id\";s:4:\"6079\";s:5:\"plans\";i:6079;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:6101;s:21:\"active_installs_count\";i:4393;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_c3ff094ed1cbaf287c6f833d3ba09\";s:2:\"id\";s:4:\"3754\";s:7:\"created\";s:19:\"2019-05-06 13:24:01\";s:7:\"updated\";s:19:\"2020-04-14 20:53:21\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3754\";s:3:\"url\";s:51:\"https://oceanwp.org/extension/ocean-footer-callout/\";s:11:\"description\";s:280:\"<ul>\n<li>Display/hide the callout on any page/post</li>\n<li>Edit the content and button url on any page/post</li>\n<li>Display the page content on the callout</li>\n<li>Enable/disable the callout button</li>\n<li>Add your own padding top/bottom</li>\n<li>Add your own color</li> </ul>\";s:17:\"short_description\";s:65:\"Add some important information about your company in your footer.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/card_banner.png\";s:15:\"selling_point_0\";s:41:\"Display/hide the callout on any page/post\";s:15:\"selling_point_1\";s:48:\"Edit the content and button url on any page/post\";s:15:\"selling_point_2\";s:39:\"Display the page content on the callout\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3754/screenshots/2.png\";}s:2:\"id\";s:3:\"821\";s:7:\"created\";s:19:\"2019-05-16 04:54:10\";s:7:\"updated\";s:19:\"2019-08-04 06:53:40\";}s:12:\"premium_slug\";s:20:\"ocean-footer-callout\";}i:1;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629149\";s:4:\"slug\";s:19:\"ocean-sticky-header\";s:5:\"title\";s:19:\"Ocean Sticky Header\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/icons/85148d096a3d4157cb78b020421bdfd3.png\";s:15:\"default_plan_id\";s:4:\"6078\";s:5:\"plans\";i:6078;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:20038;s:21:\"active_installs_count\";i:17912;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:118;s:14:\"total_renewals\";i:1;s:8:\"earnings\";d:3308.66;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_21f01f3d0a79bcd65042e3c332188\";s:2:\"id\";s:4:\"3755\";s:7:\"created\";s:19:\"2019-05-06 13:27:16\";s:7:\"updated\";s:19:\"2020-04-14 21:05:54\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3755\";s:3:\"url\";s:50:\"https://oceanwp.org/extension/ocean-sticky-header/\";s:11:\"description\";s:512:\"<ul>\n<li>Stick manually, perfect for the Custom Header style</li>\n<li>Fixed the top bar</li>\n<li>Add sticky mobile</li>\n<li>Choose between two sticky styles: Shrink or Fixed</li>\n<li>Choose between two sticky effects</li>\n<li>Enter the height of the header during scroll for the shrink style</li>\n<li>Add logo when scrolling</li>\n<li>Enter the height of the logo during scroll for the shrink style</li>\n<li>Choose the header opacity during scroll</li>\n<li>Choose the background and color during scroll</li> </ul>\";s:17:\"short_description\";s:63:\"Attach an eye-catching header at the top of your website pages.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/card_banner.png\";s:15:\"selling_point_0\";s:51:\"Stick manually, perfect for the Custom Header style\";s:15:\"selling_point_1\";s:17:\"Fixed the top bar\";s:15:\"selling_point_2\";s:17:\"Add sticky mobile\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3755/screenshots/2.png\";}s:2:\"id\";s:3:\"829\";s:7:\"created\";s:19:\"2019-05-16 05:01:04\";s:7:\"updated\";s:19:\"2019-08-04 07:27:06\";}s:12:\"premium_slug\";s:19:\"ocean-sticky-header\";}i:2;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629165\";s:4:\"slug\";s:16:\"ocean-side-panel\";s:5:\"title\";s:16:\"Ocean Side Panel\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3756/icons/e88e1d58965c5e4453f9adbdc0704df4.png\";s:15:\"default_plan_id\";s:4:\"6077\";s:5:\"plans\";i:6077;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:5455;s:21:\"active_installs_count\";i:3902;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:3;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:2;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:29.99;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_95ab9dabcffc015befcfaf19dd91e\";s:2:\"id\";s:4:\"3756\";s:7:\"created\";s:19:\"2019-05-06 13:30:08\";s:7:\"updated\";s:19:\"2020-04-14 20:38:21\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3756\";s:3:\"url\";s:47:\"https://oceanwp.org/extension/ocean-side-panel/\";s:11:\"description\";s:443:\"<ul>\n<li>Add your widgets into the Side Panel sidebar</li>\n<li>Choose your icon for the opening button</li>\n<li>Add text for the opening button</li>\n<li>Add a custom width for the panel</li>\n<li>Display the panel to the left or right</li>\n<li>Displace or not the panel</li>\n<li>Add an overlay when the panel is opened</li>\n<li>Show/Hide the close button of the panel</li>\n<li>Change the close button text</li>\n<li>Add your own color</li> </ul>\";s:17:\"short_description\";s:63:\"Add a responsive side panel with your preferred widgets inside.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3756/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3756/card_banner.png\";s:15:\"selling_point_0\";s:44:\"Add your widgets into the Side Panel sidebar\";s:15:\"selling_point_1\";s:39:\"Choose your icon for the opening button\";s:15:\"selling_point_2\";s:31:\"Add text for the opening button\";s:11:\"screenshots\";O:8:\"stdClass\":1:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3756/screenshots/0.png\";}s:2:\"id\";s:3:\"827\";s:7:\"created\";s:19:\"2019-05-16 05:00:01\";s:7:\"updated\";s:19:\"2019-08-04 07:22:03\";}s:12:\"premium_slug\";s:16:\"ocean-side-panel\";}i:3;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629243\";s:4:\"slug\";s:23:\"ocean-elementor-widgets\";s:5:\"title\";s:23:\"Ocean Elementor Widgets\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/icons/c403505d517eaedf5ec1e8e0feec6c34.png\";s:15:\"default_plan_id\";s:4:\"6076\";s:5:\"plans\";i:6076;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:21064;s:21:\"active_installs_count\";i:17049;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:4;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:92;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:2790.35;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_25eeed8cddc1b8bede158756886e8\";s:2:\"id\";s:4:\"3757\";s:7:\"created\";s:19:\"2019-05-06 13:36:11\";s:7:\"updated\";s:19:\"2020-04-14 21:39:17\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3757\";s:3:\"url\";s:54:\"https://oceanwp.org/extension/ocean-elementor-widgets/\";s:11:\"description\";s:1290:\"<ul>\n<li>Accordions widget</li>\n<li>Advanced Custom Field widget, thanks to Bruno Tritsch for the help</li>\n<li>Advanced Heading widget</li>\n<li>Animated Heading widget</li>\n<li>Banner widget</li>\n<li>Brands widget</li>\n<li>Business Hours widget</li>\n<li>Button Effects widget</li>\n<li>Buttons widget</li>\n<li>Call To Action widget</li>\n<li>Circle Progress widget</li>\n<li>Countdown widget</li>\n<li>Divider widget, to add a text or an icon in the divider</li>\n<li>Flip Box widget</li>\n<li>Google Maps widget</li>\n<li>Hotspots widget</li>\n<li>Image Comparison widget</li>\n<li>Image Gallery widget</li>\n<li>Info Box widget</li>\n<li>Instagram Feed widget</li>\n<li>Link Effects widget</li>\n<li>Login widget</li>\n<li>Lost Password widget</li>\n<li>Register widget</li>\n<li>Modal widget</li>\n<li>Navbar widget</li>\n<li>Off Canvas widget</li>\n<li>Price List widget</li>\n<li>Recipe widget</li>\n<li>Scroll Up widget</li>\n<li>Switch widget</li>\n<li>Table widget</li>\n<li>Tabs widget</li>\n<li>Team Members widget</li>\n<li>Timeline widget</li>\n<li>Contact Form 7 widget</li>\n<li>Gravity Forms widget</li>\n<li>WPForms widget</li>\n<li>Caldera Forms widget</li>\n<li>Ninja Forms widget</li>\n<li>WooCommerce Products widget</li>\n<li>WooCommerce Categories widget</li>\n<li>WooCommerce Slider widget</li> </ul>\";s:17:\"short_description\";s:75:\"Add many new powerful widgets to the popular free page builder - Elementor.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/card_banner.png\";s:15:\"selling_point_0\";s:23:\"Image Comparison widget\";s:15:\"selling_point_1\";s:21:\"Instagram Feed widget\";s:15:\"selling_point_2\";s:12:\"Table widget\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/screenshots/2.png\";s:12:\"screenshot_3\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3757/screenshots/3.png\";}s:2:\"id\";s:3:\"820\";s:7:\"created\";s:19:\"2019-05-16 04:53:49\";s:7:\"updated\";s:19:\"2019-08-04 06:51:31\";}s:12:\"premium_slug\";s:23:\"ocean-elementor-widgets\";}i:4;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629263\";s:4:\"slug\";s:11:\"ocean-hooks\";s:5:\"title\";s:11:\"Ocean Hooks\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/icons/7df3f43b29db802dbdc4bf12323e9034.png\";s:15:\"default_plan_id\";s:4:\"6075\";s:5:\"plans\";i:6075;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:7593;s:21:\"active_installs_count\";i:6431;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:2;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:29.99;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_bf5672ee85c0032b2b4d7c0a3d244\";s:2:\"id\";s:4:\"3758\";s:7:\"created\";s:19:\"2019-05-06 13:39:32\";s:7:\"updated\";s:19:\"2020-04-14 20:37:21\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3758\";s:3:\"url\";s:42:\"https://oceanwp.org/extension/ocean-hooks/\";s:11:\"description\";s:278:\"<ul>\n<li>Add different content for the same hook location</li>\n<li>Add shortcode</li>\n<li>Add PHP code</li>\n<li>Add content only for logged in/out users</li>\n<li>Display your code on the page/post/taxonomy you want</li>\n<li>Display your code on the user role you want</li> </ul>\";s:17:\"short_description\";s:60:\"Add your custom content throughout various areas of OceanWP.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/card_banner.png\";s:15:\"selling_point_0\";s:48:\"Add different content for the same hook location\";s:15:\"selling_point_1\";s:13:\"Add shortcode\";s:15:\"selling_point_2\";s:12:\"Add PHP code\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3758/screenshots/2.png\";}s:2:\"id\";s:3:\"823\";s:7:\"created\";s:19:\"2019-05-16 04:54:56\";s:7:\"updated\";s:19:\"2019-08-04 07:02:53\";}s:12:\"premium_slug\";s:11:\"ocean-hooks\";}i:5;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629271\";s:4:\"slug\";s:19:\"ocean-sticky-footer\";s:5:\"title\";s:19:\"Ocean Sticky Footer\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/icons/0b821026b5a995b136dc9b01ba1a13de.png\";s:15:\"default_plan_id\";s:4:\"6074\";s:5:\"plans\";i:6074;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:4942;s:21:\"active_installs_count\";i:3239;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:1;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:29.99;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_5552f1b8d38d0f09df4b2990b57b2\";s:2:\"id\";s:4:\"3759\";s:7:\"created\";s:19:\"2019-05-06 13:41:42\";s:7:\"updated\";s:19:\"2020-04-14 21:09:41\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3759\";s:3:\"url\";s:50:\"https://oceanwp.org/extension/ocean-sticky-footer/\";s:11:\"description\";s:163:\"<ul>\n<li>Add menu in the footer bar</li>\n<li>Add text in the footer bar</li>\n<li>Choose your own colors</li>\n<li>Hide Menu and/or text on mobile screens</li> </ul>\";s:17:\"short_description\";s:69:\"A simple extension to attach your footer to the bottom of the screen.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/card_banner.png\";s:15:\"selling_point_0\";s:26:\"Add menu in the footer bar\";s:15:\"selling_point_1\";s:26:\"Add text in the footer bar\";s:15:\"selling_point_2\";s:22:\"Choose your own colors\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3759/screenshots/2.png\";}s:2:\"id\";s:3:\"828\";s:7:\"created\";s:19:\"2019-05-16 05:00:32\";s:7:\"updated\";s:19:\"2019-08-04 07:25:54\";}s:12:\"premium_slug\";s:19:\"ocean-sticky-footer\";}i:6;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629304\";s:4:\"slug\";s:15:\"ocean-woo-popup\";s:5:\"title\";s:15:\"Ocean Woo Popup\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/icons/0430e84fecb53c3ec35df5759e22f7b2.png\";s:15:\"default_plan_id\";s:4:\"6073\";s:5:\"plans\";i:6073;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:5051;s:21:\"active_installs_count\";i:3891;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:2;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:29.99;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_9414dbc7719b150c20046f728e994\";s:2:\"id\";s:4:\"3760\";s:7:\"created\";s:19:\"2019-05-06 13:53:08\";s:7:\"updated\";s:19:\"2020-04-14 20:38:51\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3760\";s:3:\"url\";s:46:\"https://oceanwp.org/extension/ocean-woo-popup/\";s:11:\"description\";s:333:\"<ul>\n<li>Select an Elementor template (or a page if you use another page builder) to replace the content of the popup</li>\n<li>Control width, height, padding and the border radius</li>\n<li>Show/hide and reorganize the elements of the popup</li>\n<li>Replace all the texts from the customizer</li>\n<li>Choose your own colors</li> </ul>\";s:17:\"short_description\";s:79:\"A simple extension to display a popup when you click on the Add To Cart button.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/card_banner.png\";s:15:\"selling_point_0\";s:108:\"Select an Elementor template (or a page if you use another page builder) to replace the content of the popup\";s:15:\"selling_point_1\";s:52:\"Control width, height, padding and the border radius\";s:15:\"selling_point_2\";s:50:\"Show/hide and reorganize the elements of the popup\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3760/screenshots/2.png\";}s:2:\"id\";s:3:\"831\";s:7:\"created\";s:19:\"2019-05-16 05:02:03\";s:7:\"updated\";s:19:\"2019-08-04 07:39:37\";}s:12:\"premium_slug\";s:23:\"ocean-woo-popup-premium\";}i:7;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629316\";s:4:\"slug\";s:15:\"ocean-portfolio\";s:5:\"title\";s:15:\"Ocean Portfolio\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/icons/7279eda792d103bde5896515ef4e63be.png\";s:15:\"default_plan_id\";s:4:\"6072\";s:5:\"plans\";i:6072;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:4557;s:21:\"active_installs_count\";i:3752;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:3;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:2;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:76.98;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_d0109c81ea2f48fdfa29c30d9d20b\";s:2:\"id\";s:4:\"3761\";s:7:\"created\";s:19:\"2019-05-06 13:55:52\";s:7:\"updated\";s:19:\"2020-04-14 21:00:05\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3761\";s:3:\"url\";s:46:\"https://oceanwp.org/extension/ocean-portfolio/\";s:11:\"description\";s:473:\"<ul>\n<li>Display your portfolio anywhere you want via a page template or a shortcode</li>\n<li>Show/hide the filter bar</li>\n<li>Control the filter bar positioning, styling and typography</li>\n<li>Control the portfolio items styling like the margin, padding, color, overlay color,\ntypography, etc...</li>\n<li>Add your own images width and height</li>\n<li>Display items by author, categories or tags, sort by order and exclude categories</li>\n<li>And a lot more...</li> </ul>\";s:17:\"short_description\";s:75:\"A complete extension to display your portfolio and work in a beautiful way.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/card_banner.png\";s:15:\"selling_point_0\";s:75:\"Display your portfolio anywhere you want via a page template or a shortcode\";s:15:\"selling_point_1\";s:24:\"Show/hide the filter bar\";s:15:\"selling_point_2\";s:58:\"Control the filter bar positioning, styling and typography\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3761/screenshots/2.png\";}s:2:\"id\";s:3:\"826\";s:7:\"created\";s:19:\"2019-05-16 04:56:11\";s:7:\"updated\";s:19:\"2019-08-04 07:20:12\";}s:12:\"premium_slug\";s:15:\"ocean-portfolio\";}i:8;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629325\";s:4:\"slug\";s:17:\"ocean-white-label\";s:5:\"title\";s:17:\"Ocean White Label\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/icons/5fb23be4920f1bcb4c61b01ab2fc75fb.png\";s:15:\"default_plan_id\";s:4:\"6071\";s:5:\"plans\";i:6071;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:4588;s:21:\"active_installs_count\";i:3925;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_c9bb8f8d46af4c19cc2b66105accb\";s:2:\"id\";s:4:\"3762\";s:7:\"created\";s:19:\"2019-05-06 13:57:59\";s:7:\"updated\";s:19:\"2020-04-14 20:38:44\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3762\";s:3:\"url\";s:48:\"https://oceanwp.org/extension/ocean-white-label/\";s:11:\"description\";s:302:\"<ul>\n<li>Add your own branding name in the admin pages</li>\n<li>Add your own theme name</li>\n<li>Add your own theme author</li>\n<li>Add your own theme author url</li>\n<li>Add your own theme description</li>\n<li>Add your own theme screenshot</li>\n<li>Remove the White Label box in Theme Panel</li> </ul>\";s:17:\"short_description\";s:69:\"Impress clients by replacing the OceanWP name by your own brand name.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/card_banner.png\";s:15:\"selling_point_0\";s:45:\"Add your own branding name in the admin pages\";s:15:\"selling_point_1\";s:68:\"Add your own theme name, author, author url, description, screenshot\";s:15:\"selling_point_2\";s:41:\"Remove the White Label box in Theme Panel\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3762/screenshots/2.png\";}s:2:\"id\";s:3:\"830\";s:7:\"created\";s:19:\"2019-05-16 05:01:36\";s:7:\"updated\";s:19:\"2019-08-04 07:36:38\";}s:12:\"premium_slug\";s:17:\"ocean-white-label\";}i:9;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629330\";s:4:\"slug\";s:15:\"ocean-instagram\";s:5:\"title\";s:15:\"Ocean Instagram\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/icons/8b0a80f52bcda98cf367971dd98152d4.png\";s:15:\"default_plan_id\";s:4:\"6070\";s:5:\"plans\";i:6070;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:4848;s:21:\"active_installs_count\";i:3875;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:1;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:3;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:89.97;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_60babf307a20c89d435bcd61d54e8\";s:2:\"id\";s:4:\"3763\";s:7:\"created\";s:19:\"2019-05-06 14:00:21\";s:7:\"updated\";s:19:\"2020-04-14 21:05:02\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3763\";s:3:\"url\";s:46:\"https://oceanwp.org/extension/ocean-instagram/\";s:11:\"description\";s:224:\"<ul>\n<li>Display your Instagram photos</li>\n<li>Choose the column number</li>\n<li>Show/hide the likes &amp; comments</li>\n<li>Show/hide the captions</li>\n<li>Display your username, follow, posts, biograhpy, etc...</li> </ul>\";s:17:\"short_description\";s:70:\"Fetch and customize your Instagram feed to display in a beautiful way.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/card_banner.png\";s:15:\"selling_point_0\";s:29:\"Display your Instagram photos\";s:15:\"selling_point_1\";s:24:\"Choose the column number\";s:15:\"selling_point_2\";s:34:\"Show/hide the likes &amp; comments\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3763/screenshots/2.png\";}s:2:\"id\";s:3:\"824\";s:7:\"created\";s:19:\"2019-05-16 04:55:16\";s:7:\"updated\";s:19:\"2019-08-04 07:11:09\";}s:12:\"premium_slug\";s:15:\"ocean-instagram\";}i:10;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629332\";s:4:\"slug\";s:17:\"ocean-popup-login\";s:5:\"title\";s:17:\"Ocean Popup Login\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/icons/d5cd0bf761dd09b3ab23ab234d1d7ee9.png\";s:15:\"default_plan_id\";s:4:\"6069\";s:5:\"plans\";i:6069;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:7817;s:21:\"active_installs_count\";i:6867;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:5;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:4;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:169.97;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_e0499681c773af2bbac0016bb24ff\";s:2:\"id\";s:4:\"3764\";s:7:\"created\";s:19:\"2019-05-06 14:02:12\";s:7:\"updated\";s:19:\"2020-04-14 20:38:37\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3764\";s:3:\"url\";s:48:\"https://oceanwp.org/extension/ocean-popup-login/\";s:11:\"description\";s:185:\"<ul>\n<li>Add the login/register link where you want</li>\n<li>Style the form</li>\n<li>Add a background image in the form</li>\n<li>Change the title and description for the form</li> </ul>\";s:17:\"short_description\";s:59:\"A plugin to add a popup login/register form where you want.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/card_banner.png\";s:15:\"selling_point_0\";s:42:\"Add the login/register link where you want\";s:15:\"selling_point_1\";s:14:\"Style the form\";s:15:\"selling_point_2\";s:34:\"Add a background image in the form\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3764/screenshots/2.png\";}s:2:\"id\";s:3:\"825\";s:7:\"created\";s:19:\"2019-05-16 04:55:50\";s:7:\"updated\";s:19:\"2019-08-04 07:12:58\";}s:12:\"premium_slug\";s:17:\"ocean-popup-login\";}i:11;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629338\";s:4:\"slug\";s:19:\"ocean-cookie-notice\";s:5:\"title\";s:19:\"Ocean Cookie Notice\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/icons/82552898a159e5b0f04c8ffb62a9d7bb.png\";s:15:\"default_plan_id\";s:4:\"6068\";s:5:\"plans\";i:6068;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:4777;s:21:\"active_installs_count\";i:2874;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:1;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:29.99;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_2ebffcd411ce5f21e543822065b7d\";s:2:\"id\";s:4:\"3765\";s:7:\"created\";s:19:\"2019-05-06 14:04:05\";s:7:\"updated\";s:19:\"2020-04-14 21:04:03\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3765\";s:3:\"url\";s:50:\"https://oceanwp.org/extension/ocean-cookie-notice/\";s:11:\"description\";s:368:\"<ul>\n<li>Add scripts that will be loaded only after the user consent</li>\n<li>Choose to reload the page after the cookie accept</li>\n<li>Two notice styles</li>\n<li>Add your own content</li>\n<li>Add your own button text</li>\n<li>Choose between a button or a close icon to close the notice</li>\n<li>Many styling settings to customize every parts of the notice</li> </ul>\";s:17:\"short_description\";s:91:\"\nInform users that you are using cookies to comply with the EU cookie law GDPR regulations.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/card_banner.png\";s:15:\"selling_point_0\";s:59:\"Add scripts that will be loaded only after the user consent\";s:15:\"selling_point_1\";s:49:\"Choose to reload the page after the cookie accept\";s:15:\"selling_point_2\";s:17:\"Two notice styles\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/screenshots/2.png\";s:12:\"screenshot_3\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3765/screenshots/3.png\";}s:2:\"id\";s:3:\"817\";s:7:\"created\";s:19:\"2019-05-15 10:13:47\";s:7:\"updated\";s:19:\"2019-08-04 06:36:09\";}s:12:\"premium_slug\";s:19:\"ocean-cookie-notice\";}i:12;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2629341\";s:4:\"slug\";s:17:\"ocean-full-screen\";s:5:\"title\";s:17:\"Ocean Full Screen\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/icons/ceb8fda62fbae704a43b326772e28e3f.png\";s:15:\"default_plan_id\";s:4:\"6067\";s:5:\"plans\";i:6067;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:5173;s:21:\"active_installs_count\";i:4266;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:1;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:29.99;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_e0f5fb19e66d3b97f64adb891fae5\";s:2:\"id\";s:4:\"3766\";s:7:\"created\";s:19:\"2019-05-06 14:06:43\";s:7:\"updated\";s:19:\"2020-04-14 20:37:53\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3766\";s:3:\"url\";s:48:\"https://oceanwp.org/extension/ocean-full-screen/\";s:11:\"description\";s:241:\"<ul>\n<li>Very easy to use</li>\n<li>Add your own scrolling speed</li>\n<li>Add a side navigation</li>\n<li>Change the navigation color</li>\n<li>Add tooltips to the navigation</li>\n<li>Disable the scrolling effect at the size you want</li> </ul>\";s:17:\"short_description\";s:63:\"A simple and easy way to create a fullscreen scrolling website.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/card_banner.png\";s:15:\"selling_point_0\";s:16:\"Very easy to use\";s:15:\"selling_point_1\";s:28:\"Add your own scrolling speed\";s:15:\"selling_point_2\";s:21:\"Add a side navigation\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3766/screenshots/2.png\";}s:2:\"id\";s:3:\"822\";s:7:\"created\";s:19:\"2019-05-16 04:54:33\";s:7:\"updated\";s:19:\"2019-08-04 06:57:28\";}s:12:\"premium_slug\";s:17:\"ocean-full-screen\";}i:13;O:8:\"stdClass\":37:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2650006\";s:4:\"slug\";s:15:\"ocean-pro-demos\";s:5:\"title\";s:15:\"Ocean Pro Demos\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3797/icons/92e859b19391b3fda145dd81cbe14f1b.png\";s:15:\"default_plan_id\";s:4:\"6115\";s:5:\"plans\";i:6115;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:8399;s:21:\"active_installs_count\";i:6307;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:3;s:14:\"total_renewals\";i:0;s:8:\"earnings\";d:59.98;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_a34c58ab5e7159d54e88175c1c03f\";s:2:\"id\";s:4:\"3797\";s:7:\"created\";s:19:\"2019-05-14 12:39:32\";s:7:\"updated\";s:19:\"2020-04-14 21:16:37\";s:12:\"premium_slug\";s:15:\"ocean-pro-demos\";}i:14;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2655231\";s:4:\"slug\";s:11:\"ocean-extra\";s:5:\"title\";s:11:\"Ocean Extra\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/icons/a8a66d9af9373c572cd362013c38fdef.png\";s:15:\"default_plan_id\";s:4:\"6131\";s:5:\"plans\";i:6131;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:0;s:21:\"active_installs_count\";i:0;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_dc69e18411e45b6f22272ac4586b1\";s:2:\"id\";s:4:\"3806\";s:7:\"created\";s:19:\"2019-05-16 07:48:04\";s:7:\"updated\";s:19:\"2019-05-16 07:48:04\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3806\";s:3:\"url\";N;s:11:\"description\";s:759:\"<ul>\n<li style=\"color: #333;font-weight: 600\">Meta Boxes</li>\n<li>Change the layout per page/post</li>\n<li>Select the sidebar per page/post</li>\n<li>Enable/Disable the margins top/bottom</li>\n<li>Enable/Disable the title</li>\n<li>Add a custom title</li>\n<li>Add a subheading for your title</li>\n<li>Select the style of your title</li>\n<li>Unique options for the different post format</li>\n<li>Add gallery image for the gallery post format</li>\n<li>And much more...</li>\n<li style=\"color: #333;font-weight: 600;margin-top: 20px\">Theme Panel</li>\n<li>Enable/Disable the Customizer panels</li>\n<li>Activate the licenses of the OceanWP extensions</li>\n<li>Enable/Disable all the theme scripts &amp; styles</li>\n<li>Import/Export the customizer settings</li> </ul>\";s:17:\"short_description\";N;s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/card_banner.png\";s:15:\"selling_point_0\";s:31:\"Change the layout per page/post\";s:15:\"selling_point_1\";s:32:\"Select the sidebar per page/post\";s:15:\"selling_point_2\";s:45:\"Add gallery image for the gallery post format\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3806/screenshots/2.png\";}s:2:\"id\";s:3:\"832\";s:7:\"created\";s:19:\"2019-05-16 08:37:18\";s:7:\"updated\";s:19:\"2019-08-04 07:50:27\";}s:12:\"premium_slug\";s:19:\"ocean-extra-premium\";}i:15;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2655252\";s:4:\"slug\";s:20:\"ocean-social-sharing\";s:5:\"title\";s:20:\"Ocean Social Sharing\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/icons/472046596ff2243e1bab433a07d35533.png\";s:15:\"default_plan_id\";s:4:\"6132\";s:5:\"plans\";i:6132;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:48742;s:21:\"active_installs_count\";i:43633;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_0aa6121ff893b29efa9a58d6c0ad5\";s:2:\"id\";s:4:\"3807\";s:7:\"created\";s:19:\"2019-05-16 07:53:38\";s:7:\"updated\";s:19:\"2020-04-14 21:42:05\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3807\";s:3:\"url\";N;s:11:\"description\";s:336:\"<ul>\n<li>Add social networks: Twitter, Facebook, LinkedIn, Google+, Pinterest, Viber, VK, Reddit, Tumblr and Viadeo.</li>\n<li>Alter the social sharing buttons.</li>\n<li>Choose between three styles.</li>\n<li>Add the social names.</li>\n<li>Choose the heading position.</li>\n<li>Add or edit the social sharing via a child theme.</li> </ul>\";s:17:\"short_description\";s:58:\"A simple plugin to add social share buttons to your posts.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/card_banner.png\";s:15:\"selling_point_0\";s:106:\"Add social networks: Twitter, Facebook, LinkedIn, Google+, Pinterest, Viber, VK, Reddit, Tumblr and Viadeo\";s:15:\"selling_point_1\";s:32:\"Alter the social sharing buttons\";s:15:\"selling_point_2\";s:27:\"Choose between three styles\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/screenshots/2.png\";s:12:\"screenshot_3\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3807/screenshots/3.png\";}s:2:\"id\";s:3:\"838\";s:7:\"created\";s:19:\"2019-05-16 08:44:21\";s:7:\"updated\";s:19:\"2019-08-04 08:00:26\";}s:12:\"premium_slug\";s:28:\"ocean-social-sharing-premium\";}i:16;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2655271\";s:4:\"slug\";s:21:\"ocean-product-sharing\";s:5:\"title\";s:21:\"Ocean Product Sharing\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/icons/be28eef8c31337b3f73addbcce9dfde4.png\";s:15:\"default_plan_id\";s:4:\"6135\";s:5:\"plans\";i:6135;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:24945;s:21:\"active_installs_count\";i:21954;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_e8cc3b7980be98f86dc7286572cc0\";s:2:\"id\";s:4:\"3809\";s:7:\"created\";s:19:\"2019-05-16 08:00:39\";s:7:\"updated\";s:19:\"2020-04-14 21:42:04\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3809\";s:3:\"url\";N;s:11:\"description\";s:177:\"<ul>\n<li>Add social twitter, facebook, pinterest and email sharing</li>\n<li>Alter the social sharing buttons</li>\n<li>Add or edit the social sharing via a child theme</li> </ul>\";s:17:\"short_description\";s:121:\"A simple plugin to add social share buttons to your product page, compatible with WooCommerce and Easy Digital Downloads.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/card_banner.png\";s:15:\"selling_point_0\";s:57:\"Add social twitter, facebook, pinterest and email sharing\";s:15:\"selling_point_1\";s:32:\"Alter the social sharing buttons\";s:15:\"selling_point_2\";s:48:\"Add or edit the social sharing via a child theme\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3809/screenshots/2.png\";}s:2:\"id\";s:3:\"837\";s:7:\"created\";s:19:\"2019-05-16 08:43:10\";s:7:\"updated\";s:19:\"2019-08-04 07:55:00\";}s:12:\"premium_slug\";s:29:\"ocean-product-sharing-premium\";}i:17;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2655279\";s:4:\"slug\";s:20:\"ocean-custom-sidebar\";s:5:\"title\";s:20:\"Ocean Custom Sidebar\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/icons/06fd0e67684e995d78b72746831434ac.png\";s:15:\"default_plan_id\";s:4:\"6136\";s:5:\"plans\";i:6136;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:23089;s:21:\"active_installs_count\";i:19072;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_e1fc615375e847fd4d955c62b2a34\";s:2:\"id\";s:4:\"3810\";s:7:\"created\";s:19:\"2019-05-16 08:04:08\";s:7:\"updated\";s:19:\"2020-04-14 21:42:03\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3810\";s:3:\"url\";N;s:11:\"description\";s:58:\"<ul>\n<li>Create an unlimited number of sidebars</li> </ul>\";s:17:\"short_description\";s:136:\"Generates an unlimited number of sidebars and place them anywhere you wish. Go to Theme Panel > Sidebars to create your custom sidebars.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/card_banner.png\";s:15:\"selling_point_0\";s:38:\"Create an unlimited number of sidebars\";s:15:\"selling_point_1\";N;s:15:\"selling_point_2\";N;s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3810/screenshots/2.png\";}s:2:\"id\";s:3:\"833\";s:7:\"created\";s:19:\"2019-05-16 08:38:20\";s:7:\"updated\";s:19:\"2019-08-04 07:47:46\";}s:12:\"premium_slug\";s:28:\"ocean-custom-sidebar-premium\";}i:18;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2655283\";s:4:\"slug\";s:17:\"ocean-demo-import\";s:5:\"title\";s:17:\"Ocean Demo Import\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/icons/bac62de0483069acf490a59267f15f99.png\";s:15:\"default_plan_id\";s:4:\"6137\";s:5:\"plans\";i:6137;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:16046;s:21:\"active_installs_count\";i:9525;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_28285e0f391b4955f4460589da147\";s:2:\"id\";s:4:\"3811\";s:7:\"created\";s:19:\"2019-05-16 08:06:15\";s:7:\"updated\";s:19:\"2020-04-14 21:34:47\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3811\";s:3:\"url\";N;s:11:\"description\";s:55:\"<ul>\n<li>Import the sample data in one click</li> </ul>\";s:17:\"short_description\";s:80:\"Import the OceanWP demo content, widgets and customizer settings with one click.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/card_banner.png\";s:15:\"selling_point_0\";s:35:\"Import the sample data in one click\";s:15:\"selling_point_1\";N;s:15:\"selling_point_2\";N;s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3811/screenshots/2.png\";}s:2:\"id\";s:3:\"834\";s:7:\"created\";s:19:\"2019-05-16 08:39:11\";s:7:\"updated\";s:19:\"2019-08-04 07:48:57\";}s:12:\"premium_slug\";s:27:\"activity-log-mainwp-premium\";}i:19;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2655290\";s:4:\"slug\";s:18:\"ocean-posts-slider\";s:5:\"title\";s:18:\"Ocean Posts Slider\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/icons/9672cd2dd221c216014c9ad6f73e8d64.png\";s:15:\"default_plan_id\";s:4:\"6139\";s:5:\"plans\";i:6139;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:11343;s:21:\"active_installs_count\";i:9144;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_eae1ef26c136dd8af5ef7a6cf7557\";s:2:\"id\";s:4:\"3813\";s:7:\"created\";s:19:\"2019-05-16 08:08:26\";s:7:\"updated\";s:19:\"2020-04-14 21:34:21\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3813\";s:3:\"url\";N;s:11:\"description\";s:373:\"<ul>\n<li>Choose your slider style</li>\n<li>Enter the number of posts to display</li>\n<li>Select the size of the images</li>\n<li>Change the read more text</li>\n<li>Enter a margin to add a space between the slider and your content</li>\n<li>Enter the transition speed of the slides</li>\n<li>Exclude categories of posts</li>\n<li>Choose the order and oder by of posts</li> </ul>\";s:17:\"short_description\";s:71:\"Display your latest posts in a beautiful slider with different options.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/card_banner.png\";s:15:\"selling_point_0\";s:24:\"Choose your slider style\";s:15:\"selling_point_1\";s:36:\"Enter the number of posts to display\";s:15:\"selling_point_2\";s:29:\"Select the size of the images\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3813/screenshots/2.png\";}s:2:\"id\";s:3:\"836\";s:7:\"created\";s:19:\"2019-05-16 08:42:09\";s:7:\"updated\";s:19:\"2019-08-04 07:53:25\";}s:12:\"premium_slug\";s:26:\"ocean-posts-slider-premium\";}i:20;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2655295\";s:4:\"slug\";s:18:\"ocean-modal-window\";s:5:\"title\";s:18:\"Ocean Modal Window\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/icons/6f292d54bf178d4f0e6ea68523fcc206.png\";s:15:\"default_plan_id\";s:4:\"6140\";s:5:\"plans\";i:6140;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:6964;s:21:\"active_installs_count\";i:5643;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_7e254472063a1abd3b7e342930210\";s:2:\"id\";s:4:\"3814\";s:7:\"created\";s:19:\"2019-05-16 08:10:28\";s:7:\"updated\";s:19:\"2020-04-14 21:36:58\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3814\";s:3:\"url\";N;s:11:\"description\";s:203:\"<ul>\n<li>Create as many modals as you want</li>\n<li>Choose your custom width</li>\n<li>Insert the content you want (shortcodes allowed)</li>\n<li>Choose your own colors</li>\n<li>Fully responsive</li> </ul>\";s:17:\"short_description\";s:80:\"Insert any content in a modals and place the opening button anywhere to open it.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/card_banner.png\";s:15:\"selling_point_0\";s:33:\"Create as many modals as you want\";s:15:\"selling_point_1\";s:24:\"Choose your custom width\";s:15:\"selling_point_2\";s:48:\"Insert the content you want (shortcodes allowed)\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/screenshots/0.png\";s:12:\"screenshot_1\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/screenshots/1.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3814/screenshots/2.png\";}s:2:\"id\";s:3:\"835\";s:7:\"created\";s:19:\"2019-05-16 08:40:03\";s:7:\"updated\";s:19:\"2019-08-04 07:51:54\";}s:12:\"premium_slug\";s:26:\"ocean-modal-window-premium\";}i:21;O:8:\"stdClass\":38:{s:16:\"parent_plugin_id\";s:4:\"3752\";s:12:\"developer_id\";s:4:\"4545\";s:10:\"install_id\";s:7:\"2655298\";s:4:\"slug\";s:20:\"ocean-stick-anything\";s:5:\"title\";s:20:\"Ocean Stick Anything\";s:11:\"environment\";i:0;s:4:\"icon\";s:93:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/icons/57da39476e63889a0289c2e64206c970.png\";s:15:\"default_plan_id\";s:4:\"6141\";s:5:\"plans\";i:6141;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:0:\"\";s:11:\"is_released\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:14:\"installs_count\";i:20724;s:21:\"active_installs_count\";i:17483;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:15:\"total_purchases\";i:0;s:19:\"total_subscriptions\";i:0;s:14:\"total_renewals\";i:0;s:8:\"earnings\";i:0;s:10:\"commission\";s:0:\"\";s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_f9a790f52e74ee60eb2812ba763dd\";s:2:\"id\";s:4:\"3815\";s:7:\"created\";s:19:\"2019-05-16 08:12:51\";s:7:\"updated\";s:19:\"2020-04-14 21:42:07\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:4:\"3815\";s:3:\"url\";N;s:11:\"description\";s:190:\"<ul>\n<li>Stick one or several elements</li>\n<li>Add an offset to add a spacing between the top of the page and your sticky element</li>\n<li>Destroy the sticky on the size you want</li>\n</ul>\";s:17:\"short_description\";s:43:\"A simple plugin to stick anything you want.\";s:10:\"banner_url\";s:61:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/banner.png\";s:15:\"card_banner_url\";s:66:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/card_banner.png\";s:15:\"selling_point_0\";s:29:\"Stick one or several elements\";s:15:\"selling_point_1\";s:82:\"Add an offset to add a spacing between the top of the page and your sticky element\";s:15:\"selling_point_2\";s:39:\"Destroy the sticky on the size you want\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/screenshots/0.png\";s:12:\"screenshot_2\";s:68:\"//s3-us-west-2.amazonaws.com/freemius/plugins/3815/screenshots/2.png\";}s:2:\"id\";s:3:\"839\";s:7:\"created\";s:19:\"2019-05-16 08:45:08\";s:7:\"updated\";s:19:\"2019-08-04 08:03:54\";}s:12:\"premium_slug\";s:28:\"ocean-stick-anything-premium\";}}}s:7:\"created\";i:1586900527;s:9:\"timestamp\";i:1586986927;}}", "no");
INSERT INTO `wp_oneoptions` VALUES("223", "owp_dismiss_sticky_notice", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("224", "rlrsssl_options", "a:16:{s:12:\"site_has_ssl\";b:1;s:25:\"ssl_success_message_shown\";b:1;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:0;s:17:\"plugin_db_version\";s:3:\"3.3\";s:11:\"ssl_enabled\";b:1;s:9:\"debug_log\";N;s:4:\"hsts\";b:0;s:19:\"javascript_redirect\";b:0;s:11:\"wp_redirect\";b:1;s:26:\"autoreplace_insecure_links\";b:1;s:5:\"debug\";b:0;s:20:\"do_not_edit_htaccess\";b:0;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:19:\"dismiss_all_notices\";b:0;s:17:\"htaccess_redirect\";b:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("231", "rsssl_activation_timestamp", "1585962187", "yes");
INSERT INTO `wp_oneoptions` VALUES("260", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"dWvre0hKNIKmBHgFV4e4t6hXYjhN5KGh\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("262", "widget_woocommerce_widget_cart", "a:2:{i:2;a:2:{s:5:\"title\";s:6:\"Panier\";s:13:\"hide_if_empty\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("263", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("264", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("265", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("266", "widget_woocommerce_product_categories", "a:3:{i:1;a:8:{s:5:\"title\";s:11:\"Catégories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:1;s:9:\"max_depth\";s:0:\"\";}i:2;a:8:{s:5:\"title\";s:11:\"Catégories\";s:7:\"orderby\";s:5:\"order\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("267", "widget_woocommerce_product_search", "a:2:{i:2;a:1:{s:5:\"title\";s:10:\"Rechercher\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("268", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("269", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("270", "widget_woocommerce_recently_viewed_products", "a:2:{i:2;a:2:{s:5:\"title\";s:28:\"Derniers produits consultés\";s:6:\"number\";i:10;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("271", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("272", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("273", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("274", "woocommerce_onboarding_opt_in", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("275", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"produit\";s:13:\"category_base\";s:17:\"categorie-produit\";s:8:\"tag_base\";s:17:\"etiquette-produit\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("277", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("278", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("281", "woocommerce_store_address", "12 rue de la liberté", "yes");
INSERT INTO `wp_oneoptions` VALUES("282", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("283", "woocommerce_store_city", "Paris", "yes");
INSERT INTO `wp_oneoptions` VALUES("284", "woocommerce_default_country", "FR", "yes");
INSERT INTO `wp_oneoptions` VALUES("285", "woocommerce_store_postcode", "75019", "yes");
INSERT INTO `wp_oneoptions` VALUES("286", "woocommerce_allowed_countries", "specific", "yes");
INSERT INTO `wp_oneoptions` VALUES("287", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("288", "woocommerce_specific_allowed_countries", "a:1:{i:0;s:2:\"FR\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("289", "woocommerce_ship_to_countries", "disabled", "yes");
INSERT INTO `wp_oneoptions` VALUES("290", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("291", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_oneoptions` VALUES("292", "woocommerce_calc_taxes", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("293", "woocommerce_enable_coupons", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("294", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_oneoptions` VALUES("295", "woocommerce_currency", "EUR", "yes");
INSERT INTO `wp_oneoptions` VALUES("296", "woocommerce_currency_pos", "right", "yes");
INSERT INTO `wp_oneoptions` VALUES("297", "woocommerce_price_thousand_sep", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("298", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_oneoptions` VALUES("299", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `wp_oneoptions` VALUES("300", "woocommerce_shop_page_id", "7", "yes");
INSERT INTO `wp_oneoptions` VALUES("301", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("302", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("303", "woocommerce_placeholder_image", "5", "yes");
INSERT INTO `wp_oneoptions` VALUES("304", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_oneoptions` VALUES("305", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_oneoptions` VALUES("306", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("307", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("308", "woocommerce_review_rating_verification_required", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("309", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("310", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("311", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("312", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_oneoptions` VALUES("313", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("314", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("315", "woocommerce_stock_email_recipient", "vincentabensour@msn.com", "no");
INSERT INTO `wp_oneoptions` VALUES("316", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_oneoptions` VALUES("317", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("318", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("319", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("320", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_oneoptions` VALUES("321", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_oneoptions` VALUES("322", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("323", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("324", "woocommerce_prices_include_tax", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("325", "woocommerce_tax_based_on", "base", "yes");
INSERT INTO `wp_oneoptions` VALUES("326", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_oneoptions` VALUES("327", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("328", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("329", "woocommerce_tax_display_shop", "incl", "yes");
INSERT INTO `wp_oneoptions` VALUES("330", "woocommerce_tax_display_cart", "incl", "yes");
INSERT INTO `wp_oneoptions` VALUES("331", "woocommerce_price_display_suffix", "TTC", "yes");
INSERT INTO `wp_oneoptions` VALUES("332", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_oneoptions` VALUES("333", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("334", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("335", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_oneoptions` VALUES("336", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("337", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("338", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("339", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("340", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("341", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("342", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_oneoptions` VALUES("343", "woocommerce_erasure_request_removes_order_data", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("344", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_oneoptions` VALUES("345", "woocommerce_allow_bulk_remove_personal_data", "yes", "no");
INSERT INTO `wp_oneoptions` VALUES("346", "woocommerce_registration_privacy_policy_text", "Vos données personnelles seront utilisées pour vous accompagner au cours de votre visite du site web, gérer l’accès à votre compte, et pour d’autres raisons décrites dans notre [privacy_policy].", "yes");
INSERT INTO `wp_oneoptions` VALUES("347", "woocommerce_checkout_privacy_policy_text", "Vos données personnelles seront utilisées pour le traitement de votre commande, vous accompagner au cours de votre visite du site web, et pour d’autres raisons décrites dans notre [privacy_policy].", "yes");
INSERT INTO `wp_oneoptions` VALUES("348", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_oneoptions` VALUES("349", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_oneoptions` VALUES("350", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_oneoptions` VALUES("351", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_oneoptions` VALUES("352", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_oneoptions` VALUES("353", "woocommerce_email_from_name", "MyLocalShop", "no");
INSERT INTO `wp_oneoptions` VALUES("354", "woocommerce_email_from_address", "exemple@mail.com", "no");
INSERT INTO `wp_oneoptions` VALUES("355", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_oneoptions` VALUES("356", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_oneoptions` VALUES("357", "woocommerce_email_base_color", "#3c94c4", "no");
INSERT INTO `wp_oneoptions` VALUES("358", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_oneoptions` VALUES("359", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_oneoptions` VALUES("360", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_oneoptions` VALUES("361", "woocommerce_cart_page_id", "8", "no");
INSERT INTO `wp_oneoptions` VALUES("362", "woocommerce_checkout_page_id", "9", "no");
INSERT INTO `wp_oneoptions` VALUES("363", "woocommerce_myaccount_page_id", "10", "no");
INSERT INTO `wp_oneoptions` VALUES("364", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_oneoptions` VALUES("365", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_oneoptions` VALUES("366", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_oneoptions` VALUES("367", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_oneoptions` VALUES("368", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_oneoptions` VALUES("369", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_oneoptions` VALUES("370", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_oneoptions` VALUES("371", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_oneoptions` VALUES("372", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_oneoptions` VALUES("373", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_oneoptions` VALUES("374", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_oneoptions` VALUES("375", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_oneoptions` VALUES("376", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_oneoptions` VALUES("377", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_oneoptions` VALUES("378", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("379", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `wp_oneoptions` VALUES("380", "woocommerce_show_marketplace_suggestions", "no", "no");
INSERT INTO `wp_oneoptions` VALUES("381", "woocommerce_single_image_width", "504", "yes");
INSERT INTO `wp_oneoptions` VALUES("382", "woocommerce_thumbnail_image_width", "265", "yes");
INSERT INTO `wp_oneoptions` VALUES("383", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("384", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_oneoptions` VALUES("386", "default_product_cat", "70", "yes");
INSERT INTO `wp_oneoptions` VALUES("387", "woocommerce_admin_notices", "a:1:{i:0;s:20:\"no_secure_connection\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("394", "woocommerce_admin_version", "1.0.3", "yes");
INSERT INTO `wp_oneoptions` VALUES("395", "woocommerce_admin_install_timestamp", "1585962447", "yes");
INSERT INTO `wp_oneoptions` VALUES("398", "woocommerce_admin_last_orders_milestone", "10", "yes");
INSERT INTO `wp_oneoptions` VALUES("399", "woocommerce_onboarding_profile", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("402", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("406", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("412", "woocommerce_thumbnail_cropping", "custom", "yes");
INSERT INTO `wp_oneoptions` VALUES("413", "woocommerce_thumbnail_cropping_custom_width", "4", "yes");
INSERT INTO `wp_oneoptions` VALUES("414", "woocommerce_thumbnail_cropping_custom_height", "5", "yes");
INSERT INTO `wp_oneoptions` VALUES("415", "elementor_disable_color_schemes", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("416", "elementor_disable_typography_schemes", "yes", "yes");
INSERT INTO `wp_oneoptions` VALUES("417", "elementor_container_width", "1220", "yes");
INSERT INTO `wp_oneoptions` VALUES("427", "_elementor_global_css", "a:5:{s:4:\"time\";i:1585962697;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("428", "elementor_active_kit", "653", "yes");
INSERT INTO `wp_oneoptions` VALUES("451", "woocommerce_cod_settings", "a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:9:\"Sur place\";s:11:\"description\";s:89:\"Le paiement s\'effectuera avec le commerçant à l\'adresse indiquée selon ses modalités.\";s:12:\"instructions\";s:426:\"<div id=\"removeContentCustom\"><span style=\"color:red;font-weight:bold\">ATTENTION !</span>\r\nConsulter notre page <a target=\"_BLANK\" href=\"../../../informations-importantes/\"><b>Informations importantes</b></a> afin de récupérer votre commande (horaires d\'ouvertures, moyens de paiement acceptés, adresse, contact...). <a target=\"_BLANK\" href=\"../../../informations-importantes/\">Cliquez-ici pour consulter la page.</a></div>\";s:18:\"enable_for_methods\";s:0:\"\";s:18:\"enable_for_virtual\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("452", "woocommerce_cheque_settings", "a:4:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:21:\"Paiements par chèque\";s:11:\"description\";s:81:\"Veuillez envoyer un chèque à Nom de la boutique, rue, code postal, ville, pays.\";s:12:\"instructions\";s:0:\"\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("557", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("777", "woocommerce_sales_record_date", "2020-04-04", "yes");
INSERT INTO `wp_oneoptions` VALUES("778", "woocommerce_sales_record_amount", "50.61", "yes");
INSERT INTO `wp_oneoptions` VALUES("807", "elementor_allow_tracking", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("808", "elementor_tracker_notice", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("811", "woocommerce_maybe_regenerate_images_hash", "81969d684c6b70fd88c4c4d3934ee2b4", "yes");
INSERT INTO `wp_oneoptions` VALUES("1138", "cleantalk_stats", "a:4:{s:3:\"sfw\";a:4:{s:14:\"last_send_time\";i:0;s:16:\"last_send_amount\";i:0;s:16:\"last_update_time\";i:1586621032;s:7:\"entries\";i:30087;}s:14:\"last_sfw_block\";a:2:{s:4:\"time\";i:0;s:2:\"ip\";s:0:\"\";}s:12:\"last_request\";a:2:{s:4:\"time\";i:1586201527;s:6:\"server\";s:30:\"http://moderate4.cleantalk.org\";}s:8:\"requests\";a:1:{i:1586185213;a:2:{s:6:\"amount\";i:13;s:12:\"average_time\";d:0.2705987966977633;}}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1140", "widget_cleantalk_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1157", "cleantalk_errors", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1158", "cleantalk_server", "a:3:{s:11:\"ct_work_url\";s:30:\"http://moderate4.cleantalk.org\";s:13:\"ct_server_ttl\";i:239;s:17:\"ct_server_changed\";i:1586259018;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1159", "cleantalk_data", "a:36:{s:14:\"plugin_version\";s:7:\"5.136.3\";s:7:\"js_keys\";a:4:{i:1984050049;i:1586123253;i:467437974;i:1586256761;i:340464165;i:1586343674;i:217736803;i:1586621032;}s:18:\"js_keys_store_days\";i:14;s:15:\"js_key_lifetime\";i:86400;s:16:\"last_remote_call\";i:0;s:15:\"spam_store_days\";i:15;s:14:\"relevance_test\";i:0;s:17:\"notice_api_errors\";i:0;s:10:\"service_id\";i:693109;s:8:\"moderate\";i:1;s:11:\"moderate_ip\";i:0;s:10:\"ip_license\";i:0;s:10:\"spam_count\";i:0;s:11:\"auto_update\";i:0;s:10:\"user_token\";s:32:\"3ady5e5ezyHe3e2uDareGydyZe9eguWe\";s:13:\"license_trial\";i:1;s:11:\"notice_show\";i:1;s:12:\"notice_trial\";i:1;s:12:\"notice_renew\";i:0;s:13:\"notice_review\";i:0;s:18:\"notice_auto_update\";i:0;s:10:\"brief_data\";a:2:{s:9:\"spam_stat\";a:8:{s:10:\"2020-04-04\";i:0;s:10:\"2020-04-05\";i:0;s:10:\"2020-04-06\";i:0;s:10:\"2020-04-07\";i:0;s:10:\"2020-04-08\";i:0;s:10:\"2020-04-09\";i:0;s:10:\"2020-04-10\";i:0;s:10:\"2020-04-11\";i:1;}s:12:\"top5_spam_ip\";a:2:{i:0;a:3:{i:0;s:12:\"193.228.57.9\";i:1;s:2:\"AT\";i:2;i:1;}i:1;a:3:{i:0;s:13:\"5.180.244.158\";i:1;N;i:2;i:1;}}}s:14:\"array_accepted\";a:4:{i:15;i:1;i:17;i:8;i:18;i:3;i:19;i:1;}s:13:\"array_blocked\";a:4:{i:15;i:0;i:17;i:0;i:18;i:0;i:19;i:0;}s:12:\"current_hour\";i:19;s:11:\"sfw_counter\";a:2:{s:3:\"all\";i:0;s:7:\"blocked\";i:0;}s:16:\"all_time_counter\";a:2:{s:8:\"accepted\";i:13;s:7:\"blocked\";i:0;}s:12:\"user_counter\";a:3:{s:8:\"accepted\";i:13;s:7:\"blocked\";i:0;s:5:\"since\";s:6:\"05 Apr\";}s:18:\"connection_reports\";a:4:{s:7:\"success\";i:0;s:8:\"negative\";i:0;s:15:\"negative_report\";a:0:{}s:5:\"since\";s:6:\"11 Apr\";}s:7:\"ab_test\";a:1:{s:11:\"sfw_enabled\";b:0;}s:16:\"feedback_request\";s:0:\"\";s:9:\"key_is_ok\";b:1;s:4:\"salt\";s:18:\"290079900786261085\";s:5:\"valid\";i:1;s:15:\"account_name_ob\";s:29:\"changey*******@mylocalshop.fr\";s:14:\"cache_detected\";i:0;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1160", "cleantalk_settings", "a:57:{s:6:\"apikey\";s:12:\"agezyqyha3ug\";s:13:\"spam_firewall\";s:1:\"1\";s:18:\"registrations_test\";s:1:\"1\";s:13:\"comments_test\";s:1:\"1\";s:18:\"contact_forms_test\";s:1:\"1\";s:26:\"general_contact_forms_test\";s:1:\"1\";s:11:\"search_test\";s:1:\"1\";s:14:\"check_external\";s:1:\"0\";s:14:\"check_internal\";s:1:\"0\";s:16:\"wc_checkout_test\";s:1:\"1\";s:22:\"wc_register_from_order\";s:1:\"1\";s:21:\"disable_comments__all\";s:1:\"0\";s:19:\"bp_private_messages\";s:1:\"1\";s:15:\"remove_old_spam\";s:1:\"0\";s:21:\"remove_comments_links\";s:1:\"0\";s:16:\"show_check_links\";s:1:\"1\";s:30:\"manage_comments_on_public_page\";s:1:\"0\";s:17:\"protect_logged_in\";s:1:\"1\";s:21:\"check_comments_number\";s:1:\"1\";s:8:\"use_ajax\";s:1:\"1\";s:17:\"use_static_js_key\";s:2:\"-1\";s:21:\"general_postdata_test\";s:1:\"0\";s:11:\"set_cookies\";s:1:\"1\";s:21:\"set_cookies__sessions\";s:1:\"0\";s:6:\"ssl_on\";s:1:\"0\";s:19:\"use_buitin_http_api\";s:1:\"1\";s:16:\"exclusions__urls\";s:0:\"\";s:18:\"exclusions__fields\";s:0:\"\";s:17:\"exclusions__roles\";a:1:{i:0;s:13:\"Administrator\";}s:13:\"show_adminbar\";s:1:\"1\";s:16:\"all_time_counter\";s:1:\"0\";s:13:\"daily_counter\";s:1:\"0\";s:11:\"sfw_counter\";s:1:\"0\";s:10:\"store_urls\";s:1:\"1\";s:20:\"store_urls__sessions\";s:1:\"1\";s:14:\"comment_notify\";s:1:\"1\";s:19:\"autoPubRevelantMess\";i:0;s:30:\"check_external__capture_buffer\";i:0;s:23:\"disable_comments__posts\";i:0;s:23:\"disable_comments__pages\";i:0;s:23:\"disable_comments__media\";i:0;s:28:\"exclusions__urls__use_regexp\";i:0;s:30:\"exclusions__fields__use_regexp\";i:0;s:10:\"user_token\";s:0:\"\";s:15:\"collect_details\";i:0;s:23:\"send_connection_reports\";i:0;s:8:\"async_js\";i:0;s:10:\"debug_ajax\";i:0;s:12:\"gdpr_enabled\";i:0;s:9:\"gdpr_text\";s:0:\"\";s:21:\"comment_notify__roles\";a:0:{}s:21:\"complete_deactivation\";i:0;s:16:\"allow_custom_key\";i:0;s:21:\"allow_custom_settings\";i:0;s:11:\"white_label\";i:0;s:23:\"white_label__hoster_key\";s:0:\"\";s:24:\"white_label__plugin_name\";s:0:\"\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1197", "duplicator_settings", "a:17:{s:7:\"version\";s:6:\"1.3.28\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:5;s:12:\"last_updated\";s:19:\"2020-04-05-21-24-38\";s:18:\"package_ui_created\";s:1:\"1\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1198", "duplicator_version_plugin", "1.3.28", "yes");
INSERT INTO `wp_oneoptions` VALUES("1202", "duplicator_ui_view_state", "a:2:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1203", "duplicator_package_active", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-14 21:43:34\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:3:\"5.4\";s:9:\"VersionDB\";s:6:\"5.6.46\";s:10:\"VersionPHP\";s:6:\"7.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"MyLocalShopCoreV102\";s:4:\"Hash\";s:35:\"8c6abc529e2508c65569_20200414214334\";s:8:\"NameHash\";s:55:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/mylocalslb/demo/core/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://core.mylocalshop.fr/wp-snapshots/\";s:8:\"ScanFile\";s:65:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/mylocalslb/demo/core\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-14 21:43:34\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:3:\"5.4\";s:9:\"VersionDB\";s:6:\"5.6.46\";s:10:\"VersionPHP\";s:6:\"7.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"MyLocalShopCoreV102\";s:4:\"Hash\";s:35:\"8c6abc529e2508c65569_20200414214334\";s:8:\"NameHash\";s:55:\"MyLocalShopCoreV102_8c6abc529e2508c65569_20200414214334\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/mylocalslb/demo/core/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://core.mylocalshop.fr/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:63;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/mylocalslb/demo/core/wp-admin\";i:1;s:45:\"/home/mylocalslb/demo/core/wp-content/uploads\";i:2;s:47:\"/home/mylocalslb/demo/core/wp-content/languages\";i:3;s:44:\"/home/mylocalslb/demo/core/wp-content/themes\";i:4;s:38:\"/home/mylocalslb/demo/core/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/mylocalslb/demo/core\";i:1;s:37:\"/home/mylocalslb/demo/core/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:128;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1228", "cleantalk_remote_calls", "a:10:{s:18:\"close_renew_banner\";a:1:{s:9:\"last_call\";i:0;}s:10:\"sfw_update\";a:1:{s:9:\"last_call\";i:1586621032;}s:13:\"sfw_send_logs\";a:1:{s:9:\"last_call\";i:0;}s:13:\"update_plugin\";a:1:{s:9:\"last_call\";i:0;}s:14:\"install_plugin\";a:1:{s:9:\"last_call\";i:0;}s:15:\"activate_plugin\";a:1:{s:9:\"last_call\";i:0;}s:15:\"insert_auth_key\";a:1:{s:9:\"last_call\";i:0;}s:17:\"deactivate_plugin\";a:1:{s:9:\"last_call\";i:0;}s:16:\"uninstall_plugin\";a:1:{s:9:\"last_call\";i:0;}s:15:\"update_settings\";a:1:{s:9:\"last_call\";i:0;}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1322", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1323", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1324", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1343", "elementor_controls_usage", "a:1:{s:7:\"wp-page\";a:8:{s:7:\"heading\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:4:{s:5:\"title\";i:6;s:4:\"size\";i:1;s:11:\"header_size\";i:1;s:5:\"align\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:6:\"spacer\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:6;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:1:{s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:2;}s:14:\"section_layout\";a:1:{s:3:\"gap\";i:1;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:1;}}}}s:6:\"toggle\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_toggle\";a:1:{s:4:\"tabs\";i:1;}}}}s:11:\"google_maps\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:11:\"section_map\";a:2:{s:7:\"address\";i:2;s:4:\"zoom\";i:2;}}}}s:9:\"shortcode\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:17:\"section_shortcode\";a:1:{s:9:\"shortcode\";i:1;}}}}}}", "no");
INSERT INTO `wp_oneoptions` VALUES("1580", "woocommerce_customer_processing_order_settings", "a:5:{s:7:\"enabled\";s:3:\"yes\";s:7:\"subject\";s:0:\"\";s:7:\"heading\";s:0:\"\";s:18:\"additional_content\";s:249:\"<span style=\"color:red;font-weight:bold\">ATTENTION !</span><br />\r\nN\'oubliez pas de consulter notre page <a href=\"{site_address}/informations-importantes/\">{site_address}/informations-importantes/</a> pour savoir comment récupérer votre commande !\";s:10:\"email_type\";s:4:\"html\";}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1742", "duplicator_exe_safe_mode", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("1919", "USRemovernoAdminEmails", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("1920", "USRemoverdaysGrace", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("1921", "USRemoveruserWhitelist", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("1922", "USRemoverlogDir", "/home/mylocalslb/demo/core/wp-content/plugins/user-spam-remover/log", "yes");
INSERT INTO `wp_oneoptions` VALUES("1923", "USRemoveractivityLog", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("1924", "USRemoverrestoreLog", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("1925", "USRemoverlogFilename", "userspamremover.log", "yes");
INSERT INTO `wp_oneoptions` VALUES("1926", "USRemoverrestoreFilename", "userspamremover.restore.sql", "yes");
INSERT INTO `wp_oneoptions` VALUES("1969", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("1970", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_oneoptions` VALUES("1972", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("1973", "woocommerce_version", "4.0.1", "yes");
INSERT INTO `wp_oneoptions` VALUES("1974", "woocommerce_db_version", "4.0.1", "yes");
INSERT INTO `wp_oneoptions` VALUES("1995", "wp-optimize-newly-activated", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2005", "updraft_task_manager_dbversion", "1.1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2006", "wpo_update_version", "3.0.19", "yes");
INSERT INTO `wp_oneoptions` VALUES("2008", "wp-optimize-install-or-update-notice-show-time", "1586260663", "yes");
INSERT INTO `wp_oneoptions` VALUES("2010", "wp-optimize-is_gzip_compression_enabled", "gzip", "yes");
INSERT INTO `wp_oneoptions` VALUES("2012", "wp-optimize-corrupted-tables-count", "0", "yes");
INSERT INTO `wp_oneoptions` VALUES("2016", "wp-optimize-enable-auto-backup", "false", "yes");
INSERT INTO `wp_oneoptions` VALUES("2017", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("2018", "_transient_wc_attribute_taxonomies", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("2019", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:0;s:3:\"all\";i:0;s:9:\"moderated\";i:0;s:8:\"approved\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `wp_oneoptions` VALUES("2024", "_transient_woocommerce_reports-transient-version", "1586260766", "yes");
INSERT INTO `wp_oneoptions` VALUES("2029", "wpo_cache_config", "a:16:{s:19:\"enable_page_caching\";b:0;s:23:\"page_cache_length_value\";i:24;s:22:\"page_cache_length_unit\";s:5:\"hours\";s:17:\"page_cache_length\";i:86400;s:20:\"cache_exception_urls\";a:0:{}s:23:\"cache_exception_cookies\";a:0:{}s:30:\"cache_exception_browser_agents\";a:0:{}s:22:\"enable_sitemap_preload\";b:0;s:23:\"enable_schedule_preload\";b:0;s:21:\"preload_schedule_type\";s:0:\"\";s:21:\"enable_mobile_caching\";b:0;s:19:\"enable_user_caching\";b:0;s:8:\"site_url\";s:27:\"http://core.mylocalshop.fr/\";s:24:\"enable_cache_per_country\";b:0;s:17:\"wpo_cache_cookies\";a:0:{}s:25:\"wpo_cache_query_variables\";a:0:{}}", "yes");
INSERT INTO `wp_oneoptions` VALUES("2049", "_transient_timeout_wc_low_stock_count", "1588852985", "no");
INSERT INTO `wp_oneoptions` VALUES("2050", "_transient_wc_low_stock_count", "0", "no");
INSERT INTO `wp_oneoptions` VALUES("2051", "_transient_timeout_wc_outofstock_count", "1588852985", "no");
INSERT INTO `wp_oneoptions` VALUES("2052", "_transient_wc_outofstock_count", "0", "no");
INSERT INTO `wp_oneoptions` VALUES("2053", "_transient_product_query-transient-version", "1586343790", "yes");
INSERT INTO `wp_oneoptions` VALUES("2069", "new_admin_email", "changeyouremail@mylocalshop.fr", "yes");
INSERT INTO `wp_oneoptions` VALUES("2136", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_oneoptions` VALUES("2165", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_oneoptions` VALUES("2172", "fvm-last-cache-update", "1586900549", "yes");
INSERT INTO `wp_oneoptions` VALUES("2173", "fastvelocity_min_fvm_fix_editor", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2174", "fastvelocity_min_remove_print_mediatypes", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2175", "fastvelocity_fvm_clean_header_one", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2176", "fastvelocity_min_skip_google_fonts", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2177", "fastvelocity_min_force_inline_css_footer", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2178", "fastvelocity_min_skip_cssorder", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2179", "fastvelocity_gfonts_method", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2180", "fastvelocity_fontawesome_method", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2181", "fastvelocity_min_disable_css_inline_merge", "1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2182", "fastvelocity_min_blacklist", "/html5shiv.js\n/html5shiv-printshiv.min.js\n/excanvas.js\n/avada-ie9.js\n/respond.js\n/respond.min.js\n/selectivizr.js\n/Avada/assets/css/ie.css\n/html5.js\n/IE9.js\n/fusion-ie9.js\n/vc_lte_ie9.min.css\n/old-ie.css\n/ie.css\n/vc-ie8.min.css\n/mailchimp-for-wp/assets/js/third-party/placeholders.min.js\n/assets/js/plugins/wp-enqueue/min/webfontloader.js\n/a.optnmstr.com/app/js/api.min.js\n/pixelyoursite/js/public.js\n/assets/js/wcdrip-drip.js", "yes");
INSERT INTO `wp_oneoptions` VALUES("2183", "fastvelocity_min_ignorelist", "/themes/Avada/assets/js/main.min.js\n/plugins/woocommerce-product-search/js/product-search.js\n/plugins/revslider/public/assets/js/jquery.themepunch.tools.min.js\n/js/TweenMax.min.js\n/themes/jupiter/assets/js/min/full-scripts\n/plugins/LayerSlider/static/layerslider/js/greensock.js\n/themes/kalium/assets/js/main.min.js\n/js/mediaelement/\n/plugins/elementor/assets/js/common.min.js\n/plugins/elementor/assets/js/frontend.min.js\n/plugins/elementor-pro/assets/js/frontend.min.js\n/themes/kalium/assets/js/main.min.js", "yes");
INSERT INTO `wp_oneoptions` VALUES("2185", "fastvelocity_min_enable_purgemenu", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2186", "fastvelocity_preserve_settings_on_uninstall", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2187", "fastvelocity_min_default_protocol", "dynamic", "yes");
INSERT INTO `wp_oneoptions` VALUES("2188", "fastvelocity_min_disable_js_merge", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2189", "fastvelocity_min_disable_css_merge", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2190", "fastvelocity_min_disable_js_minification", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2191", "fastvelocity_min_disable_css_minification", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2192", "fastvelocity_min_skip_html_minification", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2193", "fastvelocity_min_strip_htmlcomments", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2194", "fastvelocity_min_skip_fontawesome_fonts", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2195", "fastvelocity_min_skip_emoji_removal", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2196", "fastvelocity_min_enable_defer_js", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2197", "fastvelocity_min_exclude_defer_jquery", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2198", "fastvelocity_min_force_inline_css", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2199", "fastvelocity_min_remove_googlefonts", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2200", "fastvelocity_min_defer_for_pagespeed", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2201", "fastvelocity_min_defer_for_pagespeed_optimize", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2202", "fastvelocity_min_exclude_defer_login", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2203", "fastvelocity_min_skip_defer_lists", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2204", "fastvelocity_min_fvm_cdn_url", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2205", "fastvelocity_min_fvm_cdn_force", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2206", "fastvelocity_min_change_cache_base_url", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2207", "fastvelocity_min_change_cache_path", "", "yes");
INSERT INTO `wp_oneoptions` VALUES("2210", "fastvelocity_plugin_version", "2.8.1", "yes");
INSERT INTO `wp_oneoptions` VALUES("2217", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-5.4.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-5.4.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"5.4\";s:7:\"version\";s:3:\"5.4\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1586900528;s:15:\"version_checked\";s:3:\"5.4\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_oneoptions` VALUES("2223", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1586900550;s:7:\"checked\";a:1:{s:7:\"oceanwp\";s:5:\"1.8.2\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_oneoptions` VALUES("2261", "_transient_health-check-site-status-result", "{\"good\":\"11\",\"recommended\":\"6\",\"critical\":\"0\"}", "yes");
INSERT INTO `wp_oneoptions` VALUES("2271", "_transient_timeout_elementor_remote_info_api_data_2.9.7", "1586943728", "no");
INSERT INTO `wp_oneoptions` VALUES("2272", "_transient_elementor_remote_info_api_data_2.9.7", "a:4:{s:9:\"timestamp\";i:1586900168;s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:59:{i:0;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:4;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:5;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:6;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:8;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:9;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:10;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:11;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:12;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:14;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:16;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:11:\"search-form\";s:5:\"title\";s:11:\"Search Form\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:19;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:20;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:21;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:23;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:24;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:25;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:27;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:28;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:29;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:30;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:31;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:32;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:33;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:34;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:35;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:36;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:37;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:38;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:39;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:40;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:41;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:42;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:43;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:44;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:45;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:46;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:47;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:48;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:49;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:50;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:51;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:58;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"2.9.1\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.2.9.1.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.3.2\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:1:{i:0;a:1:{i:0;a:3:{s:4:\"type\";s:8:\"language\";s:9:\"languages\";a:27:{i:0;s:5:\"he_IL\";i:1;s:5:\"en_GB\";i:2;s:5:\"en_NZ\";i:3;s:5:\"en_ZA\";i:4;s:5:\"en_AU\";i:5;s:5:\"en_CA\";i:6;s:5:\"sv_SE\";i:7;s:5:\"da_DK\";i:8;s:5:\"fr_FR\";i:9;s:5:\"de_DE\";i:10;s:5:\"nl_NL\";i:11;s:5:\"nb_NO\";i:12;s:5:\"de_AT\";i:13;s:2:\"fi\";i:14;s:5:\"it_IT\";i:15;s:5:\"nn_NO\";i:16;s:5:\"de_CH\";i:17;s:5:\"en_GB\";i:18;s:5:\"is_IS\";i:19;s:2:\"ga\";i:20;s:5:\"fr_BE\";i:21;s:5:\"nl_BE\";i:22;s:3:\"ast\";i:23;s:5:\"lb_LU\";i:24;s:5:\"es_ES\";i:25;s:5:\"pt_PT\";i:26;s:3:\"mlt\";}s:8:\"operator\";s:2:\"in\";}}}}}", "no");
INSERT INTO `wp_oneoptions` VALUES("2273", "_transient_timeout__woocommerce_helper_subscriptions", "1586901428", "no");
INSERT INTO `wp_oneoptions` VALUES("2274", "_transient__woocommerce_helper_subscriptions", "a:0:{}", "no");
INSERT INTO `wp_oneoptions` VALUES("2275", "_site_transient_timeout_theme_roots", "1586902328", "no");
INSERT INTO `wp_oneoptions` VALUES("2276", "_site_transient_theme_roots", "a:1:{s:7:\"oceanwp\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_oneoptions` VALUES("2277", "_transient_timeout__woocommerce_helper_updates", "1586943728", "no");
INSERT INTO `wp_oneoptions` VALUES("2278", "_transient__woocommerce_helper_updates", "a:4:{s:4:\"hash\";s:32:\"d751713988987e9331980363e24189ce\";s:7:\"updated\";i:1586900528;s:8:\"products\";a:0:{}s:6:\"errors\";a:1:{i:0;s:10:\"http-error\";}}", "no");
INSERT INTO `wp_oneoptions` VALUES("2279", "_site_transient_timeout_browser_2397a7ecb9ce737f692b6cba71051dc3", "1587505330", "no");
INSERT INTO `wp_oneoptions` VALUES("2280", "_site_transient_browser_2397a7ecb9ce737f692b6cba71051dc3", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"75.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_oneoptions` VALUES("2281", "_site_transient_timeout_php_check_fce1f096719779a3888ef81259141e1f", "1587505330", "no");
INSERT INTO `wp_oneoptions` VALUES("2282", "_site_transient_php_check_fce1f096719779a3888ef81259141e1f", "a:5:{s:19:\"recommended_version\";s:3:\"7.3\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wp_oneoptions` VALUES("2283", "_transient_timeout_wpforms_dash_widget_lite_entries_by_form", "1586908801", "no");
INSERT INTO `wp_oneoptions` VALUES("2284", "_transient_wpforms_dash_widget_lite_entries_by_form", "a:1:{i:709;a:3:{s:7:\"form_id\";i:709;s:5:\"count\";i:0;s:5:\"title\";s:21:\"Formulaire de contact\";}}", "no");
INSERT INTO `wp_oneoptions` VALUES("2285", "_transient_timeout_feed_c8dc84948ab55424f034a4ced348e013", "1586943731", "no");
INSERT INTO `wp_oneoptions` VALUES("2286", "_transient_feed_c8dc84948ab55424f034a4ced348e013", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"OceanWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"https://oceanwp.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Free Multi-Purpose WordPress Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Apr 2020 19:38:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://wordpress.org/?v=5.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://oceanwp.org/wp-content/uploads/2016/10/cropped-favicon-150x150.png\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"OceanWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"https://oceanwp.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"How to Create a WordPress Blog or Website in 2020, just like the Pros\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://oceanwp.org/blog/how-create-wordpress-blog-2020-pros/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://oceanwp.org/blog/how-create-wordpress-blog-2020-pros/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Apr 2020 19:38:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Introducing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://oceanwp.org/?p=145715\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1289:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/how-create-wordpress-blog-2020-pros/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2020/04/how-create-wordpress-blog-2020-pros.jpg\" width=\"2426\" height=\"1728\" title=\"How to Create a WordPress Blog or Website in 2020, just like the Pros\" alt=\"How to Create a WordPress Blog or Website in 2020, just like the Pros\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\">So you want to create a great impression with a stunning blog or website. Maybe you got inspired to write an online diary, create a digital resume for potential employers, build a personal brand, or make money by advertising. No matter what the goal, it has never been easier to build a professional and interactive [&#8230;]<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/how-create-wordpress-blog-2020-pros/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;\">Read More</a></p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Hitesh Sahni\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:46481:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/how-create-wordpress-blog-2020-pros/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2020/04/how-create-wordpress-blog-2020-pros.jpg\" width=\"2426\" height=\"1728\" title=\"How to Create a WordPress Blog or Website in 2020, just like the Pros\" alt=\"How to Create a WordPress Blog or Website in 2020, just like the Pros\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\">\n<p>So you want to create a great impression with a stunning blog or website. Maybe you got inspired to write an online diary, create a digital resume for potential employers, build a personal brand, or make money by advertising.</p>\n\n\n\n<span id=\"more-145715\"></span>\n\n\n\n<p>No matter what the goal, it has never been easier to build a professional and interactive website or blog. With new advancements in WordPress in recent years, you can now build a slick website fast and cheap, regardless of your skill level.</p>\n\n\n\n<p>In this guide, I am going to walk you through the entire process of creating a beautiful and functional website from start to finish. By following the steps outlined below, you’ll finally have an online platform you can be proud of.</p>\n\n\n\n<p>So put aside about an hour of your time and let’s get you setup with a professional website in just a few easy steps.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 1: Buy A Domain Name</strong></p>\n\n\n\n<p>The domain name is the address people will use to access your website online. For example, google.com is a domain name, and so is oceanwp.org.</p>\n\n\n\n<p>Without a domain name, there is no way for people to visit your website. So it’s a mandatory part of the website or blog creation process.</p>\n\n\n\n<p>If you are short on ideas, tools like <a href=\"https://www.namemesh.com/\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">Namemesh</a>, <a href=\"https://www.shopify.com/tools/domain-name-generator\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">Shopify</a> &amp; <a href=\"https://namestation.com/\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">Namestation</a> can help you brainstorm possible domain names.</p>\n\n\n\n<p>A domain name is not something you’re going to change again and again. So it’s wise to put some thought into your decision. Moz has a great guide on <a href=\"https://moz.com/blog/how-to-choose-a-domain-name-whiteboard-friday\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">picking a good domain name</a>.</p>\n\n\n\n<p>Also, it’s better to shortlist more than one domain name idea when you’re in the brainstorming phase. This is because your chosen domain name may not be available at the time of purchase.</p>\n\n\n\n<p>Unless you’re buying a really premium domain, a typical domain name will cost you around $10-15 per year.</p>\n\n\n\n<p>Once you’re ready with a few ideas, the best way to buy a domain is through a reputed registrar like <a href=\"https://bit.ly/2rn7q4M\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener sponsored\" class=\"rank-math-link\">Namecheap</a>. Just search for your chosen domain name, and if it’s available, add to cart and checkout. It’s that simple.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 2: Get High Quality Hosting</strong></p>\n\n\n\n<p>What is one of the first steps when you want to open a shop or office offline? You get a commercial space on rent.</p>\n\n\n\n<p>Same is the case with your online website or blog. You need to rent storage space on a server that’s online 24 hours a day. This is known as web hosting.</p>\n\n\n\n<p>Your hosting will hold all of your website content, text and images in one secure place, and will serve it to anyone who tries to access your domain name.</p>\n\n\n\n<p>Depending on the features you get, high quality WordPress hosting from a reputed company can be around $5 a month (<a href=\"https://bit.ly/2KNrTYT\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener sponsored\" class=\"rank-math-link\">Siteground</a>), $10 a month (<a href=\"https://bit.ly/2rTRtn1\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener sponsored\" class=\"rank-math-link\">Cloudways</a>), or $30 per month (Kinsta). Here’s a basic comparison to help you pick from these options.</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><td></td><td>Siteground</td><td>Cloudways</td><td>Kinsta</td></tr><tr><td>Pros</td><td>Good overall performance<p></p>\n<p>Includes SSL certificates</p>\n<p>Quality customer support</p>\n<p>Affordable pricing plans</p></td><td>Unlimited websites<p></p>\n<p>Automatic site backups</p>\n<p>Advanced server console</p>\n<p>Pay as you go pricing</p></td><td>Best overall performance<p></p>\n<p>Automatic site backups</p>\n<p>Expert WordPress support</p>\n<p>Includes SSL certificates</p></td></tr><tr><td>Cons</td><td>Limited storage space<p></p>\n<p>Limited number of websites</p></td><td>No cPanel to manage sites<p></p>\n<p>Requires some tech knowledge</p></td><td>Costlier than other hosts<p></p>\n<p>No email hosting</p></td></tr></tbody></table></figure>\n\n\n\n<p>Don’t worry if some of the pros and cons don’t make sense as of now. To put it simply, SiteGround is the cheapest option with high quality hosting and support.</p>\n\n\n\n<p>While the 10 GB storage space and bandwidth you get is less than other hosts, it’s more than enough for your new website. Cloudways has additional features, but can be a bit complicated for beginners. The best of both worlds is Kinsta, which is therefore the most expensive.</p>\n\n\n\n<p>Getting web hosting is pretty simple. Let’s take SiteGround for example. Head over to SiteGround hosting page and click the Sign Up button and pick your hosting package.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/siteground-sign-1024x562.jpg\" alt=\"siteground hosting package\" class=\"wp-image-145760\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/siteground-sign-1024x562.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/siteground-sign-300x165.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/siteground-sign-768x421.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/siteground-sign.jpg 1183w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Click Order Now on the package that you want to purchase. Next, SiteGround will ask if you already have a domain or you want to register a new one.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/siteground-domain-1024x527.jpg\" alt=\"register domain\" class=\"wp-image-145759\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/siteground-domain-1024x527.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/siteground-domain-300x155.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/siteground-domain-768x396.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/siteground-domain.jpg 1058w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Since you already purchased a domain in the first step, select that you already have a domain, enter your domain name and click on the Proceed button.</p>\n\n\n\n<p>You’ll be taken to an order form to enter your billing details and complete the signup process.</p>\n\n\n\n<p>SiteGround may try to sell some additional services, but buying them or not is totally up to you. They are not required to follow this guide and build your website.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 3: Add Custom Nameservers</strong></p>\n\n\n\n<p>I know this sounds somewhat technical, but stay with me. It’s really easy. So far you have purchased the domain and hosting, but you haven’t connected the two. That’s what we are going to do in this step.</p>\n\n\n\n<p>Once you have checked out, your host will email you the login details to your hosting account, as well as the nameservers required to connect your domain with the hosting account.</p>\n\n\n\n<p>Nameservers are basically URLs which consist of an identifier followed by domain of your host. If you have purchased hosting from SiteGround for example, your nameservers may look like this:</p>\n\n\n\n<ul><li>ns1.siteground.com</li><li>ns2.siteground.com</li></ul>\n\n\n\n<p>Take a note of these nameservers and head to your account with the domain registrar. If you have purchased domain from NameCheap for instance, then you’ll see the link to manage the domain in your account.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/namecheap-manage-1024x304.jpg\" alt=\"manage domain\" class=\"wp-image-145752\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/namecheap-manage-1024x304.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/namecheap-manage-300x89.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/namecheap-manage-768x228.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/namecheap-manage.jpg 1842w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Click “Manage” and then scroll down to get to the nameservers section.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/nameservers-1024x458.jpg\" alt=\"custom nameservers section\" class=\"wp-image-145753\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/nameservers-1024x458.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/nameservers-300x134.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/nameservers-768x344.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/nameservers.jpg 1213w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Here, select “Custom DNS” from the dropdown, enter the nameservers provided by your host, and click the tick mark to save. <a href=\"https://www.youtube.com/watch?v=9Wgu24-OzRA\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">Here’s a quick video</a> that explains the process in detail if you’re stuck.</p>\n\n\n\n<p>It may take up to 48 hours for the nameservers change to take place, but you have successfully pointed your domain to the hosting you bought.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 4: Install WordPress</strong></p>\n\n\n\n<p>WordPress is the most popular website creation and management system, currently <a href=\"https://venturebeat.com/2018/03/05/wordpress-now-powers-30-of-websites/\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener sponsored\" class=\"rank-math-link\">used by around 30%</a> of all the websites in the world.</p>\n\n\n\n<p>The growing popularity of WordPress is well-deserved. Not only is it free, but also makes really easy to build and maintain a website, and it can be extended with any features you need by installing enhancements we call “plugins”.</p>\n\n\n\n<p>Plus, there’s a widespread community of WordPress users all over the world. So anytime you run into any issue, chances are someone has already faced and solved that problem. So the solution is just a Google search away.</p>\n\n\n\n<p>Installing WordPress on your hosting is really easy. On SiteGround, for example, login to your hosting dashboard or user area and click on the My Accounts tab. Then click Go To cPanel.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/siteground-cpanel.jpg\" alt=\"go to cpanel\" class=\"wp-image-145758\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/siteground-cpanel.jpg 711w, //oceanwp.org/wp-content/uploads/2018/06/siteground-cpanel-300x202.jpg 300w\" sizes=\"(max-width: 711px) 100vw, 711px\" /></figure>\n\n\n\n<p>Once you’re in the cPanel, scroll down and look for the icon to install WordPress.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/cpanel-wordpress.jpg\" alt=\"icon to install wp\" class=\"wp-image-145748\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/cpanel-wordpress.jpg 963w, //oceanwp.org/wp-content/uploads/2018/06/cpanel-wordpress-300x157.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/cpanel-wordpress-768x402.jpg 768w\" sizes=\"(max-width: 963px) 100vw, 963px\" /></figure>\n\n\n\n<p>On the next screen, click on the Install button and you’ll see the WordPress installation form.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/install-wp-1024x473.jpg\" alt=\"wp install button\" class=\"wp-image-145751\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/install-wp-1024x473.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/install-wp-300x139.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/install-wp-768x355.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/install-wp.jpg 1026w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Choose a protocol. Default should be https://. That’s because SiteGround provides you with free SSL certificate for a year, which you should definitely install. <a href=\"https://www.siteground.com/tutorials/getting-started/install-a-certificate/\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">Here’s how</a> you can do it.</p>\n\n\n\n<p>An SSL certificate is <a href=\"https://www.howtogeek.com/181767/htg-explains-what-is-https-and-why-should-i-care/\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">basically a security badge</a> which shows how trustworthy a website is, especially if you’re going to accept payments. And a free SSL certificate for a year is great because SSL is <a href=\"https://webmasters.googleblog.com/2014/08/https-as-ranking-signal.html\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">one of the new</a> search engine ranking factors.</p>\n\n\n\n<p>So a website domain name which starts with https:// is more likely to rank higher in search engines than the one without it. Plus, if your website is not https://, it will be shown as “not secure” in the Chrome address bar, which can turn away some visitors.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/not-secure.jpg\" alt=\"\" class=\"wp-image-145754\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/not-secure.jpg 383w, //oceanwp.org/wp-content/uploads/2018/06/not-secure-300x103.jpg 300w\" sizes=\"(max-width: 383px) 100vw, 383px\" /></figure>\n\n\n\n<p>Once you have chosen a protocol, select the domain name you purchased to install WordPress. You can leave the directory field blank.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/wp-setup.jpg\" alt=\"wp installation form\" class=\"wp-image-145765\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/wp-setup.jpg 922w, //oceanwp.org/wp-content/uploads/2018/06/wp-setup-300x154.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/wp-setup-768x393.jpg 768w\" sizes=\"(max-width: 922px) 100vw, 922px\" /></figure>\n\n\n\n<p>You’ll also see some fields to type in your blog title, username, email etc. Don’t worry about the title for now, as you can easily change it later.</p>\n\n\n\n<p>But note that the username, password and email you set here is going to be used to login and manage into your WordPress website.</p>\n\n\n\n<p>The username and password you typed earlier when purchasing hosting was for your hosting account, which is not the same as your WordPress admin account.</p>\n\n\n\n<p>Leave the other fields as they are, and then click the Install button. Wait for a few seconds for it to complete, and your WordPress installation will be ready.</p>\n\n\n\n<p>In fact, now you can even try accessing your website by typing your domain name in the address bar of your web browser. And you’ll see that it works. Your website is now live on the Internet!</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 5: Login To WordPress Dashboard</strong></p>\n\n\n\n<p>Although your website is now up and running, it may not look anywhere near to how you want it to be.</p>\n\n\n\n<p>This is because it’s based on a default theme that already comes bundled and installed with WordPress. And you haven’t customized it to your needs. So that’s what we are going to do moving forward.</p>\n\n\n\n<p>To get started, you’ll need to login to your WordPress admin dashboard. If you have followed the exact instructions so far, you can access the dashboard by typing this in the address bar of of web browser.</p>\n\n\n\n<figure class=\"wp-block-embed\"><div class=\"wp-block-embed__wrapper\">\nhttp://yourdomain.com/wp-admin\n</div></figure>\n\n\n\n<p>Once you’re there, you’ll be prompted to login using the username and password you entered at the time of installing WordPress.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/wp-login.jpg\" alt=\"wp login form\" class=\"wp-image-145763\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/wp-login.jpg 631w, //oceanwp.org/wp-content/uploads/2018/06/wp-login-300x237.jpg 300w\" sizes=\"(max-width: 631px) 100vw, 631px\" /></figure>\n\n\n\n<p>After you login, you’ll see the complete interface you’re going to use from time to time to change, manage and add content to your website.</p>\n\n\n\n<p>This is called your WordPress admin dashboard. Don’t worry if it looks a bit intimidating at first. Once you get a hang of it, it’s really simple, and fun too.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/wp-dashboard-1024x441.jpg\" alt=\"wp admin dashboard\" class=\"wp-image-145762\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/wp-dashboard-1024x441.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/wp-dashboard-300x129.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/wp-dashboard-768x331.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/wp-dashboard.jpg 1882w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>You may also see some plugins already installed and some extra notifications caused by them, but don&#8217;t worry about that right now. We’ll discuss about both themes and plugins in the next steps.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 6: Install A WordPress Theme</strong></p>\n\n\n\n<p>A theme is what defines the overall look and feel of your WordPress website. And the good news is that because WordPress is so popular, there are thousands of themes available for it, both free and paid.</p>\n\n\n\n<p>But the bad news is that most of the themes (even some bestsellers) are poorly coded, bloated with unnecessary features and complicated to customize. So if you’re not careful, it’s more likely that you’ll pick a bad theme, based only on how nice and fancy it looks.</p>\n\n\n\n<p>That’s why for this tutorial, we’re going to go straight to the best &#8211; OceanWP theme. It is coded with respect to WordPress coding standards, optimized for speed and SEO, easier to customize, looks stunning and has a whole lot more.</p>\n\n\n\n<p>And here’s the real kicker: as a theme which packs a lot more value that many premium themes put together, it’s absolutely free.</p>\n\n\n\n<p>To install the OceanWP theme, just click on Appearance &gt; Themes from the left menu in your WordPress dashboard, and then click Add New.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/wp-theme.jpg\" alt=\"install wp theme\" class=\"wp-image-145766\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/wp-theme.jpg 913w, //oceanwp.org/wp-content/uploads/2018/06/wp-theme-300x157.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/wp-theme-768x401.jpg 768w\" sizes=\"(max-width: 913px) 100vw, 913px\" /></figure>\n\n\n\n<p>Once you’re there, type OceanWP in the search bar and press enter. You’ll be able to see the option to install the OceanWP theme.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/install-oceanwp-1024x362.jpg\" alt=\"install oceanwp theme\" class=\"wp-image-145750\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/install-oceanwp-1024x362.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/install-oceanwp-300x106.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/install-oceanwp-768x272.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/install-oceanwp.jpg 1263w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Hover over the theme with your mouse pointer, and click Install. And then click Activate to make the theme active on your website.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 7: Install Essential Plugins</strong></p>\n\n\n\n<p>Just like there are thousands of themes available for WordPress, so are plugins. While a theme determines the look and feel of your website, plugins add new features and functionalities.</p>\n\n\n\n<p>With a plugin, for instance, you can add a contact form on your website, block spam comments, or implement a shopping cart. The list is endless.</p>\n\n\n\n<p>When you installed WordPress and logged into your WordPress account in step 5, you may have noticed that some plugins are already installed.</p>\n\n\n\n<p>Click on Plugins in the left menu to see the full list currently installed plugins.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/wp-plugins-1024x414.jpg\" alt=\"wp installed plugins\" class=\"wp-image-145764\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/wp-plugins-1024x414.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/wp-plugins-300x121.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/wp-plugins-768x311.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/wp-plugins.jpg 1758w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>For our purpose, you can safely remove those plugins as it’s wise not to have any more plugins than what you really need for the website. To remove a plugin, click on Deactivate link next to the plugin name, and then click Delete afterwards.</p>\n\n\n\n<p>Once you have deleted the unnecessary plugins, the next step is to install the essential ones recommended by the OceanWP theme.</p>\n\n\n\n<p>Since you installed and activated the OceanWP theme, you should be seeing the recommended plugins notification at the top.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/oceanwp-plugins.jpg\" alt=\"oceanwp recommended plugins\" class=\"wp-image-145755\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/oceanwp-plugins.jpg 900w, //oceanwp.org/wp-content/uploads/2018/06/oceanwp-plugins-300x159.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/oceanwp-plugins-768x407.jpg 768w\" sizes=\"(max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<p>The OceanWP theme recommends <a href=\"https://bit.ly/2sffgxb\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener sponsored\" class=\"rank-math-link\">Elementor</a> (the best free plugin to design professional looking web pages without coding) and Ocean Extra (a free plugin required for some of the theme features to work).</p>\n\n\n\n<p>From there, you can click on “Begin installing plugins.” Then install the activate the plugins.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 8: Start Customizing</strong></p>\n\n\n\n<p>Now that you have installed and activated the base theme and plugins, you’re ready to start making the website your own.</p>\n\n\n\n<p>One of the best things about the OceanWP theme is the powerful customizer panel. In here you’ll be able to customize your website dramatically without touching any code.</p>\n\n\n\n<p>In your WordPress dashboard, go to Appearance &gt; Customize to get to the customizer panel.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/wp-customize-1024x513.jpg\" alt=\"go to customizer panel\" class=\"wp-image-145761\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/wp-customize-1024x513.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/wp-customize-300x150.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/wp-customize-768x385.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/wp-customize.jpg 1335w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>To change the website title and tagline, for instance, head over to Site Identity, as shown in the above image, and there you can change your site title and tagline.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/site-identity.jpg\" alt=\"wp site identity\" class=\"wp-image-145757\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/site-identity.jpg 952w, //oceanwp.org/wp-content/uploads/2018/06/site-identity-300x172.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/site-identity-768x441.jpg 768w\" sizes=\"(max-width: 952px) 100vw, 952px\" /></figure>\n\n\n\n<p>Let’s add a logo too. If you don’t already have a logo, you can create one for free with a tool such as <a href=\"https://www.logogarden.com/\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">Logo Garden</a>.</p>\n\n\n\n<p>In the customizer panel, click on Header, and then Logo.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/add-logo.jpg\" alt=\"change oceanwp logo\" class=\"wp-image-145747\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/add-logo.jpg 432w, //oceanwp.org/wp-content/uploads/2018/06/add-logo-230x300.jpg 230w\" sizes=\"(max-width: 432px) 100vw, 432px\" /></figure>\n\n\n\n<p>Upload the logo, and on the next screen, select Skip Cropping to get the whole logo. Then do the same for retina screens, but keep in mind that retina logo should be twice the size of normal logo. You can also <a href=\"https://www.youtube.com/watch?v=Qrr5_r8TvQI\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">watch this video</a> for better understanding.</p>\n\n\n\n<p>Next, let’s choose the primary colors for your website. In the customizer panel, go to General Options &gt; General Styling. The primary color you pick here, will be the default color for elements like links and buttons in your website.</p>\n\n\n\n<p>Similarly, you can pick your desired font styles from the Typography section on the customizer panel.</p>\n\n\n\n<p>Also, the OceanWP theme comes with a top bar enabled by default. This is really useful if you want to show additional navigation at the top.</p>\n\n\n\n<p>For a simple website though, a single menu is enough, which we will get to later. So for now, you can disable the top bar if you want.</p>\n\n\n\n<p>In the customizer panel, go to Top Bar &gt; General. Here, you can uncheck the box to disable the top bar, or leave it checked if you want it enabled.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/oceanwp-top-bar.jpg\" alt=\"change top bar\" class=\"wp-image-145756\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/oceanwp-top-bar.jpg 437w, //oceanwp.org/wp-content/uploads/2018/06/oceanwp-top-bar-300x188.jpg 300w\" sizes=\"(max-width: 437px) 100vw, 437px\" /></figure>\n\n\n\n<p>Once you’re done with the changes and want to save them, just click the blue Publish button at the top.</p>\n\n\n\n<p>There are hundreds of settings in the customizer panel that you can use to change the look and feel of most parts of your website, without touching any code or CSS. We encourage you to play around with the customizer, where any change also happen in real-time.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 9: Change Permalink Settings</strong></p>\n\n\n\n<p>You can keep on customizing over time as you work on other parts of the website and notice things that need to be changed.</p>\n\n\n\n<p>But for now, the website is currently blank, as it doesn’t have any posts or pages. So let’s work on creating some essential pages.</p>\n\n\n\n<p>Before you create a page or post in WordPress, you may want to change the permalink settings. This is because by default, your page and post URLs will be generated like this:</p>\n\n\n\n<p>yourdomain.com/?page_id=435</p>\n\n\n\n<p>yourdomain.com/2018/05/19/sample-post/</p>\n\n\n\n<p>yourdomain.com/?page_id=821</p>\n\n\n\n<p>Clearly, this is neither visitor-friendly nor good for search engines. It’s much better to have your post and page URLS like this:</p>\n\n\n\n<p>yourdomain.com/contact/</p>\n\n\n\n<p>yourdomain.com/marketing-tips/</p>\n\n\n\n<p>yourdomain.com/about-me/</p>\n\n\n\n<p>To make sure you can create such user-friendly URLs for your posts and pages, this happen, go to Settings &gt; Permalinks in your WordPress dashboard.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/permalinks-1024x494.jpg\" alt=\"change permalink setting\" class=\"wp-image-145779\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/permalinks-1024x494.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/permalinks-300x145.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/permalinks-768x370.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/permalinks.jpg 1357w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Once you’re there, select the Post Name radio button, and click Save Changes.</p>\n\n\n\n<p>Now, whenever you create or edit a page in WordPress (which we’ll talk about in the next step), you can set your own easy-to-remember and relevant URL.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/change-url-1024x385.jpg\" alt=\"wp page url\" class=\"wp-image-145768\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/change-url-1024x385.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/change-url-300x113.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/change-url-768x289.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/change-url.jpg 1032w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 10: Creating/Editing Pages</strong></p>\n\n\n\n<p>Now, the standard way to create a page in WordPress is to click Pages &gt; Add New in your WordPress dashboard.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/wp-page-1024x473.jpg\" alt=\"wp page options\" class=\"wp-image-145782\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/wp-page-1024x473.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/wp-page-300x139.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/wp-page-768x355.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/wp-page.jpg 1425w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Next, you’re going to see the WordPress text editor interface, which is a bit similar to word processing programs like WordPad or MS Word.</p>\n\n\n\n<p>Here, you can give your page a title. And you can add your content, including text, images and more in the body section.</p>\n\n\n\n<p>Once you’re done adding your content, hit the Publish button on the right to activate your page.</p>\n\n\n\n<p>Editing your existing pages is just as easy. Go to Pages &gt; All Pages to view a list of all the pages you have created so far.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/wp-all-pages-1024x565.jpg\" alt=\"list of wp pages\" class=\"wp-image-145781\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/wp-all-pages-1024x565.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/wp-all-pages-300x165.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/wp-all-pages-768x424.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/wp-all-pages.jpg 1240w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Hover over the title of the page that you want to edit, and click Edit. You’ll see the same interface that you saw when creating a page. Make the changes as you want, and then click the Update button to save the changes.</p>\n\n\n\n<p>Now, you can create and edit as many pages as you want with this approach, but the problem is that all you pages will have the same overall design. Each page will be a title, followed by chunks of text, and some images may be.</p>\n\n\n\n<p>But as promised, the aim of this guide is to show you how to create professional and beautiful pages like a pro. And that’s what we’re going to do next.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 11: Importing An OceanWP Demo</strong></p>\n\n\n\n<p>The free OceanWP theme comes with several pre-built demos, many of which are free to import.</p>\n\n\n\n<p>A demo is a sample website, with some pages already designed according to needs of businesses in a specific niche, business model or just the designer’s creative tastes.</p>\n\n\n\n<p>So if your needs fall under the category which the demo is meant for, or you really like how it’s designed, you can make your website look and feel exactly like the demo. And you can do this in just a few clicks, without any coding.</p>\n\n\n\n<p>So head over the the <a href=\"https://oceanwp.org/demos/\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener sponsored\" class=\"rank-math-link\">OceanWP demos page</a>, and decide on which demo would you like to use for your website. Once you’ve done that, the first step is to install the OceanWP demo import plugin.</p>\n\n\n\n<p>In your WordPress admin dashboard, go to Plugins &gt; Add New and search for “Ocean Demo Import.”</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/ocean-demo-import-1024x394.jpg\" alt=\"ocean demo import plugin\" class=\"wp-image-145777\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/ocean-demo-import-1024x394.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/ocean-demo-import-300x116.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/ocean-demo-import-768x296.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/ocean-demo-import.jpg 1620w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Then install and activate the plugin. Next, go to Theme Panel &gt; Install Demos. Look for the demo which you want to import, and click on it to view it’s requirements.</p>\n\n\n\n<p>For instance, let’s say I want to create a website on Yoga. Now, there’s a free demo available in OceanWP exactly for this purpose.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/install-demo-1024x536.jpg\" alt=\"oceanwp yoga demo\" class=\"wp-image-145776\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/install-demo-1024x536.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/install-demo-300x157.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/install-demo-768x402.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/install-demo.jpg 1330w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Even if none of the available demos mention your industry or purpose, there’s no need to worry. Just pick the one closest to your needs and preferences in terms of overall design, and then you can modify the pages later.</p>\n\n\n\n<p>Click on the demo you want to import and a popup will show you the plugins that you need to install before importing the demo you have clicked. Here’s what I see when I click on the Yoga demo, for instance.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/demo-install.jpg\" alt=\"import demo\" class=\"wp-image-145770\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/demo-install.jpg 913w, //oceanwp.org/wp-content/uploads/2018/06/demo-install-300x276.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/demo-install-768x707.jpg 768w\" sizes=\"(max-width: 913px) 100vw, 913px\" /></figure>\n\n\n\n<p>So before you import this demo, you’ll need to click on the buttons next to each of the plugins to install and activate those plugins.</p>\n\n\n\n<p>If a required plugin is not available for free, you can either purchase it, or proceed without installing that plugin. <a href=\"https://www.youtube.com/watch?v=8NQ3Ox-ddOI\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">Here’s a video</a> which will make the process even more clear.</p>\n\n\n\n<p>After activating the plugins, click Go To The Next Step button.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/demo-interface.jpg\" alt=\"import next step\" class=\"wp-image-145771\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/demo-interface.jpg 620w, //oceanwp.org/wp-content/uploads/2018/06/demo-interface-300x132.jpg 300w\" sizes=\"(max-width: 620px) 100vw, 620px\" /></figure>\n\n\n\n<p>On the next popup, you can pick what settings you want to import, or simply leave everything checked and click Install This Demo button.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/demo-done.jpg\" alt=\"demo imported\" class=\"wp-image-145769\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/demo-done.jpg 918w, //oceanwp.org/wp-content/uploads/2018/06/demo-done-300x142.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/demo-done-768x364.jpg 768w\" sizes=\"(max-width: 918px) 100vw, 918px\" /></figure>\n\n\n\n<p>Wait for a few minutes to see the success message, and it’s done. Now you can load your website to see the pages in action.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 12: Creating Pages With Elementor</strong></p>\n\n\n\n<p>Importing a demo will save you a lot of time. You’ll get many ready-made pages for your website. But based on your needs, you’ll want to edit the content of those pages, or create some more.</p>\n\n\n\n<p>So going forward, we recommend you to get acquainted with Elementor, the free page builder plugin we installed in one of the previous steps.</p>\n\n\n\n<p>To edit the pages you got from the OceanWP demo import, go to Pages &gt; All Pages in your WordPress dashboard to view a list of all your imported pages.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/elementor-page-1024x591.jpg\" alt=\"imported pages\" class=\"wp-image-145775\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/elementor-page-1024x591.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/elementor-page-300x173.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/elementor-page-768x443.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/elementor-page.jpg 1143w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>When you see the label “ &#8211; Elementor” next to a page title, it means that the page has been created or edited with Elementor.</p>\n\n\n\n<p>To edit a page, hover over the page title in the list, and you’ll see a link which says Edit With Elementor. Once you click on that link, you’ll see an interface like this:</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/edit-elementor-1024x577.jpg\" alt=\"\" class=\"wp-image-145772\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/edit-elementor-1024x577.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/edit-elementor-300x169.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/edit-elementor-768x433.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/edit-elementor.jpg 1314w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>On the left, you have the elementor controls to customize the page. And on the right is the page you’re editing, to which you make changes in real time.</p>\n\n\n\n<p>Creating a page with Elementor is also a similar process. Just go to Pages &gt; Add New. Give your page a title.</p>\n\n\n\n<p>By default, the width of the page will be what you have set in your WordPress customizer panel. If you want to create a page which takes the entire width of the screen, scroll down to OceanWP Settings and click on the Main tab.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/oceanwp-post-settings-1024x592.jpg\" alt=\"ocean wp page settings\" class=\"wp-image-145778\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/oceanwp-post-settings-1024x592.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/oceanwp-post-settings-300x173.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/oceanwp-post-settings-768x444.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/oceanwp-post-settings.jpg 1156w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Then, in the Content Layout section, click on the dropdown and select 100% Full Width. Next, click Save Draft or Publish button from the right to save your changes.</p>\n\n\n\n<p>To start building your new page, click on the blue Elementor button below the page title and you’ll get the same page editor interface we saw earlier.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/edit-with-elementor-1024x431.jpg\" alt=\"elementor button\" class=\"wp-image-145774\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/edit-with-elementor-1024x431.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/edit-with-elementor-300x126.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/edit-with-elementor-768x323.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/edit-with-elementor.jpg 1422w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Elementor is a powerful page builder with lots of features and <a href=\"https://library.elementor.com/\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">additional templates</a> that you can use to create new pages, without touching any code.</p>\n\n\n\n<p>So a full tutorial is beyond the scope of this guide. But it’s really quick to grasp and intuitive to use. <a href=\"https://www.youtube.com/watch?v=43j6h3oCm0U\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener nofollow\" class=\"rank-math-link\">This video</a> can help you get a hang of it and start editing pages in no time.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 13: Setting Your Homepage</strong></p>\n\n\n\n<p>Also note than just creating a page with the title “Home” will not make it the homepage. By default, WordPress shows the page with your latest blog posts as the homepage.</p>\n\n\n\n<p>If you import one of the OceanWP demos, then the homepage in that demo will automatically be set as homepage. So you don’t need to do anything.</p>\n\n\n\n<p>But if you’re creating a page on your own, or want to set another page as the homepage for your site, then you’ll need to modify a setting in WordPress.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/set-homepage.jpg\" alt=\"homepage in wordpress\" class=\"wp-image-145780\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/set-homepage.jpg 840w, //oceanwp.org/wp-content/uploads/2018/06/set-homepage-300x168.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/set-homepage-768x431.jpg 768w\" sizes=\"(max-width: 840px) 100vw, 840px\" /></figure>\n\n\n\n<p>To change this, go to Settings &gt; Reading. Then select the option &#8211; a static page. In the homepage dropdown, you’ll see a list of all the available pages.</p>\n\n\n\n<p>From here, you can select the page that you want as your website homepage. Then click the Save Changes button and it’s done.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Step 14: Edit Your Menu</strong></p>\n\n\n\n<p>Once you have created the basic pages on your website (like Home, About, Products, Contact or more), the next step is to configure your navigation.</p>\n\n\n\n<p>You want to make sure there’s a menu at the top of your website, which can lead the visitors to different pages and make it easy for them to find their way.</p>\n\n\n\n<p>In your WordPress admin dashboard, go to Appearance &gt; Menu.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://oceanwp.org/wp-content/uploads/2018/06/edit-menu-1024x573.jpg\" alt=\"wp menu\" class=\"wp-image-145773\" srcset=\"//oceanwp.org/wp-content/uploads/2018/06/edit-menu-1024x573.jpg 1024w, //oceanwp.org/wp-content/uploads/2018/06/edit-menu-300x168.jpg 300w, //oceanwp.org/wp-content/uploads/2018/06/edit-menu-768x430.jpg 768w, //oceanwp.org/wp-content/uploads/2018/06/edit-menu.jpg 1106w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Here, you can either make changes to the existing menu, or create a new one. Give your menu a name, and check the boxes from the left associated with pages you want to add to the menu.</p>\n\n\n\n<p>Then, click the Add To Menu button to add those pages to the menu. To remove a page from the menu, click on the menu item you want to remove, and then click Remove.</p>\n\n\n\n<p>Below the menu items, you also see menu settings. Here you can select at which locations you want the current menu to show. If you want the same menu to show up in the header, footer and mobile, for example, you can check all those boxes.</p>\n\n\n\n<p>Once you’re done with the changes, click Save Menu. You can now see the menu in action on your website.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Conclusion</strong></p>\n\n\n\n<p>Up until the last couple years, building a beautiful and functional website had been solely under the control of professional web designers and developers.</p>\n\n\n\n<p>Of course things got a little easier with WordPress and hundreds of ready-made templates you can use with it.</p>\n\n\n\n<p>But a good deal of custom programming was still required to make a website or blog more professional and tweak parts to look and feel exactly like you want.</p>\n\n\n\n<p>The good news is that WordPress themes like OceanWP and page builders like <a href=\"https://bit.ly/2sffgxb\" target=\"_blank\" aria-label=\" (opens in a new tab)\" rel=\"noreferrer noopener sponsored\" class=\"rank-math-link\">Elementor</a> have really leveled the playing field in 2018. And with hundreds of ready-made templates to create any type of page imaginable, there’s no excuse to not create a great website or blog.</p>\n\n\n\n<p>It’s a worthy endeavor that not only builds your technical skills, but also gives deeper satisfaction and meaning that comes from sharing who you are and your work with the world.</p>\n<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/how-create-wordpress-blog-2020-pros/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;\">Read More</a></p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://oceanwp.org/blog/how-create-wordpress-blog-2020-pros/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress Performance Tips for the Everyday User\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://oceanwp.org/blog/wordpress-performance-tips-everyday-user/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://oceanwp.org/blog/wordpress-performance-tips-everyday-user/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jan 2020 18:51:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Introducing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://oceanwp.org/?p=577771\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1246:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/wordpress-performance-tips-everyday-user/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2020/01/wordpress-performance-tips-everyday-user.jpg\" width=\"1064\" height=\"705\" title=\"WordPress Performance Tips for the Everyday User\" alt=\"WordPress Performance Tips for the Everyday User\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\">No matter what you do for a living, there is a big chance that you are running a website dedicated to your business. After all, the number of websites keeps growing steadily as there are now more than 1.7 billion sites on the Internet. Now, every website runs on a content management system (CMS) and [&#8230;]<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/wordpress-performance-tips-everyday-user/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;\">Read More</a></p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Osborne\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9013:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/wordpress-performance-tips-everyday-user/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2020/01/wordpress-performance-tips-everyday-user.jpg\" width=\"1064\" height=\"705\" title=\"WordPress Performance Tips for the Everyday User\" alt=\"WordPress Performance Tips for the Everyday User\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\">\n<p>No matter what you do for a living, there is a big chance that you are running a website dedicated to your business. After all, the number of websites keeps growing steadily as there are now more than <span style=\"color: #0000ff;\"><u><a href=\"https://www.internetlivestats.com/\">1.7 billion</a></u></span> sites on the Internet.</p>\n\n\n\n<span id=\"more-577771\"></span>\n\n\n\n<p>Now, every website runs on a content management system (CMS) and WordPress is by far the most popular choice among webmasters of all levels of knowledge and skills. A report reveals that WordPress powers <span style=\"color: #0000ff;\"><u><a href=\"https://kinsta.com/blog/wordpress-statistics/\">34% of all websites</a></u></span> on the Internet, but the platform’s market share goes as high as 60%.</p>\n\n\n\n<p>Users love WordPress because it’s simple and easy to figure out, but they still need to know a few basics in order to keep their sites running smoothly and efficiently. In this post, we will show you nine WordPress performance tips that are suitable for everyday users. Let’s take a look!</p>\n\n\n\n<h3>Find a Reliable Hosting Provider</h3>\n\n\n\n<p>Many webmasters make a simple mistake of choosing cheap but unreliable hosting providers. A typical user does it because he/she is not expecting a huge amount of traffic and therefore is not willing to invest in WordPress hosting.</p>\n\n\n\n<p>Jake Gardner, an <span style=\"color: #0000ff;\"><u><a href=\"https://www.a-writer.com/\" class=\"rank-math-link\">essay writer</a></u></span> in charge of IT topics, claims this is a big mistake: “As soon as you create an army of loyal fans, you will notice that your site is slowing down. This is why I recommend you to pick a well-known provider such as Page.ly, WP Engine, or Bluehost.”</p>\n\n\n\n<h3>Pick a Good Theme</h3>\n\n\n\n<p>A <span style=\"color: #0000ff;\"><u><a href=\"https://www.wpbeginner.com/glossary/theme/\" class=\"rank-math-link\">theme</a></u></span> is a collection of templates and style sheets used to define the appearance and display of a WordPress powered website. As such, it has an overwhelming impact on website performance because people love to see a beautiful online presentation.</p>\n\n\n\n<p>Now, you can find a lot of WordPress themes with “one size fits all” solutions. While it may seem tempting, we encourage you to opt for a specific niche-focused theme. How come? Generic themes are covering all sorts of features – even the ones you don’t really need.</p>\n\n\n\n<p>For this reason, you should pick a narrow theme that suits your business needs. If you visit a website such as <span style=\"color: #0000ff;\"><u><a href=\"https://www.bestessay.com/\" class=\"rank-math-link\">Best Essays</a></u></span>, <span style=\"color: #0000ff;\"><u><a href=\"https://www.assignmentmasters.co.uk/\" class=\"rank-math-link\">Assignment Service</a></u></span>, or <span style=\"color: #0000ff;\"><u><a href=\"http://www.bestessayservicereviews.com/essay-writing/essayedge-com-review/\" class=\"rank-math-link\">EssayEdge</a></u></span>, you will realize they use the same sort of theme because it gives them only those features academic writing agencies might need.</p>\n\n\n\n<h3>Choose the Right Plugins</h3>\n\n\n\n<p>WordPress themes determine the appearance of your site, while plugins help you to make the website better and more efficient. Just like a theme, you should also be smart enough to choose the right tools for your business demands. Generally speaking, almost every website needs plugins to enable search engine optimization, online security, contact forms, email marketing, content creation, and similar.</p>\n\n\n\n<h3>Remove the Plugins You Don&#8217;t Need Anymore</h3>\n\n\n\n<p>Every day WordPress users are known for their “set it and forget it” philosophy. This often turns out to be a disastrous habit because hackers take advantage of outdated plugins to attack WordPress websites.</p>\n\n\n\n<p>If you know that <span style=\"color: #0000ff;\"><u><a href=\"https://wpplugins.tips/wordpress-security-statistics/\" class=\"rank-math-link\">over 50%</a></u></span> of WordPress vulnerabilities come from plugins, then you understand how important it is to uninstall the tools you’re not using anymore.</p>\n\n\n\n<h3>Take Advantage of Excerpts on Homepage and Archives</h3>\n\n\n\n<p>Another thing you can do to make the website more functional is to take advantage of excerpts on the homepage and archives. Namely, WordPress will automatically load and display the entire content on a given page, which is a surefire way to degrade website performance.</p>\n\n\n\n<p>If you really think that visitors should read the whole thing, then you can leave the function as is. But if you think excerpts are enough, then follow this pattern:</p>\n\n\n\n<ul><li> Settings → Reading → For each article in a feed, show Summary </li></ul>\n\n\n\n<h3>Minimize the Size of Images</h3>\n\n\n\n<p>Visual content is always burdening WordPress websites, so you should consider minimizing the size of your images. Photos that are too big will make the site slower, which is a big deal in the world where almost 60% of visitors leave a page if it takes longer than <span style=\"color: #0000ff;\"><u><a href=\"https://marketingbulldog.com/5-page-speed-statistics-you-need-to-know-for-2019/\">three seconds</a></u></span> to load.</p>\n\n\n\n<p>The easiest solution is to use lighter images and avoid gigantic files. Another option is to install a plugin such as <span style=\"color: #0000ff;\"><u><a href=\"https://wordpress.org/plugins/wp-smushit/\">Smush Image Compression and Optimization</a></u></span> to make visual content go easy on your site.</p>\n\n\n\n<h3>Split Comments into Pages</h3>\n\n\n\n<p>When your website becomes very popular, you can expect people to start writing lots of comments all over the place. While this is a sign of professional success, it can also jeopardize performance because comment loading increases the overall speed of your website. If you want to prevent this problem, go to Settings once again:</p>\n\n\n\n<ul><li> Settings → Discussion → Break comments into pages </li></ul>\n\n\n\n<h3>Optimize a WordPress Database</h3>\n\n\n\n<p>As you keep creating new posts and adding fresh content to the website, you can expect WordPress to get slower gradually. In such circumstances, you should not hesitate to optimize a WordPress database because that’s where all the information is stored.</p>\n\n\n\n<p>You can do it manually through settings, but a much simpler solution is to install a <span style=\"color: #0000ff;\"><u><a href=\"https://wordpress.org/plugins/wp-sweep/\">WP Sweep</a></u></span> plugin. This tool will help you to get rid of many redundant features in these (and many other) segments of the site:</p>\n\n\n\n<ul><li> Auto drafts </li><li> Deleted comments </li><li> Revisions </li><li> Orphaned user meta </li><li> Transient options </li><li> Unapproved comments </li><li> Unused terms </li></ul>\n\n\n\n<h3>Keep Your System Up To Date</h3>\n\n\n\n<p>Do you know that <span style=\"color: #0000ff;\"><u><a href=\"https://www.isitwp.com/interesting-wordpress-stats-facts/#wordpress-security\">almost 40%</a></u></span> of hacked WordPress websites were using an outdated version of the platform? This means that webmasters who neglect updates are likely to suffer from malicious attacks.</p>\n\n\n\n<p>The only logical response to the threat is to keep your WordPress system up to date. Every time you see there’s a new version available, take your time to upgrade and solidify both the performance and security of your website.</p>\n\n\n\n<h4 class=\"western\"><span style=\"font-family: Calibri, serif;\">Conclusion</span></h4>\n\n\n\n<p>WordPress is responsible for the functioning of more than a third of all websites currently available online. Users appreciate the platform because it’s super-easy to figure out, but some of them are still not able to identify the most important functions of the CMS.</p>\n\n\n\n<p>In this article, we analyzed nine WordPress performance tips suitable for everyday users. Remember our tips and make sure to leave a comment if you need additional explanations – we would be glad to help you out!</p>\n<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/wordpress-performance-tips-everyday-user/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;\">Read More</a></p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://oceanwp.org/blog/wordpress-performance-tips-everyday-user/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"19\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:85:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"How to create custom websites with dynamic content using Toolset and OceanWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://oceanwp.org/blog/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://oceanwp.org/blog/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Jan 2020 16:03:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Introducing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:7:\"Toolset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://oceanwp.org/?p=578694\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1433:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2019/12/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp.jpg\" width=\"1280\" height=\"720\" title=\"How to create custom websites with dynamic content using Toolset and OceanWP\" alt=\"How to create custom websites with dynamic content using Toolset and OceanWP\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\">You would be forgiven for automatically thinking that a custom website would take hours of coding to complete. In fact, the open secret in WordPress is that it is now easier than ever to build complex websites with dynamic content without using any coding at all. Thanks to last year’s release of Gutenberg designing your [&#8230;]<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;\">Read More</a></p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Joe Lobo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:24326:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2019/12/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp.jpg\" width=\"1280\" height=\"720\" title=\"How to create custom websites with dynamic content using Toolset and OceanWP\" alt=\"How to create custom websites with dynamic content using Toolset and OceanWP\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\"><p>You would be forgiven for automatically thinking that a custom website would take hours of coding to complete. In fact, the open secret in WordPress is that it is now easier than ever to build complex websites with dynamic content without using any coding at all.</p>\n<p>Thanks to last year’s release of <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a> designing your websites on the back-end is now possible without spending significant amounts of time on PHP or even HTML or CSS. In fact, you can simply use Gutenberg’s famous blocks and its integrated plugins such as <a href=\"https://toolset.com/\">Toolset</a> to build everything.</p>\n<p>One of the easiest ways to turn your website from basic to professional is by including dynamic content. The good news is that with Toolset and <a href=\"https://oceanwp.org/\">OceanWP</a> it is easy to bring dynamic content to your website. Before we go through how you do it let’s first explain exactly what we are talking about.</p>\n<p><img class=\"alignnone size-full wp-image-578695\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/Toolset-homepage.png\" alt=\"\" width=\"1556\" height=\"1204\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/Toolset-homepage.png 1556w, //oceanwp.org/wp-content/uploads/2019/12/Toolset-homepage-300x232.png 300w, //oceanwp.org/wp-content/uploads/2019/12/Toolset-homepage-1024x792.png 1024w, //oceanwp.org/wp-content/uploads/2019/12/Toolset-homepage-768x594.png 768w, //oceanwp.org/wp-content/uploads/2019/12/Toolset-homepage-1536x1189.png 1536w\" sizes=\"(max-width: 1556px) 100vw, 1556px\" /></p>\n<h2>What is dynamic content?</h2>\n<p>With dynamic content, WordPress pulls the correct information from the database to display to the user depending on the page or post it is used on. It is in contrast to static content which does not pull any data from the database.</p>\n<p>For example, if you have a travel website with a number of different trips &#8211; such as one for Prague and one for Venice &#8211; a user will expect to see content about Prague when they click on &#8220;Prague&#8221; and the same for Venice. Both posts could have exactly the same layout but with different content. This is dynamic content.</p>\n<p><figure id=\"attachment_578696\" aria-describedby=\"caption-attachment-578696\" style=\"width: 1186px\" class=\"wp-caption alignnone\"><img class=\"size-full wp-image-578696\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/Prague.jpg\" alt=\"An example of dynamic content\" width=\"1186\" height=\"945\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/Prague.jpg 1186w, //oceanwp.org/wp-content/uploads/2019/12/Prague-300x239.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/Prague-1024x816.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/Prague-768x612.jpg 768w\" sizes=\"(max-width: 1186px) 100vw, 1186px\" /><figcaption id=\"caption-attachment-578696\" class=\"wp-caption-text\">An example of dynamic content in action.</figcaption></figure></p>\n<p>&nbsp;</p>\n<p><figure id=\"attachment_578698\" aria-describedby=\"caption-attachment-578698\" style=\"width: 1170px\" class=\"wp-caption alignnone\"><img class=\"size-full wp-image-578698\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/Venice.jpg\" alt=\"Another example of dynamic content in action.\" width=\"1170\" height=\"958\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/Venice.jpg 1170w, //oceanwp.org/wp-content/uploads/2019/12/Venice-300x246.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/Venice-1024x838.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/Venice-768x629.jpg 768w\" sizes=\"(max-width: 1170px) 100vw, 1170px\" /><figcaption id=\"caption-attachment-578698\" class=\"wp-caption-text\">We have used the same template for our &#8220;Venice&#8221; post but it displays different content thanks to Toolset.</figcaption></figure></p>\n<p>&nbsp;</p>\n<h2>Why we’re using OceanWP and Toolset</h2>\n<p>Toolset and OceanWP are both completely integrated and provide the perfect combination for creating a professional website with dynamic content.</p>\n<p>Toolset comes from the Toolset team which specializes in making it easy for both professional programmers and non-coders to build custom websites. Specifically, Toolset brings a number of advantages:</p>\n<ul>\n<li><strong>No need to switch between the back-end and front-end</strong>. Instead of wasting valuable time having to check your designs on the front-end you can be safe in the knowledge that what you see on the back-end is what you will get when you hit publish.</li>\n<li><strong>A simpler workflow</strong>. Previously on custom websites, a designer might have created their website layouts on one platform and then a developer would have had to implement them on WordPress. Now one person, regardless of their abilities, can create and display everything on WordPress.</li>\n<li><strong>Non-developers can build the website they want</strong>. Instead of compromising on their designs, non-developers can now carry out their website-building ambitions and create exactly what they wanted thanks to the simple Gutenberg interface and Toolset’ potential.</li>\n<li><strong>Save time reading documentation</strong>. Toolset is very straightforward to use and test out. Therefore, instead of reading lots of documentation you can dedicate your time to experimenting and creating content on WordPress.</li>\n<li><strong>Fewer integrations with third-party plugins</strong>. The new Gutenberg Editor and its integration with a large number of WordPress plugins such as Toolset mean you can rely on fewer third-party plugins to build your website. As a result, your website is less bloated with fewer plugins and you do not need to rely on third parties updating their plugins.</li>\n<li><strong>Follow the same workflow as the WordPress core</strong>. You do not need to worry about changing how you work with the new WordPress editor.</li>\n</ul>\n<p>Incidentally, if you want to learn more about using Gutenberg then a great resource is this <a href=\"https://colorlib.com/wp/wordpress-gutenberg-tutorial/\">WordPress Gutenberg tutorial</a> on creating custom websites using blocks.</p>\n<p>Meanwhile, OceanWP is one of the most popular websites on WordPress for businesses. Websites that are run by OceanWP have improved conversion rates, load times and SEO. Website owners can benefit hugely by combining OceanWP with Toolset to create beautiful custom websites.</p>\n<h2>Examples of what you can create using OceanWP and Toolset</h2>\n<p>Below we will go through four features you can create using OceanWP and Toolset.</p>\n<h3>How to create templates to display posts</h3>\n<p>To create your design for your posts you need to build a template. All you need to do is create a template for your custom post type once and all of the posts attributed to it will be under the same design.</p>\n<p>Below is an example of a template I created for my custom post type for tours.</p>\n<ol>\n<li style=\"list-style-type: none;\">\n<ol>\n<li>Head to Toolset-&gt;Dashboard and click on Create Content Template next to the post type. Below, I have clicked on the option next to the tours custom post type.<img class=\"alignnone size-full wp-image-578700\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/custom-template.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/custom-template.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/custom-template-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/custom-template-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/custom-template-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/custom-template-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/custom-template-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>Next, you can add the fields you want for your template. For example, I have added the Heading, Image and Single Fields blocks to display my content. Click the + option in the top left.<img class=\"alignnone size-full wp-image-578701\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/clicking-the-plus.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/clicking-the-plus.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/clicking-the-plus-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/clicking-the-plus-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/clicking-the-plus-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/clicking-the-plus-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/clicking-the-plus-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>Click under the Toolset section and search for the block you want to add. For example, I have chosen the <strong>Toolset Heading block</strong>.<img class=\"alignnone size-full wp-image-578702\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/heading-block.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/heading-block.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/heading-block-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/heading-block-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/heading-block-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/heading-block-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/heading-block-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>Toolset allows you to make your blocks dynamic in order to pull the correct content from the database. For this block click <strong>Dynamic Heading Text</strong>.</li>\n<li>Under <strong>Source</strong> select the <strong>Post Title</strong>.<img class=\"alignnone size-full wp-image-578703\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/heading-settings.jpg\" alt=\"\" width=\"2161\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/heading-settings.jpg 2161w, //oceanwp.org/wp-content/uploads/2019/12/heading-settings-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/heading-settings-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/heading-settings-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/heading-settings-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/heading-settings-2048x1207.jpg 2048w\" sizes=\"(max-width: 2161px) 100vw, 2161px\" /></li>\n<li>Follow the same steps to create your other blocks including the <strong>Image</strong> and <strong>Single Field blocks</strong>.</li>\n<li>Once you have added your blocks you can see how each of your tours posts looks on the front-end. With different content but the same template.<img class=\"alignnone size-full wp-image-578704\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/venice-front-end.jpg\" alt=\"\" width=\"1738\" height=\"1156\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/venice-front-end.jpg 1738w, //oceanwp.org/wp-content/uploads/2019/12/venice-front-end-300x200.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/venice-front-end-1024x681.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/venice-front-end-768x511.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/venice-front-end-1536x1022.jpg 1536w\" sizes=\"(max-width: 1738px) 100vw, 1738px\" /></li>\n</ol>\n</li>\n</ol>\n<h2>Build your archive pages</h2>\n<p>An archive page displays a list of the content you have published under a custom post type. For example, you can create an archive that shows all of the blog posts you have published or all of the gyms on your website.</p>\n<p>However, you can also customize how your archive pages look and which posts they display using Gutenberg and Toolset. For example, you can choose to only display blog posts from the last 30 days which are on a certain topic.</p>\n<p>Below is how I created an archive for my “Tours” custom post type.</p>\n<ol>\n<li>Head to Toolset-&gt;Dashboard and click on the Create Archive option next to the custom post type. To illustrate, I have selected to create an archive for my “Gyms” custom post type.<img class=\"alignnone size-full wp-image-578706\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/archive-post-type.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/archive-post-type.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/archive-post-type-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/archive-post-type-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/archive-post-type-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/archive-post-type-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/archive-post-type-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>Just like we did for our content template we can add the blocks we need for each post along with dynamic content so that WordPress pulls up the correct content from the database.<img class=\"alignnone size-full wp-image-578707\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/archive-design.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/archive-design.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/archive-design-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/archive-design-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/archive-design-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/archive-design-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/archive-design-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>Once you have added your blocks you can also change your archive’s layout such as the number of columns by selecting the <strong>Block Navigation</strong> and then the <strong>WordPress Archive Loop</strong>.<img class=\"alignnone size-full wp-image-578708\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/block-navigation.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/block-navigation.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/block-navigation-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/block-navigation-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/block-navigation-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/block-navigation-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/block-navigation-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>Under <strong>Loop style</strong> you can toggle the number of columns and also change the layout style of the posts (if you want an unordered list or for it to be unformatted, for example).<img class=\"alignnone size-full wp-image-578710\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/Native-WordPress-Columns.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/Native-WordPress-Columns.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/Native-WordPress-Columns-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/Native-WordPress-Columns-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/Native-WordPress-Columns-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/Native-WordPress-Columns-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/Native-WordPress-Columns-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>You can change all aspects of your layout including the order of posts, the pagination as well as columns on the right sidebar under the <strong>WordPress Archive</strong> block.<img class=\"alignnone size-full wp-image-578709\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/wordpress-archive-block.jpg\" alt=\"\" width=\"2161\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/wordpress-archive-block.jpg 2161w, //oceanwp.org/wp-content/uploads/2019/12/wordpress-archive-block-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/wordpress-archive-block-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/wordpress-archive-block-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/wordpress-archive-block-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/wordpress-archive-block-2048x1207.jpg 2048w\" sizes=\"(max-width: 2161px) 100vw, 2161px\" /></li>\n<li>You can also add texts and blocks both before and after your archive loop to provide further context about your posts. Simply click the + icon before or after and you can start adding blocks or texts.<img class=\"alignnone size-full wp-image-578711\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/add-other-blocks.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/add-other-blocks.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/add-other-blocks-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/add-other-blocks-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/add-other-blocks-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/add-other-blocks-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/add-other-blocks-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n</ol>\n<h2>Display custom lists of content</h2>\n<p>With Gutenberg and blocks such as Toolset you can display a filtered list of your content and order it in any way you like. You can design your lists in any way you like including as a table, grid or any other custom design. Toolset calls this type of list a <a href=\"https://toolset.com/home/views-create-elegant-displays-for-your-content/\">View</a>.</p>\n<p>For example, you can create a grid of the tours which cost less than $200 a month which are available in the next month and are ordered starting by the cheapest.</p>\n<p>You can add your lists of content to any page you like using blocks. Below I created a list of featured tours for my homepage.</p>\n<ol>\n<li>Choose where you want to add your View and click the + button.</li>\n<li>Add the Views block and give it a name.</li>\n<li>Choose whether you want to add <strong>Pagination, Front-end sorting or a Search</strong> (we’ll get to that later).<img class=\"alignnone size-full wp-image-578712\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/search-elements.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/search-elements.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/search-elements-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/search-elements-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/search-elements-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/search-elements-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/search-elements-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>Select which content you want to display. Below I selected the tours custom post type.<img class=\"alignnone size-full wp-image-578713\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/tours-custom-search.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/tours-custom-search.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/tours-custom-search-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/tours-custom-search-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/tours-custom-search-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/tours-custom-search-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/tours-custom-search-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>Just like with the previous features you can next add the blocks that you want to display with dynamic content.</li>\n<li>You can edit the order of your list, the content it displays and much more by clicking <strong>Block Navigation</strong> and selecting your View. Use the sidebar to go through the options. For example, you can use the <strong>Query Filter</strong> setting to add filters to only display tours with a rating of more than four stars.</li>\n</ol>\n<p><img class=\"alignnone size-full wp-image-578714\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/general-custom-search-tours.jpg\" alt=\"\" width=\"2161\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/general-custom-search-tours.jpg 2161w, //oceanwp.org/wp-content/uploads/2019/12/general-custom-search-tours-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/general-custom-search-tours-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/general-custom-search-tours-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/general-custom-search-tours-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/general-custom-search-tours-2048x1207.jpg 2048w\" sizes=\"(max-width: 2161px) 100vw, 2161px\" /></p>\n<h2>Add a custom search</h2>\n<p>A custom search is an important tool to help your users find exactly what they are looking for. Just like a search engine, you can use a custom search to narrow down your results.</p>\n<p>For example, if you are looking for a tour for less than $200 you can set it using a custom search filter.</p>\n<ol>\n<li>Just like when you display a custom list of content insert a <strong>View</strong> block into your page.</li>\n<li>In the View creation wizard enable the <strong>Search</strong> option.<img class=\"alignnone size-full wp-image-578715\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/search-bar.jpg\" alt=\"\" width=\"2160\" height=\"1274\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/search-bar.jpg 2160w, //oceanwp.org/wp-content/uploads/2019/12/search-bar-300x177.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/search-bar-1024x604.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/search-bar-768x453.jpg 768w, //oceanwp.org/wp-content/uploads/2019/12/search-bar-1536x906.jpg 1536w, //oceanwp.org/wp-content/uploads/2019/12/search-bar-2048x1208.jpg 2048w\" sizes=\"(max-width: 2160px) 100vw, 2160px\" /></li>\n<li>You can now add <strong>Search Fields, Search Buttons</strong> and many more options in the Views editing area.</li>\n<li>Just like with the other features you can use the right sidebar to make any changes including labels, stylings and the main field settings.</li>\n</ol>\n<p>Here is how the custom search looks on the front-end, complete with filters for the name, minimum rating and types of gyms.</p>\n<p><img class=\"alignnone size-full wp-image-578717\" src=\"https://oceanwp.org/wp-content/uploads/2019/12/custom-search.jpg\" alt=\"\" width=\"1425\" height=\"1222\" srcset=\"//oceanwp.org/wp-content/uploads/2019/12/custom-search.jpg 1425w, //oceanwp.org/wp-content/uploads/2019/12/custom-search-300x257.jpg 300w, //oceanwp.org/wp-content/uploads/2019/12/custom-search-1024x878.jpg 1024w, //oceanwp.org/wp-content/uploads/2019/12/custom-search-768x659.jpg 768w\" sizes=\"(max-width: 1425px) 100vw, 1425px\" /></p>\n<h2>Build your complex website using OceanWP and Toolset today!</h2>\n<p>Now that you have an idea of how easy it is to build complex websites without any coding at all you can get started today. All you need is OceanWP and the plugins associated with it including <a href=\"https://toolset.com/\">Toolset</a>.</p>\n<p>Have you built your custom website using Toolset and OceanWP? Let us know your experiences of it in the comments below!</p>\n<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;\">Read More</a></p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://oceanwp.org/blog/how-to-create-custom-websites-with-dynamic-content-using-toolset-and-oceanwp/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"500k Installs Milestone &amp; Black Friday deals\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://oceanwp.org/blog/500k-installs-milestone-black-friday-deals/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://oceanwp.org/blog/500k-installs-milestone-black-friday-deals/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Nov 2019 23:46:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Announcement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://oceanwp.org/?p=577395\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1291:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/500k-installs-milestone-black-friday-deals/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2019/11/black-2951013_1280.png\" width=\"1280\" height=\"866\" title=\"500k Installs Milestone &#038; Black Friday deals\" alt=\"500k Installs Milestone &#038; Black Friday deals\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\">Hello everyone! As Black Friday approaches, OceanWP will offer some amazing deals! It&#8217;s also a great time to celebrate another milestone: 500,000 installs, making OceanWP the fastest growing WordPress theme! For Black Friday and Cyber Monday, we will offer: &#160; Lifetime licenses: 20% off for 1-site, 3-site and 25-site for the first 200 people. Annual [&#8230;]<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/500k-installs-milestone-black-friday-deals/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;\">Read More</a></p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nicolas Lecocq\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2085:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/500k-installs-milestone-black-friday-deals/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2019/11/black-2951013_1280.png\" width=\"1280\" height=\"866\" title=\"500k Installs Milestone &#038; Black Friday deals\" alt=\"500k Installs Milestone &#038; Black Friday deals\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\"><div>\n<p>Hello everyone!</p>\n</div>\n<div>As Black Friday approaches, OceanWP will offer some amazing deals!</div>\n<div></div>\n<div>\n<p>It&#8217;s also a great time to celebrate another milestone: <span style=\"text-decoration: underline;\"><strong>500,000 installs</strong></span>, making OceanWP the fastest growing WordPress theme!</p>\n</div>\n<div>\n<p>For Black Friday and Cyber Monday, we will offer:</p>\n<p>&nbsp;</p>\n</div>\n<div><span style=\"text-decoration: underline;\"><strong>Lifetime licenses:</strong></span></div>\n<div><strong>20% off</strong> for 1-site, 3-site and 25-site for the first 200 people.<br />\n<u><br />\n</u></div>\n<div><strong><span style=\"text-decoration: underline;\">Annual licenses:</span></strong></div>\n<div><strong>25% off</strong> of 1-site for the first 300 people<br />\n<strong>30% off</strong> of 3-site and 25-site for the first 500 people</div>\n<div>\n<p>We want to thank our users and loyal community, and wish the folks in the United States a happy Thanksgiving.</p>\n<p>Catch all the deals on the bundle page:<br />\n<a href=\"https://oceanwp.org/core-extensions-bundle/\">https://oceanwp.org/core-extensions-bundle/</a></p>\n</div>\n<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/500k-installs-milestone-black-friday-deals/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;\">Read More</a></p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://oceanwp.org/blog/500k-installs-milestone-black-friday-deals/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Why OceanWP Uses Rank Math\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://oceanwp.org/blog/why-oceanwp-uses-rank-math/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://oceanwp.org/blog/why-oceanwp-uses-rank-math/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Nov 2019 09:05:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Announcement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://oceanwp.org/?p=428050\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1161:\"<p style=\"display: block; padding: 0 0 24px; margin: 0 !important;\"><a href=\"https://oceanwp.org/blog/why-oceanwp-uses-rank-math/\" target=\"_blank\"><img src=\"https://oceanwp.org/wp-content/uploads/2019/04/OceanWP-x-Rank-Math.png\" width=\"1200\" height=\"600\" title=\"Why OceanWP Uses Rank Math\" alt=\"Why OceanWP Uses Rank Math\" style=\"width: 100%!important;\"></a></p><p style=\"padding: 0 26px !important; margin: 0 !important;\">If you’re an avid OceanWP user and have recently installed our theme, you may have noticed that we make a few plugin recommendations. After all, you might be on this page because you’re trying to find out more about one of the plugins we recommend &#8211; Rank Math. So without further ado, in this post, [&#8230;]<p style=\"margin: 0!important;padding: 26px 0 0!important;\"><a href=\"https://oceanwp.org/blog/why-oceanwp-uses-rank-math/\" target=\"_blank\" style=\"display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; 